dojo.provide("webapp.email.controlBase");
dojo.declare("webapp.email.controlBase",[ICTouchAPI.webApplication],
{
	currentStatus	: 0,
	popupFilters	: null,
	deletePopUp		: null,
	errorPopup		: null,
	objMenuUI		: null,
	boolConnectionError	: false,
//	_uniqueIdGen	: 0,
//	_idMailToEdit	: -1,

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.communication", "webapp.email",true,false,false);		
		ICTouchAPI.tools.registerHomepageButton(["webapp.email.getEmail", "EMAIL_BTN", "mail-application", _('Email',"webapp.email")]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.email.getEmail", "EMAIL_BTN", "mail-application", _('Email',"webapp.email")]);

		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_RECEIVE_NTF", this.onMailReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAILBOX_FULL_NTF", this.notifyMailboxFull);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_SAVE_NTF", this.onMailSave);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_UPDATE_NTF", this.onMailUpdate);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_SEND_NTF", this.onMailSend);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_DELETE_NTF", this.onMailDelete);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_GET_ERROR_NTF", this.onMailGetError);

		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged", this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
        ICTouchAPI.settingServices.getSetting("eMailDefaultFilter",this,this._setFilter);
        ICTouchAPI.settingServices.subscribeToSetting(this,"eMailDefaultFilter",this._setFilter);
        ICTouchAPI.settingServices.getSetting("eMailDefaultSort", this, this._setSort);
        ICTouchAPI.settingServices.subscribeToSetting(this,"eMailDefaultSort", this._setSort);

		ICTouchAPI.notificationServices.addNotification({
							strNotificationName: "New_Email",
							strNotificationLabel: _("New mail", "webapp.email"),
							intNotificationValue: 0,
							callback: dojo.hitch("webapp.email", this.onNotifyNewMail)
						});
		dojo.subscribe("ContactDataClickedEmail", this, this.onEmailContact);
                ICTouchAPI.settingServices.subscribeToSetting(this, "EnableEmailPreview", this._registerHomePageContainer);
                this.loadEnablePreview();
	},

         //ENABLE PREVIEW
        loadEnablePreview:function(){
            ICTouchAPI.settingServices.getSetting("EnableEmailPreview", this, this._registerHomePageContainer);
        },

        _registerHomePageContainer : function(objSetting){
            if (objSetting){
                if(objSetting.jsValue == true){
                    ICTouchAPI.tools.registerHomepageContainer(["webapp.email.getEmailPreview", this]);
                }else{
                    ICTouchAPI.tools.unregisterHomepageContainer(["webapp.email.getEmailPreview"]);
                }
            }

        },
        //END OF ENABLE PREVIEW

	load: function() {
		//help
		var widgetsTab = [];
		for(var i=0; i<webapp.email.data.NB_STATUS; i++) {
			widgetsTab.push("emailstatus"+i);
		}
		dojo.publish("needHelpEvent",["email",widgetsTab]);
	},

    _setFilter : function(objSetting){
        if(objSetting.jsValue===0){
            this.data.selectedFilter="All";
        }
        else{
            this.data.selectedFilter="Unread"
        }

    },

    _setSort : function(objSetting){
        if(objSetting.jsValue===0){
            this.data.selectedOrderBy="Sender";
        }
        else{
            this.data.selectedOrderBy="Date";
        }

    },

	    //adds an external capability, for other webapps to be able to add buttons any appBar of the webapp Email
    addButton : function(button, widget) {
        var appBar = {};

        if (widget == "webapp.email.getMailConsultation")
        {
            appBar = ICTouchAPI.AppBarServices.getAppBar("email","emailstatus"+this.STATUS_CONSULTATION);
        }
        else if (widget == "webapp.email.getMailEdition")
        {
            appBar = ICTouchAPI.AppBarServices.getAppBar("email","emailstatus"+this.STATUS_EDITION);
        }

        var objButton = new UIElements.AppButton.AppButtonControl(button);
        appBar.addActionButton(objButton);
    },

	setHomepageContainer : function (strWebapp, div) {
		webapp.email.previewContainer = new webapp.email.getEmailPreview({ }, div);
	},

	buttonCallback : function(buttonId) {
		var data = webapp.email.data;
		switch(buttonId)
		{
			// The back button load the last container
			case data.BACK:
				switch(data._strContainerPath)
				{
					case "webapp.email.getMailConsultation" :
						dojo.publish("OpenHomepage");
						break;
					case "webapp.email.getMailEdition" :
						this.loadDraftPopup();

						break;
					default :
						data.switchContainer("getMailConsultation", data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
						break;
				}
				break;
			case data.NEW_MAIL:
				 if (webapp.email.currentStatus == data.STATUS_EDITION)
					this.loadDraftPopup();

				data.newEmail = {title:"", textBody:"", mailTo : []};
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));

				break;
			case data.EDIT_DRAFT:
				data.newEmail = {};
				data.newEmail = dojo.clone(data.currentEmail);
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.FILTERS:
				this.openFilters();
				break;
			case data.ANSWER:
                                var text=data.currentEmail.textBody;
                                var tab=null;
                                tab=text.split('\n');
                                text="";
                                for(var i=0;i<tab.length;i++){


                                        tab[i]='>'+tab[i];
                                        text+=tab[i]+'\n';

                                }

                                data.newEmail.textBody = text;
                                data.newEmail.title = "re: " + data.currentEmail.title;
				data.newEmail.mailTo = [];
				data.newEmail.mailTo.push({toAdress : data.currentEmail.fromAdress});
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.ANSWER_ALL:
                                var text=data.currentEmail.textBody;
                                var tab=null;
                                tab=text.split('\n');
                                text="";
                                for(var i=0;i<tab.length;i++){


                                        tab[i]='>'+tab[i];
                                        text+=tab[i]+'\n';

                                }

                                data.newEmail.textBody = text;
				data.newEmail.title = "re: " + data.currentEmail.title;
				data.newEmail.mailTo = [];
				data.newEmail.mailTo.push({toAdress : data.currentEmail.fromAdress});
				var i = 0;
				for(i = 0 ; i < data.currentEmail.mailTo.length; i++)
					{
						if (data.currentEmail.fromAdress != data.currentEmail.mailTo[i].toAdress)
							data.newEmail.mailTo.push({toAdress : data.currentEmail.mailTo[i].toAdress});
					}
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.FORWARD:
				//data.newEmail = dojo.clone(data.currentEmail);
				data.newEmail.textBody = data.currentEmail.textBody;
				data.newEmail.title = "fwd: "+data.currentEmail.title;
				data.newEmail.textBody = "Message forward: \n"+data.currentEmail.textBody;
				data.newEmail.mailTo = [];
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.DELETE:
				this.loadDeletePopup();
				break;
			case data.SEND:
				if (!data.newEmail.mailTo[0].toAdress || data.newEmail.mailTo[0].toAdress == "")
					{
						this.checkError(100);
					}
				else
					{
						if (data.newEmail.idMail) {
							if (data.newEmail.title == "")
								data.newEmail.title = _("No Subject", "webapp.email");
							ICTouchAPI.APIServices.Email.updateAndSendMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
						}
						else {
							if (data.newEmail.title == "")
								data.newEmail.title = _("No Subject", "webapp.email");
							ICTouchAPI.APIServices.Email.saveAndSendMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
						}
						data.switchContainer("getMailConsultation", data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
					}
				break;
			case data.CANCEL:
				data.switchContainer("getMailConsultation", data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
				break;
			case data.SAVE:
				if (data.newEmail.idMail) {
					ICTouchAPI.APIServices.Email.updateMail({params:[data.newEmail], context:this, errorCallback: this.onErrorCalback});
					webapp.email.data.currentEmail = {};
					webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
				}
				else {
					ICTouchAPI.APIServices.Email.saveMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
				}
				//data.switchContainer("getMailConsultation", data.STATUS_HOME, _("Mail consultation", "webapp.email"));
				break;
			case data.ADD_CONTACT:
				var objSearch = {
					secondaryInformation: "email", // information of the contact to be displayed at the right of the contact's display name in the search results
					lineClickCallback : {
						neededData : "email",
						context: this,
						func: this.onHandleAddContact
					},
					useDefaultCallMethod : false,
					stealth : true
				};
				webapp.search.doSearch(objSearch,
				function(){ICTouchAPI.transitionServices.back();});
				break;
			default:
				console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
				break;
		}
	},

	//handle for the search function
	onHandleAddContact: function(email, objClickedData) {
		if (email) {
			this.data.newEmail.mailTo.push({toAdress: email});
		}
		ICTouchAPI.transitionServices.getScreen({
						name: "webapp.email.getEmail",
						params: {}
				});
		this.data.switchContainer("getMailEdition", webapp.email.data.STATUS_EDITION, _("Mail Edition", "webapp.email"))
	},

	//callback for the dojo event "ContactDataClickedemail". This is an event that is fired by Contacts, when the
	//user clicks on an emial in the contact card
	onEmailContact :function(objEmail){
		webapp.email.data.mailTo(objEmail.strContent, "", "");
	},

	onDateFormatChanged: function(objSetting) {
		if (objSetting != null) {
			webapp.email.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			webapp.email.data.loadList();
		}
	},

	onErrorCalback: function(JsonResponse, args){
//		if (JsonResponse == "Could not make remote call")
//		this.checkError(110);
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting != null) {
			webapp.email.data._24hformat = objSetting.jsValue;
			webapp.email.data.loadList();
		}
	},

	onNotifyNewMail: function (){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.email.getEmail", params: {}});
                webapp.email.data.selectedFilter="Unread";
                webapp.email.data.loadDetails(1);
		//ICTouchAPI.notificationServices.setNotificationValue("New_Email", 0);
	},

	onMailReceived: function(){
		var data = webapp.email.data;
		var status, nbNew, nbTotal, nbUnread;
		var i = 0;
		for (i = 0; i < arguments.length; i++) {
			switch (arguments[i].name)
			{
				case "nbnew":nbNew = arguments[i].value;
					break;
				case "nbtot":nbTotal = arguments[i].value;
					break;
				case "nbunread":nbUnread = arguments[i].value;
					break;
				case "status":status = arguments[i].value;
					break;
			}
		}

		if (status != 0)
			this.checkError(status);
		else
			{
				data.loadList();
				var i = 0;
				for (i = 0; i < nbNew; i++)
				{
					ICTouchAPI.notificationServices.incNotification("New_Email");
				}
			}

	},

	notifyMailboxFull: function() {
		ICTouchAPI.popupServices.errorPopup(
			_("Error", "ICTouchAPI"),
			_("ERROR_MAILBOX_FULL", "webapp.email"),
			_("Ok", "ICTouchAPI"));
	},

	onMailSave: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			{
				webapp.email.data.loadList();
				webapp.email.data.currentEmail = {};
				webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
			}
	},

	onMailUpdate: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			webapp.email.data.loadList();
	},

	onMailSend: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			webapp.email.data.loadList();
	},

	onMailDelete: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			{
				webapp.email.data.loadList();
				webapp.email.data.selectedMailId = 0;
				webapp.email.data.currentEmail = {};
				webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
			}
	},

	onMailGetError: function(status){
		if (status.value != 40)
			this.checkError(status.value);
	},

	//opens a new Filter popup
	openFilters : function() {
		var context = this;
		var popupData = {
			strTitle: _("Filters", 'webapp.email'),
			strWidgetName: "webapp.email.getFilters",
			arrPopupButtons: [{
				strButtonLabel:  _("Ok", "ICTouchAPI"),
				callback: function() {
					context.updateFilters();
				}
			}]
		};
		this.popupFilters = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	// hide Popup and refresh the list
	updateFilters : function() {
		//var data = webapp.email.data;
		ICTouchAPI.popupServices.removePopup(this.popupFilters);
		webapp.email.data.loadList();
	},

	loadDraftPopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Save as draft", 'webapp.email'),
			strContent : _("Do you want to save the mail as draft?", 'webapp.email'),
			arrPopupButtons: [{
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				callback: function() {
					context.yesDraftCallback();
				}
				},

				{
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noDraftCallback();
				}
				}]
		};
		this.popupFilters = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	loadDeletePopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Delete mail", 'webapp.email'),
			strContent : _("Do you want to delete this mail?", 'webapp.email'),
			arrPopupButtons: [{
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				callback: function() {
					context.yesDeleteCallback();
				}
				},

				{
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noDeleteCallback();
				}
				}]
		};
		this.deletePopUp = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesDraftCallback: function() {
		var data = webapp.email.data;
		ICTouchAPI.popupServices.removePopup(this.popupFilters);
		if (data.newEmail.idMail)
			{
				//data.selectedMailId = data.newEmail.idMail;
				ICTouchAPI.APIServices.Email.updateMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
			}
		else
			{
				//data.selectedMailId = data.newEmail.idMail;
				ICTouchAPI.APIServices.Email.saveMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
			}
		data.selectedMailId = data.currentEmail.idMail;
		data.switchContainer("getMailConsultation", data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
	},

	noDraftCallback: function() {
		if (webapp.email.data.selectedMailId)
			webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
		else
			webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
		ICTouchAPI.popupServices.removePopup(this.popupFilters);

	},

	yesDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
		ICTouchAPI.APIServices.Email.deleteMail({params:[webapp.email.data.currentEmail.idMail], context:this, errorCallback:this.onErrorCalback});
	},

	noDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
	},

//	saveMail: function(objMail) {
//		ICTouchAPI.APIServices.Email.saveMail([objMail], this);
//	},


	checkError : function(status) {
		var strMessage = "";
		switch (status) {
			case 1:strMessage = _("ERROR_DB_OVERFLOW", "webapp.email");
				break;
			case 2:strMessage = _("ERROR_DB_OTHER", "webapp.email");
				break;
			case 5:strMessage = _("ERROR_ATTACHED_FILE_NOT_FOUND", "webapp.email");
				break;
			case 9:strMessage = _("EMAIL_ERROR_LOGIN", "webapp.email");
				break;
			/*case 10:strMessage = _("ERROR_MAX_EMAILS_REACHED", "webapp.email");
				break;*/
			case 20:strMessage = _("ERROR_EMAIL_NOT_FOUND", "webapp.email");
				break;
			case 21:strMessage = _("ERROR_EMAIL_ALREADY_READ", "webapp.email");
				break;
			case 22:strMessage = _("ERROR_EMAIL_STATUS_NOT_READ_NOR_UNREAD", "webapp.email");
				break;
			case 23:strMessage = _("ERROR_EMAIL_ALREADY_SENT", "webapp.email");
				break;
			case 30:strMessage = _("ERROR_MAILSERVER_UNREACHABLE", "webapp.email");
				break;
			case 31:strMessage = _("ERROR_MAILSERVER_ERROR", "webapp.email");
				break;
			case 35:strMessage = _("ERROR_MAILSERVER_CANT_DELETE", "webapp.email");
				break;
			case 40:strMessage = _("SEARCH_NO_MAIL_FOUND", "webapp.email");
				break;
		    case 100:strMessage = _("NO_DESTINATION_ADDRESS", "webapp.email");
				break;
			case 200:strMessage = _("ADDRESS_INVALID", "webapp.email");
				break;
//			case 110:strMessage = _("IctMail: could not make remote call", "webapp.email");
//				break;
			default:
				strMessage = _("Unknown error message", "webapp.email");
				break;
		}

		if (strMessage != "") {
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("Ok", "ICTouchAPI"), status)
		}
		return false;
	},

	//Returns a list of contacts, compiled from the list of senders
	getCurrentSenders : function() {
	},

	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction){
		this._onProgKeyConfig(objAction);
		return null;
	},

	_onProgKeyConfig : function (objAction) {
		if(objAction.action == "send-mail") {
			var objSearch = {
				clickCallback: dojo.hitch(webapp.communication, webapp.communication._progKeySetArgs)
			};
			// show numeric
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {
				funcCallbackOk : function(){
					objSearch.clickCallback(null, {strValue: this.getValue()});
				},
				funcCallbackExit : function(){
					webapp.progkeys.currentAddWidget.boolReset = false;
					ICTouchAPI.transitionServices.getScreen({name: "webapp.progkeys.getProgKeyAdd", params: {}});
				}
			});
		}
	},

	_progKeySetArgs : function(mailAddr) {
		if (mailAddr && mailAddr!="") {
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
			// We notify progkeys that he doesn't have to reset the display and variables this time
			webapp.progkeys.setProgkeysArgumentsNextStep(mailAddr);
		}
	},

	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "email",
			action : "send-mail",
			type : 1,
			icon : "mail-send-mail",
			label : "Send Mail"
		});
		return listActions;
	},

	onProgKeyClick : function(objAction) {
		if(objAction.action == "send-mail") {
			//ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication", params: {}});
			webapp.email.data.mailTo(objAction.arguments,"","");
		}
	},

	onDayChanged : function(){
		var dateNow = new Date();
		var arr = this.data.getList();
		var tabElem;
		for (var i=0; i<arr.length;i++){
			if (typeof (arr[i].objMail) == "undefined" && arr[i].date){ //If the selectItem in MenuList is not an email (no subject) or the draft category
				tabElem = arr[i];
				if(dojo.date.compare(tabElem.date, dateNow,"date") == 0){ //It is the today list ?
					tabElem.strPrimaryContent = _("TODAY", "webapp.email");
	}
				else{
					tabElem.strPrimaryContent = ICTouchAPI.tools.getFormatedDate(tabElem.date,this.data._dateFormat);
				}
				//Update display if already created
				if (this.objMenuUI){
					this.objMenuUI.updatePrimaryContent(i,tabElem.strPrimaryContent);
				}
			}
		}
	}

});
dojo.require("webapp.email.controlBase");
dojo.provide("webapp.email");
dojo.declare("webapp.email",webapp.email.controlBase,{});

webapp.email=new webapp.email();
dojo.provide("webapp.email.dataBase");
dojo.declare("webapp.email.dataBase", null, {

    _arrAppButtons : [],
    _strContainerPath : "webapp.email.getMailConsultation", //default details
    _strTitle : "", // default nothing_strContainerPath
    _strListTitle : "Emails",
    _arrEmailList : [],
    _arrEmailListPreview: [],
    _arrDraftList : [],
    _arrTempInbox : [],
    _arrAttachmentList : [],
    _dateFormat : "",
    _24hformat : false,
    _editDraftButton : null,
    _tempUnreadMails : [],

    filters : [],
    orderBy : [],
	filtersNotTranslated : [],
	orderByNotTranslated : [],
    selectedFilter : "All", //default value
    selectedOrderBy : "Date", //default value

    currentEmail: null,
    newEmail	: {},
    selectedMailId : null,

    STATUS_HOME			: 0,
    STATUS_CONSULTATION	: 1,
    STATUS_EDITION		: 2,
    NB_STATUS			: 3,
	ALL					: "All",
	UNREAD				: "Unread",
	DATE				: "Date",
	SENDER				: "Sender",

    BACK		: "BACK_BTN",

    NEW_MAIL	: "NEW_MAIL_BTN",
    EDIT_DRAFT	: "EDIT_DRAFT_BTN",
    FILTERS		: "FILTERS_BTN",
    ANSWER		: "ANSWER_BTN",
    ANSWER_ALL	: "ANSWER_ALL_BTN",
    FORWARD		: "FORWARD_BTN",
    DELETE		: "DELETE_BTN",
	ADD_CONTACT	: "ADD_CONTACT_BTN",

    SEND		: "SEND_BTN",
    CANCEL		: "CANCEL_BTN",
    SAVE		: "SAVE_BTN",

    MAIL		: "MAIL_BTN",
    ANSWER_BY_MAIL	: "ANSWER_BY_MAIL",

    MAILTYPE_DRAFT	: "DRAFT",
    MAILTYPE_UNREAD : "UNREAD",
    MAILTYPE_READ : "READ",

    constructor: function() {
        var func = dojo.hitch( webapp.email, webapp.email.buttonCallback);

        var arrButtons = [];
        arrButtons.push({
            strButtonName: this.NEW_MAIL,
            strButtonLabel: _("New mail", "webapp.email"),
            strButtonIcon: 'mail-application',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.FILTERS,
            strButtonLabel: _("Filters", "webapp.email"),
            strButtonIcon: 'mail-filter',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        this._arrAppButtons[this.STATUS_HOME] = arrButtons;

        arrButtons = [];
        arrButtons.push({
            strButtonName: this.NEW_MAIL,
            strButtonLabel: _("New mail", "webapp.email"),
            strButtonIcon: 'mail-application',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.EDIT_DRAFT,
            strButtonLabel: _("Edit draft", "webapp.email"),
            strButtonIcon: 'generic-modify',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.ANSWER,
            strButtonLabel: _("Answer", "webapp.email"),
            strButtonIcon: 'mail-answer-by-mail',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.ANSWER_ALL,
            strButtonLabel: _("Answer all", "webapp.email"),
            strButtonIcon: 'mail-answer-all',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.FORWARD,
            strButtonLabel: _("Forward", "webapp.email"),
            strButtonIcon: 'mail-forward',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.DELETE,
            strButtonLabel: _("Delete", "ICTouchAPI"),
            strButtonIcon: 'mail-delete-mail',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.FILTERS,
            strButtonLabel: _("Filters", "webapp.email"),
            strButtonIcon: 'mail-filter',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        this._arrAppButtons[this.STATUS_CONSULTATION] = arrButtons;

        arrButtons = [];
        arrButtons.push({
            strButtonName: this.SEND,
            strButtonLabel:  _("Send mail", "webapp.email"),
            strButtonIcon: 'mail-send-mail',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.CANCEL,
            strButtonLabel:  _("Cancel", "ICTouchAPI"),
            strButtonIcon: 'generic-cancel',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.SAVE,
            strButtonLabel:  _("Save mail", "webapp.email"),
            strButtonIcon: 'mail-save',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
		arrButtons.push({
            strButtonName: this.ADD_CONTACT,
            strButtonLabel:  _("Search", "ICTouchAPI"),
            strButtonIcon: 'generic-search-by-name',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        this._arrAppButtons[this.STATUS_EDITION] = arrButtons;

        for (var j = 0; j < this.NB_STATUS; j++)
        {
            var appBar = ICTouchAPI.AppBarServices.getAppBar("email","emailstatus"+j);
            for (var k in this._arrAppButtons[j])
            {
                var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[j][k]);
                appBar.addActionButton(objButton);
            }
        }
        this._loadSettings();

        //construct the filters
        this.filters.push({
            intIndex: 0,
            strLabel: _("All", "webapp.email")
        });
        this.filters.push({
            intIndex: 1,
            strLabel: _("Unread", "webapp.email")
        });
        this.orderBy.push({
            intIndex: 0,
            strLabel: _("Sender", "webapp.email")
        });
        this.orderBy.push({
            intIndex: 1,
            strLabel: _("Date", "webapp.email")
        });
		//create arrays of filters that do not pass through the translation mecanism
		this.filtersNotTranslated.push(this.All);
		this.filtersNotTranslated.push(this.UNREAD);
		this.orderByNotTranslated.push(this.SENDER);
		this.orderByNotTranslated.push(this.DATE);

        //add the MAIL and ANSWER_BY_MAIL buttons inside the communication webapp.
        // Check if the webapp communication is already loaded before adding the buttons
        // "Mail" and "Answer by Mail" to the webapp communication
        if (webapp.communication) {
            this._addEmailButtonsToCommunication();
        }
        // If the webapp communication is not loaded yet, subscribe to the event
        // "webapp.communication.loaded" emitted after the creation of the
        // communication view (posteCreate of getCommunicationBase)
        else {
            dojo.subscribe("webapp.communication.loaded", this, function() {
                this._addEmailButtonsToCommunication();
            });
        }

        this._arrDraftList = [];
    },

    /* _addEmailButtonsToCommunication
     * Add the buttons "Mail" and "Answer by Mail" to the communication webapp
     * */
    _addEmailButtonsToCommunication:function(){
        dojo.subscribe("ManageExternalButtonsCom", this, this.onManageButtonsEvent);
        var funcMail = dojo.hitch(this, this.mailBtnCallback);
		var funcAnswer = dojo.hitch(this, this.answerBtnCallback);
        var mailButton = {
            strButtonName: this.MAIL,
            strButtonLabel:  _("Mail", "webapp.email"),
            strButtonIcon: 'mail-application',
            callback: funcMail
        };
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_EMPTY, mailButton);
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG, mailButton);
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_MERGE_CALLS, mailButton);
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, mailButton);

        var answerButton = {
            strButtonName: this.ANSWER_BY_MAIL,
            strButtonLabel:  _("Answer by Mail", "webapp.email"),
            strButtonIcon: 'mail-answer-by-mail',
            callback: funcAnswer
        };
		if (webapp.communication) {
			//webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_INCOMING, answerButton);
		}
    },

    //handle the hiding and showing of the Mail and Answer by Mail buttons inside the comm appbar
    onManageButtonsEvent:function(objContact, status) {
		var numStatus = webapp.communication.data.getNumAppBarFromStatus(status);
        var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+numStatus);
        // Get the "Mail" and "Answer by Mail" buttons from the webapp appbar acording to its current status
        var btnMail = appBar.getButton(this.MAIL);
        var btnAnswerMail = appBar.getButton(this.ANSWER_BY_MAIL);

        // If the "Mail" button exists, check if a contact is selected in the communication
        // webapp -> if yes, display the "Mail" button, else hide it
        if (btnMail) {
            if (objContact && objContact.email) {
                btnMail.show();
            }
            else {
                btnMail.hide();
            }
        }
        // If the "Answer by Mail" button exists, check if a contact is selected in the communication
        // webapp -> if yes, display the "Answer by Mail" button, else hide it
        if (btnAnswerMail) {
            if (objContact && objContact.email ) {
                btnAnswerMail.show();
            }
            else {
                btnAnswerMail.hide();
            }
        }
    },

    mailBtnCallback: function(buttonId) {
        if (webapp.communication) {
            var objContact = webapp.communication.data.getCurrentContact();
            if (objContact && objContact.email){
                this.mailTo(objContact.email, "", "");
            }
        }
    },

	answerBtnCallback:function(buttonId) {
		if (webapp.communication) {
			var call = webapp.communication.data.getSelectedEntry();
			var objContact = webapp.communication.data.getCurrentContact();
			if (call && call.objCallData.callId)
			{
				ICTouchAPI.APIServices.Telephony.ignoreCall({params: [call.objCallData.callId], context: this});
			}
			if (objContact && objContact.email){
                this.mailTo(objContact.email, "", "");
            }

		}
	},

    getContainerTitle : function() {
        return this._strTitle;
    },

    getContainerPath : function(){
        return this._strContainerPath;
    },

    getListTitle : function() {
        return this._strListTitle;
    },

    getDetails : function() {
        return this.currentEmail ? this.currentEmail : {};
    },

    getList : function() {
        return this._arrEmailList;
    },

    getAttachmentList: function(){
        return this._arrAttachmentList;
    },

    getListPreview : function() {
        return this._arrEmailListPreview;
    },

    // set a new content for the container of the email and call an update of the appBar
    switchContainer: function(pageName, status, pageTitle) {
        this._strContainerPath = "webapp.email."+pageName;
        if(pageTitle)
            this._strTitle = pageTitle;
        this.updateAppBar(status);
        if (webapp.email.mainWidget)
            webapp.email.mainWidget.reloadContainer();
    },

    // set the appBar corresponding to the status
    updateAppBar: function(status) {
        // set the status
        webapp.email.currentStatus = status;

        //If current mail is not a draft, don't show "edit draft" button
        if (status == this.STATUS_CONSULTATION && this.currentEmail != null) {
            var appBar = ICTouchAPI.AppBarServices.getAppBar("email", "emailstatus"+status);
            var btn = appBar.getButton(this.EDIT_DRAFT);
            if (this.currentEmail.status == "DRAFT")
                btn.show();
            else
                btn.hide();
        }

        // button callback
        var backFunc = dojo.hitch( webapp.email, webapp.email.buttonCallback, this.BACK);
		ICTouchAPI.AppBarServices.addExitButton("email","emailstatus"+status, this.isPreviousHome(), backFunc);

        // Register appBar according to state
        ICTouchAPI.AppBarServices.setAppBar("email", "emailstatus"+status, "getEmail");
    },

    // gets the settings for the app
    _loadSettings : function(){
        ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
            // save the setting
            if (objSetting != null)
                this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
            // get another setting
            ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
                // save the setting
                if(value != null)
                    this._24hformat = value;
                this.loadList();
            });
        });
    },

    loadList : function () {
        if (this.selectedFilter == this.ALL)
            ICTouchAPI.APIServices.Email.getAllMails({
                params:[""],
                context:this,
                callback:this.loadedList,
                errorCallback:dojo.hitch(webapp.email, webapp.email.onErrorCalback)
            });
        else
            ICTouchAPI.APIServices.Email.getUnreadMails({
                params:[""],
                context:this,
                callback:this.loadedUnread,
                errorCallback:dojo.hitch(webapp.email, webapp.email.onErrorCalback)
            });
    },
    loadedUnread: function(_arr){
        this._tempUnreadMails = _arr;
        ICTouchAPI.APIServices.Email.findDraftMail({
            params:["", 0, 0],
            context:this,
            callback:this.onFindDraft,
            errorCallback:dojo.hitch(webapp.email, webapp.email.onErrorCalback)
        });
    },

    onFindDraft: function(_arr) {
        this._tempUnreadMails = this._tempUnreadMails.concat(_arr);
        this.loadedList(this._tempUnreadMails);
    },
    loadedList : function(_arr) {
        // fill _arrEmailList
        this._arrEmailList = [];
        this._arrDraftList = [];
        this._arrEmailListPreview = [];
        this._arrTempInbox = [];
        for (var i in _arr) {
            var objMail = _arr[i];
            if (objMail.status == this.MAILTYPE_DRAFT) {
                var strTime = ICTouchAPI.tools.getFormatedTime(objMail.saved.datetime.hour, objMail.saved.datetime.minute, this._24hformat);
                this._arrDraftList.push({
                    strSecondaryContent : objMail.fromAdress,
                    strPrimaryContent: objMail.title,
                    strType: "normal",
                    objMail: objMail,
                    date: strTime,
                    strTime: strTime
                });
            }
            else
                this._addToInbox(objMail);
        }
        this._sortInbox();
        this._buildList();
    },

    _addToInbox : function(objMail) {
        // first sorting of the elements, by day
        if (this.selectedOrderBy == this.DATE) {
            // Warning : javascript months starts at 0 (january..)
            var date = new Date(objMail.sentReceived.datetime.year, objMail.sentReceived.datetime.month - 1, objMail.sentReceived.datetime.day);
            // key date for the array format : day-month-year
            var strDateKey = date.format('yyyy-MM-dd',dojo.locale);

            if(!this._arrTempInbox.hasOwnProperty(strDateKey)) {
                // the key does not exist, create it
                this._arrTempInbox[strDateKey] = [];
            }

            // add the event to the day
            this._arrTempInbox[strDateKey].push(objMail);
        }
        else if (this.selectedOrderBy == this.SENDER) {
            //order the list according to senders
            var strSender = objMail.fromAdress;

            if(!this._arrTempInbox.hasOwnProperty(strSender))
                // the key does not exist, create it
                this._arrTempInbox[strSender] = [];

            this._arrTempInbox[strSender].push(objMail);
        }
    },

    _sortInbox : function() {
        if (this.selectedOrderBy == this.DATE) {
            // we must sort the temporary list by date
            // We have to sort the Keys of this array
            var keys = [];
            for (var k in this._arrTempInbox)
            {
                if (this._arrTempInbox.hasOwnProperty(k))
                {
                    keys.push(k);
                }
            }
            // sorting key by descending order
            keys.sort(function (a, b) {
                return (b > a) - (b < a);
            });

            // populate the array for the clickable list
            var dateNow   = new Date();
            var boolToday = false; // default not today
            // filling
            // through the keys of the table
            for (var j = 0; j < keys.length; j++)
            {
                var key = keys[j];

                if(this._arrTempInbox.hasOwnProperty(key))
                {
                    // gets date from the key year-month-day
                    var arrDate = key.split('-');
                    var date = new Date(arrDate[0], arrDate[1]-1, arrDate[2]);
                    // add title to the day
                    if(dojo.date.compare(date, dateNow,"date") == 0)
                    {
                        // Today !
                        this._arrEmailList.push({
                            strPrimaryContent: _("TODAY", "webapp.email"),
                            strType: "title",
                            date : date, // private property for our data
							boolToday : true
                        });
                        boolToday = true;
                    }
                    else
                    {
                        this._arrEmailList.push({
                            strPrimaryContent: _(ICTouchAPI.tools.getFormatedDate(date,this._dateFormat), "webapp.email"),
                            strType: "title",
                            date : date // private property for our data
                        });
                        boolToday = false;
                    }

                    // sort the elements added previously  by time decrease sort
                    this._arrTempInbox[key].sort(function(a,b) {
                        // a and b are two planned events
                        // test hours
                        if(a.sentReceived.datetime.hour > b.sentReceived.datetime.hour)
                            return -1;
                        else if(a.sentReceived.datetime.hour < b.sentReceived.datetime.hour)
                            return 1;
                        else //hours =, to test minutes
                        {
                            if(a.sentReceived.datetime.minute > b.sentReceived.datetime.minute)
                                return -1;
                            else if(a.sentReceived.datetime.minute < b.sentReceived.datetime.minute)
                                return 1;
                            else
                                return 0;
                        }
                    });

                    for(var keyTemp in this._arrTempInbox[key])
                    {
                        var obj = this._arrTempInbox[key][keyTemp]; // an email
                        // time print format hours:minutes-hours:minutes
                        var strTime = ICTouchAPI.tools.getFormatedTime(obj.sentReceived.datetime.hour, obj.sentReceived.datetime.minute, this._24hformat);
                        // add email event to the list
                        var objClass ="";
                        if (obj.status == "UNREAD")
                            objClass = "logEntryBlue";
                        else
                            objClass = "";
                        this._arrEmailList.push({
                            strSecondaryContent : obj.fromAdress,
                            strPrimaryContent: obj.title,
                            strPrimaryContentClass : objClass,
                            strType: "normal",
                            date: strTime,
                            strTime: strTime,
                            objMail: obj
                        });
                        // add email to the preview List
                        if(boolToday)
                        {
                            this._arrEmailListPreview.push({
                                strSecondaryContent : obj.fromAdress,
                                strPrimaryContent: obj.title,
                                strType: "normal",
                                date: strTime,
                                strTime: strTime,
                                objMail: obj
                            });
                        }
                    }
                }
            }
        }
        else {
            //manage the situation were the menulist must be sorted by Sender
            var keys = [];
            for(var k in this._arrTempInbox)
            {
                if(this._arrTempInbox.hasOwnProperty(k))
                {
                    keys.push(k);
                }
            }
            //sort the list lexicographically
            keys.sort();

            //sort the mails of the different senders by date
            for (var j = 0; j < keys.length; j++)
            {
                var key = keys[j];

                this._arrEmailList.push({
                    strPrimaryContent: key,
                    strType: "title"
                });
                if(this._arrTempInbox.hasOwnProperty(key))
                {
                    this._arrTempInbox[key].sort(function(a,b) {
                        // a and b are two emails
                        // test hours
                        if(a.sentReceived.datetime.hour > b.sentReceived.datetime.hour)
                            return -1;
                        else if(a.sentReceived.datetime.hour < b.sentReceived.datetime.hour)
                            return 1;
                        else //hours =, to test minutes
                        {
                            if(a.sentReceived.datetime.minute > b.sentReceived.datetime.minute)
                                return -1;
                            else if(a.sentReceived.datetime.minute < b.sentReceived.datetime.minute)
                                return 1;
                            else
                                return 0;
                        }
                    });
                }

                for(var keyTemp in this._arrTempInbox[key]) {
                    var obj = this._arrTempInbox[key][keyTemp]; // en email
                    // time print format hours:minutes-hours:minutes
                    var strTime = ICTouchAPI.tools.getFormatedTime(obj.sentReceived.datetime.hour, obj.sentReceived.datetime.minute, this._24hformat);
                    // add email to the list
                    this._arrEmailList.push({
                        strSecondaryContent : obj.fromAdress,
                        strPrimaryContent: obj.title,
                        strType: "normal",
                        date: strTime,
                        strTime: strTime,
                        objMail: obj
                    });
                }
            }
        }
    },

    _buildList : function () {
        //add the list of draft mails
        this._arrEmailList.push({
            strPrimaryContent: _("DRAFT", "webapp.email"),
            strType: "title"
        });
        this._arrEmailList = this._arrEmailList.concat(this._arrDraftList);
        //manage the indexes in the new or updated list
        for(var i in this._arrEmailList) {
            this._arrEmailList[i].intIndex = i;
        }
		//manage the indexes in the preview list
	
		for(var i = 0; i < this._arrEmailListPreview.length; i++) {
			this._arrEmailListPreview[i].intIndex = i + 1;
		}

	
        // refresh Lists
        if( webapp.email.mainWidget )
            webapp.email.mainWidget.reloadMenu();
        if (webapp.email.previewContainer)
            webapp.email.previewContainer.refresh();
    },

    loadDetails : function (emailId) {
        var context = this;
        var i = 0;
        this._arrAttachmentList = [];
        var index = 0;

        if (webapp.email.currentStatus == webapp.email.data.STATUS_EDITION)
            webapp.email.loadDraftPopup();

        var email = this._arrEmailList[emailId];
        this.currentEmail = email.objMail;
        //check for attachements, if found update the array containing them
        if (this.currentEmail && this.currentEmail.mailAtt) {
            if (this.currentEmail.mailAtt.length > 0) {
                for (i = 0; i < this.currentEmail.mailAtt.length; i++ )
                {
                    ICTouchAPI.APIServices.FileManager.getFile({
                        params:[this.currentEmail.mailAtt[i].fileId],
                        context:this,
                        callback:function(listFile) {
                            context._arrAttachmentList.push({
                                strLabel : _("Attached file", "webapp.email"),
                                strContent : listFile[0].name,
                                strIcon:"",
                                callback : function(){ }
                            });
                            if (index == context.currentEmail.mailAtt.length -1){
                                context.switchContainer("getMailConsultation", this.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
                                return;
                            }
                            index++;
                        }
                    });
                }
            }
        }

        //if mail is unread then call readMail function, and update the mail in the local array of mails.
        if (this.currentEmail)
            if (this.currentEmail.status == this.MAILTYPE_UNREAD && this.currentEmail.status != this.MAILTYPE_DRAFT)
            {
                ICTouchAPI.APIServices.Email.readMail({
                    params:[this.currentEmail.idMail],
                    context:this
                });
				//decrease the unread email notification
				ICTouchAPI.notificationServices.decNotification("New_Email");
                this._arrEmailList[emailId].objMail.status = this.MAILTYPE_READ;
                webapp.email.data.selectedMailId = this._arrEmailList[emailId].objMail.idMail;
                this._arrEmailList[emailId].strPrimaryContentClass = "";
                webapp.email.emailList.refresh();
            }
        this.switchContainer("getMailConsultation", this.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
    },



    //public mathod to open a new mail in edition mode
    mailTo : function(emailTo, mailSubject, mailBody) {
        ICTouchAPI.transitionServices.getScreen({
            name: "webapp.email.getEmail",
            params: {}
        });
        this.newEmail = {
            mailTo: [{
                toAdress : emailTo
            }],
            title: mailSubject,
            textBody : mailBody
        };
        this.switchContainer("getMailEdition", this.STATUS_EDITION, _("Mail Edition", "webapp.email"));
    },

    //function the retreive the filters
    getFilters : function() {
        var filters = [];
        filters[0] = this.filters;
        filters[1] = this.orderBy;
        return filters;
    },

	isPreviousHome : function() {
		switch(this._strContainerPath)	{
			case "webapp.email.getMailConsultation" :
				return true;
				break;
			case "webapp.email.getMailEdition" :
				return false;
				break;
			default :
				return false;
				break;
		}
	}


});
dojo.require("webapp.email.dataBase");
dojo.provide("webapp.email.data");

dojo.declare("webapp.email.data", webapp.email.dataBase, {});

webapp.email.data = new webapp.email.data();dojo.provide("webapp.email.getEmailBase");
dojo.declare("webapp.email.getEmailBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		container   : null,
                menu        : null,

		postCreate:function(){
			var data = webapp.email.data;
			var am = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "webapp.email.getEmailList",
					params  : {}
				},

				container : {
					name    : data.getContainerPath(),
					params  : {}
				},
				objContainerTitle : {strLabel : _("Mail Consultation", "webapp.email")},
				objMenuTitle : {strLabel : data.getListTitle()}
			}, this.mainPart);

				this.container = am.getContainer();
				this.menu = am.getMenu();
                webapp.email.mainWidget = this;
                webapp.email.emailList = am.getMenu();
				data.updateAppBar(data.STATUS_HOME);
		},

		reloadContainer: function() {
			var data = webapp.email.data;
			this.container.reload({
                objTitle: { strLabel : data.getContainerTitle() },
                objContent: {
                    name: data.getContainerPath(),
                    params: {}
                }
            });
		},

		reloadMenu: function() {
			var data = webapp.email.data;
			this.menu.reload({
                objTitle: { strLabel : data.getListTitle() },
                objContent: {
                    name: "webapp.email.getEmailList",
                    params: {}
                }
            });
		}
	}
);dojo.require("webapp.email.getEmailBase");
dojo.provide("webapp.email.getEmail");
dojo.declare("webapp.email.getEmail",
	webapp.email.getEmailBase,
	{
		templatePath: dojo.moduleUrl("webapp.email","templates/getEmail8082.html"),
		cssFile : ['main.css','icons.css'],
	}
);dojo.provide("webapp.email.getEmailListBase");
dojo.declare("webapp.email.getEmailListBase", 
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		postCreate:function() {
			var data = webapp.email.data;
			var arrEmailList = data.getList();
			// function on click to get details
			var func = dojo.hitch(data, data.loadDetails);
			webapp.email.objMenuUI = new UIElements.MenuList.MenuListControl(
				{ arrItems: arrEmailList, autoSelectFirst : false, callback: func },
				this.domList
			);
			// Compute selected item position
			if (data.selectedMailId != null) {
				var pos = 0;
				var i = 0;
				for (i = 0; i < arrEmailList.length; i++) {
					if (arrEmailList[i].objMail)
						if (data.selectedMailId == arrEmailList[i].objMail.idMail) {
							webapp.email.objMenuUI.selectItemByPosition(pos, true);
							return;
						}
					pos++;
				}
			}
		}
	}
);
dojo.require("webapp.email.getEmailListBase");
dojo.provide("webapp.email.getEmailList");

dojo.declare("webapp.email.getEmailList", 
	webapp.email.getEmailListBase,
	{
		templatePath: dojo.moduleUrl("webapp.email","templates/getEmailList8082.html"),
	}
);
dojo.provide("webapp.email.getMailConsultationBase");
dojo.declare("webapp.email.getMailConsultationBase", 
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		strCoreMessage : "",
		objAttachmentListUI : null,
		currentEmail: {},
		_attachmentList : [],

		ToSelector : 0,
		FromSelector : 1,
		TitleSelector : 2,
		MessageSelector : 3,
		domAttachments : null,
		domHeader : null,
		domMessage : null,
		domConsultation : null,

		scroll : null,

		postMixInProperties : function() {
			this.currentEmail = webapp.email.data.getDetails();
			if(this.currentEmail.textBody) {
				this.strCoreMessage = this.formatTextBody(this.currentEmail.textBody);
			}
		},

		formatTextBody :function(text) {
			var reg = RegExp("\n", "g");
			text = text.replace(reg, "<br/>");
			return text;
		},

		postCreate:function(){
			var listHeaderdetails = [];
			var context = this;
			if(this.currentEmail.mailTo)
				{
					var strTemp = "";
					var i =0;
					for (i = 0; i < this.currentEmail.mailTo.length; i++)
						{
							if (i != 0)
								strTemp += "; ";
							if (this.currentEmail.mailTo[i].toAdress != "")
								strTemp += this.currentEmail.mailTo[i].toAdress;
						}
					listHeaderdetails.push({strLabel : _("To", "webapp.email"), strContent : strTemp});
				}
			if(this.currentEmail.fromAdress)
				listHeaderdetails.push({strLabel : _("From", "webapp.email"), strContent : this.currentEmail.fromAdress});
			if(this.currentEmail.title)
				listHeaderdetails.push({strLabel : _("Title", "webapp.email"), strContent : this.currentEmail.title});
			new UIElements.PresentationList.PresentationListControl({arrItems : listHeaderdetails, boolScroll : false, boolShowLabel: true}, this.domHeader);
			
			this._attachmentList = webapp.email.data.getAttachmentList();
			if (this._attachmentList)
				this.objAttachmentListUI = new UIElements.PresentationList.PresentationListControl({arrItems : this._attachmentList, boolScroll : false, boolShowLabel: true}, this.domAttachments);

			//add a scrool to move the whole page at once
			this.scroll = new UIEffects.Scroll.VerticalList(this.domConsultation, {});
		},

		destroy: function() {
			if( this.scroll )
				this.scroll.destroy();
			this.inherited(arguments);
		},
		
		onAttachmentClick: function(){
			//alert("Call FileManager function");
		}

	});
dojo.require("webapp.email.getMailConsultationBase");
dojo.provide("webapp.email.getMailConsultation");
dojo.declare("webapp.email.getMailConsultation", 
    webapp.email.getMailConsultationBase,
    {
        templatePath: dojo.moduleUrl("webapp.email","templates/getMailConsultation8082.html"),
    }
);
dojo.provide("webapp.email.getMailEditionBase");
dojo.declare("webapp.email.getMailEditionBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		toUI		: null,
		titleUI		: null,
		messageUI	: null,
		strTo		: "",
		strTitle	: "",
		strMessage	: "",

        postMixInProperties : function() {
			this.strTo = _("To :", "webapp.email");
			this.strTitle = _("Title :", "webapp.email");
			this.strMessage = _("Message :", "webapp.email");
		},

        postCreate:function(){
			var data = webapp.email.data;
			this.toUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: true,
				funcCallback: dojo.hitch(this, this.onToUIChange)
			}, this.domTo);
			this.titleUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: false,
				funcCallback: function(strContent) {
					webapp.email.data.newEmail.title = strContent;
				}
			}, this.domTitle);
			this.messageUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: true,
				funcCallback: function(strContent) {
					webapp.email.data.newEmail.textBody = strContent
				}
			}, this.domMessage);

			//collect all the adresses and display them with ";" between them
			if(data.newEmail.mailTo)
				{
					var strTemp = "";
					var i =0;
					for (i = 0; i < data.newEmail.mailTo.length; i++)
					{
						if (i != 0)
							strTemp += "; ";
						if (data.newEmail.mailTo[i].toAdress != "")
							strTemp += data.newEmail.mailTo[i].toAdress;
					}
					this.toUI.setInputFieldContent(strTemp);
				}
			if(data.newEmail.title)
				this.titleUI.setInputFieldContent(data.newEmail.title);
			if(data.newEmail.textBody)
				this.messageUI.setInputFieldContent(data.newEmail.textBody);

			this.inherited(arguments);
		},

		onToUIChange:function(strContent) {
			var strContentTemp = dojo.trim(strContent);
			if (strContentTemp != "")
				{
				var tableau = strContentTemp.split(";");
					webapp.email.data.newEmail.mailTo = [];
					for (i = 0; i < tableau.length; i++)
						{
					if(tableau[i] && dojo.trim(tableau[i])){
						webapp.email.data.newEmail.mailTo.push({
							toAdress : dojo.trim(tableau[i])
						});
							}
							}
				var strTemp = webapp.email.data.newEmail.mailTo[0].toAdress;
				for (i = 1; i < webapp.email.data.newEmail.mailTo.length; i++) {
					strTemp += ";" + webapp.email.data.newEmail.mailTo[i].toAdress;
						}
						this.toUI.setInputFieldContent(strTemp, false);
				}
		},
    });
dojo.require("webapp.email.getMailEditionBase");
dojo.provide("webapp.email.getMailEdition");
dojo.declare("webapp.email.getMailEdition", 
    webapp.email.getMailEditionBase,
    {
        templatePath: dojo.moduleUrl("webapp.email","templates/getMailEdition8082.html"),
    }
);
dojo.provide("webapp.email.getFiltersBase");
dojo.declare("webapp.email.getFiltersBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
	     strFilters : "",
            strOrderBy : "",

	    constructor : function(){
              ICTouchAPI.settingServices.getSettingValue("eMailDefaultFilter",this,this.setFilter);
              ICTouchAPI.settingServices.getSettingValue("eMailDefaultSort", this, this.setSort);
            },

            setFilter : function(value){
                if(value===0){
                        webapp.email.data.selectedFilter="All";
                }
                else{
                     webapp.email.data.selectedFilter="Unread";
                }
            },

            setSort : function(value){
                if(value===0){
                       webapp.email.data.selectedOrderBy="Sender";
                }
                else{
                    webapp.email.data.selectedOrderBy="Date";
                }
            },


        postMixInProperties : function() {
			this.strFilters = _("Filters :", "webapp.email");
			this.strOrderBy = _("Order by :", "webapp.email");
		},

		postCreate:function(){
			this.strFilters = "";
			this.strOrderBy = "";
            var func0 = function(intIndex) {
                if(webapp.email.data.selectedFilter != webapp.email.data.filtersNotTranslated[intIndex]){
                        webapp.email.data.selectedFilter = webapp.email.data.filtersNotTranslated[intIndex];
                        ICTouchAPI.settingServices.setSettingValue("eMailDefaultFilter", intIndex);
                }
            };
            var func1 = function(intIndex) {
                if(webapp.email.data.selectedOrderBy != webapp.email.data.orderByNotTranslated[intIndex]){
                         webapp.email.data.selectedOrderBy = webapp.email.data.orderByNotTranslated[intIndex];
                         ICTouchAPI.settingServices.setSettingValue("eMailDefaultSort", intIndex);
                }
            };
            
            var _arr = webapp.email.data.getFilters();
            var i;
            for (i in _arr[0])
                if (_arr[0][i].strLabel.toTranslate == webapp.email.data.selectedFilter)
                    _arr[0][i].boolSelected = true;
                else
                    _arr[0][i].boolSelected = false;
            for (i in _arr[1])
                if (_arr[1][i].strLabel.toTranslate == webapp.email.data.selectedOrderBy)
                    _arr[1][i].boolSelected = true;
                else
                    _arr[1][i].boolSelected = false;

            new UIElements.SelectList.SelectListControl({
                    arrItems: _arr[0],
                    intContainerSize: 2,
                    boolMultiselect: false,
                    itemCallback: func0
            }, this.domSelectList0);
              new UIElements.SelectList.SelectListControl({
                    arrItems: _arr[1],
                    intContainerSize: 2,
                    boolMultiselect: false,
                    itemCallback: func1
            }, this.domSelectList1);
			this.inherited(arguments);
		}
	}
);
dojo.require("webapp.email.getFiltersBase");
dojo.provide("webapp.email.getFilters");
dojo.declare("webapp.email.getFilters",
	webapp.email.getFiltersBase,
	{
		templatePath: dojo.moduleUrl("webapp.email","templates/getFilters8082.html")
	}
);
/*Webapplication: Email - Widget: Preview*/
dojo.provide("webapp.email.getEmailPreviewBase");
dojo.declare("webapp.email.getEmailPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
        domEmailPreviewTitle: null,
        domEmailPreview: null,
		containerPreview : null,

        postMixInProperties:function(){
        },

		postCreate:function() {
/*	    new UIElements.MenuList.MenuListControl({
                arrItems : webapp.email.data.getListPreview(),
                callback : function(intIndex) {webapp.email.data.loadDetails(intIndex);  },
                boolShowTime: true,
            }, this.domEmailPreview);*/
			this.containerPreview = new UIElements.Container.ContainerControl(
	        {
	            objTitle: {
	                strLabel : webapp.email.data.getListTitle()
	            },
	            objContent: {
	                name : "UIElements.MenuList.MenuListControl",
	                params : {
						arrItems : webapp.email.data.getListPreview(),
						boolPreview : true,
						autoSelectFirst : false,
						callback : function(intIndex) {
							ICTouchAPI.transitionServices.getScreen({name: "webapp.email.getEmail", params:  {}});
							if (webapp.email.objMenuUI)
								webapp.email.objMenuUI.selectItemByPosition(intIndex, true);  },
						boolShowTime: true,
					}
	            }
	        }, this.domContent);
		},

		_clicked:function(){
            ICTouchAPI.transitionServices.getScreen({name: "webapp.email.getEmail", params:  {}});
        },

		destroy : function(){
//			if(this.containerPreview){
//				this.containerPreview.destroy();
//			}
			this.inherited(arguments);
        }
});
/*Webapplication: Email - Widget: Preview*/
dojo.require("webapp.email.getEmailPreviewBase");
dojo.provide("webapp.email.getEmailPreview");
dojo.declare("webapp.email.getEmailPreview",
	webapp.email.getEmailPreviewBase,
	{
         templatePath: dojo.moduleUrl("webapp.email","templates/getEmailPreview8082.html"),
});
