dojo.provide("webapp.email.getMailEditionBase");
dojo.declare("webapp.email.getMailEditionBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		toUI		: null,
		titleUI		: null,
		messageUI	: null,
		strTo		: "",
		strTitle	: "",
		strMessage	: "",

        postMixInProperties : function() {
			this.strTo = _("To :", "webapp.email");
			this.strTitle = _("Title :", "webapp.email");
			this.strMessage = _("Message :", "webapp.email");
		},

        postCreate:function(){
			var data = webapp.email.data;
			this.toUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: true,
				funcCallback: dojo.hitch(this, this.onToUIChange)
			}, this.domTo);
			this.titleUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: false,
				funcCallback: function(strContent) {
					webapp.email.data.newEmail.title = strContent;
				}
			}, this.domTitle);
			this.messageUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: true,
				funcCallback: function(strContent) {
					webapp.email.data.newEmail.textBody = strContent
				}
			}, this.domMessage);

			//collect all the adresses and display them with ";" between them
			if(data.newEmail.mailTo)
				{
					var strTemp = "";
					var i =0;
					for (i = 0; i < data.newEmail.mailTo.length; i++)
					{
						if (i != 0)
							strTemp += "; ";
						if (data.newEmail.mailTo[i].toAdress != "")
							strTemp += data.newEmail.mailTo[i].toAdress;
					}
					this.toUI.setInputFieldContent(strTemp);
				}
			if(data.newEmail.title)
				this.titleUI.setInputFieldContent(data.newEmail.title);
			if(data.newEmail.textBody)
				this.messageUI.setInputFieldContent(data.newEmail.textBody);

			this.inherited(arguments);
		},

		onToUIChange:function(strContent) {
			var strContentTemp = dojo.trim(strContent);
			if (strContentTemp != "")
				{
				var tableau = strContentTemp.split(";");
					webapp.email.data.newEmail.mailTo = [];
					for (i = 0; i < tableau.length; i++)
						{
					if(tableau[i] && dojo.trim(tableau[i])){
						webapp.email.data.newEmail.mailTo.push({
							toAdress : dojo.trim(tableau[i])
						});
							}
							}
				var strTemp = webapp.email.data.newEmail.mailTo[0].toAdress;
				for (i = 1; i < webapp.email.data.newEmail.mailTo.length; i++) {
					strTemp += ";" + webapp.email.data.newEmail.mailTo[i].toAdress;
						}
						this.toUI.setInputFieldContent(strTemp, false);
				}
		},
    });
