dojo.provide("webapp.email.dataBase");
dojo.declare("webapp.email.dataBase", null, {

    _arrAppButtons : [],
    _strContainerPath : "webapp.email.getMailConsultation", //default details
    _strTitle : "", // default nothing_strContainerPath
    _strListTitle : "Emails",
    _arrEmailList : [],
    _arrEmailListPreview: [],
    _arrDraftList : [],
    _arrTempInbox : [],
    _arrAttachmentList : [],
    _dateFormat : "",
    _24hformat : false,
    _editDraftButton : null,
    _tempUnreadMails : [],

    filters : [],
    orderBy : [],
	filtersNotTranslated : [],
	orderByNotTranslated : [],
    selectedFilter : "All", //default value
    selectedOrderBy : "Date", //default value

    currentEmail: null,
    newEmail	: {},
    selectedMailId : null,

    STATUS_HOME			: 0,
    STATUS_CONSULTATION	: 1,
    STATUS_EDITION		: 2,
    NB_STATUS			: 3,
	ALL					: "All",
	UNREAD				: "Unread",
	DATE				: "Date",
	SENDER				: "Sender",

    BACK		: "BACK_BTN",

    NEW_MAIL	: "NEW_MAIL_BTN",
    EDIT_DRAFT	: "EDIT_DRAFT_BTN",
    FILTERS		: "FILTERS_BTN",
    ANSWER		: "ANSWER_BTN",
    ANSWER_ALL	: "ANSWER_ALL_BTN",
    FORWARD		: "FORWARD_BTN",
    DELETE		: "DELETE_BTN",
	ADD_CONTACT	: "ADD_CONTACT_BTN",

    SEND		: "SEND_BTN",
    CANCEL		: "CANCEL_BTN",
    SAVE		: "SAVE_BTN",

    MAIL		: "MAIL_BTN",
    ANSWER_BY_MAIL	: "ANSWER_BY_MAIL",

    MAILTYPE_DRAFT	: "DRAFT",
    MAILTYPE_UNREAD : "UNREAD",
    MAILTYPE_READ : "READ",

    constructor: function() {
        var func = dojo.hitch( webapp.email, webapp.email.buttonCallback);

        var arrButtons = [];
        arrButtons.push({
            strButtonName: this.NEW_MAIL,
            strButtonLabel: _("New mail", "webapp.email"),
            strButtonIcon: 'mail-application',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.FILTERS,
            strButtonLabel: _("Filters", "webapp.email"),
            strButtonIcon: 'mail-filter',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        this._arrAppButtons[this.STATUS_HOME] = arrButtons;

        arrButtons = [];
        arrButtons.push({
            strButtonName: this.NEW_MAIL,
            strButtonLabel: _("New mail", "webapp.email"),
            strButtonIcon: 'mail-application',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.EDIT_DRAFT,
            strButtonLabel: _("Edit draft", "webapp.email"),
            strButtonIcon: 'generic-modify',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.ANSWER,
            strButtonLabel: _("Answer", "webapp.email"),
            strButtonIcon: 'mail-answer-by-mail',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.ANSWER_ALL,
            strButtonLabel: _("Answer all", "webapp.email"),
            strButtonIcon: 'mail-answer-all',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.FORWARD,
            strButtonLabel: _("Forward", "webapp.email"),
            strButtonIcon: 'mail-forward',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.DELETE,
            strButtonLabel: _("Delete", "ICTouchAPI"),
            strButtonIcon: 'mail-delete-mail',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.FILTERS,
            strButtonLabel: _("Filters", "webapp.email"),
            strButtonIcon: 'mail-filter',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        this._arrAppButtons[this.STATUS_CONSULTATION] = arrButtons;

        arrButtons = [];
        arrButtons.push({
            strButtonName: this.SEND,
            strButtonLabel:  _("Send mail", "webapp.email"),
            strButtonIcon: 'mail-send-mail',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.CANCEL,
            strButtonLabel:  _("Cancel", "ICTouchAPI"),
            strButtonIcon: 'generic-cancel',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        arrButtons.push({
            strButtonName: this.SAVE,
            strButtonLabel:  _("Save mail", "webapp.email"),
            strButtonIcon: 'mail-save',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
		arrButtons.push({
            strButtonName: this.ADD_CONTACT,
            strButtonLabel:  _("Search", "ICTouchAPI"),
            strButtonIcon: 'generic-search-by-name',
            strStatusText:'',
            strStatusIcon:'',
            callback: func
        });
        this._arrAppButtons[this.STATUS_EDITION] = arrButtons;

        for (var j = 0; j < this.NB_STATUS; j++)
        {
            var appBar = ICTouchAPI.AppBarServices.getAppBar("email","emailstatus"+j);
            for (var k in this._arrAppButtons[j])
            {
                var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[j][k]);
                appBar.addActionButton(objButton);
            }
        }
        this._loadSettings();

        //construct the filters
        this.filters.push({
            intIndex: 0,
            strLabel: _("All", "webapp.email")
        });
        this.filters.push({
            intIndex: 1,
            strLabel: _("Unread", "webapp.email")
        });
        this.orderBy.push({
            intIndex: 0,
            strLabel: _("Sender", "webapp.email")
        });
        this.orderBy.push({
            intIndex: 1,
            strLabel: _("Date", "webapp.email")
        });
		//create arrays of filters that do not pass through the translation mecanism
		this.filtersNotTranslated.push(this.All);
		this.filtersNotTranslated.push(this.UNREAD);
		this.orderByNotTranslated.push(this.SENDER);
		this.orderByNotTranslated.push(this.DATE);

        //add the MAIL and ANSWER_BY_MAIL buttons inside the communication webapp.
        // Check if the webapp communication is already loaded before adding the buttons
        // "Mail" and "Answer by Mail" to the webapp communication
        if (webapp.communication) {
            this._addEmailButtonsToCommunication();
        }
        // If the webapp communication is not loaded yet, subscribe to the event
        // "webapp.communication.loaded" emitted after the creation of the
        // communication view (posteCreate of getCommunicationBase)
        else {
            dojo.subscribe("webapp.communication.loaded", this, function() {
                this._addEmailButtonsToCommunication();
            });
        }

        this._arrDraftList = [];
    },

    /* _addEmailButtonsToCommunication
     * Add the buttons "Mail" and "Answer by Mail" to the communication webapp
     * */
    _addEmailButtonsToCommunication:function(){
        dojo.subscribe("ManageExternalButtonsCom", this, this.onManageButtonsEvent);
        var funcMail = dojo.hitch(this, this.mailBtnCallback);
		var funcAnswer = dojo.hitch(this, this.answerBtnCallback);
        var mailButton = {
            strButtonName: this.MAIL,
            strButtonLabel:  _("Mail", "webapp.email"),
            strButtonIcon: 'mail-application',
            callback: funcMail
        };
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_EMPTY, mailButton);
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG, mailButton);
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_MERGE_CALLS, mailButton);
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, mailButton);

        var answerButton = {
            strButtonName: this.ANSWER_BY_MAIL,
            strButtonLabel:  _("Answer by Mail", "webapp.email"),
            strButtonIcon: 'mail-answer-by-mail',
            callback: funcAnswer
        };
		if (webapp.communication) {
			//webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_INCOMING, answerButton);
		}
    },

    //handle the hiding and showing of the Mail and Answer by Mail buttons inside the comm appbar
    onManageButtonsEvent:function(objContact, status) {
		var numStatus = webapp.communication.data.getNumAppBarFromStatus(status);
        var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+numStatus);
        // Get the "Mail" and "Answer by Mail" buttons from the webapp appbar acording to its current status
        var btnMail = appBar.getButton(this.MAIL);
        var btnAnswerMail = appBar.getButton(this.ANSWER_BY_MAIL);

        // If the "Mail" button exists, check if a contact is selected in the communication
        // webapp -> if yes, display the "Mail" button, else hide it
        if (btnMail) {
            if (objContact && objContact.email) {
                btnMail.show();
            }
            else {
                btnMail.hide();
            }
        }
        // If the "Answer by Mail" button exists, check if a contact is selected in the communication
        // webapp -> if yes, display the "Answer by Mail" button, else hide it
        if (btnAnswerMail) {
            if (objContact && objContact.email ) {
                btnAnswerMail.show();
            }
            else {
                btnAnswerMail.hide();
            }
        }
    },

    mailBtnCallback: function(buttonId) {
        if (webapp.communication) {
            var objContact = webapp.communication.data.getCurrentContact();
            if (objContact && objContact.email){
                this.mailTo(objContact.email, "", "");
            }
        }
    },

	answerBtnCallback:function(buttonId) {
		if (webapp.communication) {
			var call = webapp.communication.data.getSelectedEntry();
			var objContact = webapp.communication.data.getCurrentContact();
			if (call && call.objCallData.callId)
			{
				ICTouchAPI.APIServices.Telephony.ignoreCall({params: [call.objCallData.callId], context: this});
			}
			if (objContact && objContact.email){
                this.mailTo(objContact.email, "", "");
            }

		}
	},

    getContainerTitle : function() {
        return this._strTitle;
    },

    getContainerPath : function(){
        return this._strContainerPath;
    },

    getListTitle : function() {
        return this._strListTitle;
    },

    getDetails : function() {
        return this.currentEmail ? this.currentEmail : {};
    },

    getList : function() {
        return this._arrEmailList;
    },

    getAttachmentList: function(){
        return this._arrAttachmentList;
    },

    getListPreview : function() {
        return this._arrEmailListPreview;
    },

    // set a new content for the container of the email and call an update of the appBar
    switchContainer: function(pageName, status, pageTitle) {
        this._strContainerPath = "webapp.email."+pageName;
        if(pageTitle)
            this._strTitle = pageTitle;
        this.updateAppBar(status);
        if (webapp.email.mainWidget)
            webapp.email.mainWidget.reloadContainer();
    },

    // set the appBar corresponding to the status
    updateAppBar: function(status) {
        // set the status
        webapp.email.currentStatus = status;

        //If current mail is not a draft, don't show "edit draft" button
        if (status == this.STATUS_CONSULTATION && this.currentEmail != null) {
            var appBar = ICTouchAPI.AppBarServices.getAppBar("email", "emailstatus"+status);
            var btn = appBar.getButton(this.EDIT_DRAFT);
            if (this.currentEmail.status == "DRAFT")
                btn.show();
            else
                btn.hide();
        }

        // button callback
        var backFunc = dojo.hitch( webapp.email, webapp.email.buttonCallback, this.BACK);
		ICTouchAPI.AppBarServices.addExitButton("email","emailstatus"+status, this.isPreviousHome(), backFunc);

        // Register appBar according to state
        ICTouchAPI.AppBarServices.setAppBar("email", "emailstatus"+status, "getEmail");
    },

    // gets the settings for the app
    _loadSettings : function(){
        ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
            // save the setting
            if (objSetting != null)
                this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
            // get another setting
            ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
                // save the setting
                if(value != null)
                    this._24hformat = value;
                this.loadList();
            });
        });
    },

    loadList : function () {
        if (this.selectedFilter == this.ALL)
            ICTouchAPI.APIServices.Email.getAllMails({
                params:[""],
                context:this,
                callback:this.loadedList,
                errorCallback:dojo.hitch(webapp.email, webapp.email.onErrorCalback)
            });
        else
            ICTouchAPI.APIServices.Email.getUnreadMails({
                params:[""],
                context:this,
                callback:this.loadedUnread,
                errorCallback:dojo.hitch(webapp.email, webapp.email.onErrorCalback)
            });
    },
    loadedUnread: function(_arr){
        this._tempUnreadMails = _arr;
        ICTouchAPI.APIServices.Email.findDraftMail({
            params:["", 0, 0],
            context:this,
            callback:this.onFindDraft,
            errorCallback:dojo.hitch(webapp.email, webapp.email.onErrorCalback)
        });
    },

    onFindDraft: function(_arr) {
        this._tempUnreadMails = this._tempUnreadMails.concat(_arr);
        this.loadedList(this._tempUnreadMails);
    },
    loadedList : function(_arr) {
        // fill _arrEmailList
        this._arrEmailList = [];
        this._arrDraftList = [];
        this._arrEmailListPreview = [];
        this._arrTempInbox = [];
        for (var i in _arr) {
            var objMail = _arr[i];
            if (objMail.status == this.MAILTYPE_DRAFT) {
                var strTime = ICTouchAPI.tools.getFormatedTime(objMail.saved.datetime.hour, objMail.saved.datetime.minute, this._24hformat);
                this._arrDraftList.push({
                    strSecondaryContent : objMail.fromAdress,
                    strPrimaryContent: objMail.title,
                    strType: "normal",
                    objMail: objMail,
                    date: strTime,
                    strTime: strTime
                });
            }
            else
                this._addToInbox(objMail);
        }
        this._sortInbox();
        this._buildList();
    },

    _addToInbox : function(objMail) {
        // first sorting of the elements, by day
        if (this.selectedOrderBy == this.DATE) {
            // Warning : javascript months starts at 0 (january..)
            var date = new Date(objMail.sentReceived.datetime.year, objMail.sentReceived.datetime.month - 1, objMail.sentReceived.datetime.day);
            // key date for the array format : day-month-year
            var strDateKey = date.format('yyyy-MM-dd',dojo.locale);

            if(!this._arrTempInbox.hasOwnProperty(strDateKey)) {
                // the key does not exist, create it
                this._arrTempInbox[strDateKey] = [];
            }

            // add the event to the day
            this._arrTempInbox[strDateKey].push(objMail);
        }
        else if (this.selectedOrderBy == this.SENDER) {
            //order the list according to senders
            var strSender = objMail.fromAdress;

            if(!this._arrTempInbox.hasOwnProperty(strSender))
                // the key does not exist, create it
                this._arrTempInbox[strSender] = [];

            this._arrTempInbox[strSender].push(objMail);
        }
    },

    _sortInbox : function() {
        if (this.selectedOrderBy == this.DATE) {
            // we must sort the temporary list by date
            // We have to sort the Keys of this array
            var keys = [];
            for (var k in this._arrTempInbox)
            {
                if (this._arrTempInbox.hasOwnProperty(k))
                {
                    keys.push(k);
                }
            }
            // sorting key by descending order
            keys.sort(function (a, b) {
                return (b > a) - (b < a);
            });

            // populate the array for the clickable list
            var dateNow   = new Date();
            var boolToday = false; // default not today
            // filling
            // through the keys of the table
            for (var j = 0; j < keys.length; j++)
            {
                var key = keys[j];

                if(this._arrTempInbox.hasOwnProperty(key))
                {
                    // gets date from the key year-month-day
                    var arrDate = key.split('-');
                    var date = new Date(arrDate[0], arrDate[1]-1, arrDate[2]);
                    // add title to the day
                    if(dojo.date.compare(date, dateNow,"date") == 0)
                    {
                        // Today !
                        this._arrEmailList.push({
                            strPrimaryContent: _("TODAY", "webapp.email"),
                            strType: "title",
                            date : date, // private property for our data
							boolToday : true
                        });
                        boolToday = true;
                    }
                    else
                    {
                        this._arrEmailList.push({
                            strPrimaryContent: _(ICTouchAPI.tools.getFormatedDate(date,this._dateFormat), "webapp.email"),
                            strType: "title",
                            date : date // private property for our data
                        });
                        boolToday = false;
                    }

                    // sort the elements added previously  by time decrease sort
                    this._arrTempInbox[key].sort(function(a,b) {
                        // a and b are two planned events
                        // test hours
                        if(a.sentReceived.datetime.hour > b.sentReceived.datetime.hour)
                            return -1;
                        else if(a.sentReceived.datetime.hour < b.sentReceived.datetime.hour)
                            return 1;
                        else //hours =, to test minutes
                        {
                            if(a.sentReceived.datetime.minute > b.sentReceived.datetime.minute)
                                return -1;
                            else if(a.sentReceived.datetime.minute < b.sentReceived.datetime.minute)
                                return 1;
                            else
                                return 0;
                        }
                    });

                    for(var keyTemp in this._arrTempInbox[key])
                    {
                        var obj = this._arrTempInbox[key][keyTemp]; // an email
                        // time print format hours:minutes-hours:minutes
                        var strTime = ICTouchAPI.tools.getFormatedTime(obj.sentReceived.datetime.hour, obj.sentReceived.datetime.minute, this._24hformat);
                        // add email event to the list
                        var objClass ="";
                        if (obj.status == "UNREAD")
                            objClass = "logEntryBlue";
                        else
                            objClass = "";
                        this._arrEmailList.push({
                            strSecondaryContent : obj.fromAdress,
                            strPrimaryContent: obj.title,
                            strPrimaryContentClass : objClass,
                            strType: "normal",
                            date: strTime,
                            strTime: strTime,
                            objMail: obj
                        });
                        // add email to the preview List
                        if(boolToday)
                        {
                            this._arrEmailListPreview.push({
                                strSecondaryContent : obj.fromAdress,
                                strPrimaryContent: obj.title,
                                strType: "normal",
                                date: strTime,
                                strTime: strTime,
                                objMail: obj
                            });
                        }
                    }
                }
            }
        }
        else {
            //manage the situation were the menulist must be sorted by Sender
            var keys = [];
            for(var k in this._arrTempInbox)
            {
                if(this._arrTempInbox.hasOwnProperty(k))
                {
                    keys.push(k);
                }
            }
            //sort the list lexicographically
            keys.sort();

            //sort the mails of the different senders by date
            for (var j = 0; j < keys.length; j++)
            {
                var key = keys[j];

                this._arrEmailList.push({
                    strPrimaryContent: key,
                    strType: "title"
                });
                if(this._arrTempInbox.hasOwnProperty(key))
                {
                    this._arrTempInbox[key].sort(function(a,b) {
                        // a and b are two emails
                        // test hours
                        if(a.sentReceived.datetime.hour > b.sentReceived.datetime.hour)
                            return -1;
                        else if(a.sentReceived.datetime.hour < b.sentReceived.datetime.hour)
                            return 1;
                        else //hours =, to test minutes
                        {
                            if(a.sentReceived.datetime.minute > b.sentReceived.datetime.minute)
                                return -1;
                            else if(a.sentReceived.datetime.minute < b.sentReceived.datetime.minute)
                                return 1;
                            else
                                return 0;
                        }
                    });
                }

                for(var keyTemp in this._arrTempInbox[key]) {
                    var obj = this._arrTempInbox[key][keyTemp]; // en email
                    // time print format hours:minutes-hours:minutes
                    var strTime = ICTouchAPI.tools.getFormatedTime(obj.sentReceived.datetime.hour, obj.sentReceived.datetime.minute, this._24hformat);
                    // add email to the list
                    this._arrEmailList.push({
                        strSecondaryContent : obj.fromAdress,
                        strPrimaryContent: obj.title,
                        strType: "normal",
                        date: strTime,
                        strTime: strTime,
                        objMail: obj
                    });
                }
            }
        }
    },

    _buildList : function () {
        //add the list of draft mails
        this._arrEmailList.push({
            strPrimaryContent: _("DRAFT", "webapp.email"),
            strType: "title"
        });
        this._arrEmailList = this._arrEmailList.concat(this._arrDraftList);
        //manage the indexes in the new or updated list
        for(var i in this._arrEmailList) {
            this._arrEmailList[i].intIndex = i;
        }
		//manage the indexes in the preview list
	
		for(var i = 0; i < this._arrEmailListPreview.length; i++) {
			this._arrEmailListPreview[i].intIndex = i + 1;
		}

	
        // refresh Lists
        if( webapp.email.mainWidget )
            webapp.email.mainWidget.reloadMenu();
        if (webapp.email.previewContainer)
            webapp.email.previewContainer.refresh();
    },

    loadDetails : function (emailId) {
        var context = this;
        var i = 0;
        this._arrAttachmentList = [];
        var index = 0;

        if (webapp.email.currentStatus == webapp.email.data.STATUS_EDITION)
            webapp.email.loadDraftPopup();

        var email = this._arrEmailList[emailId];
        this.currentEmail = email.objMail;
        //check for attachements, if found update the array containing them
        if (this.currentEmail && this.currentEmail.mailAtt) {
            if (this.currentEmail.mailAtt.length > 0) {
                for (i = 0; i < this.currentEmail.mailAtt.length; i++ )
                {
                    ICTouchAPI.APIServices.FileManager.getFile({
                        params:[this.currentEmail.mailAtt[i].fileId],
                        context:this,
                        callback:function(listFile) {
                            context._arrAttachmentList.push({
                                strLabel : _("Attached file", "webapp.email"),
                                strContent : listFile[0].name,
                                strIcon:"",
                                callback : function(){ }
                            });
                            if (index == context.currentEmail.mailAtt.length -1){
                                context.switchContainer("getMailConsultation", this.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
                                return;
                            }
                            index++;
                        }
                    });
                }
            }
        }

        //if mail is unread then call readMail function, and update the mail in the local array of mails.
        if (this.currentEmail)
            if (this.currentEmail.status == this.MAILTYPE_UNREAD && this.currentEmail.status != this.MAILTYPE_DRAFT)
            {
                ICTouchAPI.APIServices.Email.readMail({
                    params:[this.currentEmail.idMail],
                    context:this
                });
				//decrease the unread email notification
				ICTouchAPI.notificationServices.decNotification("New_Email");
                this._arrEmailList[emailId].objMail.status = this.MAILTYPE_READ;
                webapp.email.data.selectedMailId = this._arrEmailList[emailId].objMail.idMail;
                this._arrEmailList[emailId].strPrimaryContentClass = "";
                webapp.email.emailList.refresh();
            }
        this.switchContainer("getMailConsultation", this.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
    },



    //public mathod to open a new mail in edition mode
    mailTo : function(emailTo, mailSubject, mailBody) {
        ICTouchAPI.transitionServices.getScreen({
            name: "webapp.email.getEmail",
            params: {}
        });
        this.newEmail = {
            mailTo: [{
                toAdress : emailTo
            }],
            title: mailSubject,
            textBody : mailBody
        };
        this.switchContainer("getMailEdition", this.STATUS_EDITION, _("Mail Edition", "webapp.email"));
    },

    //function the retreive the filters
    getFilters : function() {
        var filters = [];
        filters[0] = this.filters;
        filters[1] = this.orderBy;
        return filters;
    },

	isPreviousHome : function() {
		switch(this._strContainerPath)	{
			case "webapp.email.getMailConsultation" :
				return true;
				break;
			case "webapp.email.getMailEdition" :
				return false;
				break;
			default :
				return false;
				break;
		}
	}


});
