dojo.provide("webapp.email.controlBase");
dojo.declare("webapp.email.controlBase",[ICTouchAPI.webApplication],
{
	currentStatus	: 0,
	popupFilters	: null,
	deletePopUp		: null,
	errorPopup		: null,
	objMenuUI		: null,
	boolConnectionError	: false,
//	_uniqueIdGen	: 0,
//	_idMailToEdit	: -1,

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.communication", "webapp.email",true,false,false);		
		ICTouchAPI.tools.registerHomepageButton(["webapp.email.getEmail", "EMAIL_BTN", "mail-application", _('Email',"webapp.email")]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.email.getEmail", "EMAIL_BTN", "mail-application", _('Email',"webapp.email")]);

		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_RECEIVE_NTF", this.onMailReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAILBOX_FULL_NTF", this.notifyMailboxFull);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_SAVE_NTF", this.onMailSave);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_UPDATE_NTF", this.onMailUpdate);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_SEND_NTF", this.onMailSend);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_DELETE_NTF", this.onMailDelete);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MAIL_GET_ERROR_NTF", this.onMailGetError);

		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged", this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
        ICTouchAPI.settingServices.getSetting("eMailDefaultFilter",this,this._setFilter);
        ICTouchAPI.settingServices.subscribeToSetting(this,"eMailDefaultFilter",this._setFilter);
        ICTouchAPI.settingServices.getSetting("eMailDefaultSort", this, this._setSort);
        ICTouchAPI.settingServices.subscribeToSetting(this,"eMailDefaultSort", this._setSort);

		ICTouchAPI.notificationServices.addNotification({
							strNotificationName: "New_Email",
							strNotificationLabel: _("New mail", "webapp.email"),
							intNotificationValue: 0,
							callback: dojo.hitch("webapp.email", this.onNotifyNewMail)
						});
		dojo.subscribe("ContactDataClickedEmail", this, this.onEmailContact);
                ICTouchAPI.settingServices.subscribeToSetting(this, "EnableEmailPreview", this._registerHomePageContainer);
                this.loadEnablePreview();
	},

         //ENABLE PREVIEW
        loadEnablePreview:function(){
            ICTouchAPI.settingServices.getSetting("EnableEmailPreview", this, this._registerHomePageContainer);
        },

        _registerHomePageContainer : function(objSetting){
            if (objSetting){
                if(objSetting.jsValue == true){
                    ICTouchAPI.tools.registerHomepageContainer(["webapp.email.getEmailPreview", this]);
                }else{
                    ICTouchAPI.tools.unregisterHomepageContainer(["webapp.email.getEmailPreview"]);
                }
            }

        },
        //END OF ENABLE PREVIEW

	load: function() {
		//help
		var widgetsTab = [];
		for(var i=0; i<webapp.email.data.NB_STATUS; i++) {
			widgetsTab.push("emailstatus"+i);
		}
		dojo.publish("needHelpEvent",["email",widgetsTab]);
	},

    _setFilter : function(objSetting){
        if(objSetting.jsValue===0){
            this.data.selectedFilter="All";
        }
        else{
            this.data.selectedFilter="Unread"
        }

    },

    _setSort : function(objSetting){
        if(objSetting.jsValue===0){
            this.data.selectedOrderBy="Sender";
        }
        else{
            this.data.selectedOrderBy="Date";
        }

    },

	    //adds an external capability, for other webapps to be able to add buttons any appBar of the webapp Email
    addButton : function(button, widget) {
        var appBar = {};

        if (widget == "webapp.email.getMailConsultation")
        {
            appBar = ICTouchAPI.AppBarServices.getAppBar("email","emailstatus"+this.STATUS_CONSULTATION);
        }
        else if (widget == "webapp.email.getMailEdition")
        {
            appBar = ICTouchAPI.AppBarServices.getAppBar("email","emailstatus"+this.STATUS_EDITION);
        }

        var objButton = new UIElements.AppButton.AppButtonControl(button);
        appBar.addActionButton(objButton);
    },

	setHomepageContainer : function (strWebapp, div) {
		webapp.email.previewContainer = new webapp.email.getEmailPreview({ }, div);
	},

	buttonCallback : function(buttonId) {
		var data = webapp.email.data;
		switch(buttonId)
		{
			// The back button load the last container
			case data.BACK:
				switch(data._strContainerPath)
				{
					case "webapp.email.getMailConsultation" :
						dojo.publish("OpenHomepage");
						break;
					case "webapp.email.getMailEdition" :
						this.loadDraftPopup();

						break;
					default :
						data.switchContainer("getMailConsultation", data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
						break;
				}
				break;
			case data.NEW_MAIL:
				 if (webapp.email.currentStatus == data.STATUS_EDITION)
					this.loadDraftPopup();

				data.newEmail = {title:"", textBody:"", mailTo : []};
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));

				break;
			case data.EDIT_DRAFT:
				data.newEmail = {};
				data.newEmail = dojo.clone(data.currentEmail);
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.FILTERS:
				this.openFilters();
				break;
			case data.ANSWER:
                                var text=data.currentEmail.textBody;
                                var tab=null;
                                tab=text.split('\n');
                                text="";
                                for(var i=0;i<tab.length;i++){


                                        tab[i]='>'+tab[i];
                                        text+=tab[i]+'\n';

                                }

                                data.newEmail.textBody = text;
                                data.newEmail.title = "re: " + data.currentEmail.title;
				data.newEmail.mailTo = [];
				data.newEmail.mailTo.push({toAdress : data.currentEmail.fromAdress});
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.ANSWER_ALL:
                                var text=data.currentEmail.textBody;
                                var tab=null;
                                tab=text.split('\n');
                                text="";
                                for(var i=0;i<tab.length;i++){


                                        tab[i]='>'+tab[i];
                                        text+=tab[i]+'\n';

                                }

                                data.newEmail.textBody = text;
				data.newEmail.title = "re: " + data.currentEmail.title;
				data.newEmail.mailTo = [];
				data.newEmail.mailTo.push({toAdress : data.currentEmail.fromAdress});
				var i = 0;
				for(i = 0 ; i < data.currentEmail.mailTo.length; i++)
					{
						if (data.currentEmail.fromAdress != data.currentEmail.mailTo[i].toAdress)
							data.newEmail.mailTo.push({toAdress : data.currentEmail.mailTo[i].toAdress});
					}
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.FORWARD:
				//data.newEmail = dojo.clone(data.currentEmail);
				data.newEmail.textBody = data.currentEmail.textBody;
				data.newEmail.title = "fwd: "+data.currentEmail.title;
				data.newEmail.textBody = "Message forward: \n"+data.currentEmail.textBody;
				data.newEmail.mailTo = [];
				data.switchContainer("getMailEdition", data.STATUS_EDITION, _("Mail Edition", "webapp.email"));
				break;
			case data.DELETE:
				this.loadDeletePopup();
				break;
			case data.SEND:
				if (!data.newEmail.mailTo[0].toAdress || data.newEmail.mailTo[0].toAdress == "")
					{
						this.checkError(100);
					}
				else
					{
						if (data.newEmail.idMail) {
							if (data.newEmail.title == "")
								data.newEmail.title = _("No Subject", "webapp.email");
							ICTouchAPI.APIServices.Email.updateAndSendMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
						}
						else {
							if (data.newEmail.title == "")
								data.newEmail.title = _("No Subject", "webapp.email");
							ICTouchAPI.APIServices.Email.saveAndSendMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
						}
						data.switchContainer("getMailConsultation", data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
					}
				break;
			case data.CANCEL:
				data.switchContainer("getMailConsultation", data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
				break;
			case data.SAVE:
				if (data.newEmail.idMail) {
					ICTouchAPI.APIServices.Email.updateMail({params:[data.newEmail], context:this, errorCallback: this.onErrorCalback});
					webapp.email.data.currentEmail = {};
					webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
				}
				else {
					ICTouchAPI.APIServices.Email.saveMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
				}
				//data.switchContainer("getMailConsultation", data.STATUS_HOME, _("Mail consultation", "webapp.email"));
				break;
			case data.ADD_CONTACT:
				var objSearch = {
					secondaryInformation: "email", // information of the contact to be displayed at the right of the contact's display name in the search results
					lineClickCallback : {
						neededData : "email",
						context: this,
						func: this.onHandleAddContact
					},
					useDefaultCallMethod : false,
					stealth : true
				};
				webapp.search.doSearch(objSearch,
				function(){ICTouchAPI.transitionServices.back();});
				break;
			default:
				console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
				break;
		}
	},

	//handle for the search function
	onHandleAddContact: function(email, objClickedData) {
		if (email) {
			this.data.newEmail.mailTo.push({toAdress: email});
		}
		ICTouchAPI.transitionServices.getScreen({
						name: "webapp.email.getEmail",
						params: {}
				});
		this.data.switchContainer("getMailEdition", webapp.email.data.STATUS_EDITION, _("Mail Edition", "webapp.email"))
	},

	//callback for the dojo event "ContactDataClickedemail". This is an event that is fired by Contacts, when the
	//user clicks on an emial in the contact card
	onEmailContact :function(objEmail){
		webapp.email.data.mailTo(objEmail.strContent, "", "");
	},

	onDateFormatChanged: function(objSetting) {
		if (objSetting != null) {
			webapp.email.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			webapp.email.data.loadList();
		}
	},

	onErrorCalback: function(JsonResponse, args){
//		if (JsonResponse == "Could not make remote call")
//		this.checkError(110);
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting != null) {
			webapp.email.data._24hformat = objSetting.jsValue;
			webapp.email.data.loadList();
		}
	},

	onNotifyNewMail: function (){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.email.getEmail", params: {}});
                webapp.email.data.selectedFilter="Unread";
                webapp.email.data.loadDetails(1);
		//ICTouchAPI.notificationServices.setNotificationValue("New_Email", 0);
	},

	onMailReceived: function(){
		var data = webapp.email.data;
		var status, nbNew, nbTotal, nbUnread;
		var i = 0;
		for (i = 0; i < arguments.length; i++) {
			switch (arguments[i].name)
			{
				case "nbnew":nbNew = arguments[i].value;
					break;
				case "nbtot":nbTotal = arguments[i].value;
					break;
				case "nbunread":nbUnread = arguments[i].value;
					break;
				case "status":status = arguments[i].value;
					break;
			}
		}

		if (status != 0)
			this.checkError(status);
		else
			{
				data.loadList();
				var i = 0;
				for (i = 0; i < nbNew; i++)
				{
					ICTouchAPI.notificationServices.incNotification("New_Email");
				}
			}

	},

	notifyMailboxFull: function() {
		ICTouchAPI.popupServices.errorPopup(
			_("Error", "ICTouchAPI"),
			_("ERROR_MAILBOX_FULL", "webapp.email"),
			_("Ok", "ICTouchAPI"));
	},

	onMailSave: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			{
				webapp.email.data.loadList();
				webapp.email.data.currentEmail = {};
				webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
			}
	},

	onMailUpdate: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			webapp.email.data.loadList();
	},

	onMailSend: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			webapp.email.data.loadList();
	},

	onMailDelete: function(){
		var i = 0;
		var status, idMail;
		for (i = 0; i < arguments.length; i++)
			switch (arguments[i].name)
			{
				case "status":status = arguments[i].value;
					break;
				case "idMail":idMail = arguments[i].value;
					break;
			}
		if (status != 0)
			this.checkError(status);
		else
			{
				webapp.email.data.loadList();
				webapp.email.data.selectedMailId = 0;
				webapp.email.data.currentEmail = {};
				webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
			}
	},

	onMailGetError: function(status){
		if (status.value != 40)
			this.checkError(status.value);
	},

	//opens a new Filter popup
	openFilters : function() {
		var context = this;
		var popupData = {
			strTitle: _("Filters", 'webapp.email'),
			strWidgetName: "webapp.email.getFilters",
			arrPopupButtons: [{
				strButtonLabel:  _("Ok", "ICTouchAPI"),
				callback: function() {
					context.updateFilters();
				}
			}]
		};
		this.popupFilters = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	// hide Popup and refresh the list
	updateFilters : function() {
		//var data = webapp.email.data;
		ICTouchAPI.popupServices.removePopup(this.popupFilters);
		webapp.email.data.loadList();
	},

	loadDraftPopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Save as draft", 'webapp.email'),
			strContent : _("Do you want to save the mail as draft?", 'webapp.email'),
			arrPopupButtons: [{
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				callback: function() {
					context.yesDraftCallback();
				}
				},

				{
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noDraftCallback();
				}
				}]
		};
		this.popupFilters = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	loadDeletePopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Delete mail", 'webapp.email'),
			strContent : _("Do you want to delete this mail?", 'webapp.email'),
			arrPopupButtons: [{
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				callback: function() {
					context.yesDeleteCallback();
				}
				},

				{
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noDeleteCallback();
				}
				}]
		};
		this.deletePopUp = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesDraftCallback: function() {
		var data = webapp.email.data;
		ICTouchAPI.popupServices.removePopup(this.popupFilters);
		if (data.newEmail.idMail)
			{
				//data.selectedMailId = data.newEmail.idMail;
				ICTouchAPI.APIServices.Email.updateMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
			}
		else
			{
				//data.selectedMailId = data.newEmail.idMail;
				ICTouchAPI.APIServices.Email.saveMail({params:[data.newEmail], context:this, errorCallback:this.onErrorCalback});
			}
		data.selectedMailId = data.currentEmail.idMail;
		data.switchContainer("getMailConsultation", data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
	},

	noDraftCallback: function() {
		if (webapp.email.data.selectedMailId)
			webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_CONSULTATION, _("Mail Consultation", "webapp.email"));
		else
			webapp.email.data.switchContainer("getMailConsultation", webapp.email.data.STATUS_HOME, _("Mail Consultation", "webapp.email"));
		ICTouchAPI.popupServices.removePopup(this.popupFilters);

	},

	yesDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
		ICTouchAPI.APIServices.Email.deleteMail({params:[webapp.email.data.currentEmail.idMail], context:this, errorCallback:this.onErrorCalback});
	},

	noDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
	},

//	saveMail: function(objMail) {
//		ICTouchAPI.APIServices.Email.saveMail([objMail], this);
//	},


	checkError : function(status) {
		var strMessage = "";
		switch (status) {
			case 1:strMessage = _("ERROR_DB_OVERFLOW", "webapp.email");
				break;
			case 2:strMessage = _("ERROR_DB_OTHER", "webapp.email");
				break;
			case 5:strMessage = _("ERROR_ATTACHED_FILE_NOT_FOUND", "webapp.email");
				break;
			case 9:strMessage = _("EMAIL_ERROR_LOGIN", "webapp.email");
				break;
			/*case 10:strMessage = _("ERROR_MAX_EMAILS_REACHED", "webapp.email");
				break;*/
			case 20:strMessage = _("ERROR_EMAIL_NOT_FOUND", "webapp.email");
				break;
			case 21:strMessage = _("ERROR_EMAIL_ALREADY_READ", "webapp.email");
				break;
			case 22:strMessage = _("ERROR_EMAIL_STATUS_NOT_READ_NOR_UNREAD", "webapp.email");
				break;
			case 23:strMessage = _("ERROR_EMAIL_ALREADY_SENT", "webapp.email");
				break;
			case 30:strMessage = _("ERROR_MAILSERVER_UNREACHABLE", "webapp.email");
				break;
			case 31:strMessage = _("ERROR_MAILSERVER_ERROR", "webapp.email");
				break;
			case 35:strMessage = _("ERROR_MAILSERVER_CANT_DELETE", "webapp.email");
				break;
			case 40:strMessage = _("SEARCH_NO_MAIL_FOUND", "webapp.email");
				break;
		    case 100:strMessage = _("NO_DESTINATION_ADDRESS", "webapp.email");
				break;
			case 200:strMessage = _("ADDRESS_INVALID", "webapp.email");
				break;
//			case 110:strMessage = _("IctMail: could not make remote call", "webapp.email");
//				break;
			default:
				strMessage = _("Unknown error message", "webapp.email");
				break;
		}

		if (strMessage != "") {
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("Ok", "ICTouchAPI"), status)
		}
		return false;
	},

	//Returns a list of contacts, compiled from the list of senders
	getCurrentSenders : function() {
	},

	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction){
		this._onProgKeyConfig(objAction);
		return null;
	},

	_onProgKeyConfig : function (objAction) {
		if(objAction.action == "send-mail") {
			var objSearch = {
				clickCallback: dojo.hitch(webapp.communication, webapp.communication._progKeySetArgs)
			};
			// show numeric
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {
				funcCallbackOk : function(){
					objSearch.clickCallback(null, {strValue: this.getValue()});
				},
				funcCallbackExit : function(){
					webapp.progkeys.currentAddWidget.boolReset = false;
					ICTouchAPI.transitionServices.getScreen({name: "webapp.progkeys.getProgKeyAdd", params: {}});
				}
			});
		}
	},

	_progKeySetArgs : function(mailAddr) {
		if (mailAddr && mailAddr!="") {
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
			// We notify progkeys that he doesn't have to reset the display and variables this time
			webapp.progkeys.setProgkeysArgumentsNextStep(mailAddr);
		}
	},

	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "email",
			action : "send-mail",
			type : 1,
			icon : "mail-send-mail",
			label : "Send Mail"
		});
		return listActions;
	},

	onProgKeyClick : function(objAction) {
		if(objAction.action == "send-mail") {
			//ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication", params: {}});
			webapp.email.data.mailTo(objAction.arguments,"","");
		}
	},

	onDayChanged : function(){
		var dateNow = new Date();
		var arr = this.data.getList();
		var tabElem;
		for (var i=0; i<arr.length;i++){
			if (typeof (arr[i].objMail) == "undefined" && arr[i].date){ //If the selectItem in MenuList is not an email (no subject) or the draft category
				tabElem = arr[i];
				if(dojo.date.compare(tabElem.date, dateNow,"date") == 0){ //It is the today list ?
					tabElem.strPrimaryContent = _("TODAY", "webapp.email");
	}
				else{
					tabElem.strPrimaryContent = ICTouchAPI.tools.getFormatedDate(tabElem.date,this.data._dateFormat);
				}
				//Update display if already created
				if (this.objMenuUI){
					this.objMenuUI.updatePrimaryContent(i,tabElem.strPrimaryContent);
				}
			}
		}
	}

});
