/**
* @class ICTouchAPI.webWidget
* @extends Object
* @abstract
* Base Class for all UI Widget - Do not use it directly
*/
dojo.provide("ICTouchAPI.webWidget");
dojo.declare("ICTouchAPI.webWidget", dijit._Widget,
    {
	/**
         * @ignore
         */
        _status: '',

        /**
         * WidgetName could be it's id (better).
         * @ignore
         */
	strWidgetName: '',

        /**
         * Pointer to the associated webapp.
         * @ignore
         */
	webapp: null,

        /**
         * Node's id that will contain the widget which id is strWidgetName.
         * @ignore
         */
	containerId: '',

        /**
         * Animation if it was called at least one time
         * @ignore
         */
	animation: null,
	// Notify the transitionServices that this widget needs to get an exclusive iframe because it contains iframes
	exclusiveIframe: false,
	/**
	 * @ignore
	 */
	_subLanguageChanged : null,

    /**
     * Prior to anything else, builds a reference Node if it does not exist.
     * @ignore is this method !
     * @param {Array} params a list of parameters to pass to the constructor.
     * @param {Array} node name of the node where to place the widget. (containerId = )
     *               and facultative : the widget's id name (strWidgetName = )
     *               If not set, the name will be it's class name + a unique id.
     * @param {String/Number} position for dojo.place. Optional argument. Can be a number
     *               or one of the following strings: "before", "after", "replace", "only",
     *               "first", or "last". If omitted, "last" is assumed.
     *               The value of "only" replaces all children of the refNode.
     *               If the position argument is a number, it indicates
     *               that the node should be inserted as a child of
     *               refNode with this number (counting from 0).
     */
	postscript: function (params, node, position) {

		// If node.containerId is set, build a new node inside of it.
		if (node && node.containerId) {
            if (!dojo.byId(node.strWidgetName)) {
                // Get base node.
                var originNode = dojo.byId(node.containerId);
                // Create new node.
                var elt = dojo.doc.createElement("div");
                // place it inside it's parent.
                dojo.query(elt)
                    .place(originNode, position);
                // Give it an id if strWidgetName is given.
                if (node.strWidgetName) {
                    elt.id = node.strWidgetName;
                    // Set widget's future anchor point.
                    var node = dojo.byId(node.strWidgetName);
                } else {
                    // Set widget's future anchor point.
                    var node = elt;
                }
            }
		}
		// Kick off the widget's building process.
		this.create(params, node);
	},

        /**
	 * Destructor of the widget
	 */
	destroy: function() {		
		if( this.animation )
			this.animation.destroy();
		ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);

		dojo.unsubscribe(this._subLanguageChanged);

		for(var attr in this) {
			/*
			 * Search for scroll elements to be destroyed
			 * If firstElementChild or lastElementChild is null, uninit will crash
			*/
			// Search for scroll elements to be destroyed
			var elt = this[attr];
			if (elt && elt.IctScroll && elt.firstElementChild && elt.lastElementChild) {
				FXScroll.unInit(elt);
			}
		}

		this.inherited(arguments);
		this.webapp.removeWidget(this.strWidgetName);
	},

        /**
         * those methods will be bound to every widget that inherits webWidget
         * @ignore
         * @param {Array} args may contain the pointer to its parent webapp (pointer webapp)
         */
	constructor: function(args){
		ICTouchAPI.logObject(this, "WIDGETS");
		this._status = "QUEUED_STACK";
		this._subLanguageChanged = null;
		// Save the widget's parent webapp pointer if given.
		if (args.webapp) {
			this.webapp = args.webapp;
		} else {
			// Else, retrieve it from the declaredClass (could not work if missspelled).
			var strWebappName = this.declaredClass;
            var splitString = strWebappName.split(".");
			splitString.pop();
            this.namespace = splitString.join(".");
			// Require the webapp.
			this.webapp = ICTouchAPI.webApplicationManager.getRefApplication(this.namespace);
		}

        // Sets the widget's Id name and loads the skin file.
        var handle=dojo.connect(this, "postCreate",this, function(){
            // Whatever happened in the previous process, this.id is set and has
            // to be equal to strWidgetName.
            this.strWidgetName = this.id;
			// Register widget.
			this.webapp.registerWidget(this);
            // Parse the dom to find any widget to create
			dojo.parser.parse();
            dojo.disconnect(handle);
        });		
		

		this._subLanguageChanged = dojo.subscribe("languageChanged", this, function() {
			for (var i in this.attributeMap) {
				if(this[i] && this[i].isI18Ned) {
					this.attr(i, this[i]);
				}
			}
		});

		// This is some special code that enables the tracking of which element leaks in chrome's profiler
		// This works by creating a new object called like the widget we are currently constructing
		if (generalConfig.developer == true) {
			var splitString = this.declaredClass.split(".");
			var strLast = splitString.pop();
			eval("this.objTracking = new function myIC_WA_"+strLast+"(){}");
		}
	},

        /**
         * @ignore
         */
	postCreate: function () {
	},

	/**
         * Called when your widget is visible
         * @ignore
         */
	show:function () {
		this._status="VISIBLE";
	},

        /**
         * hide : function called when your widget is on the top of the stack but hidden
         * @ignore
         */
	hide:function () {
		this._status="TOP_STACK";
	},

        /**
         * function called when your widget goes to the top of the stack
         * @ignore
         */
	goOnTop:function () {
		this._status="TOP_STACK";
	},

        /**
         * Function called when the widget goes back to the stack.
         * @ignore
         */
	backToStack:function () {
		this._status="QUEUED_STACK";
	},

        /**
         * Get the name of the class that created the widget.
         * @ignore
         * @return {String} the class name.
         */
	getInstanceOf: function () {
		return this.declaredClass;
	},

       /**
	* Makes this widget stealth to transitionServices
	* @param {Boolean} boolStealth stealth or unstealth!
        */
	stealth: function (boolStealth) {
		if (boolStealth === false) {
			ICTouchAPI.transitionServices.unstealth(this.getInstanceOf());
		} else {
			ICTouchAPI.transitionServices.stealth(this.getInstanceOf());
		}

	},

        /**
         * Refresh the widget's view.
	 * Using this method, the widget might blink.
	 */
	updateWidget: function() {
        // Make a fake context to replace the current one.
        var fakeCtx = new dojox.dtl.Context();
        this.render(fakeCtx);
         // Then rebuild using the right one.
        this.render();
        // This is a trick to avoid duplicating nodes in a forloop.
        // There must be a better way to achieve that!
	},

	/**
	 * Update the widget, this method has to be overriden by each webwidget
	 */
	update : function(){

	},

	/**
	 * Update the widget content, this method may be reimplmented by webwidgets
	 * @return {Boolean} true if a full reload is required
	 */
	updateContent : function(params){
		params = null;
		return true;
	},

	/**
	 * Close the widget.
	 * Removes its dom, and deletes the object.
	 */
	close: function() {
		this.webapp.removeWidget(this.id);
	},

        /**
         * Set the widget moveable.
         * the whole content is clickable and draggable.
         */
	setMoveable: function () {
		new dojo.dnd.Moveable(
			dojo.byId(this.id));
	},

	/**
	 * Refresh this view by destroying every widget contained and redo them
	 * This should be used when other widget are contained within this widget
	 * @deprecated
	 */
	refresh: function() {
		// Clone the domNode of the widget ( without its children )
		var srcNodeRef = this.domNode.cloneNode(false);
		var nodeToClean = this.domNode;
		// Replace the fresh node with the old one
		dojo.place(srcNodeRef, this.domNode, "replace");

		ICTouchAPI.tools.destroyWidgets(nodeToClean);

		//This subscribe is removed on destroy function
		this._subLanguageChanged = dojo.subscribe("languageChanged", this, function() {
			for (var i in this.attributeMap) {
				if(this[i] && this[i].isI18Ned) {
					this.attr(i, this[i]);
				}
			}
		});

		if( params != undefined )
			this.create(params, srcNodeRef);
		else
			this.create({}, srcNodeRef);
	}
});
