/**
* @class ICTouchAPI.webApplication
* @singleton
* @extends Object
* @ignore
*/
dojo.provide("ICTouchAPI.webApplication");
dojo.declare("ICTouchAPI.webApplication",
	null,
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		_arrLoadedWidgets: null,
		/**
		 * @private
		 */
		_strApplicationName: '',
		/**
		 * @private
		 */
		_myIFrame : null,

		/* ------------------------------------ Constructor --------------------------------------- */

		/**
		 * @private
		 */
		constructor: function (){
			this._strApplicationName = this.declaredClass;
			this._arrLoadedWidgets = {};
			this._registerWebApp();
		},

		/**
		 * @private
		 */
		load: function () {

		},

		/**
		 * @private
		 */
		unload: function () {
			return true;
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Get the webApplication's name.
		 * @return {String} name of the webApplication.
		 * @private
		 */
		getApplicationName: function () {
			return this._strApplicationName;
		},
		/**
		 * Get all loaded widgets for this webApplication.
		 * @return {List} List of widgets references.
		 * @private
		 */
		getLoadedWidgets: function () {
			return this._arrLoadedWidgets;
		},
		/**
		 * Get Number of loaded widgets.
		 * @return {int} number of loaded widgets.
		 * @private
		 */
		getNumberOfWidgets: function () {
			var i=0;
			for (var widget in this._arrLoadedWidgets) {
				i++;
			}
			return i;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		* Create a widget.
		* @param {String} widgetName Name of the widget
		* @param {Object} node where to place the widget (dojo.byId(node))
		* @param {List}   args list of arguments to pass to the widget
		* @private
		*/
		createWidget: function (widgetName, args, node) {
			return new this[widgetName](args, node);
		},

		/**
		 * Called after widget creation to register it in its webapp.
		 * @private
		 */
		registerWidget: function (objWidget){
			// Before registering a new widget, check if it exists.
			if(this._arrLoadedWidgets[objWidget.strWidgetName]){
				throw {
					errorType : 'existing widget',
					message : 'This widget is already loaded'
				}
				return false;
			}
			else{
				// If it doesn't exist.
				this._arrLoadedWidgets[objWidget.strWidgetName]=objWidget;
				this._notifyAddWidget(objWidget.strWidgetName);
				return true;
			}
		},

		/**
		 * Remove the references to any widget from the control and data.
		 * If the automatic behavior fails you must implement it in the webapp control
		 * @private
		 */
		removeWidgetsRef: function() {
			// Remove every reference to a widget in the control and data
			this._removeWidgetRefFromObj(this);
			this._removeWidgetRefFromObj(this.data);
		},

		/**
		 * Remove a webapp's widget.
		 * @param {String} strWidgetName Name of the widget to remove.
		 * @private
		 */
		removeWidget: function (strWidgetName) {
			// Remove widget from array.
			delete this._arrLoadedWidgets[strWidgetName];
			this._notifyRemovedWidget(strWidgetName);
			return true;
		},

		/**
		 * unlock the transition to a another widget
		 * @param {string} name Application where you want to switch
		 * @private
		 */
		unlock : function(name){
			console.log("unlock webapp : "+this._strApplicationName);
			//this function is inherited by widgets which have to be over-write this one if they do
			//have to check their state when they are left
			//we implement this mother function in order to standarize the process and avoid errors
			dojo.publish("unlockTransition",[true]);
		},


		onHide: function() {
			//* DEBUG */ console.log( "webapp onHide", this._strApplicationName );
		},

		onShow: function( screenName ) {
			//* DEBUG */ console.log( "webapp onShow", this._strApplicationName, "- screen is", screenName );
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @private
		 * Register webapp object in Application Manager
		 */
		_registerWebApp: function (){
			ICTouchAPI.webApplicationManager.registerApplication(this);
		},

		/**
		 * @private
		 * Remove every reference to a widget
		 * @param {Object} objToPurge to remove every reference to a widget
		 */
		_removeWidgetRefFromObj: function(objToPurge) {
			for( var ref in objToPurge ) {
				// Obj that will be tested
				var objToTest = objToPurge[ref];

				if( typeof objToTest == "object" && objToTest != null ) {
					if( objToTest instanceof dijit._Widget && objToTest.id != "" ) {
						delete objToPurge[ref];
					}
				}
			}
		},

		/**
		 * @private
		 * Publishes the information that a widget from this Webapp has been removed.
		 * @param {String} strWidgetName Name of the widget
		 */
		_notifyRemovedWidget: function (strWidgetName) {
			dojo.publish("webApplication.notify.removed", [[this._strApplicationName, strWidgetName]]);
		},
		/**
		 * @private
		 * Publishes the information that a widget from this Webapp has been added.
		 * @param {String} strWidgetName Name of the widget
		 */
		_notifyAddWidget: function (strWidgetName) {
			dojo.publish("webApplication.notify.added", [[this._strApplicationName, strWidgetName]]);
		},

		/**
		 * @private
		 * Send logs to the logger. To be redifined by the webapps according to their needs
		 * @param {boolean} boolAdvancedLogs Boolean indicating if advanced or basic logs has to be written
		 * (management of this boolean to be done by the webapp redefining this function)
		 */
		dump: function (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("dump function of " + this.getApplicationName() + " with " + ((boolAdvancedLogs)?"advanced":"basic") + " logs option");
		}
	});

