/**
* @class ICTouchAPI.tools
* @singleton
* @extends Object
* Usefull class for managing Date/Time and other things...
*/
dojo.provide("ICTouchAPI.tools");
dojo.declare("ICTouchAPI.tools", null,
{
	/* --------------------------------- Public attributes ------------------------------------ */

	CALLDIRECTION_OUTGOING : "CALL_OUTGOING",
	CALLDIRECTION_INCOMING : "CALL_INCOMING",

	// List of pools
	POOL_SS			: "screensaver",
	POOL_BG			: "background",
	POOL_WU			: "wakeup",
	POOL_RM			: "ringingmelody",
	//POOL_AM			: "FileManagerAlarmMelodies",
	POOL_AM                 :"appointmentmelody",//the pool for notifications

	// Call log types enum
	enumComLogEntryType : {
		CallLog			: 0,
		CallBackRequest	: 1,
		VM				: 2,
		Conference		: 3,
		IM				: 4
	},
	
	// Contact types enum
	enumContactType : {
		// Local contact created by the user (manually or by copy of a search)
		LOCAL			: 0,
		// Remote contact
		UDA				: 1,
		// Remote contact
		BUDDY			: 2,
		// Local - Provided by setting "DirectoryDefaultContacts"
		DM				: 3,
		// Remote contact
		ICS				: 4,
		// Local - Automatically created when a Manager/assistant link is created
		MA				: 5,
		// Local - Automatically created when a comlog entry not matching a local contact is added. Those are not to be displayed in contacts/search.
		CACHED			: 6
	},

	// Date and time format settings
	strDateFormat		: "",
	boolTimeFormat		: false, // 12 \ 24

	intContactFirstNameOrder	: 1, // order "name + first name" by default, order should be defined by a setting in R250

	listDefaultAvatarTypes : {
			"user"			:"",
			"conference"	:"conf_",
			"im"			:"groupchat_",
			"video"			:"video_",
			"voicemail"		:"voicemail_"
	},
	listPresence : {
			"ACTIVITY_ONTHEPHONE" : "userinfo-onthephone",
			//"ACTIVITY_APPEAR_OFFLINE" : "userinfo-offline",
			"ACTIVITY_ONLINE": "userinfo-availablephone",
			"ACTIVITY_AWAY": "userinfo-away",
			"ACTIVITY_BUSY": "userinfo-busy"
	},
	listPresenceIM : {
			"ACTIVITY_ONTHEPHONE" : "userinfo-onthephone",
			"ACTIVITY_APPEAR_OFFLINE" : "userinfo-offline",
			"ACTIVITY_OFFLINE" : "userinfo-offline",
			"ACTIVITY_AWAY" : "userinfo-away",
			"ACTIVITY_LUNCH" : "userinfo-outtolunch",
			"ACTIVITY_OTHER" : "userinfo-offline",
			"ACTIVITY_UNKNOWN" : "userinfo-offline",
			"ACTIVITY_APPOINTMENT" : "userinfo-appointement",
			"ACTIVITY_ONLINE": "userinfo-available",
			"ACTIVITY_BUSY": "userinfo-busy",
			"ACTIVITY_BE_RIGHT_BACK" :"userinfo-berightback"
	},
	listDestinationsIcons: {
		"DST_ASSOCIATE" : "communication-routing-associate",
		"DST_ATTENDANT" : "communication-routing-assistant",
		"DST_MOBILE" : "communication-routing-mobile",
		"DST_VOICE_MAIL" : "communication-routing-voicemail",
		"Other" : "communication-routing-generic"
	},

	/* --------------------------------- Private attributes ----------------------------------- */



	/* ------------------------------------ Constructor --------------------------------------- */
	/**
         * @ignore
         */
        constructor : function() {
            // Default settings for simulation mode
            if(!generalConfig.simulation) {
		ICTouchAPI.settingServices.getSetting("TimeFormat", this, this.onTimeFormatChanged);
		ICTouchAPI.settingServices.getSetting("DateFormat", this, this.onDateFormatChanged);
		ICTouchAPI.settingServices.getSetting("ContactFirstNameOrder", this, this.onContactFirstNameOrderChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "ContactFirstNameOrder", this.onContactFirstNameOrderChanged);
            }
	},


	/* ----------------------------------- Getter / Setter------------------------------------- */


	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * Needed for settings and event services
         * @ignore
	 * @return {String} : the name of this : "tools"
	 */
	getApplicationName : function() {
		return "tools";
	},

    /**
	 * Transform the text of an emoIcon to the icon thaks to very useful regular expressions.
     *
	 * @return {String} : the path to the Icon
	 */
	textEmoIcon : function(text){
		var j;
		for( j=0;j<ICTouchAPI.keyboardServices.arrEmoIconConvert.length;j++){
			if(ICTouchAPI.keyboardServices.arrEmoIconConvert[j][1]){
				var reg = RegExp(ICTouchAPI.keyboardServices.arrEmoIconConvert[j][1], "g");
				text = text.replace(reg, "<img src="+ICTouchAPI.keyboardServices.arrEmoIconConvert[j][0]+">");
			}
		}
		return text;
    },

        /**
         * @ignore
         */
	onTimeFormatChanged : function(objSetting) {
		if (objSetting != null)
			this.boolTimeFormat = objSetting.jsValue;
	},

        /**
         * @ignore
         */
	getBoolTimeFormat : function() {
		return this.boolTimeFormat;
	},

        /**
         * @ignore
         */
	onDateFormatChanged : function(objSetting) {
		if (objSetting != null)
			this.strDateFormat = objSetting.allowedValues[objSetting.jsValue].name;
	},

        /**
         * @ignore
         */
	getDateFormat : function() {
		return this.strDateFormat;
	},

	/**
         * @ignore
         */
	onContactFirstNameOrderChanged : function(objSetting) {
		if (objSetting != null) {
			this.intContactFirstNameOrder = objSetting.jsValue;
		}
	},

	/**
	 * Return the name of a file without entire path
	 * @param {String} filePath The file path
         * @return {String} the name of the file
	 */
	basename : function(path) {
		return path.replace(/.*\//, "");
	},

	/**
	 * Return the html anchor text that follows a sharp #
	 * @param {String} path The path
         * @return {String} The anchor
	 */
	anchor : function(path) {
		var anchor = path.replace(/.*#/, "");
		if (anchor != path)
			return anchor;
		return "";  // no anchor
	},


	/**
         * Useful to translate some status to an another
         * @ignore
         */
	getPresenceLabel:function(strPresence){
		var strPres="";
		var listPresence = {
			"ACTIVITY_ONTHEPHONE" : "ACTIVITY_ONTHEPHONE",
			"ACTIVITY_APPEAR_OFFLINE" : "ACTIVITY_APPEAR_OFFLINE",
			"ACTIVITY_AWAY" : "ACTIVITY_AWAY",
			"ACTIVITY_LUNCH" : "ACTIVITY_LUNCH",
			"ACTIVITY_OTHER" : "ACTIVITY_APPEAR_OFFLINE",
			"ACTIVITY_UNKNOWN" : "ACTIVITY_APPEAR_OFFLINE",
			"ACTIVITY_APPOINTMENT" : "ACTIVITY_APPOINTMENT",
			"ACTIVITY_ONLINE"   : "ACTIVITY_ONLINE",
			"ACTIVITY_BUSY" : "ACTIVITY_BUSY",
			"ACTIVITY_BE_RIGHT_BACK":"ACTIVITY_BE_RIGHT_BACK"
		}
		strPres= listPresence[strPresence] || "ACTIVITY_APPEAR_OFFLINE";
		return strPres;

	},

	/**
	 * Get a default photo according to a type
	 * @ignore
         * @param {String} strType the type of the picture (user, conference, im, video, voicemail)
	 * @param {String} strSize The time minutes
	 * @return {String} The path of the image
	 */
	// Return the path of a defaultPhoto (user, conference, im, video, voicemail), with a defined size (50, 70, 100)
	getDefaultPhotoPath : function(strType, strSize) {
		var type = "";
		if(this.listDefaultAvatarTypes[strType]){
			type = this.listDefaultAvatarTypes[strType];
		}
		type += strSize;
		strType=null;
		strSize=null;
		return "http://localhost/library/ICTouchAPI/themes/Default/images/avatar_"+type+".png";
	},

        /**
         * @ignore
         */
	getTelephonyPresenceIconPath : function(strPresence, strSize) {
		var strPresenceIcon = this.listPresence[strPresence]||"userinfo-offline";
		if(strSize){
			strPresenceIcon = strPresenceIcon + '-' + strSize;
		}
		strPresence=null;
		strSize=null;
		return strPresenceIcon;
	},

	/**
	 * Get hours in 24 format from AM/PM format
	 * @param {Number} intHours in AM/PM format
	 * @param {Boolean} boolIsMorning, true if AM, false if PM
	 * @return {Number} The time in 24 format
	 */
	get24HourFrom12 : function(intHours, boolIsMorning){
		if(boolIsMorning){
			return parseInt(intHours)%12;
		}
		return parseInt(intHours) == 12 ? 12 : parseInt(intHours) + 12;
	},

	/**
	 * Get hours in AM/PM format from 24 format
	 * @param {Number} intHours in 24 format
	 * @return {Object} The time in AM/PM format
	 * intHours:(intHours + 11)%12 + 1,
	 * boolIsMorning:intHours - 12 >= 0 ? true : false,
	 */
	get12HourFrom24 : function(intHours){
		return{
			intHours:(parseInt(intHours) + 11)%12 + 1,
			boolIsMorning:parseInt(intHours) - 12 < 0 ? true : false
		}
	},

	/**
	 * Format a Time
	 * @param {Number} strHours: The time hours
	 * @param {Number} strMinutes: The time minutes
	 * @param {Boolean} bool24h True if the hours param format is 24h
	 * @return {String} The time in String format
	 */
	getFormatedTime : function (strHours, strMinutes, bool24h)
	{
		var intHours   = parseInt(strHours);
		var intMinutes = parseInt(strMinutes);

		var objDate = {};
		// create the time string
		var strTime = "";
		// 12 / 24 format
		if(bool24h)
		{

			objDate = new Date(0,0,0,intHours,intMinutes,0);
			strTime = objDate.format("HH:mm",dojo.locale);
		}
		else
		{

			if(intHours == 0) intHours = 24;
			objDate = new Date(0,0,0,intHours,intMinutes,0);
			strTime = objDate.format("hh:mm a",dojo.locale);
		}

		strHours=null;
		strMinutes=null;
		bool24h=null;
		return strTime;

	},

	/**
	 * Format a Time with the seconds
	 * @param {Number} strHours: The time hours
	 * @param {Number} strMinutes: The time minutes
	 * @param {Number} strSeconds: The time seconds
	 * @param {Boolean} bool24h True if the hours param format is 24h
	 * @return {String} The time in String format
	 */
	getFormatedTimeWithSeconds : function (strHours, strMinutes, strSeconds, bool24h)
	{


		var intHours   = parseInt(strHours);
		var intMinutes = parseInt(strMinutes);
		var intSeconds = parseInt(strSeconds);

		var objDate = {};
		// create the time string
		var strTime = "";
		// 12 / 24 format
		if(bool24h)
		{

			objDate = new Date(0,0,0,intHours,intMinutes,intSeconds);
			strTime = objDate.format("HH:mm:ss",dojo.locale);
		}
		else
		{

			if(intHours == 0) intHours = 24;
			objDate = new Date(0,0,0,intHours,intMinutes, intSeconds);
			strTime = objDate.format("hh:mm:ss a",dojo.locale);
		}

		return strTime;
	},

	/**
	 * Format a Date
	 * @param {Date} date The date
	 * @param {String} strFormat The date format to apply
	 * @return {String} The date in String format
         * @ignore
	 */
	getFormatedDate : function (date, strFormat)
	{
		// convert to dojoFormat
		//strFormat = strFormat.replace(/dd/, 'dd');
		strFormat = strFormat.replace(/mm/, 'MM');
		strFormat = strFormat.replace(/YYYY/, 'yyyy');

		var returnedDate = date.format(strFormat,dojo.locale);
		strFormat=null;
		date=null;
		return returnedDate;
	},

	/**
	 * Check the validity of an email address
	 * @param {String} strEmail The email address to check
	 * @return {Boolean} true if the email address is valid, false otherwise
	 */
	checkEmailAddress : function (strEmail)	{
		if(strEmail){
			var regex = /^[a-zA-Z0-9._%-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
			if (strEmail.match(regex)) {
				ICTouchAPI.debugServices.debug("ICTouchAPI.tools - checkEmailAddress / Email address is valid, return true");
				return true;
			}
			else {
				ICTouchAPI.debugServices.debug("ICTouchAPI.tools - checkEmailAddress / Email address is not valid, return false");
				return false;
			}
		}
		else {
			ICTouchAPI.debugServices.warning("ICTouchAPI.tools - checkEmailAddress / strEmail is not defined or empty, return false");
			return false;
		}
	},

	/**
	 * Convert the first character only of the String to upper case
	 * @param {String} str The text to convert
         * @return {String} The converted text
	 */
	ucfirst :function (str) {
		str += '';
		var f = str.charAt(0).toUpperCase();
		return f + str.substr(1);
	},


        /**
         * @ignore
         */
	onLoadedWebapp : function(strWebapp, context, callback) {
		if (ICTouchAPI.webApplicationManager.getRefApplication(strWebapp)) {
			var func = dojo.hitch(context, callback);
			func(strWebapp);
		}
		else {
			dojo.subscribe("webApplicationManager.notify.loaded." + strWebapp, this, function() {
				var func = dojo.hitch(context, callback);
				func(strWebapp);
			});
		}
	},

	/**
	 * Register a button on the HomePage (preview Homepage)
	 * @param {Object} args The button arguments contained:
         * <pre><code>
         * - {String} strWebapp The name of the Webapp
         * - {String} strButtonName The name of the button
         * - {String} strButtonIcon The name of the icon
         * - {String} strLabel The label of the button
         * - {String} strStatusIcon The status of the led (optional) can be 'notif-on, 'notif-off' to display the led or undefined to not have a led
         * </pre></code>
	 */
	registerHomepageButton : function(args) {

		/*var name = args[0];
		var reg = /^[a-zA-Z]+\.[a-zA-Z]+/;
		var webappName = reg.exec(name);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.homepage",webappName[0], false,false,true);*/
		if(!args[5]){
			args[5] = function(){
					ICTouchAPI.transitionServices.getScreen({
						name: args[0],
						params: {},
						position: args[6]
					});
			};
		}
		dojo.publish("HomepageRegisterButton", args);
		var handler = dojo.subscribe("HomepageLoaded", this, function() {
			dojo.publish("HomepageRegisterButton", args);
			dojo.unsubscribe(handler);
		});
	},

        /**
         * Unregister a button cotnained in the Homepage (preview Homepage)
         * @param {String} args The button name
         */
	unregisterHomepageButton : function(args) {
		dojo.publish("HomepageUnregisterButton", args);
	},

	/**
	 * Register a Container in the Home Page
	 * @param {Object} args A View containing at least a ContainerControl
	 */
	registerHomepageContainer : function(args) {
		dojo.publish("HomepageRegisterPreviewContainer", args);
		var handler = dojo.subscribe("HomepageLoaded", this, function() {
			dojo.publish("HomepageRegisterPreviewContainer", args);
			dojo.unsubscribe(handler);
		});
	},

	/**
	 * Unregister a Container in the Home Page
	 * @param {Object} args A View containing at least a ContainerControl
	 */
	unregisterHomepageContainer : function(args) {
		dojo.publish("HomepageUnregisterPreviewContainer", args);
	},

	/**
	 * Register a button on the HomePage (Button HomePage)
	 * @param {Object} args The button arguments contained:
         * <pre><code>
         * - {String} strWebapp The name of the Webapp
         * - {String} strButtonName The name of the button
         * - {String} strButtonIcon The name of the icon
         * - {String} strLabel The label of the button
         * - {String} strStatusIcon The status of the led (optional) can be 'notif-on, 'notif-off' to display the led or undefined to not have a led
         * </pre></code>
	 */
	registerHomepageKey : function(args) {
		/*var name = args[0];
		var reg = /^[a-zA-Z]+\.[a-zA-Z]+/;
		var webappName = reg.exec(name);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.homepage",webappName[0], false,false,true);*/
		if(!args[5]){
			args[5] = function(){
				ICTouchAPI.transitionServices.getScreen({
					name: args[0],
					params: {},
					position: args[6]
				});
			};
		}
		dojo.publish("HomepageRegisterKey", args);
		var handler = dojo.subscribe("HomepageLoaded", this, function() {
			dojo.publish("HomepageRegisterKey", args);
			dojo.unsubscribe(handler);
		});
	},

	/**
	 * Unregister a button contained in the Homepage (button Homepage)
	 * @param {String} args The button name
	 */
	unregisterHomepageKey : function(args) {
		dojo.publish("HomepageUnregisterKey", args);
	},

	/**
	 * Unregister a awap button contained in the Homepage (button Homepage)
	 * @param {String} args The button name
	 */
	unregisterHomepageAwapKey : function(args) {
		dojo.publish("HomepageUnregisterAwapKey", args);
	},

	/**
	 *  Take a width and a height checks their rate accordingly to the screen
	 *  size and return a set of proper dimensions
	 *  @param {Number} inWidth  width to be checked, in pixel
	 *  @param {Number} inHeight  height to be checked, in pixel
	 *  @return {Object} holds proper dimensions: top, left, width and height
         *  @ignore
	 */
	getRatedDimensions : function(inWidth,inHeight){
		var width, height, top, left;
		//ratio between the given width and the expected one
		var ratioW = inWidth/800;
		//ratio between the given height and the expected one
		var ratioH = inHeight/480;
		//if the picture is bigger than the screen
		if(inWidth>800 || inHeight>480) {
			//check the ratio between width and height
			var ratio = inWidth/inHeight;
			//if the width is the more stretched dimension
			if(ratioW >= ratioH) {
				width = 800; //set the new size
				ratioW = 1; //deifne the width as base of rated dimensions
				height = width/ratio; //compute the rated height
				ratioH = height/inHeight; //compute the new rate between coming height and new height
			}else { //else
				height = 480;
				ratioH = 1;
				width = height*ratio;
				ratioW = width/inWidth;
			}
		}
		else {
			//keep the given dimensions unchanged
			width = inWidth;
			height = inHeight;
		}
		//compute the new top and left positions
		top = (480-height)/2;
		left = (800-width)/2;

		return {
			'top' : top,
			'left' : left,
			'width' : width,
			'height' : height,
			'ratioW' : ratioW,
			'ratioH':ratioH
		};
	},

	/* ----------------------------------- Private methods ------------------------------------- */

	/**
	 * @ignore
	 */
	getChildren : function(type, id) {
		var node = dojo.query(type + "#" + id)[0];

		if (node != undefined) {
			var childrenIds = {};
			for (var i=0; i < node.childElementCount; i++) {
				childrenIds[i] = node.children[i].id;

			}

			return childrenIds;
		}
		else {
			return undefined;
		}
	},

	/**
	 * @ignore
	 */
	getClickableListTitle : function(iframeid, widgetname) {
		return dojo.query("li[class='ContainerTitleContent']", dojo.query("*[widgetname='" + widgetname + "']", dojo.query("iframe[id='" + iframeid + "']")[0].contentDocument)[0])[0];
	},

	/**
	 * @ignore
	 */
	getClickableListItems : function(iframeid, widgetname) {
		//return dojo.query("li[class~='Content']", dojo.query("*[widgetname='" + widgetname + "']", dojo.query("iframe[id='" + iframeid + "']")[0].contentDocument)[0]);
		return document.getElementById(iframeid).contentDocument.body.querySelectorAll("*[widgetname='"+ widgetname +"'] li[class~='Content']");

	},

	/**
	 * @ignore
	 */
	setRefreshable : function(objWidget) {
		ICTouchAPI.debugServices.warning("ICTouchAPI.tools - setRefreshable / Do not use setRefreshable anymore, it's broken");
		objWidget.refresh = function(params) {
			// Clone the domNode of the widget ( without it's children )
			var srcNodeRef = this.domNode.cloneNode(false);
			var nodeToClean = this.domNode;
			// Replace the fresh node with the old one
			dojo.place(srcNodeRef, this.domNode, "replace");

			// Restart the lifecycle of this UI
			this.destroy(true);
			if( params != undefined )
				this.create(params, srcNodeRef);
			else
				this.create({}, srcNodeRef);

			// Start background cleaning task
			setTimeout(function() {
				// Destroy every widget contained within this UI
				var list = dojo.query('[widgetId]', nodeToClean);
				ICTouchAPI.debugServices.debug("ICTouchAPI.tools - setRefreshable / Destroying "+list.length+" Widget while refreshing");
				list.forEach(function(domWidget){
					var objWidget = dijit.byNode(domWidget);
					// Don't destroy ourself
					if( objWidget != null && objWidget.id != nodeToClean.id) {
						objWidget.destroy();
					}
				});
				// Finish him ! ( destroy the old dom )
				dojo.destroy(nodeToClean);
			}, 0);
		};
	},

	/**
	 * @ignore
	 */
	getPresenceIconPath:function(strPresence, strSize) {
		var strPresenceIcon= this.listPresenceIM[strPresence]||"userinfo-invisible";
		if(strSize){
			strPresenceIcon=strPresenceIcon+"-"+strSize;
		}
		strPresence=null;
		strSize=null;
		return(strPresenceIcon);

	},



	/**
	 * Change the status icon of a button contained into the Homepage
	 * @param {Object} args An object containing:
	 * <pre><code>
	 * - {String} The name of the button
	 * - {String } The new status of the led ('notif-on' or 'notif-off'
	 * </code></pre>
	 */
	changeHomepageStatusIcon : function (args) {
		dojo.publish("HomepageChangeStatusIcon", args);
		var handler = dojo.subscribe("HomepageLoaded", this, function() {
			dojo.publish("HomepageChangeStatusIcon", args);
			dojo.unsubscribe(handler);
		});
	},

	/**
	 * @ignore
	 */
	getContactPhone : function(objContact, boolCanonical) {
		var phoneNumber = "";
		// Find contact number.
		if (objContact.officePhone) {
			phoneNumber = objContact.officePhone;
		}
		else if (objContact.personalHome) {
			phoneNumber = objContact.personalHome;
		}
		else if (objContact.personalMobile) {
			phoneNumber = objContact.personalMobile;
		}
		else if (objContact.personalFax) {
			phoneNumber = objContact.personalFax;
		}
		if(typeof phoneNumber == "object"){
			if(boolCanonical){
				phoneNumber = (phoneNumber.value) ? phoneNumber.value.canonicalNumber : phoneNumber.canonicalNumber;
			} else {
				phoneNumber = (phoneNumber.value) ? phoneNumber.value.number : phoneNumber.number;
			}
		}

		objContact=null;
		return phoneNumber;
	},

	/**
	 * @ignore
	 */
	getNumbersFromContact : function(objContact) {
		var _arrNumbers = [];
		// Find contact number.

		if (objContact.officePhone) {
			_arrNumbers.push(objContact.officePhone);
		}
		if (objContact.personalHome) {
			_arrNumbers.push(objContact.personalHome);
		}
		if (objContact.personalMobile) {
			_arrNumbers.push(objContact.personalMobile);
		}
		if (objContact.officePhoneCan) {
			_arrNumbers.push(objContact.officePhoneCan);
		}
		if (objContact.personalHomeCan) {
			_arrNumbers.push(objContact.personalHomeCan);
		}
		if (objContact.personalMobileCan) {
			_arrNumbers.push(objContact.personalMobileCan);
		}
		objContact=null;
		return _arrNumbers;
	},


	/**
	 * @ignore
	 */
	getContactPresentationList : function(objContact, context, callback, strI18nRef, callIcon, boolOnlyPhoneNumbers) {
		var list = [];
		var item;
		var arrLabels = this.getContactFieldLabels();
		var _arrNumbersFromActiveCall = webapp.communication ? webapp.communication.data.getNumbersFromActiveCall() : [];
		var itemIcon = callIcon ? callIcon : "communication-call";
		if(objContact){
			for (var i in arrLabels) {
				if ( ((boolOnlyPhoneNumbers && (arrLabels[i].type == "Phone" || arrLabels[i].type == "otherPhone")) || (!boolOnlyPhoneNumbers && arrLabels[i].type != "Header")) && (objContact[arrLabels[i].id] || (objContact.miscMap && objContact.miscMap[arrLabels[i].id]))) {
					item = {
						strId: arrLabels[i].id,
						strLabel: _(arrLabels[i].label, strI18nRef),
						strContent: (objContact[arrLabels[i].id]) ? (objContact[arrLabels[i].id]) : objContact.miscMap[arrLabels[i].id],
						strType: arrLabels[i].type
                        //strIcon:(arrLabels[i].type == "Phone") ? 'communication-call' : null
					};

					if(arrLabels[i].type == "Phone" || arrLabels[i].type == "otherPhone"){

						if(typeof objContact[arrLabels[i].id] == "object"){
							item.strContent = (objContact[arrLabels[i].id].value)?objContact[arrLabels[i].id].value.number : objContact[arrLabels[i].id].number;
						}
                                                if (item.strContent === "anonymous" || item.strContent === "***") {
                                                    item.strContent = _("anonymous","ICTouchAPI");
                                                    item.callback = null;
                                                    item.strIcon = null;
                                                }
                                                else {
						var boolFind = false;
						for(var j = 0 ; j < _arrNumbersFromActiveCall.length ; j++)
						{
							if(_arrNumbersFromActiveCall[j]==objContact[arrLabels[i].id] || _arrNumbersFromActiveCall[j]==objContact[arrLabels[i].id+"Can"]){
								boolFind = true;
								item.callback = null;
								item.strIcon = null;
								item.strHighlight = "highlight"
								break;
							}
						}
						if(!boolFind){
							item.callback = dojo.hitch(context, callback, item);
							item.strIcon = itemIcon;
						}
                                                }
					}
                                        else{
						item.callback = dojo.hitch(context, callback, item);
						item.strIcon = null;
					}

					list.push(item);
				}
			}
		}
		objContact=null;
		context=null;
		callback=null;
		strI18nRef=null;
		return list;
	},

	/**
	 * @ignore
	 */
	getContactFieldLabels : function() {
		var _arrLabels = [];
		_arrLabels['name']				= {id: 'name', label: "Last name", type: "Header", misc: false};
		_arrLabels['firstName']			= {id: 'firstName', label: "First name", type: "Header", misc: false};
		_arrLabels['personalFax']		= {id: 'personalFax', label: "Extension number", type: "otherPhone", misc: false};
		_arrLabels['officePhone']		= {id: 'officePhone', label: "Phone", type: "Phone", misc: false};
		_arrLabels['personalMobile']	= {id: 'personalMobile', label: "Mobile phone", type: "Phone", misc: false};
		_arrLabels['assistant']			= {id: 'assistant', label: "Other phone", type: "Phone", misc: false};
		_arrLabels['collaborationId']			= {id: 'collaborationId', label: "IM", type: "IM", misc: false};
		_arrLabels['email']				= {id: 'email', label: "E-mail", type: "Email", misc: false};
		_arrLabels['fax']				= {id: 'fax', label: "Fax", type: "Fax", misc: false};
		_arrLabels['personalHome']		= {id: 'personalHome', label: "Private phone", type: "Phone", misc: false};
		_arrLabels['personalEmail']		= {id: 'personalEmail', label: "Private e-mail", type: "Email", misc: false};
		_arrLabels['photo']				= {id: 'photo', label: "Picture", type: "Header", misc: false};
		_arrLabels['company']			= {id: 'company', label: "Company", type: "Header", misc: true};
		_arrLabels['job']				= {id: 'job', label: "Job title", type: "Header", misc: true};
		_arrLabels['address']			= {id: 'address', label: "Address", type: "Address", misc: true};
		_arrLabels['zip']				= {id: 'zip', label: "Zip", type: "Zip", misc: true};
		_arrLabels['city']				= {id: 'city', label: "City", type: "Header", misc: true};
		_arrLabels['country']			= {id: 'country', label: "Country", type: "Header", misc: true};
		return _arrLabels;
	},

	/**
	 * Return the display name of the contact according to the following rules:
	 * - if the objContact has a firstName and/or a name, compute the display name according to the order
	 *   defined by the boolean _boolLastNameFirstNameOrder (should be linked to a setting to add in R250):
	 *   - if _boolLastNameFirstNameOrder is true, return the display name in the order "lastName + firstName"
	 *     with a space between the lastName and firstName
	 *   - if _boolLastNameFirstNameOrder is false, return the display name in the order "firstName + lastName"
	 *     with a space between the firstName and lastName
	 * - else if the objContact has a phoneNumber, return the phoneNumber as display name
	 * - else, return empty string ""
	 *
	 * @param {Object}   the Contact object used to compute the display name
	 * @return {String} Returns the display name of the contact.
	 * @ignore
	 */
	getContactDisplayName : function(objContact) {
		var displayNameLabel = "";
		if (objContact){
			var name = (objContact.name)?objContact.name:"";
			var firstName = (objContact.firstName)?objContact.firstName:"";
			if (this.intContactFirstNameOrder == 0) {
				firstName = (firstName) ? firstName + " " : "";
				displayNameLabel = firstName + name;
			}
			else {
				name = (name) ? name + " " : "";
				displayNameLabel = name + firstName;
			}
			var phoneNumber = this.getContactPhone(objContact);
			if (!displayNameLabel && phoneNumber) {
				displayNameLabel = phoneNumber;
			}
		}
		return displayNameLabel;
	},

	/**
	 * @ignore
	 */
	isFirstNameFirstDisplayed : function() {
		return (this.intContactFirstNameOrder == 0);
	},

	/**
	 * @ignore
	 */
	getLogDataFromStatus : function(objLogData,strSize) {
		// default nothing
		var obj = {
			strIcon : "",
			strNotif : ""
		};

		// switch on datas entryType then other attribute
		switch (objLogData.entryType)
		{
			// incoming, outgoing, missed
			case this.enumComLogEntryType.CallLog:
				// we needs to switch on callReason

				switch(objLogData.callDirection.value.value)
				{
					case this.CALLDIRECTION_OUTGOING:
						if(objLogData.isAnswered == 0)
						{
							// out no answer (= red)
							obj.strIcon = "communication-log-outgoing-call-no-answer";
						}
						else
						{
							// out ok (= blue)
							obj.strIcon = "communication-log-outgoing-call";
						}
						break;
					case this.CALLDIRECTION_INCOMING:
						// is it a missed call ?
						if(objLogData.isAnswered == 0)
						{
							//missed  (incoming not answered = red)
							obj.strIcon = "communication-log-missed-call";
							obj.strNotif = "Missed";
						}
						else
						{
							// incoming answered (=blue)
							obj.strIcon = "communication-log-incoming-call";
						}
						break;
				}
				break;
			// callback request
			case this.enumComLogEntryType.CallBackRequest:
				obj.strIcon = "communication-log-call-me-back";
				obj.strNotif = "Callback";
				break;
			// VM
			case this.enumComLogEntryType.VM:
				if(objLogData.entryPriority == 2){
					obj.strIcon = "communication-log-log-voicemail-priority";
				} else {
					obj.strIcon = "communication-log-voicemail";
				}
				obj.strNotif = "Voicemail";
				break;
			// Conference
			case this.enumComLogEntryType.Conference:
				obj.strIcon = "communication-log-conference-finish";
				break;
			// IM
			case this.enumComLogEntryType.IM:
				obj.strIcon = "communication-log-instant-messaging";
				break;
		}
		if(strSize){
			strSize="-"+strSize;
			obj.strIcon+=strSize;

		}
		objLogData=null;
		return obj;
	},

	/**
	 * @ignore
	 */
	formatRoutingLabel : function(from, dest, number, boolOther, noI18nize) {
		var arrLabel = [];
		arrLabel.push(from);
		arrLabel.push("to");
		if(boolOther){
			// do not translate phonenumbers in case 'Other'
			arrLabel.push(number);
		}else{
			arrLabel.push(dest);
		}
		
		if(noI18nize){
			return arrLabel;
		} else {
			return _(arrLabel, "webapp.userservices");
		}
	},
	
	/**
	 * @ignore
	 */
	getRoutingIcon: function(dest) {
		var icon = this.listDestinationsIcons[dest];
		if (typeof icon !== "string") {
			icon = this.listDestinationsIcons["Other"];
		}
		return icon + "-32";
	},

	/**
	 * @ignore
	 */
	getObjectReference : function(objRefStr) {
		var arr = objRefStr.split('.');

		var myObj = window;
		var length = arr.length;
		for (var i=0; i<length; i++) {
			myObj = myObj[arr[i]];
			if(!myObj){
				//this is done so we will not ask for the attribute of an undefined object
				return false;
			}
		}

		return myObj;
	},

	/**
	 * @ignore
	 */
	getEventArguments : function(args) {
		var arr = {};
		if (args && args.length) {
			var len = args.length;
			for (var i = 0; i < len; i++) {
				arr[args[i].name] = args[i].value;
			}
		}
		args=null;
		return arr;
	},

	/**
	 * check recursively if all the fields of the given objects are equal
	 * @param {Object} obj1 The first object to compare
	 * @param {Object} obj2 The second object to compare
	 * @return {Boolean} true if the objects are identical, false otherwise
	 */
	compareObjects : function(obj1, obj2){
        var isIdentical = true;
		if (obj1 && obj2) {
		for (var i in obj1) {
			if (obj1[i] !== obj2[i]) {
				if ((typeof obj1[i] === "object") && (typeof obj2[i] === "object" )) {
					isIdentical = this.compareObjects(obj1[i], obj2[i]);
					if (!isIdentical) {
						break;
					}
				}
					else if (!obj1[i] && !obj2[i]){ // if one obj[i] is null and the other obj[i] is "" continue
						continue;
					}
				else {
					isIdentical = false;
					break;
					}
				}
			}
		}
		else if (obj1 != obj2) {
			isIdentical = false;
		}

		obj1 = null;
		obj2 = null;
		return isIdentical;
	},

	/**
	 * This function remove any text node that contains only whitespace that is a direct child of domList
	 * The purpose is to allow "display: inline-block" without any CSS hack while keeping a nice template
	 * @ignore
         * @param {HTMLElement} domList
	 */
	removeWhitespaceNodes : function(domList) {
		// Can't use dojo.query because it ignores text nodes
		var list = domList.childNodes;
		// Match when the string is only composed of whitespaces or empty
		var regex = /^\s*$/;
		for(var i=0; i<list.length; ++i) {
			var item = list[i];
			if( item.nodeType == domList.TEXT_NODE && item.nodeValue.match(regex) != null ) {
				domList.removeChild(item);
			}
		}
	},

	/**
	 * Destroy the widget by givin it's root node
         * @ignore
	 * @param {HTMLElement} domWidget of the widget to destroy
	 * @return {Number} number of widget destroyed
	 */
	destroyWidgetByNode : function(domWidget) {
		var objWidget = dijit.byNode(domWidget);
		// Destroy it if it's really a widget
		if( objWidget != null ) {

			objWidget.destroy();
			return 1;
		}
		return 0;
	},

	/**
	 * Destroy every widget contained within this domElement
	 * then destroy the domElement itself
         * @ignore
	 * @param {HTMLElement} domElement is the dom to wipe out
	 * @param {Boolean} boolAvoidRoot if there is a widget at the root of domElement, should it be kept
	 */
	destroyWidgets : function(domElement, boolAvoidRoot) {


		// Get the list of elements to clean
		var list = dojo.query("[widgetid]", domElement);

		var nbr = 0;
		// Start the tear down
		list.forEach(function(element){
			nbr += ICTouchAPI.tools.destroyWidgetByNode(element);
		});
		if( !boolAvoidRoot ) {
			nbr += ICTouchAPI.tools.destroyWidgetByNode(domElement);
		}

		ICTouchAPI.debugServices.debug("ICTouchAPI.tools - destroyWidgets / Destroying "+nbr+" Widget while refreshing");

		// Finish him ! ( destroy the old dom )
		dojo.destroy(domElement);

	},

	/**
	 * Retrieve frame's id from a node
         * @ignore
	 * @param {HTMLElement} domSearch search the frame's id attached to this node
	 * @return {String} return the id or null if the node isn't attached to any frame
	 */
	getFrameId : function(domSearch) {
		// Search every node for the attribute frameid until we reach the root
		while(domSearch && domSearch.getAttribute) {
			var strFrameId = domSearch.getAttribute("frameid");
			if( typeof strFrameId == "string" ) {
				return strFrameId;
			}
			domSearch = domSearch.parentNode;
		}
		return null;
	},

	/**
	 * Convert callback object to dojo.hitch. If callback is function, callback is directly returned.
	 * @ignore
         * @param {Object} callback Object containing :
	 *				- context : context of the webapp
	 *				- func : callback function
	 *				- param : optionnal parameter for callback. Can be String, Number or Boolean
	 * @return {Function} dojo.hitch function.
	 */
	callbackToHitch : function(callback) {
		if(callback!=null) {
			if (typeof(callback)==="function") {
				return callback;
			}
			else {
				if (callback.context && callback.func) {
					if (callback.param) {
						//if (typeof(callback.param)==="string" || typeof(callback.param)==="number" || typeof(callback.param)==="boolean") {
							return dojo.hitch(callback.context, callback.func, callback.param);
						//}
						//else {
						//	throw "incorrect param";
						//}
					}
					else {
						return dojo.hitch(callback.context, callback.func);
					}
				}
			}
		}
		return null;
	}
});

ICTouchAPI.tools = new ICTouchAPI.tools();
