/**
 * @ignore
 */
dojo.provide("ICTouchAPI.simulation");
dojo.declare(
	"ICTouchAPI.simulation",
	null,
	{
		arrSettings		: [],
		arrContacts		: [],
		arrPhoneCalls	: [], // current calls
		arrComLog		: [], // history
		arrAgenda		: [],
		arrCapabilities	: [],
		arrMails		: [],
		arrConversations: [],
		arrFilesTypes	: [],
		arrFilesList	: [],
		arrPools		: [],
		objUndefinedSetting : null,

		constructor:function()
		{
			this.buildSettings();
			this.buildContacts();
			this.buildComLog();
			this.buildAgenda();
			this.buildCapabilities();
			this.builMails();
			this.buildConversations();
			this.buildFilesmanager();

			if( ICTouchAPI.devContext.simulation )
			{
				this._handler = setTimeout(dojo.hitch(this, this.simulateScreensaver), 60*1000);
				dojo.connect(dojo.body(), "click", this, this.clicked);
			}
		},

		simulateScreensaver:function()
		{
//            ICTouchAPI.eventServices._corePublishEvent("Screensaver_On");
		},

		clicked:function()
		{
			clearTimeout(this._handler);
			this._handler = setTimeout(dojo.hitch(this, this.simulateScreensaver), 60*1000);
		},

		fakeCallCore:function(args)
		{
			var url = dojo.moduleUrl("ICTouchAPI", "SimulatedCalls/"+args.domainName+"/"+args.methodName+".js").toString();
			dojo.xhrGet({
				url: url,
				handleAs: 'text',
				load: function(strSimulate, ioArgs){
					eval(strSimulate);
					var data = simulate(args);
					if (dojo.isFunction(args.callback)){

						/* Calling callback with correct context */
						var arrArguments = new Array();
						arrArguments.push(data);
						if( args.callbackParams !== undefined )
							arrArguments.push(args.callbackParams);

						// Permet de s'evader du try/catch stupide de dojo
						setTimeout(function() {
							args.callback.apply(args.context, arrArguments);
						}, 1);
					}
					else{
						// error callback is not a function or is empty
					}
				},
				error: function(error, ioArgs){
					//error durant xhr request execution
					console.error("callCoreApplicationMethod:error " + error + " url:"+ioArgs.url);
				}
			});
		},

		buildConversations : function ()
		{
			this.arrConversations.push({
				idConversation  : 0,
				conversationEndTime : {
					day:'26',
					month:'10',
					year:'2009',
					hour:'14',
					minute:'07'
				},
				contactFrom : "John Doe",
				contactTo   : "Jane Doe",
				ims : [
					{
						idIm    : 0,
						sentTime    : 2,
						message : "call me as soon as you get this message!",
						receiveTime : 2,
						isRead  :   false,
						distantId   : 1,
						boolDirection   : true
					},
					{
						idIm    : 1,
						sentTime    : 2,
						message : "I called but no answer",
						receiveTime : 3,
						isRead  :   false,
						distantId   : 1,
						boolDirection   : true
					},
					{
						idIm    : 2,
						sentTime    : 2,
						message : "Try again.",
						receiveTime : 3,
						isRead  :   false,
						distantId   : 1,
						boolDirection   : true
					}
				]
			});
		},

		builMails : function(){
			this.arrMails.push({
				to:"someone@gmail.com",
				from:"info@actimage.com",
				title:"This is the mail title",
				body:"This is the mail body",
				id : 0,
				status : "unread",
				attachment : [],
				dateTime: {
					datetime:{
						day:'26',
						month:'10',
						year:'2009',
						hour:'14',
						minute:'07'
					}
				}
			});
			this.arrMails.push({
				to:"someone@gmail.com",
				from:"info@actimage.com",
				title:"This is the mail title",
				body:"This is the mail body",
				id : 1,
				status : "read",
				attachment :[],
				dateTime: {
					datetime:{
						day:'17',
						month:'10',
						year:'2009',
						hour:'16',
						minute:'43'
					}
				}
			});
			this.arrMails.push({
				to:"someone@alcatel.com",
				from:"info@actimage.com",
				title:"",
				body:"",
				id : 2,
				status : "read",
				attachment : [{
					name : "Meetings.xls",
					type : "Excel"
				}, {
					name : "Appointments.xls",
					type : "Excel"
				}],
				dateTime: {
					datetime:{
						day:'17',
						month:'10',
						year:'2009',
						hour:'09',
						minute:'25'
					}
				}
			});
		},

		buildSettings : function() {
			this.objUndefinedSetting = { id: "", value: "", label: "_undefined_", type:"TEXT", allowedValues: {}, mainCategory: "", category: "", rights: "RW_RW", display: false, isUndefined: 1 };
			this.arrSettings.push({ id: "AccessByURL", value: "true", label: "Access by URL", type:"BOOLEAN", allowedValues: [], mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "LockedBookmark", value: "false", label: "Locked Bookmark", type:"BOOLEAN", allowedValues: [], mainCategory: "Device", category: "PhoneConfiguration", enabled: true, admin: true, module: "", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "DateFormat", value: 0, label: "Date format", type:"CHOICE", allowedValues: [{id: 0, name: "dd/mm/YYYY"}, {id: 1, name:"mm/dd/YYYY"}, {id: 2, name:"YYYY/mm/dd"}], mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "TimeFormat", value: 0, label: "Time format", type:"BOOLEAN[12,24]", allowedValues: [], mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "RoutingList", value: "Immediate:Other:0123456789;On busy:Mobile:;On no answer:Voicemail:", label: "Routing list", type:"LIST[TEXT]", allowedValues: { }, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "RoutingIcon", value: "", label: "Routing icon", type:"TEXT", allowedValues: { }, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "Hour", value: "22:30", label: "Hour", type:"TIME", allowedValues: { }, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "RoutingLabel", value: "", label: "Routing label", type:"TEXT", allowedValues: { }, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "ActiveRouting", value: "On busy:Mobile:", label: "Active Routing", type:"TEXT", allowedValues: { }, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "AllowDirectCustomForward", value: "true", label: "Allow direct custom forward", type:"BOOLEAN", allowedValues: {}, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "Language", value: 1, label: "Language", type:"CHOICE", allowedValues: [{id: 0, name: "en"}, {id: 1, name: "fr"}, {id: 2, name: "es"}, {id: 3, name: "de"}, {id: 4, name: "it"}], mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "Defaultkeyboard", value: "0", label: "Default keyboard", type:"CHOICE", allowedValues: [{id: "0", name: "azerty"}, {id: "1", name: "qwerty"}], mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ComlogFilterIncoming", value: "true", label: "Filter incoming", type:"BOOLEAN[on,off]", allowedValues: { }, mainCategory: "Application", category: "Comlog", user_rights: 2, admin_rights: 2, module: "Communication", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ComlogFilterOutgoing", value: "true", label: "Filter outgoing", type:"BOOLEAN[on,off]", allowedValues: { }, mainCategory: "Application", category: "Comlog", user_rights: 2, admin_rights: 2, module: "Communication", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ComlogFilterVM", value: "false", label: "Filter voice mail", type:"BOOLEAN[on,off]", allowedValues: { }, mainCategory: "Application", category: "Comlog", user_rights: 2, admin_rights: 2, module: "Communication", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ComlogFilterIM", value: "false", label: "Filter Instant Messages", type:"BOOLEAN[on,off]", allowedValues: { }, mainCategory: "Application", category: "Comlog", user_rights: 2, admin_rights: 2, module: "Communication", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ComlogFilterCallback", value: "false", label: "Filter callback request", type:"BOOLEAN", allowedValues: { }, mainCategory: "Application", category: "Comlog", user_rights: 2, admin_rights: 2, module: "Communication", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "IPAddress", value: "127.0.0.1", label: "IP Address", type:"IP_ADDRESS", allowedValues: { }, mainCategory: "Admin", category: "-", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserBackgroundPicture", value: "", label: "User background picture", type:"TEXT", allowedValues: { }, mainCategory: "webapp", category: "Filesmanager", user_rights: 2, admin_rights: 2, module: "", display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "UserRingingMelody", value: "", label: "User ringing melody", type:"TEXT", allowedValues: { }, mainCategory: "webapp", category: "Filesmanager", user_rights: 2, admin_rights: 2, module: "", display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "EnableUserPhoto", value: "true", label: "Enable user photo", type:"BOOLEAN", allowedValues: { }, mainCategory: "user", category: "User data", user_rights: 2, admin_rights: 2, module: "", display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserName", value: "Doe", label: "Name", type:"TEXT", allowedValues: { }, mainCategory: "Application", category: "UserData", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserFirstName", value: "John", label: "First name", type:"TEXT", allowedValues: { }, mainCategory: "Application", category: "UserData", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserPhoto", value: "library/ICTouchAPI/themes/Default/images/picture_family.png", label: "Photo", type:"TEXT", allowedValues: { }, mainCategory: "Application", category: "UserData", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			//this.arrSettings.push({ id: "Password", value: "abc", label: "Password", type:"PASSWORD", allowedValues: { }, mainCategory: "Application", category: "UserData", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "PhoneNumber", value: "0123456789", label: "Phone number", type:"TEXT", allowedValues: { }, mainCategory: "user", category: "User data", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserPresence", value: "0", label: "Presence", type:"CHOICE", allowedValues: [{ id: "0", name: "Available" }, { id: "1", name:"Busy" }, { id: "2", name:"Away" }, { id: "3", name:"Invisible" }], mainCategory: "user", category: "User services", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserPresenceCustomMsg", value: "I'm eating", label: "Custom Message", type:"TEXT", allowedValues: {}, mainCategory: "user", category: "User services", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "NewCallDefaultMethod", value: "1", label: "New call method", type:"CHOICE", allowedValues: [{id: "0", name: "Dial-pad"}, {id: "1", name: "Keyboard"}], mainCategory: "Application", category: "Communication", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ScreenSaverRegistered", value: "0", label: "Registered screensaver", type:"CHOICE", allowedValues: [{id: "webapp.screensaver.defaultScreensaver", name: "Default screensaver" }], mainCategory: "Application", category: "ScreenSaver", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "ScreensaverSlideshowList", value: "image1.jpg;image2.jpg;image3.jpg;image4.jpg", label: "Screensaver slideshow list", type:"LIST", allowedValues: { }, mainCategory: "Application", category: "ScreenSaver", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "ScreensaverSlideshowDelay", value: 4, label: "screensaverSlideshowDelay", type:"NUMERIC[1-60]", allowedValues: { }, mainCategory: "Application", category: "ScreenSaver", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "DemoMode", value: "false", label: "Demo mode", type:"BOOLEAN", allowedValues: { }, mainCategory: "Application", category: "ScreenSaver", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "ScreenSaverEnabled", value: "false", label: "Enable screensaver", type:"BOOLEAN", allowedValues: { }, mainCategory: "Application", category: "ScreenSaver", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyNumber1", value: "911", label: "First emergency number", type:"PHONE_NUMBER", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyLabel1", value: "Urgences", label: "First emergency label", type:"TEXT", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyIcon1", value: "", label: "First emergency icon", type:"TEXT", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyNumber2", value: "", label: "Second emergency number", type:"PHONE_NUMBER", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyLabel2", value: "", label: "Second emergency label", type:"TEXT", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyIcon2", value: "", label: "Second emergency icon", type:"TEXT", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyNumber3", value: "", label: "Third emergency number", type:"PHONE_NUMBER", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyLabel3", value: "", label: "Third emergency label", type:"TEXT", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "EmergencyIcon3", value: "", label: "Third emergency icon", type:"TEXT", allowedValues: { }, mainCategory: "DeviceManager", category: "EmergencyNumber", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "AlarmTimeList", value: "0", label: "List of times", type:"CHOICE", allowedValues: [{ value: 5, name: "5 minutes before" },{ value: 60, name: "1 hour before" }], mainCategory: "webapp", category: "agenda", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "EMailDefaultSort", value: "0", label: "EMail Default Sort", type:"CHOICE", allowedValues: [{ value: 0, name: "date" },{ value: 1, name: "sender" }], mainCategory: "webapp", category: "email", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "EMailFilter", value: "0", label: "EMail Filter", type:"CHOICE", allowedValues: [{ value: 0, name: "all" },{ value: 1, name: "unread" }], mainCategory: "webapp", category: "email", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "HomepageContainers", value: "", label: "Homepage Previews list", type:"LIST", allowedValues: { }, mainCategory: "webapp", category: "homepage", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "ProgKeysLocations", value: "{label : 'Virtual Key', index : 'virtual'};{label : 'Physical Key', index : 'physical'}", label: "Actions for programmable keys", type:"LIST", allowedValues: { }, mainCategory: "webapp", category: "Programmable Keys", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "DoNotDisturb", value: "false", label: "Do not disturb", type:"BOOLEAN[on,off]", allowedValues: { }, mainCategory: "webapp", category: "homepage", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "HomepageButtons", value: "", label: "Homepage Buttons list", type:"LIST", allowedValues: { }, mainCategory: "webapp", category: "homepage", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "ConnectivityItems", value: "{event:'JACK_PLUG',icons:['connectivity-headset-16']}", label: "Connectivity events", type:"LIST", allowedValues: { }, mainCategory: "Application", category: "Connectivity", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "CurrentEnetcfgSntpSyncStatus", value: "0", label: "Is SNTP", type:"CHOICE", allowedValues: [{id: "0", name: "YES" }, {id: "1", name: "NO" }, {id: "2", name: "SYNC" }], mainCategory: "Device", category: "Platform", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "IsLocalDateSet", value: "false", label: "Is local date set", type:"BOOLEAN", allowedValues: { }, mainCategory: "Application", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "ScreenTransitionEffect", value: "true", label: "Screen transition effect", type:"BOOLEAN", allowedValues: { }, mainCategory: "Application", category: "Effects", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "HapticEnabled", value: "false", label: "Enable haptic", type:"BOOLEAN", allowedValues: { }, mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "RingingBeforeValues", value: "{value:5,name:'5 minutes before'};{value:60,name:'1 hour before'}", label: "Ringing time values", type:"LIST", allowedValues: { }, mainCategory: "Application", category: "Agenda", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "TestDate", value: "1262696940", label: "Test Date", type:"DATE", allowedValues: { }, mainCategory: "Device", category: "Test", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "TestPhone", value: "0490380000", label: "Test phone", type:"PHONE_NUMBER", allowedValues: { }, mainCategory: "Device", category: "Test", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "TelephonyForwardTypes", value: "TYP_IMMEDIATE;TYP_ON_BUSY;TYP_ON_NO_ANSWER;TYP_ON_BUSY_OR_NO_ANSWER", label: "Forward Types", type:"LIST", allowedValues: { }, mainCategory: "Application", category: "Userservices", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "TelephonyForwardDestinations", value: "DST_VOICEMAIL;DST_MOBILE;DST_ASSOCIATE;DST_ASSISTANT", label: "Forward Destinations", type:"LIST", allowedValues: { }, mainCategory: "Application", category: "Userservices", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "TypeValueList", value: "0", label: "Contact Type Values", type:"LIST",allowedValues: [{ id: "0", name: "Phone" }, { id: "1", name:"Mail" }, { id: "2", name:"Fax" }, { id: "3", name:"Adress" }, { id: "4", name:"Adress2" }, { id: "5", name:"Adress3" }, { id: "6", name:"Adress4" }], mainCategory: "Application", category: "Contacts", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "HomepageEditMode", value: "", label: "Edit Homepage", type:"LIST", mainCategory: "Application", category: "Homepage", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "UserRole", value: "1", label: "UserRole", type:"CHOICE", allowedValues: [{id: "0", name: "MANAGER" }, {id: "1", name: "ASSISTANT" }, {id: "2", name: "UNKNOWN" }], mainCategory: "user", category: "User data", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 });
			this.arrSettings.push({ id: "UserCallSupervisionStatus", value: "true", label: "Notification Status", type:"BOOLEAN", allowedValues: [], mainCategory: "user", category: "User data", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });
			this.arrSettings.push({ id: "VVMUseSearchWebapp", value: "true", label: "eMail Search in VVM", type:"BOOLEAN", allowedValues: [], mainCategory: "Device", category: "PhoneConfiguration", user_rights: 2, admin_rights: 2, display: true, isUndefined: 0 });

			this.arrSettings.push({ id: "MyBluetooth", application: "bluetooth", label: "bluetooth", value:"webapp.bluetooth.getMyDevices", type:"WEBAPP", allowedValues: { }, mainCategory: "Bluetooth", category: "MesEquipements", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 , missing_mandatory : false });
			this.arrSettings.push({ id: "AddBluetooth", application: "bluetooth", label: "bluetooth", value:"webapp.bluetooth.getAddDevice", type:"WEBAPP", allowedValues: { }, mainCategory: "Bluetooth", category: "Ajouter", user_rights: 2, admin_rights: 2, display: false, isUndefined: 0 , missing_mandatory : false });
		
		},

		buildCapabilities : function() {
			var cst = {
				AVAILABLE 			: 0,
				UNAVAILABLE 		: 1,
				TEMP_UNAVAILABLE	: 2,
				UNKNOWN				: -1
			};
			this.arrCapabilities.push({ module: "Agenda", name: "Repeat", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Agenda", name: "Stop", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Agenda", name: "Snooze", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Agenda", name: "WakeUpVolume", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Agenda", name: "WakeUpMelody", value: cst.UNAVAILABLE});
			this.arrCapabilities.push({ module: "Agenda", name: "EventCreation", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Agenda", name: "EventModification", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "makeCall", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "hold", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "release", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "sendDtmf", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "transfer", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "conference", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "answer", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "retrieve", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "reject", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "ignore", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "cancelConference", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "doNotDisturb", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "routing", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "doUserPresence", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "doRouting", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "doVoicemailEdition", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "doSetUserDetails", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "callBackRequest", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "deflect", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "messageDeposit", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Telephony", name: "record", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Voicemail", name: "IMConnected", value: cst.AVAILABLE});
			this.arrCapabilities.push({ module: "Voicemail", name: "VisualVoicemail", value: cst.UNAVAILABLE});
		},

		buildContacts : function() {
			this.arrContacts["LOCAL"] = [];
			this.arrContacts["REMOTE"] = [];
			this.arrContacts["LOCAL"].push({
				id: 0, surname: "Heil", firstname: "Jérôme", nickname: "", job: "Engineer", language: "fr",
				addressMap: { Email: { address: "jerome.heil@actimage.com" }, Phone: { phoneNumber: "60001" } }
			});
			this.arrContacts["LOCAL"].push({
				id: 1, surname: "Ach", firstname: "Benjamin", nickname: "", job: "Integrator", language: "fr",
				addressMap: { Email: { address: "benjamin.ach@actimage.com" }, Phone: { phoneNumber: "60002" } }
			});
			this.arrContacts["LOCAL"].push({
				id: 2, surname: "Takvorian", firstname: "Joel", nickname: "", job: "Engineer", language: "fr",
				company: { name: "Actimage", locality: { city: "Colmar", zip: "68000", country: "France" } },
				addressMap: { Email: { address: "joel.takvorian@actimage.com" }, Phone: { phoneNumber: "60003" } }
			});
			this.arrContacts["REMOTE"].push({
				id: 3, surname: "Noël", firstname: "Cédric", nickname: "", job: "Engineer", language: "fr",
				addressMap: { Email: { address: "cedric.noel@actimage.com" }, Phone: { phoneNumber: "60004" } }
			});
			this.arrContacts["REMOTE"].push({
				id: 4, surname: "Scherrer", firstname: "Olivier", nickname: "", job: "Engineer", language: "fr",
				addressMap: { Email: { address: "olivier.scherrer@alcatel.com" }, Phone: { phoneNumber: "60005" } }
			});
		},

		buildAgenda : function() {
			this.arrAgenda["WAKEUP"] = [];
			this.arrAgenda["APPOINTMENT"] = [];
			this.arrAgenda["WAKEUP"].push({
				id: 20, label: "REVEIL",
				beginDate: { datetime: { day:'11', month:'09', year:'2009', hour:'12', minute:'00' } },
				endDate: { datetime: { day:'11', month:'09', year:'2009', hour:12, minute:2 } },
				alarmState : true,
				alarm: { type: "Alarm", value: { id: 1, sourceType: "SRC_STREAMING", sourcePath: "http://rtl.com/", volume: 7 } }
			});
			this.arrAgenda["APPOINTMENT"].push({
				id: 1, label: "Meal",
				beginDate: { datetime: { day:'11', month:'09', year:'2009', hour:'12', minute:'00' } },
				endDate: { datetime: { day:'14', month:'09', year:'2009', hour:'12', minute:'10' } },
				alarmState : false
			});
			this.arrAgenda["APPOINTMENT"].push({
				id: 2, label: "Meeting",
				beginDate: { datetime: { day:'06', month:'08', year:'2009', hour:'14', minute:'00' } },
				endDate: { datetime: { day:'06', month:'08', year:'2009', hour:'18', minute:'00' } },
				alarmState : false
			});
			this.arrAgenda["APPOINTMENT"].push({
				id: 3, label: "Travel time",
				beginDate: { datetime: { day:'01', month:'07', year:'2009', hour:'07', minute:'30' } },
				endDate: { datetime: { day:'01', month:'07', year:'2009', hour:'09', minute:'00' } },
				alarmState : false
			});
			this.arrAgenda["APPOINTMENT"].push({
				id: 4, label: "الص�?حة الرئيسية",
				beginDate: { datetime: { day:'30', month:'10', year:'2009', hour:'07', minute:'30' } },
				endDate: { datetime: { day:'30', month:'10', year:'2009', hour:'09', minute:'00' } },
				alarmState : false
			});
		},

		buildComLog : function() {
			this.arrComLog.push({comLogEntryId: 15,phoneNumber: "123456",entryType: 2, duration:200, label: "", WSRecordingId:25, connectionTime: 50, contactId: 2, dateTime: { datetime: { year: 2010, month: 1, day: 2, hour: 13, minute: 59 }}, isRead : false });

			this.arrComLog.push({comLogEntryId: 13,phoneNumber: "01234567", entryType: 0, duration:1, label: "", contactId: -1, dateTime: { datetime: { year: 2005, month: 12, day: 20, hour: 14, minute: 59 }}, isRead : false, isAnswered: true, callDirection: { value: { value: "CALL_OUTGOING" }}});
			this.arrComLog.push({comLogEntryId: 12,phoneNumber: "01234567", entryType: 0, duration:0, label: "", contactId: -1, dateTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}, isRead : true, isAnswered: true, callDirection: { value: { value: "CALL_INCOMING" }}});
			this.arrComLog.push({comLogEntryId: 11,phoneNumber: "0123456789", entryType: 0, duration:0, label: "", contactId: -1, dateTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}, isRead : true, isAnswered: true, callDirection: { value: { value: "CALL_OUTGOING" }}});
			this.arrComLog.push({comLogEntryId: 10,phoneNumber: "60002",entryType: 0, duration:176, label: "", contactId: 2, dateTime: { datetime: { year: 2009, month: 1, day: 21, hour: 15, minute: 16 }}, isRead : false, isAnswered: true, callDirection: { value: { value: "CALL_OUTGOING" }}});
			this.arrComLog.push({comLogEntryId: 9,phoneNumber: "888",entryType: 2, duration:356, label: "", contactId: -1, dateTime: { datetime: { year: 2009, month: 4, day: 22, hour: 17, minute: 26 }}, isRead : true });
			this.arrComLog.push({comLogEntryId: 8,phoneNumber: "60002",entryType: 0, duration:124, label: "", contactId: 2, dateTime: { datetime: { year: 2009, month: 11, day: 23, hour: 5, minute: 36 }}, isRead : false, isAnswered: false, callDirection: { value: { value: "CALL_INCOMING" }}});
			this.arrComLog.push({comLogEntryId: 7,phoneNumber: "60001",entryType: 0, duration:567, label: "", contactId: 1, dateTime: { datetime: { year: 2009, month: 7, day: 12, hour: 5, minute: 46 }}, isRead : true, isAnswered: false, callDirection: { value: { value: "CALL_INCOMING" }}});
			this.arrComLog.push({comLogEntryId: 6,phoneNumber: "888",entryType: 2, duration:34, label: "", contactId: -1, dateTime: { datetime: { year: 2008, month: 3, day: 6, hour: 7, minute: 56 }}, isRead : false });
			this.arrComLog.push({comLogEntryId: 5,phoneNumber: "60001",entryType: 0, duration:654, label: "", contactId: 1, dateTime: { datetime: { year: 2009, month: 6, day: 8, hour: 10, minute: 56 }}, isRead : true, isAnswered: true, callDirection: { value: { value: "CALL_OUTGOING" }}});
			this.arrComLog.push({comLogEntryId: 4,phoneNumber: "888",entryType: 2, duration:877, label: "", contactId: -1, dateTime: { datetime: { year: 2009, month: 4, day: 8, hour: 12, minute: 57 }}, isRead : true });
			this.arrComLog.push({comLogEntryId: 3,phoneNumber: "60001",entryType: 0, duration:877, label: "", contactId: 1, dateTime: { datetime: { year: 2009, month: 10, day: 21, hour: 5, minute: 58 }}, isRead : false, isAnswered: true, callDirection: { value: { value: "CALL_OUTGOING" }}});
			this.arrComLog.push({comLogEntryId: 2,phoneNumber: "60001",entryType: 0, duration:720, label: "", contactId: 1, dateTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}, isRead : true, isAnswered: true, callDirection: { value: { value: "CALL_INCOMING" }}});
			this.arrComLog.push({comLogEntryId: 1,phoneNumber: "888",entryType: 2, duration:4, label: "", contactId: -1, dateTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}, isRead : true });
			this.arrComLog.push({comLogEntryId: 14,phoneNumber: "666",entryType: 4, duration:200, label: "", contactId: 1, dateTime: { datetime: { year: 2010, month: 1, day: 2, hour: 13, minute: 59 }}, isRead : false });
			

			// Active phone call
            //this.arrPhoneCalls.push({callId: 1001, phoneNumber: "0123456789", callDirection: 1, isConnected: true, isLocal:true, duration: 0, startTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}});
            //this.arrPhoneCalls.push({callId: 1002, phoneNumber: "0123456766", callDirection: 1, isConnected: false, duration: 0, startTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}});
            //this.arrPhoneCalls.push({callId: 1003, phoneNumber: "0123456766", callDirection: 0, isConnected: false, duration: 0, startTime: { datetime: { year: 2005, month: 12, day: 20, hour: 13, minute: 59 }}});
		},

		buildFilesmanager : function() {
			this.arrFilesTypes = [];
			this.arrFilesTypes.push({id:1, name:"Audio files"});
			this.arrFilesTypes.push({id:2, name:"Video files"});
			this.arrFilesTypes.push({id:3, name:"Image files"});
			this.arrFilesTypes.push({id:4, name:"WebRadio"});
			this.arrFilesTypes.push({id:5, name:"WebTv"});
			this.arrFilesTypes.push({id:6, name:"Bookmarks"});

			this.arrFilesList = [];
			for( var i in this.arrFilesTypes)
				this.arrFilesList[this.arrFilesTypes[i].id] = [];

			this.arrFilesList[1].push({id:4, path:"http://pluton.frequence3.net:19000/frequence3.ogg", name:"frequence3.ogg", size:4, device: 'usnetb'});
			this.arrFilesList[1].push({id:5, path:"Punk is not dead.mp3", name:"Punk is not dead.mp3", size:5});
			this.arrFilesList[1].push({id:6, path:"Dire Straits.mp3", name:"Dire Straits.mp3", device: 'usb'});
			this.arrFilesList[1].push({id:7, path:"http://localhost/xera_lliendes_lliendes.mp3", name:"xera_lliendes_lliendes.mp3", size:5, device: 'net'});
			this.arrFilesList[1].push({id:8, path:"http://localhost/bugsbunny1.wav", name:"bugsbunny1.wav"});
			this.arrFilesList[1].push({id:9, path:"http://api.jamendo.com/get2/stream/track/redirect/?id=14772&streamencoding=ogg2", name:"api.jamendo.com", device: 'net'});

			this.arrFilesList[2].push({id:1, path:"movie1.avi", name:"movie1.avi",  size:650, device: 'stream'});
			this.arrFilesList[2].push({id:2, path:"movie2.mpg", name:"movie2.mpg"});
			this.arrFilesList[2].push({id:3, path:"http://movies.apple.com/movies/us/apple/ipoditunes/2007/touch/ads/apple_ipodtouch_touch_r640-9cie.mov", name:"apple_ipodtouch_touch_r640-9cie.mov", size:1});
			this.arrFilesList[2].push({id:4, path:"http://www.dailymotion.com/cdn/OGG-320x240/video/x99gp5_transformers640_creation?key=2b1fcbfc108b2fe2a5e13e27a58317b013e0fa9", name:"x99gp5_transformers640_creation"});

			this.arrFilesList[3].push({id:1, path:"http://localhost/lliendes_frontal_mini.jpg", name:"lliendes_frontal_mini.jpg"});

			this.arrFilesList[4].push({id:1, path:"...", name:"RFM"});
			this.arrFilesList[4].push({id:2, path:"...", name:"France Info"});

			this.arrFilesList[5].push({id:1, path:"...", name:"TF1"});
			this.arrFilesList[5].push({id:2, path:"...", name:"M6"});
			this.arrFilesList[5].push({id:3, path:"...", name:"TV5 Monde"});
			this.arrFilesList[5].push({id:4, path:"...", name:"TRS1"});
			this.arrFilesList[5].push({id:5, path:"...", name:"Canal J"});

			this.arrFilesList[6].push({id:1, path:"http://www.google.com", name:"Google", isLink: true});
			this.arrFilesList[6].push({id:2, path:"http://wikipedia.com", name:"Wikipedia", isLink: true});
			this.arrFilesList[6].push({id:3, path:"http://youtube.com", name:"Youtube", isLink: true});

			this.arrPools = [];
			this.arrPools["background"] = [];
			this.arrPools["wakeup"] = [];
			this.arrPools["screensaver"] = [];
			this.arrPools["ring"] = [];
		},

		// needed to simulate timers for ongoing Communications
		intervalHandlerOngoingCom : null,
		// call when an ongoing call is started
		startTimer : function () {
			// interval of one sec for calling update function
			if(!this.intervalHandlerOngoingCom)
				this.intervalHandlerOngoingCom = setInterval( dojo.hitch(this, this.increaseOnGoingTimers), 1000);
		},
		// call when an ongoing call is stopped
		stopTimer : function () {
			// we can't stop cause ongoing call are working
			if(this.arrPhoneCalls != 0) return;
			// clear interval
			if(this.intervalHandlerOngoingCom)
				clearInterval(this.intervalHandlerOngoingCom);
			this.intervalHandlerOngoingCom = null;
		},
		// increase duration of the phone calls
		increaseOnGoingTimers : function () {
			// through PhoneCalls increment duration
			for(var i=0; i<this.arrPhoneCalls.length;i++)
			{
				this.arrPhoneCalls[i].duration++;
			}
		},

		switchCapability : function (strCapname, intNewValue) {
			for (var i in this.arrCapabilities) {
				var objCap = this.arrCapabilities[i];
				if (objCap.name == strCapname) {
					objCap.value = intNewValue;
					ICTouchAPI.eventServices._corePublishEvent("CapabilityChanged" + objCap.module, [{value:{module:objCap.module,capability:objCap.name}}]);
					return;
				}
			}
		}
	}
);

ICTouchAPI.simulation=new ICTouchAPI.simulation();
