/**
* @class ICTouchAPI.presenceServices
* @singleton
* @ignore
* @extends Object
*/
dojo.provide("ICTouchAPI.presenceServices");
dojo.declare("ICTouchAPI.presenceServices",
	null,
	{
		/* --------------------------------- Public attributes ------------------------------------ */



		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		* @property
		* @type Boolean
		* @private
		*/
		imEnabled : false,

		/**
		* @property
		* @type Boolean
		* @private
		*/
		presenceAddedInDs : false,

		/**
		* @property
		* @type Boolean
		* @private
		*/
		boolIMAvailble : null,

		/**
		* @property
		* @type Boolean
		* @private
		*/
		boolTelephonyPresenceAvailable : null,
		/**
		* @property
		* @type Boolean
		* @private
		*/
		boolDisableIM : false,

		/* ------------------------------------ Constructor --------------------------------------- */

		/**
		* The presence services manage presence for contacts and update it in dataStore for webapps
		* @private
		*/
		constructor: function() {
			ICTouchAPI.eventServices.subscribeToEvent(this,"IM_ENABLED",this.initPresenceInDataStore);
			// Default settings for simulation mode
                        if(!generalConfig.simulation) {
			ICTouchAPI.settingServices.subscribeToSetting(this,"IMAvailable",this.onIMAvailable);
			ICTouchAPI.settingServices.getSetting("IMAvailable",this,this.onIMAvailable);
			ICTouchAPI.settingServices.subscribeToSetting(this,"TelephonyPresenceAvailable",this.onTelephonyPresence);
			ICTouchAPI.settingServices.getSetting("TelephonyPresenceAvailable",this,this.onTelephonyPresence);
                        }
			// If we are in remote display, call manually the initDataStores function to create the dataStore of contacts
			// (in remote display we will not receive the 'end_of_init_IctDirectory' event)'
			if (ICTouchAPI.remoteDisplay) {
				this.initPresenceInDataStore({
					value:true
				});
			}
			ICTouchAPI.eventServices.subscribeToEvent(this, "IM_BUDDIES_DELETED", this.onBuddyDeleted);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Get Application Name
		 * @private
		 * @return {String} The name of the Application Service
		 */
		getApplicationName: function(){
			return "presenceServices";
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		* Get the state of the IM feature
		* @return {Boolean} True if the Im is enabled
		*/
		isImAvailable : function(){
			return this.imEnabled;
		},

		/**
		* Get the state telephony presence availability
		* @return {Boolean} True if the telephony presence is available
		*/
		isTelephonyPresenceAvailable : function() {
			return this.boolTelephonyPresenceAvailable;
		},

		/**
		* Get the state IM presence availability
		* @return {Boolean} True if the IM presence is available
		*/
		isIMPresenceAvailable : function() {
			return this.boolIMAvailble;
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @private
		 */
		initPresenceInDataStore: function(event) {
			// Static value to disable presence feature because out of scope.
			if(!this.boolDisableIM){
				if(event && typeof event.value != "undefined"){
					var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
					var myDSContent;
					// IM may be enabled for managerAssistant, even if both settings of IM and telephonic presence are unavailable.
					if(event.value && (this.boolIMAvailble || this.boolTelephonyPresenceAvailable)){
						// Initiate presence in DataStore if not already done
						if(myDS && !this.presenceAddedInDs){
							// Add columns in dataModel
							myDS.addColumn({
								index: 'IMPresence'
							});
							myDS.addColumn({
								index: 'telephonyPresence'
							});
							// Subscribe to presenceChange event
							ICTouchAPI.eventServices.subscribeToEvent(this,"IM_PRESENCE_CHANGE",this.onPresenceChanged);
							this.presenceAddedInDs = true;
						}
						if(this.presenceAddedInDs){
							// If dataStore is initiated, get presence for every contact in it.
							myDSContent = myDS.getList();
							var arrContactId = [];
							for(var i in myDSContent){
								arrContactId.push(myDSContent.contactId);
							}
							ICTouchAPI.APIServices.InstantMessaging.getPresenceForContacts({
								params:[arrContactId],
								context:this,
								callback:this.setPresenceList
							});
						}
					}
					this.imEnabled = event.value;
					dojo.publish("IM_AVAILABILITY_CHANGED", [this.imEnabled]);
				}
			}
		},

		/**
		 * @private
		 */
		setPresenceList : function(presenceList) {
			if(presenceList && presenceList.length){
				var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
				for (var i = 0; i < presenceList.length; i++) {
					if(presenceList[i].contactId){
						var presence = {
							IMPresence : '',
							telephonyPresence : ''
						};
						if(this.boolIMAvailble){
							presence.IMPresence = presenceList[i].imPresenceValue.value.labelStatus;
						}
						if(this.boolTelephonyPresenceAvailable){
							presence.telephonyPresence = presenceList[i].telephonicPresenceValue.value.labelStatus;
						}
						if(presence.IMPresence != '' || presence.telephonyPresence != ''){
							myDS.editAt(presenceList[i].contactId, presence);
						}
					}
				}
			}
		},

		/**
		 * @private
		 */
		onPresenceChanged : function(presenceList) {
			if(presenceList && presenceList.value && presenceList.value.length){
				this.setPresenceList(presenceList.value);
			}
		},

		/**
		 ** @private
		 **/
		onIMAvailable : function(objSetting){
			if(objSetting){
				this.boolIMAvailble = objSetting.jsValue;
		    }

			if (ICTouchAPI.remoteDisplay) {
				this.initPresenceInDataStore({
					value:this.boolIMAvailble || this.boolTelephonyPresenceAvailable
				});
			}
		},

                /**
                 * @private
                 */
		onTelephonyPresence : function(objSetting){
			if(objSetting){
				this.boolTelephonyPresenceAvailable = objSetting.jsValue;
				dojo.publish("TELEPHONY_PRESENCE_AVAILABILITY_CHANGED", [this.boolTelephonyPresenceAvailable]);
			}

			if (ICTouchAPI.remoteDisplay) {
				this.initPresenceInDataStore({
					value:this.boolIMAvailble || this.boolTelephonyPresenceAvailable
				});
			}
		},

		/**
		 * @private
		 */
		onBuddyDeleted : function(arrContactId){
			var contactId;
			var arrContact;
			var presence = {
				IMPresence : '',
				telephonyPresence: ''
			};
			var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
			while(arrContactId.value.length > 0){
				contactId = arrContactId.value.pop();
				arrContact = myDS.find(["contactId"], contactId);

				if(this.isImAvailable() && arrContact[0]){
				myDS.editAt(arrContact[0].contactId, presence);
				}
		    }
		}

	});

// Create presence services
ICTouchAPI.presenceServices=new ICTouchAPI.presenceServices();



