/**
* @class ICTouchAPI.webApplicationManager
* @singleton
* @ignore
* @extends Object
*/
dojo.provide("ICTouchAPI.navigationServices");
dojo.declare("ICTouchAPI.navigationServices",
	null,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		focusedView: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor: function() {
			// If it's not 8052 don't start services
			if( generalConfig.version != "8052" )
				return;
			ICTouchAPI.eventServices.subscribeToEvent(this, "SENSEKEY_UP", this.eventUp);
			ICTouchAPI.eventServices.subscribeToEvent(this, "SENSEKEY_DOWN", this.eventDown);
			ICTouchAPI.eventServices.subscribeToEvent(this, "SENSEKEY_LEFT", this.eventLeft);
			ICTouchAPI.eventServices.subscribeToEvent(this, "SENSEKEY_RIGHT", this.eventRight);
			ICTouchAPI.eventServices.subscribeToEvent(this, "SENSEKEY_OK", this.eventOk);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		getApplicationName: function()
		{
			return "navigationServices";
		},

		getCurrentFocus: function()
		{
			return this.focusedView;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		changeFocus: function(view)
		{
			this.focusedView = view;
		},

		navigate: function(eventName)
		{
			if( this.focusedView && this.focusedView.navigate )
				this.focusedView.navigate(eventName);
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		eventUp:	function() {
			this.navigate("UP");
		},
		/**
		 * @ignore
		 */
		eventDown:	function() {
			this.navigate("DOWN");
		},
		/**
		 * @ignore
		 */
		eventLeft:	function() {
			this.navigate("LEFT");
		},
		/**
		 * @ignore
		 */
		eventRight:	function() {
			this.navigate("RIGHT");
		},
		/**
		 * @ignore
		 */
		eventOk:	function() {
			this.navigate("OK");
		},
	});

// Create navigation services
ICTouchAPI.navigationServices=new ICTouchAPI.navigationServices();
