/**
* @class ICTouchAPI.mode
* @namespace ICTouchAPI
* @extends Object
* @ignore
* mode holds the instruction to be runned when it is selected as the current mode of a led
*/
dojo.provide("ICTouchAPI.mode");

dojo.declare("ICTouchAPI.mode",null,
{
	/* --------------------------------- Public attributes ------------------------------------ */

	/* --------------------------------- Private attributes ----------------------------------- */

	/* ------------------------------------ Constructor --------------------------------------- */

	/**
	 * constructor
	 */
	constructor : function(name,ledId,priority,runFunction){
		this.strName = name;
		this.intLedId = ledId;
		this.intPriority = priority;
		this.run = dojo.hitch(this,runFunction);

		this.boolSate = false;
	},

	/**
	 * destroy
	 */
	destroy : function(){
		delete this.run;
	},

	/* ----------------------------------- Getter / Setter------------------------------------- */

	/**
	 * Return the state of the mode
	 * @return {boolean} the state
	 */
	getState : function(){
		return this.boolSate;
	},

	/**
	 * Return the priority of the mode
	 * @return {Numeric} the priority
	 */
	getPriority : function(){
		return this.intPriority;
	},

	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * activate the mode
	 */
	activate : function(){
		this.boolSate = true;
	},

	/**
	 * desactivate the mode
	 */
	desactivate : function(){
		this.boolSate = false;
	}

/* --------------------------------- Private Methods -------------------------------------- */

});

	/**
	 *global dictionnary of leds colors names. Used to translate colors names to number
	 * @property
	 * @type {Object} 
	 */
ICTouchAPI.mode.prototype.arrColors = {
	'std':0,
	'blue':1,
	'red':2,
	'purple':3,
	'green':4,
	'cyan':5,
	'yellow':6,
	'white':7
};
	/**
	 * global mode value reference
	 * @cfg {Numeric} intOFF numerical value to be sent to the core system for OFF mode
	 */
ICTouchAPI.mode.prototype.intOFF = 0;
	/**
	 * global mode value reference
	 * @cfg {Numeric} intON numerical value to be sent to the core system for ON mode
	 */
ICTouchAPI.mode.prototype.intON = 1;
	/**
	 * global mode value reference
	 * @cfg {Numeric} intBLINK numerical value to be sent to the core system for BLINK mode
	 */
ICTouchAPI.mode.prototype.intBLINK = 100;