/**
* @class ICTouchAPI.led
* @extends Object
* @ignore
* class led used to manage a led modes and priorities
*/
dojo.require("ICTouchAPI.mode");
dojo.provide("ICTouchAPI.led");

dojo.declare("ICTouchAPI.led",null,
{
	/* --------------------------------- Public attributes ------------------------------------ */

	/* --------------------------------- Private attributes ----------------------------------- */

	/* ------------------------------------ Constructor --------------------------------------- */

	constructor : function(name,computeModeFunction) {
		//name of the button : home; mute, ...
		this.intName = name;
		this.arrModes = {};

		/*this._createModeON();
		this._createModeOFF();
		this._createModeBLINK();*/
        this.createMode(ICTouchAPI.mode.prototype.intOFF,
        ICTouchAPI.mode.prototype.arrColors['std'], 'OFF', 0);
        this.createMode(ICTouchAPI.mode.prototype.intON,
        ICTouchAPI.mode.prototype.arrColors['std'], 'ON', 10);
        this.createMode(ICTouchAPI.mode.prototype.intBLINK,
        ICTouchAPI.mode.prototype.arrColors['std'], 'BLINK', 20);


		this.currentMode = null;

		if(computeModeFunction && typeof(computeModeFunction) == "function"){
			//this.computeMode = dojo.hitch(this,computeModeFunction);
		}

		this.activateMode('OFF');

	},

	/**
	 *Method called when the LED has to be destroyed
	 */
	destroy : function(){
		//for each registred mode
		for(var _mode in this.arrModes){
			this.arrModes[_mode].destroy();

		}

	},

	/* ----------------------------------- Getter / Setter------------------------------------- */

	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * add a mode to the led instance
	 * @param {string} strModeName name of the mode to be loaded
	 * @param {mode} mode the mode object
	 */
	addMode : function(strModeName,mode){
		this.arrModes[strModeName] = mode;
	},

	/**
	 *	try to activate a mode on the led
	 *	@param {string} strModeName name of the mode to be activated
	 */
	activateMode : function(strModeName){
		this.arrModes[strModeName].activate();
		if(!this.currentMode || this.arrModes[strModeName].getPriority() > this.currentMode.getPriority()){
			this.currentMode = this.arrModes[strModeName];
			this.currentMode.run();
		}
	},

	/**
	 * try to desactivate a mode on the led
	 * @param {string} strModeName name of the mode to be desactivated
	 */
	desactivateMode : function(strModeName){
		if(strModeName != 'OFF'){
			this.arrModes[strModeName].desactivate();
			if(this.arrModes[strModeName] == this.currentMode){
				this.computeMode();
			}
		}
	},

	/* --------------------------------- Private Methods -------------------------------------- */

	/**
	 * @private
	 */
	computeMode : function(){
		//if the current mode has been desactivated
		if(!this.currentMode || !this.currentMode.getState()){
			//set the current to OFF by default
			this.currentMode = this.arrModes['OFF'];
		}

		//for each registred mode
		var mode = null;
		for(var _mode in this.arrModes){
			mode = this.arrModes[_mode];
			//which is activated
			if(mode.getState()){
				//if it has priority on the crurrent mode
				if(mode.getPriority() > this.currentMode.getPriority()){
					//set the current mode up to it
					this.currentMode = mode;
				}else{
			//keep the current mode
			}
			}
		}
          //run the new current mode and ..
		//if it returns false, the mode has desactivated it itslef
		if(this.currentMode && !this.currentMode.run()){
			//if the mode return false then the new current mode has to be computed once again
			this.computeMode();
		}

	},

	/**
	 * @private
	 */
    createMode : function(callInteger,colorInteger,modeName,modePriority){
                callInteger = (callInteger ? callInteger : 0);
                colorInteger = (colorInteger ? colorInteger : 0);
                modeName = (modeName ? modeName : 'customMode');
                modePriority = (modePriority ? modePriority : 0);

                var runFunc = function(){
                        //runned in mode

                    // Don't call platform in simulation mode
                    if(!generalConfig.simulation) {
                        ICTouchAPI.APIServices.Platform.setLedStatus({
                                params: [
                                        this.intLedId, //known within the running context : MODE
                                        callInteger,
                                        colorInteger,
                                        0, //unused but has to be sent
                                        0  //unused but has to be sent
                                ]
                        });
                    }
                    return true;
                }
                //led mode
                this.arrModes[modeName] = new ICTouchAPI.mode(modeName,this.intName,modePriority,runFunc);

    }

			});

	/**
	 * global dictionnary of leds names. Used to translate names to number.
	 * @property
	 * @type {Object}
	 */
ICTouchAPI.led.prototype.arrLedsNames =  {
	'mute' : 0,
	'volumeDown' : 1,
	'volumeUp' : 2,
	'handsFree' : 3,
	'userInfo' : 4,
	'communication' : 5,
	'dialer' : 6,
	'event' : 7,
	'home' : 8,
	'ringing' : 9
};