/**
* @class ICTouchAPI.hotelServices
* @extends Object
* @singleton
* Retrieves every user information from OXE in hotel mode, and provide a getter for these info.
 * <br />
* The service publishes the following events (using dojo.publish):<br />
*	- <b>GuestCheckIn:</b> published when the checkin state changes. Provide a boolean indicating if the state is checkin or not.<br />
*	- <b>GuestInfo:</b> published when new guest informations are received. Provide an object containing the fields guestName, guestNumber and setNumber.<br />
*/
dojo.provide("ICTouchAPI.hotelServices");
dojo.declare("ICTouchAPI.hotelServices", null , {

/* --------------------------------- Public attributes ------------------------------------ */

/* --------------------------------- Private attributes ----------------------------------- */

	// Defines
	/**
	 * @ignore
	 */
	boolCheckIn					: null,

	/**
	 * @ignore
	 */
	guestName					: "",

	/**
	 * Also called GPIN
	 * @ignore
	 */
	guestNumber					: "",

	/**
	 * @ignore
	 */
	setNumber					: "",

       
/* ------------------------------------ Constructor --------------------------------------- */

	/**
	 * @ignore
	 */
	constructor : function () {
		ICTouchAPI.eventServices.subscribeToEvent(this, "GuestInfo", this.notifyGuestInfo);
		ICTouchAPI.eventServices.subscribeToEvent(this, "GuestCheckIn", this.notifyGuestCheckIn);
	},

/* ----------------------------------- Getter / Setter------------------------------------- */


/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * Return all the information provided by OXE in Hotel mode.
	 * @return {Object} An object containing a the CheckIn state, a guest name, a guest number and a set number.
	 */
	getHotelInfo : function() {
		return {
			boolCheckIn : this.boolCheckIn,
			guestName : this.guestName,
			guestNumber : this.guestNumber, // GPIN
			setNumber : this.setNumber
		};
	},

/* --------------------------------- Private Methods -------------------------------------- */

	/**
	 * @ignore
	 * Because the eventServices wants an application name we provide one.
	 * @return {String} Return hotelServices
	 */
	getApplicationName: function(){
		return "hotelServices";
	},
	
	/**
	 * @ignore
	 */
	notifyGuestCheckIn : function(objEvent) {
		if(objEvent){
			var boolCheckInState = (objEvent.value) ? true : false;
			this.boolCheckIn = boolCheckInState;
			dojo.publish("GuestCheckIn", [boolCheckInState]);
		}
		objEvent = null;
	},

	/**
	 * @ignore
	 */
	notifyGuestInfo : function() {
		var objEventArguments = ICTouchAPI.tools.getEventArguments(arguments);

		// Update class attributes
		this.guestName = objEventArguments.guestName || "";
		this.guestNumber = objEventArguments.guestNumber || "";
		this.setNumber = objEventArguments.setNumber || "";

		var objInfo = {
			guestName : this.guestName,
			guestNumber : this.guestNumber,
			setNumber : this.setNumber
		}

		dojo.publish("GuestInfo", [objInfo]);
	},

	/**
	 * @ignore
	 */
	dump : function() {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("HotelServices data:");
		ICTouchAPI.debugServices.dump(" - boolCheckIn: " + this.boolCheckIn);
		ICTouchAPI.debugServices.dump(" - guestName: " + this.guestName);
		ICTouchAPI.debugServices.dump(" - guestNumber: " + this.guestNumber);
		ICTouchAPI.debugServices.dump(" - setNumber: " + this.setNumber);
	}
});

ICTouchAPI.hotelServices = new ICTouchAPI.hotelServices();
