/*
 * @class ICTouchAPI
 * @ignore
 * ICTouchAPI is the framework's root. It fires all the required initializations
 * and then builds the screen.
 */
ICTouchAPI = {
	_arrOnInitCallback :[],
	_initEnded : false,
	_hErrorAlert: null,
	_hWarnAlert: null,
	//_hErrorDebug: null,
	//_hWarnDebug: null,

	initFramework : function() {
		this.initPaths();
		this.initAlerts(generalConfig.alertLevel);
		this.initUIEffects();
		this.initAPIs();
		this.initServices();
		this.initDebug();

		//the following code needs to be synchronized with the skin initialization. The previous
		//solution was to use a synchronized xhr query. Our new solution (nov 2010) has been to add a parameter to the API in order to synchronize or not
		//the query
		//Load the main css file
		//ICTouchAPI.skinServices.loadCssSkinFile("ICTouchAPI", "main.css", true);

		ICTouchAPI.initUIElements();
		var header = dojo.query("head")[0];		
		ICTouchAPI.skinServices.registerHeader(header, "WindowFrame", "webapp",window.document);

		webapp = {};
		awap = {};

                // Do not initialize webapps on simulation
                if(!generalConfig.simulation) {
                    ICTouchAPI.getInitializationScreen();
                }
		ICTouchAPI.log("Finished loading framework", "INIT");
	},

	getInitializationScreen : function(){
		ICTouchAPI.webApplicationManager.loadWebapp("settings");
		ICTouchAPI.webApplicationManager.loadWebapp("initialization");
		ICTouchAPI.transitionServices.getScreen({
			name:"webapp.initialization.initializationWidget",
			params: {},
			position: "FullScreen"
		});
		// If remote-display is activated, we have to manually send the end_of_init_IctDirectory event to initialize the DataStore.
		if (ICTouchAPI.remoteDisplay){
                    ICTouchAPI.eventServices._corePublishEvent("end_of_init_IctDirectory");
                }
	},

	initFirstScreen : function(){
		this.initWebApplications(this.devContext.developer);
		this.initWidget();
		this._loadInitCallbacks();
	},

	initPaths: function () {
		if(!generalConfig.simulation) {
		dojo.registerModulePath("ICTouchAPI","library/ICTouchAPI");
		dojo.registerModulePath("webapp","webapp");
		dojo.registerModulePath("dijit","library/dijit");
		dojo.registerModulePath("dojox","library/dojox");
		dojo.registerModulePath("dojo","library/dojo");
		dojo.registerModulePath("UIElements","library/ICTouchAPI/UIElements");
		dojo.registerModulePath("UIEffects","library/ICTouchAPI/UIEffects");
		}
	},

	// Initiate debug mode with debugServices methods called on console.*** functions
	initDebug: function() {
		if(!ICTouchAPI.remoteDisplay){
			dojo.connect(console, "error", ICTouchAPI.debugServices, ICTouchAPI.debugServices.error);
			dojo.connect(console, "warn", ICTouchAPI.debugServices, ICTouchAPI.debugServices.warning);
			dojo.connect(console, "info", ICTouchAPI.debugServices, ICTouchAPI.debugServices.info);
			dojo.connect(console, "debug", ICTouchAPI.debugServices, ICTouchAPI.debugServices.debug);
		}
	},

	// Initiate alert mode, called on console.warn and console.error
	initAlerts: function (alertLevel) {
		if (alertLevel > 0) {
			this._hErrorAlert = dojo.connect(console, "error", this, this.onAlertError);
			if (alertLevel > 1) {
				this._hWarnAlert = dojo.connect(console, "warn", this, this.onAlertWarn);
			}
		}
	},

	// Stop alert mode
	stopAlerts: function(){
		if(this._hErrorAlert){
			dojo.disconnect(this._hErrorAlert);
			this._hErrorAlert = null;
		}
		if(this._hWarnAlert){
			dojo.disconnect(this._hErrorAlert);
			this._hWarnAlert = null;
		}
	},

	onAlertError: function (str) {
		alert("Error: " + dojo.toJson(str));
	},

	onAlertWarn: function (str) {
		alert("Warn: " + dojo.toJson(str));
	},

	initAPIs : function(){
		var bDevMode = generalConfig.developer;
		if (bDevMode) {
			dojo.require("ICTouchAPI.APIServices.requireList", true);
			dojo.forEach(ICTouchAPI.APIServices.requireList,
				function (service) {
					dojo.require(service);
				}
				);
		} else {
			dojo.require("ICTouchAPI.APIServices.APIServices_mini", true);
		}
	},

	initServices: function () {
		var bDevMode = generalConfig.developer;
		if (bDevMode) {
			dojo.require("ICTouchAPI.requireList", true);
			dojo.forEach(ICTouchAPI.requireList,
				function (service) {
					dojo.require(service);
				}
				);
		} else {
			dojo.require("ICTouchAPI.services_mini", true);
		}

	},

	initUIEffects : function () {
		var bDevMode = generalConfig.developer;
		if (bDevMode) {
			dojo.require("UIEffects.requireList", true);
			dojo.forEach(UIEffects.requireList,
				function (UIEffect) {
					dojo.require("UIEffects."+UIEffect+".requireList", true);
					dojo.forEach(UIEffects[UIEffect]["requireList"],
						function (file) {
							dojo.require("UIEffects."+UIEffect+"."+file, true);
						}
						);
				}
				);
		} else {
			dojo.require("UIEffects.UIEffects_mini", true);
		}
	},

	initUIElements: function () {
		var bDevMode = generalConfig.developer;
		if (bDevMode) {
			dojo.require("UIElements.requireList"+generalConfig.version, true);
			dojo.require("UIElements._base");
			dojo.forEach(UIElements.requireList,
				function (UIElement) {
					dojo.require("UIElements."+UIElement+".requireList", true);
					dojo.forEach(UIElements[UIElement]["requireList"],
						function (file) {
							var UIModulePath = "UIElements."+UIElement;
							var fileVersion = file+generalConfig.version;
							dojo.require(UIModulePath+"."+fileVersion, true);
							//Load related css file(s)
							/*if(generalConfig.cssDeveloper){
								var cssFile = UIElements[UIElement][file].prototype.cssFile;
								if(cssFile){
									if(typeof cssFile === "object"){
										dojo.forEach(cssFile,function(css){
											ICTouchAPI.skinServices.loadCssSkinFile(UIModulePath, css, true);
										});
									}
									else{
										ICTouchAPI.skinServices.loadCssSkinFile(UIModulePath, cssFile, true);
									}
								}
							}*/
						}
						);
				}
				);
			/*if(!generalConfig.cssDeveloper){
				ICTouchAPI.skinServices.loadCssSkinFile("UIElements", generalConfig.version, true);
			}*/
		} else {
			dojo.require("UIElements.UIElements_mini_"+generalConfig.version, true);
			//ICTouchAPI.skinServices.loadCssSkinFile("UIElements", generalConfig.version, true);
		}
	},

	initWebApplications: function () {
		ICTouchAPI.webApplicationManager.loadInitFiles();
	},

	initWidget:function(){
		if (generalConfig.version == "8082"){
			var defaultWebapp = {
				name: "webapp.homepage.getHomepage",
				params: {},
				position: "Middle"
			};
			var screenDescription = [
			{
				name:"webapp.userinfo.getUserInfo",
				params:{},
				position:"TopBarLeft"
			}
			,{
				name:"webapp.notifications.getNotifications",
				params:{},
				position:"TopBarMiddle"
			}
			,{
				name:"webapp.connectivity.getConnectivity",
				params :{},
				position:"TopBarRight"
			}
			];
			ICTouchAPI.transitionServices.initialize(screenDescription);
			if(webapp.lock && webapp.lock.isLocked()){
				webapp.lock.lockPhone();
			} else {
				ICTouchAPI.transitionServices.getDefaultScreen();
			}
			ICTouchAPI.webApplicationManager.unloadApplication("initialization");
		}else if  (generalConfig.version == "8052"){
			ICTouchAPI.transitionServices.initialize({
				globalContainer :
				{
					name : "UIElements.GlobalContainer.GlobalContainerControl",
					params :
					{
						objTop :
						{
							name : "UIElements.InfoBar.InfoBarControl",
							params : {
								arrItems: ["webapp.userinfo.getUserInfo", "webapp.connectivity.getConnectivity"]
							}
						},
						objSideZone : {
							name    : "UIElements.SideBar.SideBarControl",
							params  : {
								arrSideKeys: webapp.webappTest.data.getSideKeys()
							}
						}
					},
					screenContainer : "domContent"
				},
				firstScreen :
				{
					name : "webapp.homepage.getHomepage",
					params : {}
				}
			});
		}
		ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
			params:["presentationLoaded"]
		});
	},

	main: function (){
		// Define an empty function when console.groupCollasped doesn't exist
		if(typeof console.groupCollapsed == "undefined"){
			console.groupCollapsed = function(){};
		}
		ICTouchAPI.devContext=generalConfig;
		ICTouchAPI.remoteDisplay = /remote-display/.exec(location.search);
		// Set Gate URI according to client's IP address
		ICTouchAPI.getICTGateURI=function (port) {
			// If in file protocol, localhost is used for files and xhr requests.
			if (location.protocol === "file:") {
				resultURI = "http://127.0.0.1:" +  port + "/";
			} else {
				// Else, recomposes the URL from whom is calling the application
				// Could be either localhost or distant host.
				var splittedString = location.href.split("/");
				var resultURI = "";
				for(var i=0;i<3;i++) {
					resultURI=resultURI+splittedString[i]+"/";
				}
				resultURI += splittedString[3];
				resultURI += ":"+port +"/";
			}
			return resultURI;
		}
		ICTouchAPI.applicationsCallURI = ICTouchAPI.getICTGateURI(ICTouchAPI.devContext.applicationsCallPort);
		ICTouchAPI.eventChannelURI = ICTouchAPI.getICTGateURI(ICTouchAPI.devContext.eventChannelPort);
		// If in remote display mode, one need to kill webclient first to avoid requests concurrency.
		if (ICTouchAPI.remoteDisplay && !generalConfig.simulation) {
			// Calls an application method to kill the ICTWebClient to switch
			// to the remote display mode.
			dojo.xhrGet({
				url: ICTouchAPI.applicationsCallURI  + "/services/ICTGate/stopLocalSession",
				load: function(){
					console.log("Local session stopped.");
				},
				sync: true,
				error: function(){
					document.body.innerHTML = "Unable to stop local session.";
				}
			});
		}

                if(!generalConfig.simulation) {
                    // Language setting requested
                    dojo.xhrGet({
                            url: ICTouchAPI.applicationsCallURI  + "/services/SettingsManager/getSetting?json0=%7B%22type%22%3A%22QString%22%2C%22value%22%3A%22Language%22%7D",
                            sync: true,
                            handleAs: 'json',
                            load: function(response, ioArgs){
                                    var setting = response.value ;
                                    if (typeof setting.allowedValues[setting.value].name != "undefined") {
                                            dojo.locale = setting.allowedValues[setting.value].name;
                                    }
                            },
                            error: function(error){
                                    console.error(error);
                                    dojo.locale = 'en';
                            }
                    });
                }
                else {
                    dojo.locale = 'en';
                }

		this.startTime = new Date().getTime();
		this.output = "";
		this.durations = {};
		this.durations["dev"] = this.devContext.developer;
		this.nbStep = 0;
		/*console.log(this.devContext.developer ? "developer mode - all files are loaded separately"
			: "production mode - make sure you have launched the build file first");*/
		ICTouchAPI.initFramework();
	},

	/**
	 * Declare a function that will be loaded at the end of the webapplications initialization step
	 * @ignore
	 * @param {Function} callback function to execute
	 * @param {Object} context context for the function execution
	 */
	addOnInit : function(context, callback){
		if(context!=null){
			callback = dojo.hitch(context,callback);
		}
		if(this._initEnded == false){
			this._arrOnInitCallback.push(callback);
		}else{
			callback();
		}
	},

	_loadInitCallbacks : function(){
		while(typeof this._arrOnInitCallback[0] === "function"){
			this._arrOnInitCallback[0]();
			this._arrOnInitCallback.shift();
		}
		this._initEnded=true;
	},

	log : function(strMessage, strModule){
		if (generalConfig.logModules[strModule] === true){
		}
	},

	logObject : function(obj, strModule){
		/*if (generalConfig.logModules[strModule] === true) {
			console.log(strModule + ": ");
			console.log(obj);
		}*/
	}
}
dojo.addOnLoad(function () {
	ICTouchAPI.main(ICTouchAPI.devContext);
})
