/**
* @class ICTouchAPI.HttpServices
* @singleton
* @extends Object
* Manage an HTTP Connection to a remote server
*/
dojo.provide("ICTouchAPI.HttpServices");
window.ICTouchAPI.HttpServices = {

	/**
	 * Get an HTTP Ressource
	 * @param {Object} args : : JavaScript object of name/string value pairs :<pre><code>
	 * - method : Method to pass parameters to remote ressource. Method is "get" or "post" or "put" or "head"
 	 * - url : url of ressource
	 * - putData : data send for xhrPut request
	 * - postData : data send for xhrPost request
	 * - responseType : Type of server response. Type is "text" or "xml"
	 * - content : contains properties with strinf values. These properties will be serialized as nameX=valueX and passed to the request<br>
	 * - context : The given context
	 * - header : A JavaScript object of name/string value pairs. These values are sending to HTTP Headers(Example: Content-Type, X-Method-Override, or Content-Encoding)<br>
	 * - timeout : Milliseconds to wait for the response. If this time passes, the error callback is called<br>
	 * - callback : This function is called on response received
	 * - callbackParams : parameters given to the callback whic can be reused in the callback function
	 * - callbackError : This function is called on timeout</code></pre>
	 */
	httpRequest: function(args) {

		var url = args.url;
		//Add "http://" at begin if not present
		if (url.search("^http://")==-1 && url.search("^https://")==-1) {
			url = "http://"+url;
		}
		//Rewrite URL to use internal proxy
		if (url.search("^http://")!=-1) {
			url = url.replace(new RegExp("^http://"), "http://"+location.hostname+"/ext/");
		}
		else if (url.search("^https://")!=-1) {
			url = url.replace(new RegExp("^https://"), "http://"+location.hostname+"/exts/");
		}

		ICTouchAPI.debugServices.debug("ICTouchAPI.HttpServices - httpRequest / HTTPServices::httpRequest() to:" + url);

		var xhrArgs	= {
			url: url,
			timeout: args.timeout || 20000,
			handleAs: args.responseType || "text",
			content : args.content,
			callbackParams : args.callbackParams,
			// call the defined callback function on result received
			load: function () {
				return args.callback && args.callback.apply(args.context, arguments);
			},
			// call the defined callbackError function on timeout
			error: function () {
				return args.callbackError && args.callbackError.apply(args.context, arguments);
			}
		};

		if (args.headers) {
			xhrArgs.headers = args.headers;
		}

		if (args.method == "get") {
			return dojo.xhrGet(xhrArgs);
		} else if (args.method == "post") {
			if (args.postData) {
				xhrArgs.postData = args.postData;
			}
			return dojo.xhrPost(xhrArgs);
		} else if (args.method == "put") {
			if (args.putData) {
				xhrArgs.putData = args.putData;
			}
			return dojo.xhrPut(xhrArgs);
		} else if(args.method == "head"){
			return dojo.xhr("HEAD",xhrArgs);
		} else {
			return false;
		}
	}
};
