/**
* @class ICTouchAPI.WSManager
* @singleton
* @extends Object
* @ignore
*/
dojo.provide("ICTouchAPI.APIServices.WSManager");
dojo.declare("ICTouchAPI.APIServices.WSManager",[ICTouchAPI.APIServices.APIServicesBase],
{
    /**
     * submitUserPassword
     * @param [array] args containing the following parameters:
     *  	string password corresponding to the password
     *		boolean canceled indicating if the user pressed on Ok (false) of on exit (true)
     * @ignore
     */
    submitUserPassword : function(args) {
		args.params[0]	= Encryption.encryptRSA(args.params[0]);
		
        this.callCoreApplicationMethod({
            domainName : "WSManager",
            methodName : "submitUserPassword",
            context : args.context,
            params: args.params,
            paramType: ["QString", "bool"],
            callback : args.callback,
			callbackParams : args.callbackParams
        });
        args = null;
    },

    /**
     * changePassword
     * @param args containing the following parameter:
     *  	string oldPassword corresponding to the new password
     *  	string newPassword corresponding to the new password
     *  @ignore
     */
    changePassword : function(args) {
		args.params[0]	= Encryption.encryptRSA(args.params[0]);
		args.params[1]	= Encryption.encryptRSA(args.params[1]);
		
        this.callCoreApplicationMethod({
            domainName : "WSManager",
            methodName : "changePassword",
            context : args.context,
            params: args.params,
            paramType: ["QString","QString"],
            callback : args.callback,
			callbackParams : args.callbackParams
        });
        args = null;
    },

    /**
     * reconnectAfterPwdChanged
     * @param args containing the following parameter:
     *  	string password corresponding to the new password
     * @ignore
     */
    reconnectAfterPwdChanged : function(args) {
		args.params[0]	= Encryption.encryptRSA(args.params[0]);

        this.callCoreApplicationMethod({
            domainName : "WSManager",
            methodName : "reconnectAfterPwdChanged",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
			callbackParams : args.callbackParams
        });
        args = null;
    },

	getCapabilityGlobal : function(args) {
		this.callCoreApplicationMethod({
			domainName: "WSManager",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	getCapabilityInstance : function(args) {
		this.callCoreApplicationMethod({
			domainName: "WSManager",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["int", "QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	}
 });

ICTouchAPI.APIServices.WSManager = new ICTouchAPI.APIServices.WSManager();