/**
 * @ignore
 */
dojo.provide("ICTouchAPI.APIServices.SettingsManager");
dojo.declare("ICTouchAPI.APIServices.SettingsManager",[ICTouchAPI.APIServices.APIServicesBase],
{
    getMainCategories : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getMainCategories",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            errorCallback : args.errorCallback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    getCategories : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getCategories",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString"],
            callback : args.callback,
            errorCallback : args.errorCallback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    getSettings : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getSettings",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString", "QString"],
            callback : args.callback,
            errorCallback : args.errorCallback,
            callbackParams: args.callbackParams
        });
        args = null;
    },


	getMainCategoriesWithCheck : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getMainCategoriesWithCheck",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            errorCallback : args.errorCallback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    getCategoriesWithCheck : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getCategoriesWithCheck",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString"],
            callback : args.callback,
            errorCallback : args.errorCallback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    getSetting : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getSetting",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams,
			sync : (args.sync ? args.sync : false)
        });
        args = null;
    },

    getSettingValue : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "getSettingValue",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams,
			sync : (args.sync ? args.sync : false)
        });
        args = null;
    },

    setSetting : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "setSetting",
            context : args.context,
            params: args.params,
            paramType: ["Setting"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    setSettingValue : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "setSettingValue",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    //called to check weither we upgrade some settings before to enter in the webapp setting
    //the platform lock the webapp acces
    enterMMI : function(args) {
        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "enterMMI",
            context : args.context,
            callback : args.callback
        });
        args = null;
    },

    //send an event expected by the settingManager to leave the webapp
    exitMMI : function() {
        ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
            params:["exitMMI"]
        });
    },

	needReboot : function(args) {

        this.callCoreApplicationMethod({
            domainName : "SettingsManager",
            methodName : "needReboot",
            context : args.context,
            callback : args.callback
        });
        args = null;
    }
});

ICTouchAPI.APIServices.SettingsManager = new ICTouchAPI.APIServices.SettingsManager();
