/**
 * @class ICTouchAPI.APIServices.ProgrammableKeys
 * @singleton
 * @extends ICTouchAPI.APIServices.APIServicesBase
 * IctProgrammableKeys module manages the keys of the Programmable Keys application.<br>
 * A key comes along with an action to do. This module also manages actions.<br>
 * The keys and actions are saved in a persistent database.
 */
 
 
dojo.provide("ICTouchAPI.APIServices.ProgrammableKeys");
dojo.declare("ICTouchAPI.APIServices.ProgrammableKeys",[ICTouchAPI.APIServices.APIServicesBase],
{
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>all keys</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * 
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with the list of keys,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idKey {Number} The key object identifier
     * &nbsp;&nbsp;_idDM {String} Ignored
     * &nbsp;&nbsp;_idAction {Number} The action object identifier
     * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
     * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
     * &nbsp;&nbsp;_icon {String} The file relative name of the icon
     * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1 
     * &nbsp;&nbsp;_aom_type {Number} type
     * &nbsp;&nbsp;_aom_addr {Number} address
     * }
     * </pre>
     */	
    getAllProgrammableKeys : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "getAllProgrammableKeys",
            context: args.context,
            params: args.params,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },
    
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>all keys</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve all keys that fit a given container</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the container
     * <pre>
     * {String} the container
     * </pre>
     *
     * The callback will be called with the list of keys,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idKey {Number} The key object identifier
     * &nbsp;&nbsp;_idDM {String} Ignored
     * &nbsp;&nbsp;_idAction {Number} The action object identifier
     * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
     * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
     * &nbsp;&nbsp;_icon {String} The file relative name of the icon
     * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1
     * &nbsp;&nbsp;_aom_type {Number} type
     * &nbsp;&nbsp;_aom_addr {Number} address
     * }
     * </pre>
     */	
	getProgrammableKeysByContainer : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "getProgrammableKeysByContainer",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>key identifier</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Create a key</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the keys of the Programmable Key application,it has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;_idKey {Number} The key object identifier
     * &nbsp;&nbsp;_idDM {String} Ignored
     * &nbsp;&nbsp;_idAction {Number} The action object identifier
     * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
     * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
     * &nbsp;&nbsp;_icon {String} The file relative name of the icon
     * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1
     * &nbsp;&nbsp;_aom_type {Number} type
     * &nbsp;&nbsp;_aom_addr {Number} address
     * }
     * </pre>
     *
     * The callback will be called with the key identifier,possible values are :
     * <pre>
     * - -2 : Error
     * - -1 : The data base is full
     * -  n  : The key identifier
     * </pre>
     */	
	
	createProgrammableKey : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "createProgrammableKey",
            context: args.context,
            params: args.params,
            paramType: ["Key"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Delete a key</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the key id
     * <pre>
     * {Number} the key id
     * </pre>
     *
     * The callback will be called with status,possible values are :
     * <pre>
     *  - -2 : Error
     *  -  0 : Success
     * </pre>
     */	
	deleteProgrammableKey : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "deleteProgrammableKey",
            context: args.context,
            params: args.params,
            paramType: ["qlonglong"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>key</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve a key</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the key id
     * <pre>
     * {Number} the key id
     * </pre>
     *
     * The callback will be called with the list of keys
     * -A list of one key in case of success
     * -A list of null length if the key has not been found
     * each of keys following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idKey {Number} The key object identifier
     * &nbsp;&nbsp;_idDM {String} Ignored
     * &nbsp;&nbsp;_idAction {Number} The action object identifier
     * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
     * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
     * &nbsp;&nbsp;_icon {String} The file relative name of the icon
     * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1
     * &nbsp;&nbsp;_aom_type {Number} type
     * &nbsp;&nbsp;_aom_addr {Number} address
     * }
     * </pre>
     */		
	
	getProgrammableKey : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "getProgrammableKey",
            context: args.context,
            params: args.params,
            paramType: ["qlonglong"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Change a key</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the keys of the Programmable Key application,it has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;_idKey {Number} The key object identifier
     * &nbsp;&nbsp;_idDM {String} Ignored
     * &nbsp;&nbsp;_idAction {Number} The action object identifier
     * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
     * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
     * &nbsp;&nbsp;_icon {String} The file relative name of the icon
     * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1
     * &nbsp;&nbsp;_aom_type {Number} type
     * &nbsp;&nbsp;_aom_addr {Number} address
     * }
     * </pre>
     *
     * The callback will be called with status,possible values are :
     * <pre>
     *  - -2 : Error
     *  -  0 : Success
     * </pre>
     */	
	modifyProgrammableKey : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "modifyProgrammableKey",
            context: args.context,
            params: args.params,
            paramType: ["Key"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>all the actions</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve all the actions</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with the list of actions,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _idAction {Number} The action object identifier
     * &nbsp;&nbsp; _idDM {String} Ignored
     * &nbsp;&nbsp; _type {Number} the action type,possible values are:
     * &nbsp;&nbsp;               - 0 for no type,
     * &nbsp;&nbsp;               - 1 for direct call,
     * &nbsp;&nbsp;               - 2 for shortcut access key,
     * &nbsp;&nbsp;               - 3 for shortcut action key,
     * &nbsp;&nbsp;               - 4 for flip flop
     * &nbsp;&nbsp; _action {String} The javascript function name
     * &nbsp;&nbsp; _webAppName {String} The webapp name which contains the function
     * &nbsp;&nbsp; _arguments {String} The arguments required by the function
     * &nbsp;&nbsp; _label {String} The string to display
     * &nbsp;&nbsp; _shortLabel {String} The string to display     
     * }
     * </pre>
     */	
	
	getAllActions : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "getAllActions",
            context: args.context,
            params: args.params,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>action identifier</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Create an action</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the action of the Programmable Key application ,it has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idAction {Number} The action object identifier
     * &nbsp;&nbsp; _idDM {String} Ignored
     * &nbsp;&nbsp; _type {Number} the action type,possible values are:
     * &nbsp;&nbsp;                - 0 for no type,
     * &nbsp;&nbsp;                - 1 for direct call,
     * &nbsp;&nbsp;                - 2 for shortcut access key,
     * &nbsp;&nbsp;                - 3 for shortcut action key,
     * &nbsp;&nbsp;                - 4 for flip flop
     * &nbsp;&nbsp; _action {String} The javascript function name
     * &nbsp;&nbsp; _webAppName {String} The webapp name which contains the function
     * &nbsp;&nbsp; _arguments {String} The arguments required by the function
     * &nbsp;&nbsp; _label {String} The string to display
     * &nbsp;&nbsp; _shortLabel {String} The string to display     
     * }
     * </pre>
     *
     * The callback will be called with the action identifier
     * <pre>
     * {Number} the action identifier
     * </pre>
     */
	addAction : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "addAction",
            context: args.context,
            params: args.params,
            paramType: ["Action"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Change an action</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the action of the Programmable Key application ,it has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idAction {Number} The action object identifier
     * &nbsp;&nbsp; _idDM {String} Ignored
     * &nbsp;&nbsp; _type {Number} the action type,possible values are:
     * &nbsp;&nbsp;                - 0 for no type,
     * &nbsp;&nbsp;                - 1 for direct call,
     * &nbsp;&nbsp;                - 2 for shortcut access key,
     * &nbsp;&nbsp;                - 3 for shortcut action key,
     * &nbsp;&nbsp;                - 4 for flip flop
     * &nbsp;&nbsp; _action {String} The javascript function name
     * &nbsp;&nbsp; _webAppName {String} The webapp name which contains the function
     * &nbsp;&nbsp; _arguments {String} The arguments required by the function
     * &nbsp;&nbsp; _label {String} The string to display
     * &nbsp;&nbsp; _shortLabel {String} The string to display     
     * }
     * </pre>
     *
     * The callback will be called with status,possible values are :
     * <pre>
     *  - -2 : Error
     *  -  0 : Success
     * </pre>
     */	
	modifyAction : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "modifyAction",
            context: args.context,
            params: args.params,
            paramType: ["Action"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
	   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Delete an action</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the action id
     * <pre>
     * {Number} the action id
     * </pre>
     *
     * The callback will be called with status,possible values are :
     * <pre>
     *  - -2 : Error
     *  -  0 : Success
     * </pre>
     */	
	deleteAction : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "deleteAction",
            context: args.context,
            params: args.params,
            paramType: ["qlonglong"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>action list</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve an action</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the action id
     * <pre>
     * {Number} the action id
     * </pre>
     *
     * The callback will be called with the list of actions
     * -A list of one action in case of success
     * -A list of null length if the action has not been found
     * each of actions following this structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idAction {Number} The action object identifier
     * &nbsp;&nbsp; _idDM {String} Ignored
     * &nbsp;&nbsp; _type {Number} the action type,possible values are:
     * &nbsp;&nbsp;                - 0 for no type,
     * &nbsp;&nbsp;                - 1 for direct call,
     * &nbsp;&nbsp;                - 2 for shortcut access key,
     * &nbsp;&nbsp;                - 3 for shortcut action key,
     * &nbsp;&nbsp;                - 4 for flip flop
     * &nbsp;&nbsp; _action {String} The javascript function name
     * &nbsp;&nbsp; _webAppName {String} The webapp name which contains the function
     * &nbsp;&nbsp; _arguments {String} The arguments required by the function
     * &nbsp;&nbsp; _label {String} The string to display
     * &nbsp;&nbsp; _shortLabel {String} The string to display     
     * }
     * </pre>
     */		
	getAction : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "getAction",
            context: args.context,
            params: args.params,
            paramType: ["qlonglong"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},
	
	   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Change the position of several keys</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the list of other attributes in a JSON structure (key-value)
     *
     * The callback will be called with status
     * <pre>
     * {Boolean} true when all changes success
     * </pre>
     */	
	changeProgrammableKeysPosition : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "changeProgrammableKeysPosition",
            context: args.context,
            params: args.params,
            paramType: ["QMap<int,int>"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>capability of the module</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the name of the capability
     * <pre>
     * {String} the name of the capability
     * </pre>
     *
     * The callback will be called with the capability, following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String} 
     * &nbsp;&nbsp;state {Number} 
     * }
     * </pre>
     */

	getCapability : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctProgrammableKeys",
            methodName: "getCapability",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	 }
	 
/**
 * @event KEY_CREATE_NTF
 * This event is used to notify that a key is created.
 * @param {Object} param contains the created key,following the structure:
 * <pre>
 * {
 * &nbsp;&nbsp;_idKey {Number} The key object identifier
 * &nbsp;&nbsp;_idDM {String} Ignored
 * &nbsp;&nbsp;_idAction {Number} The action object identifier
 * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
 * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
 * &nbsp;&nbsp;_icon {String} The file relative name of the icon
 * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1 
 * &nbsp;&nbsp;_aom_type {Number} type
 * &nbsp;&nbsp;_aom_addr {Number} address
 * }
 * </pre>
 */

/**
 * @event KEY_MODIFY_NTF
 * This event is used to notify that the key is changed.
 * @param {Object} param contains the changed key,following the structure:
 * <pre>
 * {
 * &nbsp;&nbsp;_idKey {Number} The key object identifier
 * &nbsp;&nbsp;_idDM {String} Ignored
 * &nbsp;&nbsp;_idAction {Number} The action object identifier
 * &nbsp;&nbsp;_container {String} An arbitrary string chosen by the application
 * &nbsp;&nbsp;_position {Number} The button order displayed on the screen
 * &nbsp;&nbsp;_icon {String} The file relative name of the icon
 * &nbsp;&nbsp;_type {Number} possible value is 0 or 1 or -1 
 * &nbsp;&nbsp;_aom_type {Number} type
 * &nbsp;&nbsp;_aom_addr {Number} address
 * }
 * </pre>
 */	 

/**
 * @event KEY_DELETE_NTF
 * This event is used to notify that the key is deleted.
 * @param {Number} param contains the deleted key identifier
 */	 
	 
/**
 * @event ACTION_CREATE_NTF
 * This event is used to notify that an action is created.
 * @param {Object} param contains the created action,following the structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _idAction {Number} The action object identifier
 * &nbsp;&nbsp; _idDM {String} Ignored
 * &nbsp;&nbsp; _type {Number} the action type,possible values are:
 * &nbsp;&nbsp;                - 0 for no type,
 * &nbsp;&nbsp;                - 1 for direct call,
 * &nbsp;&nbsp;                - 2 for shortcut access key,
 * &nbsp;&nbsp;                - 3 for shortcut action key,
 * &nbsp;&nbsp;                - 4 for flip flop
 * &nbsp;&nbsp; _action {String} The javascript function name
 * &nbsp;&nbsp; _webAppName {String} The webapp name which contains the function
 * &nbsp;&nbsp; _arguments {String} The arguments required by the function
 * &nbsp;&nbsp; _label {String} The string to display
 * &nbsp;&nbsp; _shortLabel {String} The string to display     
 * }
 * </pre>
 */	 
 
 /**
 * @event ACTION_MODIFY_NTF
 * This event is used to notify that an action is changed.
 * @param {Object} param contains the changed action,following the structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _idAction {Number} The action object identifier
 * &nbsp;&nbsp; _idDM {String} Ignored
 * &nbsp;&nbsp; _type {Number} the action type,possible values are:
 * &nbsp;&nbsp;                - 0 for no type,
 * &nbsp;&nbsp;                - 1 for direct call,
 * &nbsp;&nbsp;                - 2 for shortcut access key,
 * &nbsp;&nbsp;                - 3 for shortcut action key,
 * &nbsp;&nbsp;                - 4 for flip flop
 * &nbsp;&nbsp; _action {String} The javascript function name
 * &nbsp;&nbsp; _webAppName {String} The webapp name which contains the function
 * &nbsp;&nbsp; _arguments {String} The arguments required by the function
 * &nbsp;&nbsp; _label {String} The string to display
 * &nbsp;&nbsp; _shortLabel {String} The string to display     
 * }
 * </pre>
 */	 
 
 /**
 * @event ACTION_DELETE_NTF
 * This event is used to notify that an action is deleted.
 * @param {Number} param contains the deleted action identifier
 */
 
});

ICTouchAPI.APIServices.ProgrammableKeys = new ICTouchAPI.APIServices.ProgrammableKeys();
