/**
 * @class ICTouchAPI.APIServices.InstantMessaging
 * @ignore
 * @extends Object
 * The IctIM module provides all Instant Messaging (IM) and presence features :<br>
 * <br>-Change the IM presence of the user (the telephonic presence is managed automatically),
 * <br>-Manage a buddy list : add/remove buddies and associate a nickname ("display name") to each of them,
 * <br> -Be notified about the presence changes of all buddies,
 * <br>-Send instant messages to a buddy,
 * <br> -Receive instant messages from any contact, and answer to it.
 * <br><br>This module sends notifications about :<br>
 * <br>-Buddy list modifications,
 * <br>-Presence modifications relative to the ictouch user and its buddies,
 * <br>-Instant messages sent and received.
 */
 
 
dojo.provide("ICTouchAPI.APIServices.InstantMessaging");
dojo.declare("ICTouchAPI.APIServices.InstantMessaging",[ICTouchAPI.APIServices.APIServicesBase],
{
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Send a new instant message to answer to the conversation corresponding to the given identifier.If the given conversation is already closed, a new one will be opened.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;idConversation {Number}  the identifier of the conversation
     * &nbsp;&nbsp;message {String} the content of the instant message
     * }
     * </pre>
     *
     * The callback will be called with a value,but it is deprecated, do not use
     *
     * <pre>
     * {Number} deprecated, do not use
     * </pre>
     */
	
	answerIM : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctIM",
			methodName : "answerIM",
			context : args.context,
			params: args.params,
			paramType: ["int", "QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b> the identifier of the conversation</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Send a instant message to the contact corresponding to the given identifier. A new conversation will be created if necessary.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;contactId {String} the unique identifier of the contact
     * &nbsp;&nbsp;message {String} the content of the instant message
     * }
     * </pre>
     *
     * The callback will be called with the identifier of the conversation created
     *
     * <pre>
     * {Number} the identifier of the conversation created
     * </pre>
     */

	sendIM : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctIM",
			methodName : "sendIM",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the list of Conversation objects</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve the conversation corresponding to the given identifier.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the unique identifier of the conversation
     * <pre>
     * {Number} the unique identifier of the conversation
     * </pre>
     *
     * The callback will be called with the list of Conversation objects,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _idConversation {String} The unique identifier of the instant conversation.
     * &nbsp;&nbsp; _phoneNumber {String}  The phone number of the distant associated to the conversation.
     * &nbsp;&nbsp; _contactId {String}  The contactId, unique identifier of the distant (empty if the distant is not a buddy).
     * &nbsp;&nbsp; _messageList (JSON)  List of the 15 last instant messages of the conversation.See the description below.
     * &nbsp;&nbsp; _conversationDateTime {Date}  The date&time of the Conversation (set when closing the conversation).
     * &nbsp;&nbsp; _isRead {Boolean} Indicates if the conversation has been read or not by the ictouch user.
     * &nbsp;&nbsp; _isClosed {Boolean} Indicates if the conversation has been closed or not by the ictouch user. A conversation must be closed before being deleted.
     * &nbsp;&nbsp; _sipuaImId {String}  The unique identifier used by SIPUA to identify the conversation.
     * }
     * </pre>
     *
     *The parameter _messageList is  the List of the 15 last instant messages of the conversation,each of them has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idInstantMessage {Number} The unique identifier of the instant message.
     * &nbsp;&nbsp; _direction {Number}The direction of the instant message (0 for an incoming message, 1 for an outgoing message).
     * &nbsp;&nbsp; _contactId {String} The unique identifier the distant as a contact.
     * &nbsp;&nbsp; _message {String} The text content of the instant message.
     * &nbsp;&nbsp; _sendTime {Date} The date&time when the instant message was sent.
     * &nbsp;&nbsp; _receivedTime {Date} The date&time when the instant message was received.
     * &nbsp;&nbsp; _idConversation {Number} The identifier of the Conversation containing this instant message.   
     * }
     * </pre>       
     */

	getConversationById : function(args) {
	this.callCoreApplicationMethod({
		domainName : "IctIM",
		methodName : "getConversationById",
		context : args.context,
        params: args.params,
        paramType: ["int"],
		callback : args.callback,
		callbackParams: args.callbackParams
	});
	args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Set as read the conversation corresponding to the given identifier.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the unique identifier of the conversation
     * <pre>
 	   * {Number} the unique identifier of the conversation
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	setConversationAsRead : function(args) {
	this.callCoreApplicationMethod({
		domainName : "IctIM",
		methodName : "setConversationAsRead",
		context : args.context,
        params: args.params,
        paramType: ["int"],
		callback : args.callback,
		callbackParams: args.callbackParams
	});
	args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>capability of the module</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the name of the capability
     * <pre>
     * {String} the name of the capability
     * </pre>
     *
     * The callback will be called with the capability, following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String} 
     * &nbsp;&nbsp;state {Number} 
     * }
     * </pre>
     */

	getCapability : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getCapability",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Update the IM presence of the current ictouch user.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;idIMStatus {Number} the identifier of the new status (-1 to ignore)
     * &nbsp;&nbsp; message {String} a personnalized message
     * }
     * </pre>
     *
     * The callback will be called with void
     *
     * <pre>
     * {void} void
     * </pre>
     */

	setStatus : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "setStatus",
            context: args.context,
            params: args.params,
            paramType: ["int" , "QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the value of the Status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Getter method for attribute Status.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     *
     * The callback will be called with status value
     *
     * <pre>
     * {Number} status value
     * </pre>
     */

	getStatus : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getStatus",
            context: args.context,
            params: args.params,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the presence data</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve the presence data associated to the current ictouch user.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     *
     * The callback will be called with he list of Presence objects,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _imPresenceValue {JSON} The IM presence status of the user.See the description below.
     * &nbsp;&nbsp; _telephonicPresenceValue {JSON} The telephonic presence status of the user.See the description below.
     * &nbsp;&nbsp; _personnalizedMessage {String} A personalized message that can be filled by the user.
     * &nbsp;&nbsp;                                to give more details about its presence status.
     * &nbsp;&nbsp; _imAddress {String} The IM address of the user.
     * &nbsp;&nbsp; _phoneNumber {String} The phone number of the user.
     * &nbsp;&nbsp; _displayName {String} The display name (nickname) used to identify a buddy.
     * &nbsp;&nbsp;                       This name will be displayed instead of the phone number when an instant message is received from this user.
     * &nbsp;&nbsp; _groupName {String} The name of the buddy list containing this user.
     * &nbsp;&nbsp; _contactId {String} The unique identifier of the user as a contact.
     * }
     * </pre>
     *
     * The parameter _imPresenceValue and _telephonicPresenceValue are the presence statuses ,each of them has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
     * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
     * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
     * }
     * </pre>   
     *   
     * The _labelStatus Possible values are :
     * <pre>
     *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
     *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
     *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
     *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
     *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
     *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
     *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
     *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
     *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
     * </pre>     
     */


	getPresence : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getPresence",
            context: args.context,
            params: args.params,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>all the possible values for PresenceStatus</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve all the possible values for PresenceStatus.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     *
     * The callback will be called with the list of PresenceStatus objects,each of them following this structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
     * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
     * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
     * }
     * </pre>   
     *   
     * The _labelStatus Possible values are :
     * <pre>
     *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
     *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
     *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
     *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
     *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
     *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
     *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
     *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
     *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
     * </pre>     
     */

	getAvailableStatuses : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getAvailableStatuses",
            context: args.context,
            params: args.params,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },


    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the presence data</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve the presence data associated to the current ictouch user.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     *
     * The callback will be called with he list of Presence objects,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _imPresenceValue {JSON} The IM presence status of the user.See the description below.
     * &nbsp;&nbsp; _telephonicPresenceValue {JSON} The telephonic presence status of the user.See the description below.
     * &nbsp;&nbsp; _personnalizedMessage {String} A personalized message that can be filled by the user.
     * &nbsp;&nbsp;                                to give more details about its presence status.
     * &nbsp;&nbsp; _imAddress {String} The IM address of the user.
     * &nbsp;&nbsp; _phoneNumber {String} The phone number of the user.
     * &nbsp;&nbsp; _displayName {String} The display name (nickname) used to identify a buddy.
     * &nbsp;&nbsp;                       This name will be displayed instead of the phone number when an instant message is received from this user.
     * &nbsp;&nbsp; _groupName {String} The name of the buddy list containing this user.
     * &nbsp;&nbsp; _contactId {String} The unique identifier of the user as a contact.
     * }
     * </pre>
     *
     *The parameter _imPresenceValue and _telephonicPresenceValue are the presence statuses ,each of them has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
     * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
     * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
     * }
     * </pre>   
     *   
     * The _labelStatus Possible values are :
     * <pre>
     *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
     *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
     *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
     *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
     *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
     *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
     *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
     *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
     *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
     * </pre>     
     */

	getPresence : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getPresence",
            context: args.context,
            params: args.params,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b> the presence data associated to the contact </b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve the presence data associated to the contact corresponding to the given identifier.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the unique identifier of the contact
     * <pre>
     * {String} the unique identifier of the contact
     * </pre>
     *
     * The callback will be called with he list of Presence objects,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _imPresenceValue {JSON} The IM presence status of the user.See the description below.
     * &nbsp;&nbsp; _telephonicPresenceValue {JSON} The telephonic presence status of the user.See the description below.
     * &nbsp;&nbsp; _personnalizedMessage {String} A personalized message that can be filled by the user.
     * &nbsp;&nbsp;                                to give more details about its presence status.
     * &nbsp;&nbsp; _imAddress {String} The IM address of the user.
     * &nbsp;&nbsp; _phoneNumber {String} The phone number of the user.
     * &nbsp;&nbsp; _displayName {String} The display name (nickname) used to identify a buddy.This name will be displayed
     * &nbsp;&nbsp;                       instead of the phone number when an instant message is received from this user.
     * &nbsp;&nbsp; _groupName {String} The name of the buddy list containing this user.
     * &nbsp;&nbsp; _contactId {String} The unique identifier of the user as a contact.
     * }
     * </pre>
     *
     *The parameter _imPresenceValue and _telephonicPresenceValue are the presence statuses ,each of them has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
     * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
     * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
     * }
     * </pre>   
     *   
     * The _labelStatus Possible values are :
     * <pre>
     *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
     *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
     *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
     *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
     *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
     *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
     *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
     *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
     *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
     * </pre>     
     */

	getPresenceForContact : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getPresenceForContact",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b> the presence data associated to the contacts </b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve the presence data associated to the contacts corresponding to the given identifiers.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains a list of contactId,each of them has the following 
     * <pre>
     * {String} the unique identifier of the contact
     * </pre>
     *
     * The callback will be called with he list of Presence objects,each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _imPresenceValue {JSON} The IM presence status of the user.See the description below.
     * &nbsp;&nbsp; _telephonicPresenceValue {JSON} The telephonic presence status of the user.See the description below.
     * &nbsp;&nbsp; _personnalizedMessage {String} A personalized message that can be filled by the user.
     * &nbsp;&nbsp;                                to give more details about its presence status.
     * &nbsp;&nbsp; _imAddress {String} The IM address of the user.
     * &nbsp;&nbsp; _phoneNumber {String} The phone number of the user.
     * &nbsp;&nbsp; _displayName {String} The display name (nickname) used to identify a buddy.
     * &nbsp;&nbsp;                       This name will be displayed instead of the phone number when an instant message is received from this user.
     * &nbsp;&nbsp; _groupName {String} The name of the buddy list containing this user.
     * &nbsp;&nbsp; _contactId {String} The unique identifier of the user as a contact.
     * }
     * </pre>
     *
     *The parameter _imPresenceValue and _telephonicPresenceValue are the presence statuses ,each of them has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
     * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
     * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
     * }
     * </pre>   
     *   
     * The _labelStatus Possible values are :
     * <pre>
     *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
     *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
     *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
     *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
     *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
     *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
     *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
     *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
     *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
     * </pre>     
     */

	getPresenceForContacts : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getPresenceForContacts",
            context: args.context,
            params: args.params,
            paramType: ["QStringList"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Modify the display name of a contact belonging to the buddy list.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp; contactId {String} the unique identifier of the contact
     * &nbsp;&nbsp; displayName {String} the new display name of the buddy
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	modifyContactfromBuddyList : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "modifyContactFromBuddyList",
            context: args.context,
            params: args.params,
            paramType: ["QString", "QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Add a contact to the buddy list.</b>
     * <br>contactId is used as the main key (if the imAddress corresponding to the contactId is not the same as the imAddress parameter, we use the imAddress corresponding to the contactId)
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp; imAddress {String} the IM address of the contact
     * &nbsp;&nbsp; contactId {String} the unique identifier of the contact
     * &nbsp;&nbsp; displayName {String} the display name of the new buddy
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	addContactInBuddyList : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "addContactInBuddyList",
            context: args.context,
            params: args.params,
            paramType: ["QString", "QString", "QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Remove a contact from the buddy list.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the unique identifier of the contact
     * <pre>
     * {String} the unique identifier of the contact
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	removeContactFromBuddyList : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "removeContactFromBuddyList",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

  /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Close the conversation corresponding to the given identifier.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the unique identifier of the conversation
     * <pre>
     * {Number}  the unique identifier of the conversation
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	closeConversation : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "closeConversation",
            context: args.context,
            params: args.params,
            paramType: ["int"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

  /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Search the collaborationId associated with the given login in ContactProfile.
     * The response will be sent asynchronously in {@link #IM_EVENT_GET_COLLABID_RESULT}.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the login used as search key
     * <pre>
     * {String} The login used as search key
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	getCollaborationId : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctIM",
            methodName: "getCollaborationId",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },
    
/**
 * @event IM_BUDDY_ADDED
 * This event is used to notify that a new buddy has been added to the buddy list of the ictouch user.
 * @param {String} param contains the IM address of the added buddy.
 */	 
 
/**
 * @event IM_BUDDY_DELETED
 * This event is used to notify that a buddy has been removed from the buddy list of the ictouch user.
 * @param {String} param contains the IM address of the removed buddy.
 */	 
 
 /**
 * @event IM_BUDDY_LIST_MODIFIED
 * This event is used to notify that the buddy list content has changed.
 * @param {String} param contains the name of the updated buddy list.
 */	 
 
 /**
 * @event IM_CONVERSATION_READ 
 * This event is used to notify that a conversation has been read.
 * @param {Number} param contains the unique identifier of the conversation.
 */

 /**
 * @event IM_CONVERSATION_DELETED
 * This event is used to notify that a conversation has been deleted.
 * All instant messages belonging to this conversation were deleted too.
 * @param {Number} param contains the unique identifier of the conversation.
 */

 /**
 * @event IM_CONVERSATION_CLOSED 
 * This event is used to notify that a conversation has been closed,and can't be used anymore to store instant messages. If the user wants to send an instant
 * message to the same user, a new conversation will be created.
 * @param {Number} param contains the unique identifier of the conversation.
 */

 /**
 * @event IM_SENT 
 * This event is used to notify that IM and presence features are now ready to be used (presence subscribed and buddy list retrieved).
 * @param {JSON} param contains the following structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;message {JSON}  the data of the message.See the description below.
 * &nbsp;&nbsp;displayName {String} the display name (nickname) of the sender.
 * &nbsp;&nbsp;phoneNumber {String} the phone number of the sender.
 * }
 * </pre>
 *
 * The parameter message has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _idInstantMessage {Number} The unique identifier of the instant message.
 * &nbsp;&nbsp; _direction {Number}The direction of the instant message (0 for an incoming message, 1 for an outgoing message).
 * &nbsp;&nbsp; _contactId {String} The unique identifier the distant as a contact.
 * &nbsp;&nbsp; _message {String} The text content of the instant message.
 * &nbsp;&nbsp; _sendTime {Date} The date&time when the instant message was sent.
 * &nbsp;&nbsp; _receivedTime {Date} The date&time when the instant message was received.
 * &nbsp;&nbsp; _idConversation {Number} The identifier of the Conversation containing this instant message.   
 * }
 * </pre> 
 */
 
 /**
 * @event IM_RECEIVED 
 * This event is used to notify that a new instant message has been received.
 * @param {JSON} param contains the following structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;message {JSON}  the data of the message.See the description below.
 * &nbsp;&nbsp;displayName {String} the display name (nickname) of the distant.
 * &nbsp;&nbsp;phoneNumber {String} the phone number of the distant.
 * }
 * </pre>
 *
 * The parameter message has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _idInstantMessage {Number} The unique identifier of the instant message.
 * &nbsp;&nbsp; _direction {Number}The direction of the instant message (0 for an incoming message, 1 for an outgoing message).
 * &nbsp;&nbsp; _contactId {String} The unique identifier the distant as a contact.
 * &nbsp;&nbsp; _message {String} The text content of the instant message.
 * &nbsp;&nbsp; _sendTime {Date} The date&time when the instant message was sent.
 * &nbsp;&nbsp; _receivedTime {Date} The date&time when the instant message was received.
 * &nbsp;&nbsp; _idConversation {Number} The identifier of the Conversation containing this instant message.   
 * }
 * </pre> 
 */
 
 /**
 * @event IM_EVENT_GET_COLLABID_RESULT 
 * This event is used to return the result of a call to IctIM::getCollaborationId.
 * @param {JSON} param contains the following structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;login {String} the login used as the search key. 
 * &nbsp;&nbsp;collaborationId {String} the collaborationId that was found (empty if nothing found).
 * }
 * </pre> 
 */
 
 /**
 * @event IM_PRESENCE_CHANGE 
 * This event is used to notify that the presence of one buddy at least has been changed.
 * @param {JSON} param contains the list of updated data of each presence,each of them following the structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _imPresenceValue {JSON} The IM presence status of the user.See the description below.
 * &nbsp;&nbsp; _telephonicPresenceValue {JSON} The telephonic presence status of the user.See the description below.
 * &nbsp;&nbsp; _personnalizedMessage {String} A personalized message that can be filled by the user.
 * &nbsp;&nbsp;                                to give more details about its presence status.
 * &nbsp;&nbsp; _imAddress {String} The IM address of the user.
 * &nbsp;&nbsp; _phoneNumber {String} The phone number of the user.
 * &nbsp;&nbsp; _displayName {String} The display name (nickname) used to identify a buddy.
 * &nbsp;&nbsp;                       This name will be displayed instead of the phone number when an instant message is received from this user.
 * &nbsp;&nbsp; _groupName {String} The name of the buddy list containing this user.
 * &nbsp;&nbsp; _contactId {String} The unique identifier of the user as a contact.
 * }
 * </pre>
 *
 * The parameter _imPresenceValue and _telephonicPresenceValue are the presence statuses ,each of them has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
 * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
 * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
 * }
 * </pre>   
 *   
 * The _labelStatus Possible values are :
 * <pre>
 *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
 *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
 *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
 *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
 *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
 *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
 *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
 *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
 *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
 * </pre>     
 */
 

 /**
 * @event IM_SET_PRESENCE_NTF 
 * This event is used to notify that the presence of the ictouch user has been changed.
 * @param {JSON} param contains the updated data of the presence,following the structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _imPresenceValue {JSON} The IM presence status of the user.See the description below.
 * &nbsp;&nbsp; _telephonicPresenceValue {JSON} The telephonic presence status of the user.See the description below.
 * &nbsp;&nbsp; _personnalizedMessage {String} A personalized message that can be filled by the user.
 * &nbsp;&nbsp;                                to give more details about its presence status.
 * &nbsp;&nbsp; _imAddress {String} The IM address of the user.
 * &nbsp;&nbsp; _phoneNumber {String} The phone number of the user.
 * &nbsp;&nbsp; _displayName {String} The display name (nickname) used to identify a buddy.
 * &nbsp;&nbsp;                       This name will be displayed instead of the phone number when an instant message is received from this user.
 * &nbsp;&nbsp; _groupName {String} The name of the buddy list containing this user.
 * &nbsp;&nbsp; _contactId {String} The unique identifier of the user as a contact.
 * }
 * </pre>
 *
 * The parameter _imPresenceValue and _telephonicPresenceValue are the presence statuses ,each of them has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp; _idStatus {Number} The unique identifier of the status. See _labelStatus for possible values.
 * &nbsp;&nbsp; _labelStatus {String} The label of the status.See the description below.
 * &nbsp;&nbsp; _myTeamWorkStatus {Number} Status value for MyTeamwork. N.B : deprecated.
 * }
 * </pre>   
 *   
 * The _labelStatus Possible values are :
 * <pre>
 *-"ACTIVITY_APPEAR_OFFLINE" (_idStatus=1) : can be set manually,
 *-"ACTIVITY_ONLINE" (_idStatus=2) : can be set manually,
 *-"ACTIVITY_AWAY" (_idStatus=3) : automatic status,
 *-"ACTIVITY_LUNCH" (_idStatus=4) : can be set manually,
 *-"ACTIVITY_ONTHEPHONE" (_idStatus=5) : automatic status,
 *-"ACTIVITY_OTHER" (_idStatus=6) : read-only status, not used yet,
 *-"ACTIVITY_UNKNOWN" (_idStatus=7) : default status,
 *-"ACTIVITY_BUSY" (_idStatus=8) : can be set manually,
 *-"ACTIVITY_BE_RIGHT_BACK" (_idStatus=9) : can be set manually.
 * </pre>     
 */

});

ICTouchAPI.APIServices.InstantMessaging = new ICTouchAPI.APIServices.InstantMessaging();
