/**
 * @ignore
 */
dojo.provide("ICTouchAPI.APIServices.IctUser");
dojo.declare("ICTouchAPI.APIServices.IctUser",[ICTouchAPI.APIServices.APIServicesBase],
{
	lockRequest : function(args) {
        this.callCoreApplicationMethod({
            domainName: "IctUser",
            methodName: "lockRequest",
            context: args.context,
            paramType: [],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

	unLockRequest : function(args) {
		args.params[0]	= Encryption.encryptRSA(args.params[0]);
		
        this.callCoreApplicationMethod({
            domainName: "IctUser",
            methodName: "unLockRequest",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

	login : function() {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "login"
		});
	},

	getManagerList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "getManagerList",
			context: args.context,
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	getAssistantList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "getAssistantList",
			context: args.context,
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	consultWhiteList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "consultWhiteList",
			context: args.context,
			params: args.params,
            paramType: [],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	addContactsInWhiteList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "addContactsInWhiteList",
			context: args.context,
			params: args.params,
			paramType: ["QStringList"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	removeContactsInWhiteList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "removeContactsInWhiteList",
			context: args.context,
			params: args.params,
			paramType: ["QStringList"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	deleteWhiteList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "deleteWhiteList",
			context: args.context,
			params: args.params,
			paramType: [],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	getFilteringLevel : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "getFilteringLevel",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	activateFiltering : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "activateFiltering",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	deActivateFiltering : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "deActivateFiltering",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	activateSupervision : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "activateSupervision",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	deActivateSupervision : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "deActivateSupervision",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	setFilteringLevel : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "setFilteringLevel",
			context: args.context,
			params: args.params,
			paramType: ["QString", "QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	isInWhiteList : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "isInWhiteList",
			context: args.context,
			params: args.params,
			paramType: ["QStringList"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	getCapabilityGlobal : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	getCapabilityInstance : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["int", "QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	eraseUserData : function(args) {
		args.params[0]	= Encryption.encryptRSA(args.params[0]);
		
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "eraseUserData",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	unLockVVMAccessRequest : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "unLockVVMAccessRequest",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	lockVVMAccessRequest : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctUser",
			methodName: "lockVVMAccessRequest",
			context: args.context,
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	}
});

ICTouchAPI.APIServices.IctUser = new ICTouchAPI.APIServices.IctUser();
