/**
 * @class ICTouchAPI.APIServices.IctMPInterface
 * @singleton
 * @extends ICTouchAPI.APIServices.APIServicesBase
 * IctMPInterface is a module that communicates directly, using DBus, with the MediaPlayer. IctMPinterface can demand to MediaPlayer to play, pause... music files. <br>
 * This is the class that external web applications must use. Such applications can not have the right to access directly to the infrastructure applications, MediaPlayer taking part of this set.
 */


dojo.provide("ICTouchAPI.APIServices.IctMPInterface");
dojo.declare("ICTouchAPI.APIServices.IctMPInterface",[ICTouchAPI.APIServices.APIServicesBase],
{

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Playes a media file.
     * deprecated instead if using this method, you must use void playMedia()</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;idFile {Number} the File identifier
     * &nbsp;&nbsp; filePath {String} the full url of the File
     * &nbsp;&nbsp; x {Number} x position  -  !!NOT USED!!
     * &nbsp;&nbsp; y {Number} y position  -  !!NOT USED!!
     * &nbsp;&nbsp; w {Number} w position  -  !!NOT USED!!
     * &nbsp;&nbsp; h {Number} h position  -  !!NOT USED!!
     * &nbsp;&nbsp; volume {Number} the volume to set  -  !!NOT USED!!
     * &nbsp;&nbsp; loop {Boolean} true if the music will be played in loop  -  !!NOT USED!!
     * &nbsp;&nbsp; index {Number} index
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
	launchMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "launchMP",
			context : args.context,
			params: args.params,
			paramType: ["int","QString","int","int","int","int","double","bool","qlonglong"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Plays a media file.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;idFile {Number} identifier of the File that we want to play.
     * &nbsp;&nbsp; filePath {String} full File path.
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
	playMedia : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "playMedia",
			context : args.context,
			params: args.params,
			paramType: ["int","QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Plays a media file.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;idFile {Number} identifier of the File that we want to play.
     * &nbsp;&nbsp; filePath {String} full File path.
     * &nbsp;&nbsp;  seek {qlonglong} : seek (0 to start at beginning).
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
	playMediaWithSeek : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "playMediaWithSeek",
			context : args.context,
			params: args.params,
			paramType: ["int","QString","qlonglong"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Send the media sessin data to the presentation.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
	getMediaSessionInfos : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "getMediaSessionInfos",
			context: args.context,
			params: args.params,
			paramType: [],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},


    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Puts the currently playing melody in pause or replayes a paused melody.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains a File identifier
     * <pre>
 	   * {Number} a File identifier.
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	playPauseMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "playPauseMP",
			context : args.context,
			params: args.params,
			paramType: ["int"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Puts the reading pointer of the currently loaded file in 0 position.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains a File identifier
     * <pre>
 	   * {Number} a File identifier.
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	rewindMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "rewindMP",
			context : args.context,
			params: args.params,
			paramType: ["int"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Stops the currently playing file.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains a File identifier
     * <pre>
 	   * {Number} a File identifier.
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */


	stopMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "stopMP",
			context : args.context,
			params: args.params,
			paramType: ["int"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>call method setVolumeMP</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the volume value
     * <pre>
 	   * {Number} a volume value
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	setVolumeMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "setVolumeMP",
			context : args.context,
			params: args.params,
			paramType: ["double"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>call method muteMP</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	muteMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "muteMP",
			context : args.context,
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>call method unMuteMP</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	unMuteMP : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMPInterface",
			methodName : "unMuteMP",
			context : args.context,
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>capability of the module</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the name of the capability
     * <pre>
     * {String} the name of the capability
     * </pre>
     *
     * The callback will be called with the capability, following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String}
     * &nbsp;&nbsp;state {Number}
     * }
     * </pre>
     */

	getCapabilityGlobal : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>capability of an object of the module</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;name {String}  Name of the capability
     * &nbsp;&nbsp;listId {Number} ID of the list of capabilities
     * }
     * </pre>
     *
     * The callback will be called with the capability, following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String}
     * &nbsp;&nbsp;state {Number}
     * }
     * </pre>
     */

	getCapabilityInstance : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["int", "QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the list of capability of an object</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the ID of the list of capabilities
     * <pre>
     * {Number} the ID of the list of capabilities
     * </pre>
     *
     * The callback will be called with a map of capabilities indexed by name, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String}
     * &nbsp;&nbsp;state {Number}
     * }
     * </pre>
     */

	getCapabilities : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "getCapabilities",
			context: args.context,
			params: args.params,
			paramType: ["int"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Asks MediaPlayer to sends its current state. The state as an event.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	mediaPlayerSendState : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "mediaPlayerSendState",
			context: args.context,
			params: args.params,
			paramType: [],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Preview of a ring tone (play it). Use it only in settings application to preview a ringtone before choose its in settings application.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the file path
     * <pre>
 	   * {String} the full url of the File.
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	preview : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "preview",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	  /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Preview of a ring tone (play it). Use it only in settings application to preview a ringtone before choose its in settings application.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the file path
     * <pre>
 	   * {String} the full url of the File.
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	volumePreview : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "volumePreview",
			context: args.context,
			params: args.params,
			paramType: ["QString","double"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Stops a preview</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */

	stopPreview : function(args) {
		this.callCoreApplicationMethod({
			domainName: "IctMPInterface",
			methodName: "stopPreview",
			context: args.context,
			params: args.params,
			paramType: [],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	}
})

ICTouchAPI.APIServices.IctMPInterface = new ICTouchAPI.APIServices.IctMPInterface();