/**
 * @class ICTouchAPI.APIServices.IctDirectory
 * @singleton
 * @extends ICTouchAPI.APIServices.APIServicesBase
 * The IctDirectory module is the one used for all functions related to Directory Applications.<br>
 * It provides API to search users with different criterias and also functions to retrieve all information related to one.
 */
dojo.provide("ICTouchAPI.APIServices.IctDirectory");
dojo.declare("ICTouchAPI.APIServices.IctDirectory",[ICTouchAPI.APIServices.APIServicesBase],
{    
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of contacts</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method provides the sorted (by last name, first name) list of local contacts (including DM contacts)<br>
     * Particular rules :<br>
     * - to get all the contacts, specify startInd:-1 , length:-1 </b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{Number} index of the first contact to return
     * &nbsp;&nbsp;{Number} number of contacts to return
     * }
     * </pre>
     *
     * The callback will be called with the list of contacts, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _contactId {String} The unique Id of a local contact                                     
     * &nbsp;&nbsp; _loginName {String} Login Name (when contact is copied from a search)                    
     * &nbsp;&nbsp; _salutation {String} Mr Mrs etc                                                             
     * &nbsp;&nbsp; _firstName {String} First Name                                                              
     * &nbsp;&nbsp; _name {String} Last Name                                                                    
     * &nbsp;&nbsp; _latinFirstName {String} not in use                                                         
     * &nbsp;&nbsp; _latinName {String} not in use yet                                                          
     * &nbsp;&nbsp; _language {String} not in use yet                                                           
     * &nbsp;&nbsp; _timezone {String} not in use yet                                                           
     * &nbsp;&nbsp; _officePhone {String} phone number (granted dialable in a further realease)                 
     * &nbsp;&nbsp; _attendant {String} name of the attendant (not yet in use)                               
     * &nbsp;&nbsp; _colleague {String} name of a colleague (not yet in use)                                 
     * &nbsp;&nbsp; _assistant {String} name of the assistant (not yet in use)                               
     * &nbsp;&nbsp; _email {String} email address                                                            
     * &nbsp;&nbsp; _fax {String} fax number (granted dialable in a further realease)                        
     * &nbsp;&nbsp; _voicemail {String} not in use yet                                                       
     * &nbsp;&nbsp; _personalHome {String} personnal phone number (granted dialable in a further realease)   
     * &nbsp;&nbsp; _personalMobile {String} personnal phone number (granted dialable in a further realease) 
     * &nbsp;&nbsp; _personalFax {String} personnal fax number (granted dialable in a further realease)      
     * &nbsp;&nbsp; _personalEmail {String} personal email address                                           
     * &nbsp;&nbsp; _collaborationId {String} Instant messaging address                                      
     * &nbsp;&nbsp; _misc {Object} A list of other attributes in a JSON structure (key-value)
     * &nbsp;&nbsp; _isPreviewed {Boolean} true if shown in user's Home page                                     
     * &nbsp;&nbsp; _isPrivate {Boolean} true if created by the user                                             
     * &nbsp;&nbsp; _type {Number} see enum IctDirectoryEnum                                                     
     * &nbsp;&nbsp; _photo {String} the url of contact photo                                                 
     * &nbsp;&nbsp; _melody {String} the url of ringing melody when this contact calls (not yet in use)      
     * &nbsp;&nbsp; _lastModificationDate {Date} as said                   
     * }            
     * </pre>
     */                
	getLocalContacts : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "getLocalContacts",
			params: args.params,
			paramType: ["int", "int"],
			context : args.context,
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of contacts</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method provides the sorted (by last name, first name) list of local contacts (including DM contacts) that are shown in the Home page<br>
     * Particular rules :<br>
     * - to get all the contacts, specify startInd:-1 , length:-1 </b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{Number} index of the first contact to return
     * &nbsp;&nbsp;{Number} number of contacts to return
     * }
     * </pre>
     *
     * The callback will be called with the list of contacts, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _contactId {String} The unique Id of a local contact                                     
     * &nbsp;&nbsp; _loginName {String} Login Name (when contact is copied from a search)                    
     * &nbsp;&nbsp; _salutation {String} Mr Mrs etc                                                             
     * &nbsp;&nbsp; _firstName {String} First Name                                                              
     * &nbsp;&nbsp; _name {String} Last Name                                                                    
     * &nbsp;&nbsp; _latinFirstName {String} not in use                                                         
     * &nbsp;&nbsp; _latinName {String} not in use yet                                                          
     * &nbsp;&nbsp; _language {String} not in use yet                                                           
     * &nbsp;&nbsp; _timezone {String} not in use yet                                                           
     * &nbsp;&nbsp; _officePhone {String} phone number (granted dialable in a further realease)                 
     * &nbsp;&nbsp; _attendant {String} name of the attendant (not yet in use)                               
     * &nbsp;&nbsp; _colleague {String} name of a colleague (not yet in use)                                 
     * &nbsp;&nbsp; _assistant {String} name of the assistant (not yet in use)                               
     * &nbsp;&nbsp; _email {String} email address                                                            
     * &nbsp;&nbsp; _fax {String} fax number (granted dialable in a further realease)                        
     * &nbsp;&nbsp; _voicemail {String} not in use yet                                                       
     * &nbsp;&nbsp; _personalHome {String} personnal phone number (granted dialable in a further realease)   
     * &nbsp;&nbsp; _personalMobile {String} personnal phone number (granted dialable in a further realease) 
     * &nbsp;&nbsp; _personalFax {String} personnal fax number (granted dialable in a further realease)      
     * &nbsp;&nbsp; _personalEmail {String} personal email address                                           
     * &nbsp;&nbsp; _collaborationId {String} Instant messaging address                                      
     * &nbsp;&nbsp; _misc {Object} A list of other attributes defined by keyword, value
     * &nbsp;&nbsp; _isPreviewed {Boolean} true if shown in user's Home page                                     
     * &nbsp;&nbsp; _isPrivate {Boolean} true if created by the user                                             
     * &nbsp;&nbsp; _type {Number} see enum IctDirectoryEnum                                                     
     * &nbsp;&nbsp; _photo {String} the url of contact photo                                                 
     * &nbsp;&nbsp; _melody {String} the url of ringing melody when this contact calls (not yet in use)      
     * &nbsp;&nbsp; _lastModificationDate {Date} as said                   
     * }            
     * </pre>
     */  
	getAllContactsInPreview : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "getAllContactsInPreview",
			params: args.params,
			paramType: ["int", "int"],
			context : args.context,
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of contacts</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method provides a Contact list of 1 local contact, or empty, of the passed contactId<br>
     * - user to provide contact Id<br>
     *
     * Particular rules :<br>
     * - this method is currently not able to return more than 1 contact (but this should not happen to have many contacts with the same id)<br></b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the contact Id.
     * <pre>
     * {String} the contact Id
     * </pre>
     *
     * The callback will be called with the list of contacts, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _contactId {String} The unique Id of a local contact                                     
     * &nbsp;&nbsp; _loginName {String} Login Name (when contact is copied from a search)                    
     * &nbsp;&nbsp; _salutation {String} Mr Mrs etc                                                             
     * &nbsp;&nbsp; _firstName {String} First Name                                                              
     * &nbsp;&nbsp; _name {String} Last Name                                                                    
     * &nbsp;&nbsp; _latinFirstName {String} not in use                                                         
     * &nbsp;&nbsp; _latinName {String} not in use yet                                                          
     * &nbsp;&nbsp; _language {String} not in use yet                                                           
     * &nbsp;&nbsp; _timezone {String} not in use yet                                                           
     * &nbsp;&nbsp; _officePhone {String} phone number (granted dialable in a further realease)                 
     * &nbsp;&nbsp; _attendant {String} name of the attendant (not yet in use)                               
     * &nbsp;&nbsp; _colleague {String} name of a colleague (not yet in use)                                 
     * &nbsp;&nbsp; _assistant {String} name of the assistant (not yet in use)                               
     * &nbsp;&nbsp; _email {String} email address                                                            
     * &nbsp;&nbsp; _fax {String} fax number (granted dialable in a further realease)                        
     * &nbsp;&nbsp; _voicemail {String} not in use yet                                                       
     * &nbsp;&nbsp; _personalHome {String} personnal phone number (granted dialable in a further realease)   
     * &nbsp;&nbsp; _personalMobile {String} personnal phone number (granted dialable in a further realease) 
     * &nbsp;&nbsp; _personalFax {String} personnal fax number (granted dialable in a further realease)      
     * &nbsp;&nbsp; _personalEmail {String} personal email address                                           
     * &nbsp;&nbsp; _collaborationId {String} Instant messaging address                                      
     * &nbsp;&nbsp; _misc {Object} A list of other attributes defined by keyword, value
     * &nbsp;&nbsp; _isPreviewed {Boolean} true if shown in user's Home page                                     
     * &nbsp;&nbsp; _isPrivate {Boolean} true if created by the user                                             
     * &nbsp;&nbsp; _type {Number} see enum IctDirectoryEnum                                                     
     * &nbsp;&nbsp; _photo {String} the url of contact photo                                                 
     * &nbsp;&nbsp; _melody {String} the url of ringing melody when this contact calls (not yet in use)      
     * &nbsp;&nbsp; _lastModificationDate {Date} as said                   
     * }            
     * </pre>
     */
	getContactById : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "getContactById",
			context : args.context,
			params: args.params,
			paramType: ["QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method starts a search of contacts (local at least, remote on option) matching a N-worded string<br>
     * Particular rules :<br>
     * - searchId is mandatory and provides a way to retrieve the found contacts later, and to purge the search results (for memory deallocation)<br>
     * - "startSearch" is designed to be asynchroneous; the application will, later, emit 0 to N "DIR_SEARCH_RESULTS_ (searchId)" events,
     * and one DIR_SEARCH_COMPLETED_(searchId) event when the search is finished.<br>
     * - localOnly, if specified true, will not try to retrieve contacts from UDA directories<br>
     * - name can be multi-worded :<br>
     * - simplest case, one word: it will search the contacts whose last name or first name starts with name parameter<br>
     * - elaborated cases, several words (separated by blank) : it will search the contacts who have all the words in the beginning of the last name and/or first name<br>
     * - the number of possible words is limited by the setting "DirMaxWord", but the above rule makes useful only 1 or 2 words<br>
     * - in case of remote search, all the available UDA directories are scanned<br>
     *
     * Emitted events after startSearchContactByName(searchId) :<br>
     *
     * - DIR_SEARCH_RESULTS_(searchId) , with param int nbResults (1 to N)<br>
     * - DIR_SEARCH_COMPLETED_(searchId), with param int nbResults (0 to N)<br>
     * There can be zero to several successive DIR_SEARCH_RESULTS_(searchId), and always one final DIR_SEARCH_COMPLETED_(searchId).
     * Each DIR_SEARCH_RESULT provided quickly the information on the search progress, with the total increasing nbResults reached at this stage.
     * When a search step provides 0 results, no DIR_SEARCH_RESULTS is sent, thus avoids disturbing the client for nothing new.
     * When the client gets a DIR_SEARCH_RESULT_(searchId) corresponding to his search, he then can fetch part or all results using method "GET_SEARCH_RESULTS".
     * This allows a fast display while search is still going on.
     * The client may also want to wait "DIR_SEARCH_COMPLETED_(searchId)" (nbResults) and the retrieve part or all of the contacts.<br>
     *
     * Caution: the getSearchResults that the client would then use to get part of the contacts before the end of the search,
     * would always get the set of [start, number] contacts AFTER a sort of the current search results, not knowing if further results would or not insert names in this list.
     * So, a client should not consider that pages requested before the DIR_SEARCH_COMPLETED are correctly sorted</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String}   mandatory: allows to link search request on one side, resulting events , requests and results on the other side          
     * &nbsp;&nbsp;{String}   see method description
     * &nbsp;&nbsp;{Boolean}  if specified and true, will not try to retrieve contacts from UDA directories; and will return only zero to one DIR_SEARCH_RESULTS_(searchId)  
     * }
     * </pre>
     *
     * The callback will be called with a result status, which is always 0 (success).  
     */
	startSearchContactByName : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "startSearchContactByName",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString", "int", "bool"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

	startSearchContactByAllFields : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "startSearchContactByAllFields",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString", "bool"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method is IDENTICAL to startSearchContactByName,
     * excepted the parameter which is a phone number.
     * The same mechanism allows an asynchrone notification of successive sets of results.
     * Please refer to method startSearchContactByName</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String}   mandatory: allows to link search request on one side, resulting events , requests and results on the other side
     * &nbsp;&nbsp;{String}   see method description
     * &nbsp;&nbsp;{Boolean}  if specified and true, will not try to retrieve contacts from UDA directories; and will return only zero to one DIR_SEARCH_RESULTS_(searchId)
     * }
     * </pre>
     *
     * The callback will be called with a result status, which is always 0 (success).  
     */
	startSearchContactByPhoneNumber : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "startSearchContactByPhoneNumber",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString", "bool"],
			callback : args.callback,
			callbackParams: args.callbackParams,
			errorCallback : args.errorCallback
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method creates a contact in the local database<br>
     * - user to provide all information<br>
     *
     *  Particular rules :<br>
     *  - if request Id is "DM" the contact type is "DM" else it is local<br>
     *  - event DIR_CONTACT_CREATED is sent if ok,  excepted for a DM contact<br>
     *  - contact last modification date is set to current date time<br>
     *  - contact Id is calculated depending on origin: DM or not<br></b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} a request Id
     * &nbsp;&nbsp;{Object}   the Contact to create
     * }
     * </pre>
     
     * The second parameter has the following structs: 
     * <pre>
     * {
     * _contactId {String} The unique Id of a local contact                                     
     * _loginName {String} Login Name (when contact is copied from a search)                    
     * _salutation {String} Mr Mrs etc                                                             
     * _firstName {String} First Name                                                              
     * _name {String} Last Name                                                                    
     * _latinFirstName {String} not in use                                                         
     * _latinName {String} not in use yet                                                          
     * _language {String} not in use yet                                                           
     * _timezone {String} not in use yet                                                           
     * _officePhone {String} phone number (granted dialable in a further realease)                 
     * _attendant {String} name of the attendant (not yet in use)                               
     * _colleague {String} name of a colleague (not yet in use)                                 
     * _assistant {String} name of the assistant (not yet in use)                               
     * _email {String} email address                                                            
     * _fax {String} fax number (granted dialable in a further realease)                        
     * _voicemail {String} not in use yet                                                       
     * _personalHome {String} personnal phone number (granted dialable in a further realease)   
     * _personalMobile {String} personnal phone number (granted dialable in a further realease) 
     * _personalFax {String} personnal fax number (granted dialable in a further realease)      
     * _personalEmail {String} personal email address                                           
     * _collaborationId {String} Instant messaging address                                      
     * _misc {Object} A list of other attributes defined by keyword, value
     * _isPreviewed {Boolean} true if shown in user's Home page                                     
     * _isPrivate {Boolean} true if created by the user                                             
     * _type {Number} see enum IctDirectoryEnum                                                     
     * _photo {String} the url of contact photo                                                 
     * _melody {String} the url of ringing melody when this contact calls (not yet in use)      
     * _lastModificationDate {Date} as said                   
     * }            
     * </pre>
     *
     * The callback will be called with a result status.  
     * Possible value are:
     * <pre>
     * {
     * &nbsp;&nbsp; 0 if successful    
     * &nbsp;&nbsp; 6 during synchronization (contact it then read-only)
     * &nbsp;&nbsp; 3 if the max number was reached ;
     * &nbsp;&nbsp; -1: database error
     * }
     * </pre>     
     */
	createLocalContact : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "createLocalContact",
			context : args.context,
			params: args.params,
			paramType: ["QString", "Contact"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method updates a contact in the local database, using contactId key<br>
     * - user to provide all information<br>
     *
     * Particular rules :<br>
     * - only the pure local contacts can be updated (DM cannot, and other types, remote, are only in memory and are not updated)<br>
     * - event DIR_CONTACT_UPDATED is sent if ok<br>
     * - it removes the old photo in the filesystem if different<br>
     * - contact last modification date is set to current date time<br></b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} a request Id
     * &nbsp;&nbsp;{Object}   the Contact to create
     * }
     * </pre>
     
     * The second parameter has the following structs: 
     * <pre>
     * {
     * _contactId {String} The unique Id of a local contact                                     
     * _loginName {String} Login Name (when contact is copied from a search)                    
     * _salutation {String} Mr Mrs etc                                                             
     * _firstName {String} First Name                                                              
     * _name {String} Last Name                                                                    
     * _latinFirstName {String} not in use                                                         
     * _latinName {String} not in use yet                                                          
     * _language {String} not in use yet                                                           
     * _timezone {String} not in use yet                                                           
     * _officePhone {String} phone number (granted dialable in a further realease)                 
     * _attendant {String} name of the attendant (not yet in use)                               
     * _colleague {String} name of a colleague (not yet in use)                                 
     * _assistant {String} name of the assistant (not yet in use)                               
     * _email {String} email address                                                            
     * _fax {String} fax number (granted dialable in a further realease)                        
     * _voicemail {String} not in use yet                                                       
     * _personalHome {String} personnal phone number (granted dialable in a further realease)   
     * _personalMobile {String} personnal phone number (granted dialable in a further realease) 
     * _personalFax {String} personnal fax number (granted dialable in a further realease)      
     * _personalEmail {String} personal email address                                           
     * _collaborationId {String} Instant messaging address                                      
     * _misc {Object} A list of other attributes in a JSON structure (key-value)
     * _isPreviewed {Boolean} true if shown in user's Home page                                     
     * _isPrivate {Boolean} true if created by the user                                             
     * _type {Number} see enum IctDirectoryEnum                                                     
     * _photo {String} the url of contact photo                                                 
     * _melody {String} the url of ringing melody when this contact calls (not yet in use)      
     * _lastModificationDate {Date} as said                   
     * }            
     * </pre>
     *
     * The callback will be called with a result status.  
     * Possible value are:
     * <pre>
     * {
     * &nbsp;&nbsp; 0 if successful    
     * &nbsp;&nbsp; 1 if the found contact is not a pure local
     * &nbsp;&nbsp; 2 if the contact is not found though its contactId
     * &nbsp;&nbsp; 6 during synchronization
     * &nbsp;&nbsp; -1: database error
     * }
     * </pre>     
     */
	modifyLocalContact : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "modifyLocalContact",
			context : args.context,
			params: args.params,
			paramType: ["QString", "Contact"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method definitely deletes a contact in the local database, using contactId key<br>
     * - user to provide key<br>
     * Particular rules :<br>
     * - event DIR_CONTACT_DELETED is sent if ok, but not for DM delete<br>
     * - it removes the old photo in the file system if different<br></b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} a request Id
     * &nbsp;&nbsp;{Object}   the Contact to create
     * }
     * </pre>
     
     * The second parameter has the following structs: 
     * <pre>
     * {
     * _contactId {String} The unique Id of a local contact                                     
     * _loginName {String} Login Name (when contact is copied from a search)                    
     * _salutation {String} Mr Mrs etc                                                             
     * _firstName {String} First Name                                                              
     * _name {String} Last Name                                                                    
     * _latinFirstName {String} not in use                                                         
     * _latinName {String} not in use yet                                                          
     * _language {String} not in use yet                                                           
     * _timezone {String} not in use yet                                                           
     * _officePhone {String} phone number (granted dialable in a further realease)                 
     * _attendant {String} name of the attendant (not yet in use)                               
     * _colleague {String} name of a colleague (not yet in use)                                 
     * _assistant {String} name of the assistant (not yet in use)                               
     * _email {String} email address                                                            
     * _fax {String} fax number (granted dialable in a further realease)                        
     * _voicemail {String} not in use yet                                                       
     * _personalHome {String} personnal phone number (granted dialable in a further realease)   
     * _personalMobile {String} personnal phone number (granted dialable in a further realease) 
     * _personalFax {String} personnal fax number (granted dialable in a further realease)      
     * _personalEmail {String} personal email address                                           
     * _collaborationId {String} Instant messaging address                                      
     * _misc {Object} A list of other attributes in a JSON structure (key-value)
     * _isPreviewed {Boolean} true if shown in user's Home page                                     
     * _isPrivate {Boolean} true if created by the user                                             
     * _type {Number} see enum IctDirectoryEnum                                                     
     * _photo {String} the url of contact photo                                                 
     * _melody {String} the url of ringing melody when this contact calls (not yet in use)      
     * _lastModificationDate {Date} as said                   
     * }            
     * </pre>
     *
     * The callback will be called with a result status.  
     * Possible value are:
     * <pre>
     * {
     * &nbsp;&nbsp; 0 if successful    
     * &nbsp;&nbsp; 1 if the found contact is of type UDA or ICE (remote contacts in memory)
     * &nbsp;&nbsp; 2 if the contact is not found though its contactId
     * &nbsp;&nbsp; 6 during synchronization
     * &nbsp;&nbsp; -1: database error
     * }
     * </pre>     
     */
	deleteLocalContact : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "deleteLocalContact",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>String</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method copys the contact to local</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params contains the contact Id
     * <pre>
     * {String} the contact Id
     * </pre>
     *
     * The callback will be called with a String.
     */
	copyContactToLocal : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "copyContactToLocal",
			context : args.context,
			params: args.params,
			paramType: ["QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>sorted list of ContactSummary</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This Method retrieves a list of found ContactSummary in a given search. Only basic information of the contacts are contained in the ContactSummary (contactId, name, firstName, officePhone, email, type).
	 * The whole contact object can be obtained using the function getContactFromSearch. Please refer to "getContactFromSearch" for more details about this function.
     * Please refer to "startSearchContactByName" for more details about the asynchroneous mechanism of searchs.<br>
     *
     * Particular rules :<br>
     * - startInd and length are mandatory, there are no default values to get all the list<br>
     * - startInd : specify 0 to get the first contact<br>
     * - to get all the found contacts, specify startind=0, length = the number of found contacts (nbResults returned by the event DIR_SEARCH_RESULTS or by the final DIR_SEARCH_COMPLETED)<br>
     * Caution: the  getSearchResults that the client would then use to get part of the contacts before the end of the search,
     * would always get the set of [start, number] contacts AFTER a sort of the current search results, not knowing if further results would or not insert names in this list.
     * So, a client should not consider that pages requested before the DIR_SEARCH_COMPLETED are correctly sorted</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the reference of the search
     * &nbsp;&nbsp;{Number} the index of the first contact
     * &nbsp;&nbsp;{Number} the number of wanted contacts starting from startInd
     * }
     * </pre>
     *
     * The callback will be called with the list of contacts, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _contactId {String} The unique Id of a local contact                                                 
     * &nbsp;&nbsp; _firstName {String} First Name                                                              
     * &nbsp;&nbsp; _name {String} Last Name                                                      
     * &nbsp;&nbsp; _officePhone {String} phone number (granted dialable in a further realease)                           
     * &nbsp;&nbsp; _email {String} email address                
     * }            
     * </pre>
     */     
	getSearchResults : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "getSearchResults",
			context : args.context,
			params: args.params,
			paramType: ["QString", "int", "int"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>contact</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This Method retrieves a found contact in a given search. Unlike the ContactSummary obtained using getSearchResults, this contact contains the detailed informations.
	 * 
     * Particular rules :<br>
     * - searchId and contactId are mandatory<br>
     * - searchId : specify the id of the search from which the contact has to be get<br>
     * - contactId : specify the id of the contact to be get
     * Caution: once a new search has been launched with a new search id, the previous search is no longer available in IctDirectory.
	 * Therefore, a client has to get the whole contact needed BEFORE starting a new search with a new search id</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the reference of the search
     * &nbsp;&nbsp;{Number} the reference of the contact to get
     * }
     * </pre>
     *
     * The callback will be called with the contact corresponding to the given contactId. The contact returned has the following structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; _contactId {String} The unique Id of a local contact
     * &nbsp;&nbsp; _loginName {String} Login Name (when contact is copied from a search)
     * &nbsp;&nbsp; _salutation {String} Mr Mrs etc
     * &nbsp;&nbsp; _firstName {String} First Name
     * &nbsp;&nbsp; _name {String} Last Name
     * &nbsp;&nbsp; _latinFirstName {String} not in use
     * &nbsp;&nbsp; _latinName {String} not in use yet
     * &nbsp;&nbsp; _language {String} not in use yet
     * &nbsp;&nbsp; _timezone {String} not in use yet
     * &nbsp;&nbsp; _officePhone {String} phone number (granted dialable in a further realease)
     * &nbsp;&nbsp; _attendant {String} name of the attendant (not yet in use)
     * &nbsp;&nbsp; _colleague {String} name of a colleague (not yet in use)
     * &nbsp;&nbsp; _assistant {String} name of the assistant (not yet in use)
     * &nbsp;&nbsp; _email {String} email address
     * &nbsp;&nbsp; _fax {String} fax number (granted dialable in a further realease)
     * &nbsp;&nbsp; _voicemail {String} not in use yet
     * &nbsp;&nbsp; _personalHome {String} personnal phone number (granted dialable in a further realease)
     * &nbsp;&nbsp; _personalMobile {String} personnal phone number (granted dialable in a further realease)
     * &nbsp;&nbsp; _personalFax {String} personnal fax number (granted dialable in a further realease)
     * &nbsp;&nbsp; _personalEmail {String} personal email address
     * &nbsp;&nbsp; _collaborationId {String} Instant messaging address
     * &nbsp;&nbsp; _misc {Object} A list of other attributes in a JSON structure (key-value)
     * &nbsp;&nbsp; _isPreviewed {Boolean} true if shown in user's Home page
     * &nbsp;&nbsp; _isPrivate {Boolean} true if created by the user
     * &nbsp;&nbsp; _type {Number} see enum IctDirectoryEnum
     * &nbsp;&nbsp; _photo {String} the url of contact photo
     * &nbsp;&nbsp; _melody {String} the url of ringing melody when this contact calls (not yet in use)
     * &nbsp;&nbsp; _lastModificationDate {Date} as said
     * </pre>
     */
	getContactFromSearch : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "getContactFromSearch",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method is IDENTICAL to startSearchContactByName,
     * excepted the parameter which is a phone number.
     * The same mechanism allows an asynchrone notification of successive sets of results.
     * Please refer to method startSearchContactByName</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String}   mandatory: allows to link search request on one side, resulting events , requests and results on the other side
     * &nbsp;&nbsp;{String}   see method description
     * &nbsp;&nbsp;{Boolean}  if specified and true, will not try to retrieve contacts from UDA directories; and will return only zero to one DIR_SEARCH_RESULTS_(searchId)
     * }
     * </pre>
     *
     * The callback will be called with a result status, which is always 0 (success).  
     */
	purgeSearchResults : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "purgeSearchResults",
			context : args.context,
			params: args.params,
			paramType: ["QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method changes the "isPreview" flag to TRUE so that the contact is shown on the Home page<br>
     * - user to provide contact Id<br>
     * Particular rules :<br>
     * - event DIR_CONTACTINPREVIEW_CREATED is sent if ok, but not for DM contact</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String}   a request Id
     * &nbsp;&nbsp;{String}   the contact Id
     * }
     * </pre>
     *
     * The callback will be called with a result status, which is always 0 (success).  
     * <pre>
     * {
     * &nbsp;&nbsp; 0 if successful    
     * &nbsp;&nbsp; 4 if the found contact is already flagged
     * &nbsp;&nbsp; 6 during synchronization
     * &nbsp;&nbsp; -1: database error
     * }
     * </pre>     
     */
	addContactToPreview : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "addContactToPreview",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method changes the "isPreview" flag to FALSE so that the contact is not shown on the Home page<br>
     * - user to provide contact Id<br>
     * Particular rules :<br>
     * - event DIR_CONTACTINPREVIEW_DELETED is sent if ok, but not for DM contact</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String}   a request Id
     * &nbsp;&nbsp;{String}   the contact Id
     * }
     * </pre>
     *
     * The callback will be called with a result status, which is always 0 (success).  
     * <pre>
     * {
     * &nbsp;&nbsp; 0 if successful    
     * &nbsp;&nbsp; 4 if the found contact is already flagged
     * &nbsp;&nbsp; 6 during synchronization
     * &nbsp;&nbsp; -1: database error
     * }
     * </pre>     
     */
	removeContactFromPreview : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctDirectory",
			methodName : "removeContactFromPreview",
			context : args.context,
			params: args.params,
			paramType: ["QString", "QString"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	}
});

ICTouchAPI.APIServices.IctDirectory = new ICTouchAPI.APIServices.IctDirectory();
