/**
 * @class ICTouchAPI.APIServices.GreenManager
 * @singleton
 * @extends ICTouchAPI.APIServices.APIServicesBase
 *  This API manages the screensaver.
 */

dojo.provide("ICTouchAPI.APIServices.GreenManager");
dojo.declare("ICTouchAPI.APIServices.GreenManager",[ICTouchAPI.APIServices.APIServicesBase],
{
    setScreensaverState : function(args) {
        this.callCoreApplicationMethod({
            domainName : "GreenManager",
            methodName : "setScreensaverState",
            context : args.context,
            params: args.params,
            paramType: ["bool"],
            callback : args.callback
        });
        args = null;
    }

/**
 * @event Screensaver_Off
 * This event occurs when the screensaver is displayed and when the user touchs the screen.
 */
    
/**
 * @event Screensaver_On
 * This event is sent when the screensaver delay has expired (no screen interaction during this delay)
 */
 });



ICTouchAPI.APIServices.GreenManager = new ICTouchAPI.APIServices.GreenManager();
