/**
 * @class ICTouchAPI.APIServices.FileManager
 * @extends ICTouchAPI.APIServices.APIServicesBase
 * @singleton
 * The file manager module is in charge of all the file manager features.<br>
 * The file manager module provides services in order to manage actions on files.<br>
 * These files can be stored on the phone itself,on an USB Key
 * or can be a link to a streaming audio or video.
 */
dojo.provide("ICTouchAPI.APIServices.FileManager");
dojo.declare("ICTouchAPI.APIServices.FileManager",[ICTouchAPI.APIServices.APIServicesBase],
{
//    getMediaTypeList : function(context, callback, callbackParams) {
//        this.callCoreApplicationMethod({
//            domainName : "FileManager",
//            methodName : "getMediaTypeList",
//            context : context,
//            callback : callback,
//            callbackParams: callbackParams
//        });
//    },

//    getMediaList : function(params, context, callback, callbackParams) {
//        this.callCoreApplicationMethod({
//            domainName : "FileManager",
//            methodName : "getMediaList",
//            context : context,
//            params: params,
//            paramType: ["int"],
//            callback : callback,
//            callbackParams: callbackParams
//        });
//    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Deletes a file</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the file.
     * Possible values are :
     *
     * <pre>
     * {Number} the identifier of the file.
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   removal successful
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -3  unknown file identifier
     * &nbsp;&nbsp; -6  permission denied
     * &nbsp;&nbsp; -7  the file does not exist
     * }
     * </pre>
     */
    deleteFile : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "deleteFile",
            context : args.context,
            params: args.params,
            paramType: ["int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Renames a file</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the new name of the file
     * &nbsp;&nbsp;{String} the new path of the file
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   rename successful
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -3  unknown file identifier
     * &nbsp;&nbsp; -4  already exists
     * &nbsp;&nbsp; -5  name already exists
     * &nbsp;&nbsp; -6  permission denied
     * }
     * </pre>
     */
    renameFile : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "renameFile",
            context : args.context,
            params: args.params,
            paramType: ["int", "QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

	moveFileToDevice : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "moveFileToDevice",
            context : args.context,
            params: args.params,
            paramType: ["int", "enum"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method adds a category of files.<br>
     * By default, 4 categories will be created on module installation:<br>
     * Other : all the files which are not supported by the phone<br>
     * Audio : it gathers files with extensions like jpg,bmp,gif and png<br>
     * Picture : it gathers files with extensions like ogg, mp3 and wav<br>
     * Web Radio : it gathers url and all informations related to the link:name of the radio,...<br></b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the name of the category
     * &nbsp;&nbsp;{Number} the rank of the category
     * &nbsp;&nbsp;{Boolean} false means the user can't suppress the category
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   insertion successful
     * &nbsp;&nbsp; -14  order
     * &nbsp;&nbsp; -15 the category already exists
     * }
     * </pre>
     */
	addFileCategory : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "addFileCategory",
            context : args.context,
            params: args.params,
            paramType: ["FileCategory"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>information of a category</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets all the information of a category  which is passed as an argument</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the name of the category
     *
     * <pre>
     * {String} the name of the category
     * </pre>
     *
     * The callback will be called with a JSON with the folloing structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
	getFileCategory : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getFileCategory",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method modifies a category</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   modification successful
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -2 the category does not exist
     * &nbsp;&nbsp; -14 the order of the category must be >= 0
     * &nbsp;&nbsp; -15 the category already exists
     * }
     * </pre>
     */
	modifyFileCategory : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "modifyFileCategory",
            context : args.context,
            params: args.params,
            paramType: ["FileCategory"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method deletes a FileCategory according to its identifier. All the FileType linked with
     * this category will be removed. All the File will be attached to the 'Other' category with
	 * a FileType 'unknown'</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the category to delete.
     *
     * <pre>
     * {Number} the identifier of the category to delete
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   deletion successful
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -2 the category does not exist
     * &nbsp;&nbsp; -6 the permission is denied : the category can not be deleted
     * }
     * </pre>
     */
	deleteFileCategory : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "deleteFileCategory",
            context : args.context,
            params: args.params,
            paramType: ["int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of File</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets all the files corresponding to the category in argument.
     * If the index is incorrect, an empty list will be return. The startInd must be positive.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     *
     * <pre>
     * {
     * {String} the name of the category
     * {Number} ndex of the first category to return (0 for the first one)
     * {Number} the number of categories to return
     * }
     * </pre>
     *
     * The callback will be called with a list of File, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;url {String} file URL.
     * &nbsp;&nbsp;rights {String} file access rights. Possible users: USER,GROUP,OTHER. Possible access rights for each user: 'r', 'w', 'x'.
     * &nbsp;&nbsp;size {Number} total size of the file in bytes.
     * &nbsp;&nbsp;device {String} device in which the file is located: 'USERSPACE', 'System' and 'USB'.
     * &nbsp;&nbsp;category {Object} the file category in which the current file is classified.
     * &nbsp;&nbsp;typeFile {Object} type of the file.
     * &nbsp;&nbsp;isLink {Number} defines if a file is a link or not. Possible values: -1 value for an empty file object, 0 the file is not a link, 1 the file is a link.
     * &nbsp;&nbsp;name {String} short name of the file, e.g. without it's full path.
     * &nbsp;&nbsp;streaming {Boolean} if TRUE the file is a streaming source, FALSE otherwise.
     * }
     * </pre>
     *
     * The typeFile parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileType {Number} identifier of the current file type
     * &nbsp;&nbsp;extension {String} extension associated to the current file type (ex: mp3)
     * &nbsp;&nbsp;header {String} associate header (magic number) for the current file type (ex: audio/mpeg)
     * &nbsp;&nbsp;category {Object} associated file category to the current file type
     * }
     * </pre>
     *
     * The category parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
	getFileDescriptions : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getFileDescriptions",
            context : args.context,
            params: args.params,
            paramType: ["QString","int","int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of File</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets all the files according to different criteria</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * {String} the name of the category. If the name does not match with any of the stored categories, an empty list is returned.
     * {Number} index of the first File to return (0 for the first one), has to be positive.
     * {Number} the number of File to return, has to be positive.
     * {String} a list of type (actually, the magic number) to select, separeted by the special character ";"(for instance : "audio/mpeg;audio/x-wav").
     * {String} the list of the device identifier separated by the special character ";" (for instance : "0;1")
     * }
     * </pre>
     *
     * Possible value of the device identifier are:
     * <pre>
     * {
     * &nbsp;&nbsp;0 for local disk
     * &nbsp;&nbsp;1 for the USB key
     * }
     * <pre>
     *
     * The callback will be called with a list of File, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;url {String} file URL.
     * &nbsp;&nbsp;rights {String} file access rights. Possible users: USER,GROUP,OTHER. Possible access rights for each user: 'r', 'w', 'x'.
     * &nbsp;&nbsp;size {Number} total size of the file in bytes.
     * &nbsp;&nbsp;device {String} device in which the file is located: 'USERSPACE', 'System' and 'USB'.
     * &nbsp;&nbsp;category {Object} the file category in which the current file is classified.
     * &nbsp;&nbsp;typeFile {Object} type of the file.
     * &nbsp;&nbsp;isLink {Number} defines if a file is a link or not. Possible values: -1 value for an empty file object, 0 the file is not a link, 1 the file is a link.
     * &nbsp;&nbsp;name {String} short name of the file, e.g. without it's full path.
     * &nbsp;&nbsp;streaming {Boolean} if TRUE the file is a streaming source, FALSE otherwise.
     * }
     * </pre>
     *
     * The typeFile parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileType {Number} identifier of the current file type
     * &nbsp;&nbsp;extension {String} extension associated to the current file type (ex: mp3)
     * &nbsp;&nbsp;header {String} associate header (magic number) for the current file type (ex: audio/mpeg)
     * &nbsp;&nbsp;category {Object} associated file category to the current file type
     * }
     * </pre>
     *
     * The category parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
	getFilesWithFilter : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getFilesWithFilter",
            context : args.context,
            params: args.params,
            paramType: ["QString","int","int", "QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>result status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method returns the total number of files present in category 'nameCategory'</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the name of the category.
     *
     * <pre>
     * {String} name of the category
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   total number of files
     * &nbsp;&nbsp; -2 the category does not exist
     * }
     * </pre>
     */
	getFilesInCategorySize : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getFilesInCategorySize",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method checks if a file exists according to its path</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the full path of the file.
     *
     * <pre>
     * {String} the full path of the file
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; true   the file already exists
     * &nbsp;&nbsp; false  it does not exist
     * }
     * </pre>
     */
	fileExists : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "fileExists",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This methods copy a file to a specified device. If successful, the event {@link #FILE_LIST_CHANGED} is fired.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{Number} the identifier of the file
     * &nbsp;&nbsp;{Number} the device where the file will be copied
     * &nbsp;&nbsp;{Boolean} if the destination file already exists, the FileManager will overwrite it if overwrite is true.
     * </pre>
     *
     * Possible value of the device identifier are:
     * <pre>
     * {
     * &nbsp;&nbsp;0 for local disk
     * &nbsp;&nbsp;1 for the USB key
     * }
     * <pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   copy successful
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -3  unknown file identifier
     * &nbsp;&nbsp; -6  the permission is denied
     * &nbsp;&nbsp; -8  the file is a link
     * &nbsp;&nbsp; -9  the file is already on device
     * &nbsp;&nbsp; -10 the USB key is not connected
     * &nbsp;&nbsp; -11 unknown device identifier
     * &nbsp;&nbsp; -12 the device is full
     * &nbsp;&nbsp; -13 the file exists but overwrite forbidden
     * }
     * </pre>
     */
	copyFileToDevice : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "copyFileToDevice",
            context : args.context,
            params: args.params,
            paramType: ["int","int","bool"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method adds a new file type which will be managed by the category.<br>
     * All the files of these type will be displayed in the selected category.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the name of the category
     * &nbsp;&nbsp;{String}  the filname extension (ex : wav, gif ,...)
     * &nbsp;&nbsp;{String} the magic number of this type of file (ex: audio/x-wav, image/gif, ...)
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   insertion successful
     * &nbsp;&nbsp; -2  the category does not exist
     * &nbsp;&nbsp; -18  the file type already exists
     * }
     * </pre>
     */
	addFileTypeToCategory : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "addFileTypeToCategory",
            context : args.context,
            params: args.params,
            paramType: ["QString","QString","QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method adds a new pool. This new pool can be used by webapp application.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params contains the name of the pool.
     *
     * <pre>
     * {String} the name of the pool, <b>the length of the name of the pool must be less or equal to 45 characters</b>
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   insertion successful
     * &nbsp;&nbsp; -16  the pool already exists
     * }
     * </pre>
     */
	addPool : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "addPool",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method checks if a file is stored into a pool</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the name of the pool
     * &nbsp;&nbsp;{Number} :the File identifier
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 1   the file is in pool
     * &nbsp;&nbsp; 0   the file does not exist in pool
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -7  the file does not exist
     * &nbsp;&nbsp; -17 the pool does not exist
     * }
     * </pre>
     */
	fileExistsInPool : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "fileExistsInPool",
            context : args.context,
            params: args.params,
            paramType: ["QString", "int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method save a link into the FileManager
     * If the operation is successful , the event {@link #FILE_LIST_CHANGED} is sent.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the url of the link
     * &nbsp;&nbsp;{String} :the category associated with the link
     * &nbsp;&nbsp;{String} the name of the link
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   insertion successful
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -2  the category does not exist
     * &nbsp;&nbsp; -4  the url already exists
     * &nbsp;&nbsp; -5  the name already existst
     * }
     * </pre>
     */
	putLinkUnderFMControl : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "putLinkUnderFMControl",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method copies the File on the local disk of the device.
     * If the operation is successful , the event {@link #FILE_LIST_CHANGED} is sent.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params contains the full path of the File.
     *
     * <pre>
     * {String} the full path of the File
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   identifier of the File
     * &nbsp;&nbsp; -1  technical problem
     * &nbsp;&nbsp; -5  the name of the file already exists
     * &nbsp;&nbsp; -7  the file does not exist
     * &nbsp;&nbsp; -9  the file is already stored on the device
     * &nbsp;&nbsp; -12  the device is full
     * }
     * </pre>
     */
	putUnderFMControl : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "putUnderFMControl",
            context : args.context,
            params: args.params,
            paramType: ["QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },
	///////// TODO
	modifyLink : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "modifyLink",
            context : args.context,
            params: args.params,
            paramType: ["int", "QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method adds a file in a pool.<br>
     * The file will be both displayed in his category and in the pool.
	 * One file can be inserted in several pools.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the name of the pool
     * &nbsp;&nbsp;{String} :the path of the file
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 0   insertion successful
     * &nbsp;&nbsp; -6  permission denied
     * &nbsp;&nbsp; -7  the file does not exist
     * &nbsp;&nbsp; -17 the pool does not exist
     * }
     * </pre>
     */
	addFileInPool : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "addFileInPool",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method removes a File from a dedicated Pool.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the name of the pool
     * &nbsp;&nbsp;{String} the full path of the File to removes
     * }
     * </pre>
     *
     * The callback will be called with a status. Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; 2   technical problem
     * &nbsp;&nbsp; 0   deletion successful
     * &nbsp;&nbsp; -6  permission denied: can not remove the file
     * &nbsp;&nbsp; -7  the file does not exist
     * &nbsp;&nbsp; -17 the pool does not exist
     * }
     * </pre>
     */
	removeFileFromPool : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "removeFileFromPool",
            context : args.context,
            params: args.params,
            paramType: ["QString", "QString"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of File</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets all the File stored into the pool passed as an argument.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the name of the pool
     * &nbsp;&nbsp;{Number} index of the first File to return (0 for the first one), has to be positive.
     * &nbsp;&nbsp;{Number} the number of File to return, has to be positive.
     * }
     * </pre>
     *
     * The callback will be called with a list of File, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;url {String} file URL.
     * &nbsp;&nbsp;rights {String} file access rights. Possible users: USER,GROUP,OTHER. Possible access rights for each user: 'r', 'w', 'x'.
     * &nbsp;&nbsp;size {Number} total size of the file in bytes.
     * &nbsp;&nbsp;device {String} device in which the file is located: 'USERSPACE', 'System' and 'USB'.
     * &nbsp;&nbsp;category {Object} the file category in which the current file is classified.
     * &nbsp;&nbsp;typeFile {Object} type of the file.
     * &nbsp;&nbsp;isLink {Number} defines if a file is a link or not. Possible values: -1 value for an empty file object, 0 the file is not a link, 1 the file is a link.
     * &nbsp;&nbsp;name {String} short name of the file, e.g. without it's full path.
     * &nbsp;&nbsp;streaming {Boolean} if TRUE the file is a streaming source, FALSE otherwise.
     * }
     * </pre>
     *
     * The typeFile parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileType {Number} identifier of the current file type
     * &nbsp;&nbsp;extension {String} extension associated to the current file type (ex: mp3)
     * &nbsp;&nbsp;header {String} associate header (magic number) for the current file type (ex: audio/mpeg)
     * &nbsp;&nbsp;category {Object} associated file category to the current file type
     * }
     * </pre>
     *
     * The category parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
    getFilesInPool : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getFilesInPool",
            context : args.context,
            callback : args.callback,
			params	: args.params,
			paramType : ["QString","int","int"],
            callbackParams: args.callbackParams
        });
        args = null;
    },

    getPoolSize : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getPoolSize",
            context : args.context,
            callback : args.callback,
			params	: args.params,
			paramType : ["QString"],
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>FileCategory</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets the FileCategory for a file thanks to the full path of the file.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params params contains the full path of the File.
     *
     * <pre>
     * {String} the full path of the File
     * </pre>
     *
     * The callback will be called with a FileCategory which contains the following structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
    getCategoryForFile : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getCategoryForFile",
            context : args.context,
            callback : args.callback,
			params	: args.params,
			paramType : ["QString"],
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>a list of FileCategory</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets all categories of file that are available between startInd and length
     * NB: if the index is incorrect, an empty list will be return. The startInd must be positive.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params is an array which contains the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;{Number} index of the first category to return (0 for the first one)
     * &nbsp;&nbsp;{Number} the number of categories to return
     * }
     * </pre>
     *
     * The callback will be called with a list of FileCategory, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
    getAllFileCategories : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getAllFileCategories",
            context : args.context,
            callback : args.callback,
			params	: args.params,
			paramType : ["int","int"],
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>String</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method gets all the magic numbers which are stored under the same category.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params params contains the name of the category.
     *
     * <pre>
     * {String} the name of the category
     * </pre>
     *
     * The callback will be called with a String.
     *
     * <pre>
     * {String} a list of magic number seperated by the special character ";", for instance : "application/ogg;audio/mpeg;audio/x-wav").
     * </pre>
     */
    getExtensions : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getExtensions",
            context : args.context,
            callback : args.callback,
			params	: args.params,
			paramType : ["QString"],
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the file</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method returns the file corresponding to the identifier passed as an argument.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * Params contains the identifier of the file to search:
     *
     * <pre>
     * {Number} the identifier of the file to search
     * </pre>
     *
     * The callback will be called with a list of File, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;url {String} file URL.
     * &nbsp;&nbsp;rights {String} file access rights. Possible users: USER,GROUP,OTHER. Possible access rights for each user: 'r', 'w', 'x'.
     * &nbsp;&nbsp;size {Number} total size of the file in bytes.
     * &nbsp;&nbsp;device {String} device in which the file is located: 'USERSPACE', 'System' and 'USB'.
     * &nbsp;&nbsp;category {Object} the file category in which the current file is classified.
     * &nbsp;&nbsp;typeFile {Object} type of the file.
     * &nbsp;&nbsp;isLink {Number} defines if a file is a link or not. Possible values: -1 value for an empty file object, 0 the file is not a link, 1 the file is a link.
     * &nbsp;&nbsp;name {String} short name of the file, e.g. without it's full path.
     * &nbsp;&nbsp;streaming {Boolean} if TRUE the file is a streaming source, FALSE otherwise.
     * }
     * </pre>
     *
     * The typeFile parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileType {Number} identifier of the current file type
     * &nbsp;&nbsp;extension {String} extension associated to the current file type (ex: mp3)
     * &nbsp;&nbsp;header {String} associate header (magic number) for the current file type (ex: audio/mpeg)
     * &nbsp;&nbsp;category {Object} associated file category to the current file type
     * }
     * </pre>
     *
     * The category parameter has the following structure :
     *
     * <pre>
     * {
     * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
     * &nbsp;&nbsp;caregoryName {String} name of the current category
     * &nbsp;&nbsp;categoryOrder {Number} order of the current category
     * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
     * }
     * </pre>
     */
    getFile : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getFile",
            context : args.context,
            callback : args.callback,
			params	: args.params,
			paramType : ["int"],
            callbackParams: args.callbackParams
        });
        args = null;
    },

	/*
	 * @ignore
	 */
	getDefaultAlarmMelody : function(args) {
		this.callCoreApplicationMethod({
            domainName : "IctFileManager",
            methodName : "getDefaultAlarmMelody",
            context : args.context,
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
	}

/**
 * @event FILE_LIST_CHANGED
 * This event is used to notify that several files have been changed.
 * @param {Object} param contains the list of the file categories, each of them following this structure:
 * <pre>
 * {
 * &nbsp;&nbsp;idFileCategory {Number} associated identifier for the current file category
 * &nbsp;&nbsp;caregoryName {String} name of the current category
 * &nbsp;&nbsp;categoryOrder {Number} order of the current category
 * &nbsp;&nbsp;deletable {Boolean} defines if a category can be deleted or not. Some categories are system defined and can not be modified by the user.
 * }
 * </pre>
 */

/**
 * @event FILE_DELETED
 * This event is used to notify that a File has been deleted.
 * @param {Number} param contains the identifier of the file that has been deleted.
 */

});

ICTouchAPI.APIServices.FileManager = new ICTouchAPI.APIServices.FileManager();
