/**
 * @class ICTouchAPI.APIServices.Email
 * @extends Object
 * @ignore
 * The Email module is in charge of all the emails features.<br>
 * It provides functions allowing users to manage their mails and receive events related to them.
 */
dojo.provide("ICTouchAPI.APIServices.Email");
dojo.declare("ICTouchAPI.APIServices.Email",[ICTouchAPI.APIServices.APIServicesBase],
{
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of all mails in database</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>the list of all mails in database corresponding to the criteria.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the search criteria.
     * 
     * <pre>
     * {String} for the search criteria.
     * </pre>
     *
     *
     * The callback will be called with the list of all mails in database, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     */            
	getAllMails : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMail",
			methodName : "getAllMails",
			context : args.context,
			params: args.params,
            paramType: ["QString"],
			callback : args.callback,
			errorCallback : args.errorCallback
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of unread mails in database</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>the list of unread mails in database corresponding to the criteria.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the search criteria.
     * 
     * <pre>
     * {String} for the search criteria.
     * </pre>
     *
     *
     * The callback will be called with the list of unread mails in database, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     */     
	getUnreadMails : function(args) {
		this.callCoreApplicationMethod({
			domainName : "IctMail",
			methodName : "getUnreadMails",
			context : args.context,
			params: args.params,
            paramType: ["QString"],
			callback : args.callback,
			errorCallback: args.errorCallback
		});
		args = null;
	},
	
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Set the mail to the "READ" status.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the id of the mail to be set as read.
     * 
     * <pre>
     * {Number} for the id of the mail
     * </pre>
     *
     *
     * The callback will be called with the status, Possible value are:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; -1 EMAIL_NOT_FOUND
     * &nbsp;&nbsp; 21 mail already Read
     * &nbsp;&nbsp; 22 mail in another status
     * &nbsp;&nbsp; 0 SUCCESS
     * }
     * </pre>
     */    	
        readMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "readMail",
            context : args.context,
            params: args.params,
            paramType: ["int"]
        });
        args = null;
    },
    
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Update mail attributes and send the event {@link #MAIL_UPDATE_NTF} containing the new MailId.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON which contains the following structure : 
     * 
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     *
     * The callback will be called with the status, Possible value are:
     *
     * <pre>
     * {                                            
     * &nbsp;&nbsp; -999 ERR_EMAIL_DISABLED 
     * &nbsp;&nbsp; 20 EMAIL_NOT_FOUND      
     * &nbsp;&nbsp; 10 MAILBOX_FULL         
     * &nbsp;&nbsp; 5 Linked file not found 
     * &nbsp;&nbsp; 2 Database error        
     * &nbsp;&nbsp; 0 SUCCESS                                           
     * }            
     * </pre>
     */        
        updateMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "updateMail",
            context : args.context,
            params: args.params,
            paramType: ["Mail"],
			errorCallback : args.errorCallback
        });
        args = null;
        },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of mails</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Search a mail and return the list of mails corresponding to the criteria.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} The search criteria
     * &nbsp;&nbsp;{Number} The page Number
     * &nbsp;&nbsp;{Number} The length of a page
     * }
     * </pre>
     *
     * The callback will be called with the list of mails in database, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     */         
		findMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "findMail",
            context : args.context,
            params: args.params,
            paramType: ["QString", "int", "int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
        },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of mails</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Search a mail and return the list of mails corresponding to the criteria. In case of error the event {@link #MAIL_FIND_ERROR_NTF} is send</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} The search criteria
     * &nbsp;&nbsp;{Number} The page Number
     * &nbsp;&nbsp;{Number} The length of a page
     * }
     * </pre>
     *
     * The callback will be called with the list of mails in database, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipient.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     */       
		findDraftMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "findDraftMail",
            context : args.context,
            params: args.params,
            paramType: ["QString", "int", "int"],
            callback : args.callback,
			errorCallback : args.errorCallback
        });
        args = null;
        },
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the eMail in database</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>The eMail in database corresponding to the id.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of mail.
     * 
     * <pre>
     * {Number} for the identifier of mail
     * </pre>
     *
     *
     * The callback will be called with the mails in database, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     */       
        getMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "getMail",
            context : args.context,
            params: args.params,
            paramType: ["int"],
			errorCallback : args.errorCallback
        });
        args = null;
        },
        
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status of the action</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Send a mail and set the mail's status to SENT, and send the event {@link #MAIL_SEND_NTF}.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the id of the mail to be sent, using configured mail server, user and password.
     * 
     * <pre>
     * {Number} the id of the mail to be sent, using configured mail server, user and password.
     * </pre>
     *
     *
     * The callback will be called with the status, Possible value are:
     *
     * <pre>
     * {                                              
     * &nbsp;&nbsp; -999 ERR_EMAIL_DISABLED 
     * &nbsp;&nbsp; 31 SERVER_ERROR             
     * &nbsp;&nbsp; 20 EMAIL_NOT_FOUND          
     * &nbsp;&nbsp; 23 EMAIL_ALREADY_SENT       
     * &nbsp;&nbsp; 10 MAILBOX_FULL             
     * &nbsp;&nbsp; 5 Linked file not found     
     * &nbsp;&nbsp; 2 Database error  
     * &nbsp;&nbsp; 0 SUCCESS                             
     * }            
     * </pre>       
     */                
        sendMail : function(args ) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "sendMail",
            context : args.context,
            params: args.params,
            paramType: ["int"],
			errorCallback :args.errorCallback
        });
        args = null;
        },
        
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status of mail saved</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Save a mail in database.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON which contains the following structure : 
     * 
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     *
     * The callback will be called with the status, Possible value are:
     *
     * <pre>
     * {                                             
     * &nbsp;&nbsp; -999  ERR_EMAIL_DISABLED    
     * &nbsp;&nbsp; 31 SERVER_ERROR             
     * &nbsp;&nbsp; 20 EMAIL_NOT_FOUND          
     * &nbsp;&nbsp; 23 EMAIL_ALREADY_SENT       
     * &nbsp;&nbsp; 10 MAILBOX_FULL             
     * &nbsp;&nbsp; 5 Linked file not found     
     * &nbsp;&nbsp; 2 Database error  
     * &nbsp;&nbsp; 0 SUCCESS                             
     * }            
     * </pre>       
     */         
		saveMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "saveMail",
            context : args.context,
            params: args.params,
            paramType: ["Mail"],
			errorCallback : args.errorCallback
        });
        args = null;
        },

        

        updateSettingValue : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "updateSettingValue",
            context : args.context,
            params: args.params,
            paramType: [],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
        },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status of deletion</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Delete a mail and send the event {@link #MAIL_DELETE_NTF}.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the id of mail to delete.
     * 
     * <pre>
     * {Number} for the id of mail to delete.
     * </pre>
     *
     *
     * The callback will be called with the status, Possible value are:
     *
     * <pre>
     * {                                     
     * &nbsp;&nbsp; -1 EMAIL_NOT_FOUND        
     * &nbsp;&nbsp; 2 Database error          
     * &nbsp;&nbsp; 0 SUCCESS                 
     * }            
     * </pre>       
     */               
        deleteMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "deleteMail",
            context : args.context,
            params: args.params,
            paramType: ["int"],
			errorCallback : args.errorCallback
        });
        args = null;
        },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status of receive</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Retrieve mails from the server and store it from the database.
     * Invoked by the Presentation on RECEIVE_MAIL_EVENT event.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON which contains the following structure : 
     * 
     * <pre>
     * {
     * &nbsp;&nbsp;_evtName {String} name of the event.
     * &nbsp;&nbsp;_argList {Object} a list of other attributes in a JSON structure
     * &nbsp;&nbsp;_argTypes {JSONO} A list of other attributes in a JSON structure
     * }
     * </pre>
     *
     *
     * The callback will be called with the status, Possible value are:
     *
     * <pre>
     * {                                             
     * &nbsp;&nbsp; -999  ERR_EMAIL_DISABLED 
     * &nbsp;&nbsp; 31 SERVER_ERROR          
     * &nbsp;&nbsp; 30 SERVER_UNREACHABLE        
     * &nbsp;&nbsp; 10 MAILBOX_FULL          
     * &nbsp;&nbsp; 2 Database error         
     * &nbsp;&nbsp; 0 SUCCESS                 
     * }       
     * </pre>       
     */                
		receiveMails : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "receiveMails",
            context : args.context
        });
        args = null;
        },
        
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status of sent</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Update and Send a mail.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON which contains the following structure : 
     * 
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     *
     *
     * The callback will be called with the status of sent, Possible value are:
     *
     * <pre>
     * {                                             
     * &nbsp;&nbsp; -999  ERR_EMAIL_DISABLED 
     * &nbsp;&nbsp; 31 SERVER_ERROR          
     * &nbsp;&nbsp; 20 EMAIL_NOT_FOUND       
     * &nbsp;&nbsp; 23 EMAIL_ALREADY_SENT    
     * &nbsp;&nbsp; 10 MAILBOX_FULL          
     * &nbsp;&nbsp; 5 Linked file not found  
     * &nbsp;&nbsp; 2 Database error         
     * &nbsp;&nbsp; 0 SUCCESS                 
     * }
     * </pre>                  
     */                                           
		saveAndSendMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "saveAndSendMail",
            context : args.context,
            params: args.params,
            paramType: ["Mail"],
			errorCallback : args.errorCallback
        });
        args = null;
        },
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>status of sent</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Update and Send a mail. Set the mail's status to SENT, and send the event {@link #MAIL_SEND_NTF}.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON which contains the following structure : 
     * 
     * <pre>
     * {
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence
     * &nbsp;&nbsp;_fromAdress {String} Address of the sender, as received in mail argument
     * &nbsp;&nbsp;_title {String} Title of the mail, as received in mail argument                                                    
     * &nbsp;&nbsp;_status {String} Status of the mail : DRAFT, SENT, READ or UNREAD.                                                 
     * &nbsp;&nbsp;_saved {Date} Date of the last modification.                                                                   
     * &nbsp;&nbsp;_sentReceived {Date} Date of the sent or receive depending of the mail status.                                 
     * &nbsp;&nbsp;_textBody {Date} Body of the mail.                                                                             
     * &nbsp;&nbsp;_formattedBody {String} Body of the mail , formatted in different format (for exemple, html part of the mail).     
     * &nbsp;&nbsp;_formattedType {String} Type of the formattedBody (Text or HTML).                                                  
     * &nbsp;&nbsp;_charset {String} Original charset of the message. The message is converted in UTF-8 before being sent on DBUS.    
     * &nbsp;&nbsp;_mailTo {Object} List of recipients.
     * &nbsp;&nbsp;_mailAtt (JSON) : List of attachments.
     * }
     * </pre>
     *
     * The parameter _mailTo has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailTo {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_toAdress {String} Recipient Address.
     * }
     * </pre>
     *
     * The parameter _mailAtt has the following structs:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;_idMailAtt {Number} Unique mail attachment identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_idMail {Number} Unique mail identifier, calculated by a database sequence.
     * &nbsp;&nbsp;_fileId {Number} ID of the file representing the attachment.
     * &nbsp;&nbsp;_mimeType {String} Mime type of the file.
     * &nbsp;&nbsp;_fileName {String} Name of the attachment.                                
     * &nbsp;&nbsp;_ignoredAttachments {Boolean} Set to true if some attachments have been ignored.                                       
     * }
     * </pre>
     *
     *
     * The callback will be called with the status of sent, Possible value are:
     *
     * <pre>
     * {                                             
     * &nbsp;&nbsp; -999  ERR_EMAIL_DISABLED 
     * &nbsp;&nbsp; 31 SERVER_ERROR          
     * &nbsp;&nbsp; 20 EMAIL_NOT_FOUND       
     * &nbsp;&nbsp; 23 EMAIL_ALREADY_SENT    
     * &nbsp;&nbsp; 10 MAILBOX_FULL          
     * &nbsp;&nbsp; 5 Linked file not found  
     * &nbsp;&nbsp; 2 Database error         
     * &nbsp;&nbsp; 0 SUCCESS                 
     * }
     * </pre>                  
     */          
		updateAndSendMail : function(args) {
        this.callCoreApplicationMethod({
            domainName : "IctMail",
            methodName : "updateAndSendMail",
            context : args.context,
            params: args.params,
            paramType: ["Mail"]
        });
        args = null;
        }

/**
 * @event MAILBOX_FULL_NTF
 * This event is used to sent after various actions that fail due to reachet number of locally stored emails limit.
 */

/**
 * @event MAIL_DELETE_NTF
 * This event is used to notify that a mail was deleted.
 * @param {Object} param contains the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;status {Number} The status of deletion.
 * &nbsp;&nbsp;idMail {Number} ID of the deleted mail.
 * }
 * </pre>
 */

/**
 * @event MAIL_GET_ERROR_NTF
 * This event is used to notify that the method {@link #getAllMails} or {@link #getUnreadMails} failed.
 * @param {Number} param contains the status of action.
 */

/**
 * @event MAIL_RECEIVE_NTF
 * This event is used to notify that a mail was received.
 * @param {Object} param contains the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;status {Number} The status of deletion.
 * &nbsp;&nbsp;nbnew {Number} Number of new mail.
 * &nbsp;&nbsp;nbunread {Number} Number of unread mail.
 * &nbsp;&nbsp;nbtot {Number} Total number of mail.
 * }
 * </pre>
 */

/**
 * @event MAIL_SAVE_NTF
 * This event is used to notify that a mail was saved.
 * @param {Object} record contains the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;status {Number} The status of deletion.
 * &nbsp;&nbsp;idMail {Number} ID of the deleted mail.
 * }
 * </pre>
 */

/**
 * @event MAIL_SEND_NTF
 * This event is used to notify that a mail was send.
 * @param {Object} param contains the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;status {Number} The status of send.
 * &nbsp;&nbsp;idMail {Number} ID of the deleted mail.
 * }
 * </pre>
 */

/**
 * @event MAIL_UPDATE_NTF
 * This event is used to notify that a mail was updated.
 * @param {Object} param contains the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;status {Number} The status of update.
 * &nbsp;&nbsp;idMail {Number} ID of the deleted mail.
 * }
 * </pre>
 */

});

ICTouchAPI.APIServices.Email = new ICTouchAPI.APIServices.Email();
