/**
 * @class ICTouchAPI.APIServices.Comlog
 * @extends ICTouchAPI.APIServices.APIServicesBase
 * @singleton
 * The responsibilities of this component are :<br><br>
 * &nbsp;- Collect the information from all applications which need to be recorded. This is done
 *   by subscribing to the relevant events of these applications.<br>
 * &nbsp;- Ensure the persistence of the data by storing them in a database.<br>
 * &nbsp;- Give the list of the recordings to any other application. Several variants of the find
 *   method are available: with filter by log type, and/or by contact. The list can be sent
 *   totally or by pages.<br><br>
 * Note: the list is always sorted by date<br><br>
 * &nbsp;- Allow to mark events as read and to delete them.<br>
 * &nbsp;- Notify the ComLog presentation WebApp when the ComLog is changed.<br>
 * &nbsp;- Notify the top bar each time the count of unread logs of a given category is changed.<br>
 * &nbsp;- Delete oldest entries of the ComLog when the maximal size is reached.<br><br>
 * The ComLog application's role is to keep a track of the communication activities of the phone.
 * Each of these activities (phone call, incoming voicemail, Callback request, etc) is stored in
 * an internal database.
 */
dojo.provide("ICTouchAPI.APIServices.Comlog");
dojo.declare("ICTouchAPI.APIServices.Comlog",[ICTouchAPI.APIServices.APIServicesBase],
{
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>ComLogEntry entries</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Finds the entries of the ComLog matching the filter.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{Number} the status
     * &nbsp;&nbsp;{Number} the type
     * }
     * </pre>
     *
     * The callback will be called with the list of planned events, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; entryType {Object} Type of communication.
     * &nbsp;&nbsp; comLogEntryId {Number} Unique comlog entry identifier.
     * &nbsp;&nbsp; isRead {Boolean} Entry already (True) or not yet (False) read.
     * &nbsp;&nbsp; dateTime {Date} Date and time of the beginning of the logged event.
     * &nbsp;&nbsp; phoneNumber {String} Phone number of the correspondent. The string may be empty for the VM or if number is unknown.
     * &nbsp;&nbsp; comId {Number} Phone call identifier.
     * &nbsp;&nbsp; label {String} Name or phone number displayed in the ComLog summary.
     * &nbsp;&nbsp; contactId {String} Contact identifier of the correspondent if contact is defined, else correspondent's phone number.
     * &nbsp;&nbsp; endTime {Date} Date and time of the end of the logged event.
     * &nbsp;&nbsp; connectionTime {Date} Date and time of the beginning of the conversation.
     * &nbsp;&nbsp; isAnswered {Boolean} True if the call has been answered.
     * &nbsp;&nbsp; callDirection {Object} "Incoming" or "Outgoing".
     * &nbsp;&nbsp; startReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; endReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; countNew {Number} Number of new messages.
     * &nbsp;&nbsp; countOld {Number} Number of old messages.
     * &nbsp;&nbsp; com2Id {Number} Second phone call identifier.
     * &nbsp;&nbsp; wsRecordId {String} ICE comlog identifier.
     * &nbsp;&nbsp; idMail {Number} email identifier.
     * &nbsp;&nbsp; emailTitle {String} email subject.
     * &nbsp;&nbsp; conversationId {Number} Instant messaging identifier.
     * &nbsp;&nbsp; isWhiteList {Boolean} True if distant party belongs to correspondent's white list.
     * &nbsp;&nbsp; fromBossSecretary {Boolean} True if call routed to secretary phone in a manager/secretary context.
     * &nbsp;&nbsp; peerId {String} Identification of the peer in a manager/secretary context.
     * &nbsp;&nbsp; entryPriority {Object} comlog entry priority
     * }
     * </pre>
     *
     * Possible values of entryType are :
     *
     * <pre>
     * - "CallLog"          for Calllog
     * - "CallBackRequest"  for CR
     * - "VM"               for VoiceMail
     * - "Conference"       for Conference
     * - "IM"               for Instance Message
     * - "Email"            for Email
     * </pre>
     *
     * Possible value of callDirection are :
     *
     * <pre>
     * - "CALL_INCOMING"         for incoming call
     * - "CALL_OUTGOING"         for outgoing call
     * </pre>
     *
     * Possible value of startReason and endReason are :
     *
     * <pre>
     * - "CALL_REASON_NORMAL"       for a normal call
     * - "CALL_REASON_TRANSFERRED"  for a transferred call
     * </pre> 
     *   
     * Possible value of entryPriority are :
     *
     * <pre>
     * - "Low"      for low priority
     * - "Normal"   for normal priority
     * - "High"     for high priority
     * </pre>      
     */        
    findEntries : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "findEntries",
            context : args.context,
            params: args.params,
            paramType: ["int", "int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>ComLogEntry entries</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Finds the entries of the ComLog matching the filter for a given Contact.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the contact
     * &nbsp;&nbsp;{Number} the status
     * &nbsp;&nbsp;{Number} the type
     * }
     * </pre>
     *
     * The callback will be called with the list of planned events, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; entryType {Object} Type of communication.
     * &nbsp;&nbsp; comLogEntryId {Number} Unique comlog entry identifier.
     * &nbsp;&nbsp; isRead {Boolean} Entry already (True) or not yet (False) read.
     * &nbsp;&nbsp; dateTime {Date} Date and time of the beginning of the logged event.
     * &nbsp;&nbsp; phoneNumber {String} Phone number of the correspondent. The string may be empty for the VM or if number is unknown.
     * &nbsp;&nbsp; comId {Number} Phone call identifier.
     * &nbsp;&nbsp; label {String} Name or phone number displayed in the ComLog summary.
     * &nbsp;&nbsp; contactId {String} Contact identifier of the correspondent if contact is defined, else correspondent's phone number.
     * &nbsp;&nbsp; endTime {Date} Date and time of the end of the logged event.
     * &nbsp;&nbsp; connectionTime {Date} Date and time of the beginning of the conversation.
     * &nbsp;&nbsp; isAnswered {Boolean} True if the call has been answered.
     * &nbsp;&nbsp; callDirection {Object} "Incoming" or "Outgoing".
     * &nbsp;&nbsp; startReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; endReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; countNew {Number} Number of new messages.
     * &nbsp;&nbsp; countOld {Number} Number of old messages.
     * &nbsp;&nbsp; com2Id {Number} Second phone call identifier.
     * &nbsp;&nbsp; wsRecordId {String} ICE comlog identifier.
     * &nbsp;&nbsp; idMail {Number} email identifier.
     * &nbsp;&nbsp; emailTitle {String} email subject.
     * &nbsp;&nbsp; conversationId {Number} Instant messaging identifier.
     * &nbsp;&nbsp; isWhiteList {Boolean} True if distant party belongs to correspondent's white list.
     * &nbsp;&nbsp; fromBossSecretary {Boolean} True if call routed to secretary phone in a manager/secretary context.
     * &nbsp;&nbsp; peerId {String} Identification of the peer in a manager/secretary context.
     * &nbsp;&nbsp; entryPriority {Object} comlog entry priority
     * }
     * </pre>
     *
     * Possible values of entryType are :
     *
     * <pre>
     * - "CallLog"          for Calllog
     * - "CallBackRequest"  for CR
     * - "VM"               for VoiceMail
     * - "Conference"       for Conference
     * - "IM"               for Instance Message
     * - "Email"            for Email
     * </pre>
     *
     * Possible value of callDirection are :
     *
     * <pre>
     * - "CALL_INCOMING"         for incoming call
     * - "CALL_OUTGOING"         for outgoing call
     * </pre>
     *
     * Possible value of startReason and endReason are :
     *
     * <pre>
     * - "CALL_REASON_NORMAL"       for a normal call
     * - "CALL_REASON_TRANSFERRED"  for a transferred call
     * </pre>
     *
     * Possible value of entryPriority are :
     *
     * <pre>
     * - "Low"      for low priority
     * - "Normal"   for normal priority
     * - "High"     for high priority
     * </pre>
     */
    findEntriesByContact : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "findEntriesByContact",
            context : args.context,
            params: args.params,
            paramType: ["QString", "int", "int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

	 /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>ComLogEntry entries</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Finds the entries of the ComLog matching the categories.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
	 * &nbsp;&nbsp;{QStringList} Categories Array of string, each entry is on this pattern: "categoriesId:filterReadId"
	 *
     * }
     * </pre>
     *
     * The callback will be called with the list of planned events, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; entryType {Object} Type of communication.
     * &nbsp;&nbsp; comLogEntryId {Number} Unique comlog entry identifier.
     * &nbsp;&nbsp; isRead {Boolean} Entry already (True) or not yet (False) read.
     * &nbsp;&nbsp; dateTime {Date} Date and time of the beginning of the logged event.
     * &nbsp;&nbsp; phoneNumber {String} Phone number of the correspondent. The string may be empty for the VM or if number is unknown.
     * &nbsp;&nbsp; comId {Number} Phone call identifier.
     * &nbsp;&nbsp; label {String} Name or phone number displayed in the ComLog summary.
     * &nbsp;&nbsp; contactId {String} Contact identifier of the correspondent if contact is defined, else correspondent's phone number.
     * &nbsp;&nbsp; endTime {Date} Date and time of the end of the logged event.
     * &nbsp;&nbsp; connectionTime {Date} Date and time of the beginning of the conversation.
     * &nbsp;&nbsp; isAnswered {Boolean} True if the call has been answered.
     * &nbsp;&nbsp; callDirection {Object} "Incoming" or "Outgoing".
     * &nbsp;&nbsp; startReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; endReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; countNew {Number} Number of new messages.
     * &nbsp;&nbsp; countOld {Number} Number of old messages.
     * &nbsp;&nbsp; com2Id {Number} Second phone call identifier.
     * &nbsp;&nbsp; wsRecordId {String} ICE comlog identifier.
     * &nbsp;&nbsp; idMail {Number} email identifier.
     * &nbsp;&nbsp; emailTitle {String} email subject.
     * &nbsp;&nbsp; conversationId {Number} Instant messaging identifier.
     * &nbsp;&nbsp; isWhiteList {Boolean} True if distant party belongs to correspondent's white list.
     * &nbsp;&nbsp; fromBossSecretary {Boolean} True if call routed to secretary phone in a manager/secretary context.
     * &nbsp;&nbsp; peerId {String} Identification of the peer in a manager/secretary context.
     * &nbsp;&nbsp; entryPriority {Object} comlog entry priority
     * }
     * </pre>
     *
     * Possible values of entryType are :
     *
     * <pre>
     * - "CallLog"          for Calllog
     * - "CallBackRequest"  for CR
     * - "VM"               for VoiceMail
     * - "Conference"       for Conference
     * - "IM"               for Instance Message
     * - "Email"            for Email
     * </pre>
     *
     * Possible value of callDirection are :
     *
     * <pre>
     * - "CALL_INCOMING"         for incoming call
     * - "CALL_OUTGOING"         for outgoing call
     * </pre>
     *
     * Possible value of startReason and endReason are :
     *
     * <pre>
     * - "CALL_REASON_NORMAL"       for a normal call
     * - "CALL_REASON_TRANSFERRED"  for a transferred call
     * </pre>
     *
     * Possible value of entryPriority are :
     *
     * <pre>
     * - "Low"      for low priority
     * - "Normal"   for normal priority
     * - "High"     for high priority
     * </pre>
     */
     findEntriesByCategories: function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "findEntriesByCategories",
            context : args.context,
            params: args.params,
            paramType : ["QStringList"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>ComLogEntry entries</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Finds the entries of the ComLog matching the filter for a given Contact.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{String} the contact
     * &nbsp;&nbsp;{Number} the status
     * &nbsp;&nbsp;{Number} the type
     * &nbsp;&nbsp;{Number} the number
     * &nbsp;&nbsp;{Number} the start
     * }
     * </pre>
     *
     * The callback will be called with the list of planned events, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp; entryType {Object} Type of communication.
     * &nbsp;&nbsp; comLogEntryId {Number} Unique comlog entry identifier.
     * &nbsp;&nbsp; isRead {Boolean} Entry already (True) or not yet (False) read.
     * &nbsp;&nbsp; dateTime {Date} Date and time of the beginning of the logged event.
     * &nbsp;&nbsp; phoneNumber {String} Phone number of the correspondent. The string may be empty for the VM or if number is unknown.
     * &nbsp;&nbsp; comId {Number} Phone call identifier.
     * &nbsp;&nbsp; label {String} Name or phone number displayed in the ComLog summary.
     * &nbsp;&nbsp; contactId {String} Contact identifier of the correspondent if contact is defined, else correspondent's phone number.
     * &nbsp;&nbsp; endTime {Date} Date and time of the end of the logged event.
     * &nbsp;&nbsp; connectionTime {Date} Date and time of the beginning of the conversation.
     * &nbsp;&nbsp; isAnswered {Boolean} True if the call has been answered.
     * &nbsp;&nbsp; callDirection {Object} "Incoming" or "Outgoing".
     * &nbsp;&nbsp; startReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; endReason {Object} "normalCall" or "transferredCall".
     * &nbsp;&nbsp; countNew {Number} Number of new messages.
     * &nbsp;&nbsp; countOld {Number} Number of old messages.
     * &nbsp;&nbsp; com2Id {Number} Second phone call identifier.
     * &nbsp;&nbsp; wsRecordId {String} ICE comlog identifier.
     * &nbsp;&nbsp; idMail {Number} email identifier.
     * &nbsp;&nbsp; emailTitle {String} email subject.
     * &nbsp;&nbsp; conversationId {Number} Instant messaging identifier.
     * &nbsp;&nbsp; isWhiteList {Boolean} True if distant party belongs to correspondent's white list.
     * &nbsp;&nbsp; fromBossSecretary {Boolean} True if call routed to secretary phone in a manager/secretary context.
     * &nbsp;&nbsp; peerId {String} Identification of the peer in a manager/secretary context.
     * &nbsp;&nbsp; entryPriority {Object} comlog entry priority
     * }
     * </pre>
     *
     * Possible values of entryType are :
     *
     * <pre>
     * - "CallLog"          for Calllog
     * - "CallBackRequest"  for CR
     * - "VM"               for VoiceMail
     * - "Conference"       for Conference
     * - "IM"               for Instance Message
     * - "Email"            for Email
     * </pre>
     *
     * Possible value of callDirection are :
     *
     * <pre>
     * - "CALL_INCOMING"         for incoming call
     * - "CALL_OUTGOING"         for outgoing call
     * </pre>
     *
     * Possible value of startReason and endReason are :
     *
     * <pre>
     * - "CALL_REASON_NORMAL"       for a normal call
     * - "CALL_REASON_TRANSFERRED"  for a transferred call
     * </pre>
     *
     * Possible value of entryPriority are :
     *
     * <pre>
     * - "Low"      for low priority
     * - "Normal"   for normal priority
     * - "High"     for high priority
     * </pre>
     */
    findEntriesByContactNb : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "findEntriesByContact",
            context : args.context,
            params: args.params,
            paramType: ["QString", "int", "int", "int", "int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Deletes a ComLogEntry of the ComLog.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of ComLogEntry to delete.
     *
     * <pre>
     * {Number} for id of the ComLogEntry to delete
     * </pre>     
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
    deleteEntry : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "deleteEntry",
            context : args.context,
            params: args.params,
            paramType: ["qlonglong"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Deletes all ComLog entries.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *  
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
    deleteAll : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "deleteAll",
            context : args.context,
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Deletes ComLog entries with selected types.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains a list of couples representing the filters for the deletion of comlog entries. Each of them has the following
     * <pre>
     * {String} logTypeFilter:readStatusFilter
     * </pre>
     *  
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     *
     * Possible values of logTypeFilter are :
     *
     * <pre>
     * - 0   for an incoming call
     * - 1   for an outgoing call
     * - 2   for an answered incoming call
     * - 3   for an answered outgoing call
     * - 4   for an unanswered incoming call
     * - 5   for an unanswered outgoing call
     * - 6   for a call back request
     * - 7   for voice mail 
     * - 8   for all kind of calls 
     * - 9   for an instant message
     * - 10  for an email
     * - 11  for a conference
     * </pre> 
     *
     * Possible valueis of readStatusFilter are :
     *
     * <pre>
     * - 0  for a not yet read comlog entry
     * - 1  for an already read comlog entry
     * - 2  for all comlog entries
     * </pre> 
     */
	deleteWithMoreFilters : function(args){
		this.callCoreApplicationMethod({
			domainName		: "Comlog",
			methodName		: "deleteWithMoreFilters",
			context			: args.context,
			params			: args.params,
			paramType		: ["QStringList"],
			callback		: args.callback,
			callbackParams	: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Marks an entry of the ComLog as read.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of ComLogEntry to be marked.
     *
     * <pre>
     * {Number} for id of the ComLogEntry to be marked
     * </pre>     
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
    markEntryAsRead : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "markEntryAsRead",
            context : args.context,
            params: args.params,
            paramType: ["qlonglong"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Marks all missed call entries of the ComLog as read.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
    readAllMissedCall : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Comlog",
            methodName : "readAllMissedCall",
            context : args.context,
            params: args.params,
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>number of events</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Counts the number of entries in the ComLog with a given read status and from a given category.</b>
     *
     * @param {Object} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;{Number} the status
     * &nbsp;&nbsp;{Number} the type
     * }
     * </pre>   
     *
     * The callback will be called with a number of events:
     *
     * <pre>
     * int {Number}
     * </pre>
     */
    count : function(args){
		this.callCoreApplicationMethod({
			domainName		: "Comlog",
			methodName		: "count",
			context			: args.context,
			params			: args.params,
			paramType		: ["int","int"],
			callback		: args.callback,
			callbackParams	: args.callbackParams
		});
		args = null;
	}
	
/**
 * @event notifyCallBackRequestCountChanged
 * This event is used to sent when the number of unread callback request ComLogEntries is changed (increased or decreased).
 * @param {Number} param The number of unread callback request entries.
 */

/**
 * @event notifyComLogChanged
 * This event is used to sent when the structure of the Comlog is changed.
 */
 
 /**
 * @event notifyComLogEntryChanged
 * This event is used to sent when the number of unread voice mail ComLogEntries is changed (increased or decreased).
 * @param {Number} param contains the number of unread voice mail entries.
 */

/**
 * @event notifyMissedCallsCountChanged
 * This event is used to sent when the number of unread unanswered incoming call ComLogEntries is changed (increased or decreased).
 * @param {Number} param contains the number of unread unanswered incoming call entries.
 */
 
 /**
 * @event notifyVoiceMailCountChanged
 * This event is used to sent when the number of unread voice mail ComLogEntries is changed (increased or decreased).
 * @param {Number} param contains the number of unread voice mail entries.
 */

});

ICTouchAPI.APIServices.Comlog = new ICTouchAPI.APIServices.Comlog();
