/**
 * @class ICTouchAPI.APIServices.Agenda
 * @extends Object
 * @ignore
 * In general there are 3 different operations that let the user to program, modify and remove a wake-up/appointment. By default the Agenda supports only one wake-up
 * and multiple appointments. The wake-up is reused every time, so it is not useful to remove it but just to modify it.
 * <br><br>A wake-up could be programmed locally, e.g. the Agenda manages it by itself. When the time for the wake-up comes, there will be a pop-up windows shown on the screen
 * with 2 or 3 buttons. These buttons let the user to manage the wake-up: STOP, REPEAT and SNOOZE. STOP stops the alarm immediately, REPEAT repeats the alarm after some time
 * interval defined by the user. SNOOZE lets the music used for a wake-up continue to play but removes the pop-up. The SNOOZE will appear only if the media source used for the
 * wake-up is a link, e.g. not a local file.
 * <br><br>A wake-up can be also a distant. In this case, Agenda is used just to contact the server delivering the telephony services. In our case the server should be an OXE. After the
 * request has been processed by OXE, Agenda do not controls anymore the wake-up. When the wake-up time comes, it is a special type of ring that is made. In this case Agenda
 * has just to update its state: turn off the wake-up led and remove the connectivity icon.
 * <br><br>Appointments are programmed always locally, e.g. managed by Agenda. Appointments can be programmed by the user himself or delivered by the Device Manager (programmed by an
 * administrator). For each appointment there is an associated notification. This notification occurs N minutes before the appointment, if there was enough time when the
 * appointment has been programmed. The appointment can be with or without alarm. When it is programmed with alarm, a pop-up will appear on the screen with 2 buttons: STOP and
 * REPEAT. STOP stops the appointments alarm and REPEAT, repeats it after some time interval defined by the user.
 */


dojo.provide("ICTouchAPI.APIServices.Agenda");
dojo.declare("ICTouchAPI.APIServices.Agenda",[ICTouchAPI.APIServices.APIServicesBase],
{
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>list of planned events</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice : in case of repetitive appointments, only the first occurrence of the event is returned.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the type of planned events to retrieve.
     * Possible values are :
     * 
     * <pre>
     * - "WAKEUP" for WakeUp instances
     * - "APPOINTMENT" for Appointment instances
     * </pre>
     *
     * The callback will be called with the list of planned events, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     */
    
    findPlannedEventByType : function(args) {
        this.callCoreApplicationMethod({
            domainName: "Agenda",
            methodName: "findPlannedEventByType",
            context: args.context,
            params: args.params,
            paramType: ["QString"],
            callback: args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the Appointment instance</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b></b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the appointment to retrieve.
     *
     * <pre>
     * {Number} the identifier of the appointment
     * </pre>
     * 
     * The callback will be called with the appointment,following this structure:
     *
     * <pre>
     * {    
     * &nbsp;&nbsp;description {String} free zone to describe the appointment.
     * &nbsp;&nbsp;place {String} The location of the appointment
     * &nbsp;&nbsp;alarmReminderDelay {Number} Delay in between the alarm and the beginning of the appointment, in minutes. Default value is 0, this value means that the alarm will start exactly at the programmed time.
     * &nbsp;&nbsp;repetitionEndDate {Date} End date for a repetitive event (inclusive). By default is not a valid date. In this case alarm will occur infinitely (daily, weekly, monthly).
     * &nbsp;&nbsp;puid {String} Identifier of the Appointment on PC side (for synchronization purpose) NB: the ICTOUCH itself doesn't initialize this field.
     * &nbsp;&nbsp;lastModificationDate {Date} Date of the last modification of the Appointment (for synchronization purpose)
     * &nbsp;&nbsp;readOnly {Boolean} boolean to check if the user is able to modify the Appointment(for synchronization purpose : this attribute is set to true when the Agenda synchronizes complex repetitive tasks.
     * &nbsp;&nbsp;                   This avoids difficult merges on PC side when the database is exported).
     * &nbsp;&nbsp;isDMAppointment {Boolean} boolean to check if the Appointment has been filled by the DM
     * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
     * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
     * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     *
     * The parameter alarm has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;param id {Number}  Alarm identifier
     * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
     * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
     * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
     * }
     * </pre>
     */
    getAppointmentById : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "getAppointmentById",
            context : args.context,
            params: args.params,
            paramType: ["int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>WakeUp instance</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b></b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the wake-up to retrieve.
     *
     * <pre>
     * {Number} the identifier of wakeup
     * </pre>
     *
     * The callback will be called with the wake-up, following this structure:
     *
     * <pre>
     * {    
     * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
     * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
     * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     *
     * The parameter alarm has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;param id {Number}  Alarm identifier
     * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
     * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
     * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
     * }
     * </pre>
     */
	getWakeUpById : function(args) {
		this.callCoreApplicationMethod({
			domainName : "Agenda",
			methodName : "getWakeUpById",
			context : args.context,
			params: args.params,
			paramType: ["int"],
			callback : args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>Appointment unique identifier</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>This method will save the appointment in the database.Then, a notification will be programmed via the scheduler,which will call notificationTriggered() on notification trigger.
     * <br>Finally, if the alarm is ON, a local alarm will be programmed via the Scheduler module, which will call localAlarmTriggered() on alarm trigger.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the event to schedule,it has the following structure:
     * <pre>
     * {    
     * &nbsp;&nbsp;description {String} free zone to describe the appointment.
     * &nbsp;&nbsp;place {String} The location of the appointment
     * &nbsp;&nbsp;alarmReminderDelay {Number} Delay in between the alarm and the beginning of the appointment, in minutes. Default value is 0, this value means that the alarm will start exactly at the programmed time.
     * &nbsp;&nbsp;repetitionEndDate {Date} End date for a repetitive event (inclusive). By default is not a valid date. In this case alarm will occur infinitely (daily, weekly, monthly).
     * &nbsp;&nbsp;puid {String} Identifier of the Appointment on PC side (for synchronization purpose) NB: the ICTOUCH itself doesn't initialize this field.
     * &nbsp;&nbsp;lastModificationDate {Date} Date of the last modification of the Appointment (for synchronization purpose)
     * &nbsp;&nbsp;readOnly {Boolean} boolean to check if the user is able to modify the Appointment(for synchronization purpose : this attribute is set to true when the Agenda synchronizes complex repetitive tasks. 
     * &nbsp;&nbsp;                   This avoids difficult merges on PC side when the database is exported).
     * &nbsp;&nbsp;isDMAppointment {Boolean} boolean to check if the Appointment has been filled by the DM
     * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
     * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
     * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     *
     * The parameter alarm has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;param id {Number}  Alarm identifier
     * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
     * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
     * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
     * }
     * </pre>
     *
     * The callback will be called with the Appointment unique identifier
     * <pre>
     * {Number} the Appointment unique identifier
     * </pre>
     */
    addPlannedAppointment : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "addPlannedEvent",
            context : args.context,
            params: args.params,
            paramType: ["Appointment"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>Wakeup unique identifier</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br>This method will save the wakeUp in the database.</b>
     * <br>Then, if the alarm is ON :
     * <br>-in a local context, the alarm will be programmed via the Scheduler module,which will call localAlarmTriggered() on alarm trigger;
     * <br>-in a distant context, the alarm will be scheduled via SIPUA. The alarm itself is managed like a automatic incoming call made by the PABX.
     *
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the event to schedule,it has the following structure:
     * <pre>
     * {    
     * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
     * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
     * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     *
     * The parameter alarm has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;param id {Number}  Alarm identifier
     * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
     * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
     * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
     * }
     * </pre>  
     *
     * The callback will be called with the Wakeup unique identifier
     * <pre>
     * {Number} the Wakeup unique identifier
     * </pre>
     */
 
	addPlannedWakeUp : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "addPlannedEvent",
            context :args.context,
            params: args.params,
            paramType: ["WakeUp"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice: this method will update the appointment in the database.
     * If necessary, the notification will be reprogrammed via the scheduler, which will call notificationTriggered() on notification trigger.</b>
     * <br><br>If the alarm was deactivated (previously ON, now OFF),the associated task will be removed from the Scheduler.
     * <br><br>If the alarm was activated (previously OFF, now ON),the alarm will be programmed via the Scheduler module,which will call localAlarmTriggered() on alarm trigger;
     * <br><br>If the appointment time changed and the alarm stayed ON,the alarm will be reprogrammed via the Scheduler module,which will call localAlarmTriggered() on alarm trigger;
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the event to schedule,it has the following structure:
     * <pre>
     * {    
     * &nbsp;&nbsp;description {String} free zone to describe the appointment.
     * &nbsp;&nbsp;place {String} The location of the appointment
     * &nbsp;&nbsp;alarmReminderDelay {Number} Delay in between the alarm and the beginning of the appointment, in minutes. Default value is 0, this value means that the alarm will start exactly at the programmed time.
     * &nbsp;&nbsp;repetitionEndDate {Date} End date for a repetitive event (inclusive). By default is not a valid date. In this case alarm will occur infinitely (daily, weekly, monthly).
     * &nbsp;&nbsp;puid {String} Identifier of the Appointment on PC side (for synchronization purpose) NB: the ICTOUCH itself doesn't initialize this field.
     * &nbsp;&nbsp;lastModificationDate {Date} Date of the last modification of the Appointment (for synchronization purpose)
     * &nbsp;&nbsp;readOnly {Boolean} boolean to check if the user is able to modify the Appointment(for synchronization purpose : this attribute is set to true when the Agenda synchronizes complex repetitive tasks. 
     * &nbsp;&nbsp;                   This avoids difficult merges on PC side when the database is exported).
     * &nbsp;&nbsp;isDMAppointment {Boolean} boolean to check if the Appointment has been filled by the DM
     * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
     * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
     * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     *
     * The parameter alarm has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;param id {Number}  Alarm identifier
     * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
     * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
     * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
     * }
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
	 */
    modifyPlannedAppointment : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "modifyPlannedEvent",
            context : args.context,
            params: args.params,
            paramType: ["Appointment"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice: this method will update the wakeup in the database.
     * <br>If necessary, the notification will be reprogrammed via the scheduler, which will call notificationTriggered() on notification trigger.</b>
     * <br><br>If the alarm was deactivated (previously ON, now OFF) :
     * <br>-in a local context, the alarm will be removed from the Scheduler module,
     * <br>-in a distant context, tje alarm will be cancelled by a call to SIPUA.
     * <br><br>If the alarm was activated (previously OFF, now ON), the alarm will be programmed via the Scheduler module or SIPUA, according to the local/distant context (see addPlannedEvent).
     *
     * <br><br>If the wakeUp time changed and the alarm stayed ON :
     * <br>-in a local context, the alarm will be reprogrammed via the Scheduler module,which will call localAlarmTriggered() on alarm trigger;
     * <br>-in a distant context, the alarm will be rescheduled via SIPUA.
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is a JSON,representing the event to schedule,it has the following structure:
     * <pre>
     * {    
     * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
     * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
     * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
     * &nbsp;&nbsp;id {Number} event identifier
     * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
     * &nbsp;&nbsp;label {String} Short description of the planned event
     * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
     * }
     * </pre>
     *
     * The parameter alarm has the following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;param id {Number}  Alarm identifier
     * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
     * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
     * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
     * }
     * </pre>  
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
	modifyPlannedWakeUp : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "modifyPlannedEvent",
            context : args.context,
            params: args.params,
            paramType: ["WakeUp"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice : this method will remove the PlannedEvent from the database.</b>
     * <br><br>If the planned event is an instance of WakeUp,this method will remove the wakeUp from the database.
     * <br>If necessary, the alarm will be canceled :
     * <br>-in a local context, by removing the associated Scheduler task;
     * <br>-in a distant context, by calling SIPUA to remove it.
     * <br><br>If the planned event is an instance of Appointment,this method will remove the appointment from the database.
     * <br>The Scheduler task associated to the notification(s) will be deleted.If necessary, the alarm will also be canceled,by removing the associated task from the Scheduler.
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;plannedEventType {String}  the type of the PlannedEvent to delete
     * &nbsp;&nbsp;plannedEventId {Number} the identifier of the PlannedEvent to delete
     * }
     * </pre>
     *
     * params plannedEventType possible values are :     * 
     * <pre>
     * - "WAKEUP" for WakeUp instances
     * - "APPOINTMENT" for Appointment instances,
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
    removePlannedEvent : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "removePlannedEvent",
            context : args.context,
            params: args.params,
            paramType: ["QString","int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice : Stop the alarm definitively</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the alarm to stop.
     * 
     * <pre>
     *  {Number} for the identifier of the alarm
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */
    stopAlarm : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "stopAlarm",
            context : args.context,
            params: args.params,
            paramType: ["int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice : stop the alarm and schedule the next ringing if necessary</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the alarm to repeat.
     * <pre>
     * {Number} for the identifier of the alarm
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */    
    repeatAlarm : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "repeatAlarm",
            context : args.context,
            params: args.params,
            paramType: ["int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },
    
    /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b></b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     * <b><br><br>Important notice : Only available for a webradio : stop the alarm definitively but let the music play.</b>
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the identifier of the alarm to snooze.
     * 
     * <pre>
     * {Number} the identifier of the alarm
     * </pre>
     *
     * The callback will be called with a void:
     *
     * <pre>
     * void {void}
     * </pre>
     */      
    snoozeAlarm : function(args) {
        this.callCoreApplicationMethod({
            domainName : "Agenda",
            methodName : "snoozeAlarm",
            context : args.context,
            params: args.params,
            paramType: ["int"],
            callback : args.callback,
            callbackParams: args.callbackParams
        });
        args = null;
    },

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>capability of the module</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the name of the capability
     * <pre>
     * {String} the name of the capability
     * </pre>
     *
     * The callback will be called with the capability, following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String} 
     * &nbsp;&nbsp;state {Number} 
     * }
     * </pre>
     */

	getCapabilityGlobal : function(args) {
		this.callCoreApplicationMethod({
			domainName: "Agenda",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>capability of an object of the module</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params is an array which contains the following structure :
     * <pre>
     * {
     * &nbsp;&nbsp;name {String}  Name of the capability
     * &nbsp;&nbsp;listId {Number} ID of the list of capabilities
     * }
     * </pre>
     *
     * The callback will be called with the capability, following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String} 
     * &nbsp;&nbsp;state {Number} 
     * }
     * </pre>
     */

	getCapabilityInstance : function(args) {
		this.callCoreApplicationMethod({
			domainName: "Agenda",
			methodName: "getCapability",
			context: args.context,
			params: args.params,
			paramType: ["int", "QString"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	},

   /**
     * Executes the given callback <i>(callback)</i> within the given context <i>(context)</i> with the <b>the list of capability of an object</b> corresponding to the given parameters <i>(params)</i> along with additional callback parameters <i>(callbackParams)</i>.
     *
     * @param {JSON} args The following structure:
     * <pre>
     * {
     * &nbsp;&nbsp;params {Object} The function parameters. See below for the details
     * &nbsp;&nbsp;context {Object} the webapp context
     * &nbsp;&nbsp;callback {Function} The webapp callback
     * &nbsp;&nbsp;callbackParams: The additional callback parameters or null
     * }
     * </pre>
     *
     * params contains the ID of the list of capabilities
     * <pre>
     * {Number} the ID of the list of capabilities
     * </pre>
     *
     * The callback will be called with a map of capabilities indexed by name, each of them following this structure:
     *
     * <pre>
     * {
     * &nbsp;&nbsp;name {String} 
     * &nbsp;&nbsp;state {Number} 
     * }
     * </pre>
     */

	getCapabilities : function(args) {
		this.callCoreApplicationMethod({
			domainName: "Agenda",
			methodName: "getCapabilities",
			context: args.context,
			params: args.params,
			paramType: ["int"],
			callback: args.callback,
			callbackParams: args.callbackParams
		});
		args = null;
	}
	
/**
 * @event AgendaContentChanged 
 * This event is used to notify that the Agenda's content has changed. Example: an appointment is added, modified or deleted.
 */	
	
/**
 * @event AlarmStarted 
 * This event is used to notify that a wake-up alarm is started.
 * @param {JSON} param contains a reference to the object wake-up which alarm has started. To check if the event is corresponding to the real alarm state of the wake-up, you can explore the value of the 'alarmState' variable of wakeUp, 
 * following the structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
 * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
 * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
 * &nbsp;&nbsp;id {Number} event identifier
 * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
 * &nbsp;&nbsp;label {String} Short description of the planned event
 * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * }
 * </pre>
 *
 * The parameter alarm has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;param id {Number}  Alarm identifier
 * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
 * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
 * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
 * }
 * </pre>
 */
 
/**
 * @event AlarmStopped
 * This event is used to notify that a wake-up alarm is stopped.
 * @param {JSON} param contains a reference to the object wake-up which alarm has stopped. To check if the event is corresponding to the real alarm state of the wake-up, you can explore the value of the 'alarmState' variable of wakeUp,
 * following the structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
 * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
 * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
 * &nbsp;&nbsp;id {Number} event identifier
 * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
 * &nbsp;&nbsp;label {String} Short description of the planned event
 * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * }
 * </pre>
 *
 * The parameter alarm has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;param id {Number}  Alarm identifier
 * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
 * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
 * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
 * }
 * </pre>
 */


/**
 * @event AlarmState
 * This event is used to notify that the wake-up alarm state has changed to ON or to OFF.
 * @param {JSON} param contains a reference to the object wake-up which alarm has changed its state.
 * To check what is the state of the alarm, you should access the internal variable of wakeUp - 'alarmState',
 * following the structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
 * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
 * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
 * &nbsp;&nbsp;id {Number} event identifier
 * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
 * &nbsp;&nbsp;label {String} Short description of the planned event
 * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * }
 * </pre>
 *
 * The parameter alarm has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;param id {Number}  Alarm identifier
 * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
 * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
 * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
 * }
 * </pre>
 */
	
/**
 * @event  PlannedEventNotification
 * This event is used to send a notification to remind that an apppointment will start soon.
 * @param {JSON} param contains a reference to the object appointment that has been notified,
 * following the structure:
 * <pre>
 * {    
 * &nbsp;&nbsp;description {String} free zone to describe the appointment.
 * &nbsp;&nbsp;place {String} The location of the appointment
 * &nbsp;&nbsp;alarmReminderDelay {Number} Delay in between the alarm and the beginning of the appointment, in minutes. Default value is 0, this value means that the alarm will start exactly at the programmed time.
 * &nbsp;&nbsp;repetitionEndDate {Date} End date for a repetitive event (inclusive). By default is not a valid date. In this case alarm will occur infinitely (daily, weekly, monthly).
 * &nbsp;&nbsp;puid {String} Identifier of the Appointment on PC side (for synchronization purpose) NB: the ICTOUCH itself doesn't initialize this field.
 * &nbsp;&nbsp;lastModificationDate {Date} Date of the last modification of the Appointment (for synchronization purpose)
 * &nbsp;&nbsp;readOnly {Boolean} boolean to check if the user is able to modify the Appointment(for synchronization purpose : this attribute is set to true when the Agenda synchronizes complex repetitive tasks. 
 * &nbsp;&nbsp;                   This avoids difficult merges on PC side when the database is exported).
 * &nbsp;&nbsp;isDMAppointment {Boolean} boolean to check if the Appointment has been filled by the DM
 * &nbsp;&nbsp;alarm {JSON} associated alarm to the planned event.See the description below
 * &nbsp;&nbsp;notificationIdentifier {Number} identifier to the associated notification to the planned event.
 * &nbsp;&nbsp;repetitionPeriod {String} "OCCUR_ONE_TIME" or "OCCUR_DAILY" or "OCCUR_WEEKLY" or "OCCUR_MONTHLY"
 * &nbsp;&nbsp;id {Number} event identifier
 * &nbsp;&nbsp;type {String} "TYPE_WAKEUP" or "TYPE_APPOINTMENT"
 * &nbsp;&nbsp;label {String} Short description of the planned event
 * &nbsp;&nbsp;beginDate {Date} Begin date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * &nbsp;&nbsp;endDate {Date}  End date of the event. NB: For a WakeUp, time is only useful. Date is not taken into account
 * }
 * </pre>
 *
 * The parameter alarm has the following structure:
 * <pre>
 * {
 * &nbsp;&nbsp;param id {Number}  Alarm identifier
 * &nbsp;&nbsp;idFile {Number} File identifier used to define the audio file used for the present alarm.
 * &nbsp;&nbsp;volume {Number}  volume level for the alarm's music
 * &nbsp;&nbsp;idCapabilities {Number} identifier of the associated capabilities of the present alarm.
 * }
 * </pre>
 */
	
	
});

ICTouchAPI.APIServices.Agenda = new ICTouchAPI.APIServices.Agenda();
