/**
 * @class ICTouchAPI.APIServices.APIServicesBase
 * @abstract
 * Abstract Class for all API Services - Do not use it directly
 *
 * Create API Interface Service.
 *
 * ICTGate services Path is HTTP://localhost:80/services/ : absolute HTTP://localhost:80/ : relative:services/
 * ICTouchAPI.APIServices=new ICTouchAPI.APIServices("HTTP://localhost:80/","services/");
 */
dojo.provide("ICTouchAPI.APIServices.APIServicesBase");
dojo.declare("ICTouchAPI.APIServices.APIServicesBase",null,
	{
	//defined in ICTouchAPI.main function
	_absolutePath:ICTouchAPI.applicationsCallURI,
	_relativePath:"services/",

	/**
	* @ignore
	*/
	constructor:function(){
		this._absolutePath = ICTouchAPI.applicationsCallURI;
	},

	/**
	 * Translates a javascript request into a http request for the ICTGate code application
	 * @param {String} domainName : called service/module (i.e. : telephony)
	 * @param {String} methodName : called method in service/module (i.e : makeCall)
	 * @param {Function} callback   : function to be called when response occurs
	 * @param {Array} params[]   : json required parameters for the methodName
	 * @returns response (must be json) is sent to callback function
	 */
	callCoreApplicationMethod : function(args){
		var url = this._absolutePath + this._relativePath + args.domainName + "/" + args.methodName;

		var json = {};
		if (args.params) {
			for (var i in args.params) {
				var subObj = {};
				if(typeof(args.paramType[i])=="object"){
					subObj['type'] = args.paramType[i].type;
					subObj['format'] = args.paramType[i].format;
					subObj['value'] = args.params[i];

				}else if(args.paramType[i] == 'QStringList'){
					subObj['type'] = "QString";
					subObj['format'] = 'list';
					subObj['value'] = args.params[i];
				} else {
					subObj['type'] = args.paramType[i];
					subObj['value'] = args.params[i];
				}

				json['json'+i] = dojo.toJson(subObj);
			}
		}

		dojo.xhrGet({
			url: url,
			handleAs: 'json',
			content: json,
			sync : (args.sync ? args.sync : false),
			load: function(data,ioArgs){
				var json = "";
				if (data && data.error == "false") {
					if (args.context && args.callback && typeof args.callback == "function") {
						args.context.__tempMethod__ = dojo.hitch(args.context, args.callback);
						json = data ? data.value : data;
						if (data && data.error == "true") {
							console.error("Error from business call: " + data.value);
							console.error("URL: " + ioArgs.url);
							if (args.errorCallback && typeof args.errorCallback == "function")
								args.context.__tempMethod__ = dojo.hitch(args.context, args.errorCallback);
							else
							{
								// clear the JSon
								json = {};
							}
						}

						// always call the callback
						args.context.__tempMethod__(json, args.callbackParams);
						delete args.context.__tempMethod__;
					}
				}
				else {
					json = data ? data.value : data;
					var func;
					if (args.context && args.errorCallback && typeof args.errorCallback == "function") {
						func = dojo.hitch(args.context, args.errorCallback);
						func(json, args.callbackParams);
					}
					else if (args.context && args.callback && typeof args.callback == "function") {
						func = args.context.__tempMethod__ = dojo.hitch(args.context, args.callback);
						func({}, args.callbackParams);
					}
				}
				args = null;
				data = null;
				ioArgs = null;
			},

			error: function(error, ioArgs){
				if (args.context && args.errorCallback && typeof args.errorCallback == "function") {
					var func = dojo.hitch(args.context, args.errorCallback);
					func({}, args.callbackParams);
				}
				// Better method for giving good errors display to developers

				if( error.stack )
					console.error(error.stack);
				else
					console.error(error);

				args = null;
				error = null;
				ioArgs = null;

			}
		});
	},

	/**
	 * @ignore
	 * Call this method with old function name and new one, it will execute it and console warn a message
	 * saying the old one is not to use anymore.
	 */
	_deprecated : function (oldName, newFunc, args) {
		console.warn(this.declaredClass + "." + oldName + " is deprecated, please use " + newFunc + " instead.");
		return this[newFunc].apply(this, args);
	}
});

//ICTouchAPI.APIServices=new ICTouchAPI.APIServices();
