/**
* @class ICTouchAPI.APIServices
* @singleton
* @ignore
*
*/
dojo.provide("ICTouchAPI.APIServices");
dojo.declare("ICTouchAPI.APIServices",null,
	
	{
	_absolutePath:ICTouchAPI.applicationsCallURI,
	_relativePath:"services/",

	constructor:function(){
		this._absolutePath = ICTouchAPI.applicationsCallURI;
	},

	/**
	 * Translates a javascript request into a http request for the ICTGate code application
	 * @param {String} domainName called service/module (i.e. : telephony)
	 * @param {String} methodName called method in service/module (i.e : makeCall)
	 * @param {Func} callback function to be called when response occurs
	 * @param {List} params[] json required parameters for the methodName
	 * @return response (must be json) is sent to callback function
         * @private
	 */
	callCoreApplicationMethod : function(args){
		if ((ICTouchAPI.devContext.simulation === true && args.simulate !== false) || args.simulate === true) {
			var func = dojo.hitch(ICTouchAPI.simulation, ICTouchAPI.simulation.fakeCallCore);
			func(args);
			return;
		}else{
			var url = this._absolutePath + this._relativePath + args.domainName + "/" + args.methodName;
			var json = {};
			if (args.params) {
				for (var i in args.params) {
					var subObj = {};
					if(args.paramType[i] == 'QStringList'){
						subObj['type'] = "QString";
						subObj['format'] = 'list';
						subObj['value'] = args.params[i];
					} else {
						subObj['type'] = args.paramType[i];
						subObj['value'] = args.params[i];
					}
					
					json['json'+i] = dojo.toJson(subObj);
				}
			}
			dojo.xhrGet({
				url: url,
				handleAs: 'json',
				content: json,

				load: function(data,ioArgs){
					var json = "";
					if (data && data.error == "false") {
						if (args.context && args.callback && typeof args.callback == "function") {
							args.context.__tempMethod__ = dojo.hitch(args.context, args.callback);
							json = data ? data.value : data;
							if (data && data.error == "true") {
								console.error("Error from business call: " + data.value);
								console.error("URL: " + ioArgs.url);
								if (args.errorCallback && typeof args.errorCallback == "function"){
									args.context.__tempMethod__ = dojo.hitch(args.context, args.errorCallback);
								}else{
									json = {};
								}
							}
							args.context.__tempMethod__(json, args.callbackParams);
							delete args.context.__tempMethod__;
						}
					}else{
						json = data ? data.value : data;
						var func;
						if (args.context && args.errorCallback && typeof args.errorCallback == "function") {
							func = dojo.hitch(args.context, args.errorCallback);
							func(json, args.callbackParams);
						}else if (args.context && args.callback && typeof args.callback == "function") {
							func = args.context.__tempMethod__ = dojo.hitch(args.context, args.callback);
							func({}, args.callbackParams);
						}
					}
				},

				error: function(error, ioArgs){
					if (args.context && args.errorCallback && typeof args.errorCallback == "function") {
						var func = dojo.hitch(args.context, args.errorCallback);
						func({}, args.callbackParams);
					}
					if( error.stack ){
						console.error(error.stack);
					}else{
						console.error(error);
					}
				}
			});
		}
	}
});

ICTouchAPI.APIServices=new ICTouchAPI.APIServices();
