function createKeysBoth(table) {
	var tr = dojo.create("tr", { }, table);
	var td = dojo.create("td", { innerHTML: "Toggle RTL", colspan: 3 }, tr);
	dojo.connect(td, "click", toggleRTL);
	
	var tr = dojo.create("tr", { }, table);
	var td = dojo.create("td", { innerHTML: "Toggle reverseMode", colspan: 3 }, tr);
	dojo.connect(td, "click", toggleReverse);
	
	var tr = dojo.create("tr", { }, table);
	var td = dojo.create("td", { innerHTML: "Reload CSS :)", colspan: 3 }, tr);
	dojo.connect(td, "click", reloadCSS);
	
	var tr = dojo.create("tr", { }, table);
	var td = dojo.create("td", { innerHTML: "Max Depth", colspan: 3 }, tr);
	dojo.connect(td, "click", computeDepth);
	
	var arrCapabilities = ICTouchAPI.simulation.arrCapabilities;
	
	for( var cap in ICTouchAPI.simulation.arrCapabilities )
	{
		tr = dojo.create("tr", { }, table);		
		td = dojo.create("td", { innerHTML: arrCapabilities[cap].name, colspan: 3 }, tr);
		colorCell(arrCapabilities[cap].name, td);
		td.capName = arrCapabilities[cap].name;
		dojo.connect(td, "click", toggleCapability);
	}
}

function colorCell(name, td) {
	var color = "yellow";
	var arrCapabilities = ICTouchAPI.simulation.arrCapabilities;
	var index = indexByName(name);
	switch(arrCapabilities[index].value)
	{
		case 0:
			color = "green";
			break;
		case 1:
			color = "red";
			break;
	}
	
	dojo.style(td, "background", color);
}

function indexByName(name) {
	var arrCapabilities = ICTouchAPI.simulation.arrCapabilities;
	var index = -1;
	for(var cap in arrCapabilities) {
		if(arrCapabilities[cap].name == name)
			index = cap;
	}
	return index;
}

function toggleCapability(event) {
	var capName = event.currentTarget.capName;
	var capIndex = indexByName(event.currentTarget.capName);
	var arrCap = ICTouchAPI.simulation.arrCapabilities;
	ICTouchAPI.simulation.switchCapability(capName, (arrCap[capIndex].value+1)%3);
	colorCell(capName, event.currentTarget);
}

function toggleReverse() {
	var iframe = dojo.byId("myFrame");
	var idojo = iframe.contentWindow.dojo;
	var global = idojo.byId("MainContainer");
	idojo.style(global, "display", "none");
	idojo.toggleClass(global, "reverseMode");
	setTimeout(function(){ idojo.style(global, "display", ""); }, 1);
}

function toggleRTL() {
	var iframe = dojo.byId("myFrame");
	var idojo = iframe.contentWindow.dojo;
	var global = idojo.byId("MainContainer");
	idojo.style(global, "display", "none");
	idojo.toggleClass(global, "rtlMode");
	setTimeout(function(){ idojo.style(global, "display", ""); }, 1);
}

function reloadCSS() {
	var iframe = dojo.byId("myFrame");
	var idojo = iframe.contentWindow.dojo;
	
	var list = idojo.query("head link");
	list.orphan();
	if( window.oldList == undefined )
		window.oldList = list;
	setTimeout(function(){ replaceCSS(oldList); }, 1);	
}

function replaceCSS(arrLink) {
	var add = "?value="+Math.floor(Math.random()*1000000);
	var idojo = iframe.contentWindow.dojo;
	for(var i=0; i<arrLink.length; ++i)
	{
		var domLink = arrLink[i];
		var newHref = domLink.href + add;
		var newLink = idojo.create("link", { href: newHref, rel: "stylesheet", media: "screen", type: "text/css" }, idojo.query("head")[0]);
	}
}

function computeDepth() {
	var iframe = dojo.byId("myFrame");
	var idojo = iframe.contentWindow.dojo;
	var depth = maxDepth(idojo.body());
}

function maxDepth(node) {
	var childs = dojo.query("> *", node);
	if( childs.length == 0 )
		return {"intDepth": 1, "objDepth": node};

	var depth = maxDepth(childs[0]);
	
	var maxi = depth.intDepth;
	var objDepth = depth.objDepth;
	for(var i = 1; i < childs.length; ++i)
	{
		var depth = maxDepth(childs[i]);
		if( depth.intDepth > maxi )
		{
			objDepth = depth.objDepth;
			maxi = depth.intDepth;
		}
	}
	return {"intDepth": maxi+1, "objDepth": objDepth};
}

function testICTouch() {
	var iframe = dojo.byId("myFrame");
	if( iframe.contentWindow.webapp !== undefined )
		createKeys();
	else
		setTimeout(testICTouch, 200);
}

dojo.addOnLoad(testICTouch);
