function sendUP() {
	ICTouchAPI.eventServices._corePublishEvent("SENSEKEY_UP");
}

function sendDOWN() {
	ICTouchAPI.eventServices._corePublishEvent("SENSEKEY_DOWN");
}

function sendLEFT() {
	ICTouchAPI.eventServices._corePublishEvent("SENSEKEY_LEFT");
}

function sendRIGHT() {
	ICTouchAPI.eventServices._corePublishEvent("SENSEKEY_RIGHT");
}

function sendOK() {
	ICTouchAPI.eventServices._corePublishEvent("SENSEKEY_OK");
}

function createKeys() {
	var iframe = dojo.byId("myFrame");

	if( !iframe || !iframe.contentWindow.generalConfig || !iframe.contentWindow.generalConfig.simulation )
		return;
		
	window.ICTouchAPI = iframe.contentWindow.ICTouchAPI;
	window.UIElements = iframe.contentWindow.UIElements;
	window.UIEffects = iframe.contentWindow.UIEffects;
	window.webapp = iframe.contentWindow.webapp;
	
	var div = dojo.create("div", { "id": "keyboard" }, dojo.body(), "last");
	var table = dojo.create("table", { }, div);
	var cells = [];
	for(i=0; i<3; ++i)
	{
		var row = dojo.create("tr", { }, table, "last");
		cells[i] = [];
		for(j=0; j<3; ++j)
		{
			cells[i][j] = dojo.create("td", { }, row, "last");
		}
	}
	
	cells[0][1].innerHTML = "UP";
	dojo.connect(cells[0][1], "onclick", sendUP);
	
	cells[2][1].innerHTML = "DOWN";
	dojo.connect(cells[2][1], "onclick", sendDOWN);
	
	cells[1][0].innerHTML = "LEFT";
	dojo.connect(cells[1][0], "onclick", sendLEFT);
	
	cells[1][2].innerHTML = "RIGHT";
	dojo.connect(cells[1][2], "onclick", sendRIGHT);
	
	cells[1][1].innerHTML = "OK";
	dojo.connect(cells[1][1], "onclick", sendOK);
	
	createKeysBoth(table);
}

var iframe = dojo.byId("myFrame");
iframe.contentWindow.overrideConfig = { version: "8052" };
