dojo.provide("webapp.myICWall.getViewSettingsBase");
dojo.declare("webapp.myICWall.getViewSettingsBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{

	/**
	 * Reference on the list Widget
	 */
	list:null,

	/**
	 * Reference on the category Widget
	 */
	settings:null,

	/**
	 * reference on the layout widget
	 */
	layout:null,

	/**
	 * Create the visual element
	 */
	postCreate:function(){

		// Declaration
		var data = webapp.myICWall.data;
		// On category selected callback function
		var onSelectedAppsClick = dojo.hitch(this,this.OnSelectedAppsClickCallback);
		// On webapps selected/unselected callback function
		var onSettingsClick = dojo.hitch(this,this.OnSettingClickCallback);

		data.updateAppBar(data.MAIN_STATUS);

		// Define the view layout
		this.layout = new UIElements.ApplicationMode.ThirdControl({
			objMenu: {
				name	:"webapp.myICWall.getSelectedApps",
				params:{
					callBackFunc: onSelectedAppsClick
				}
			},
			objContainer : {
				name    : "webapp.myICWall.getSettings",
				params  : {}
			},
			objContainerTitle : {
				strLabel : _("Preferences","webapp.myICWall")
			},
			objMenuTitle : {
				strLabel:_("Selected Hosted Applications","webapp.myICWall")
			}
		},this.domViewSettings);

		// Keep reference on the widgets
		this.list = this.layout.getContainer();
		this.settings = this.layout.getMenu().getContent();
		var backFunc = dojo.hitch( webapp.myICWall, webapp.myICWall.buttonCallback, data.BACK_TO_PREV);
		ICTouchAPI.AppBarServices.addExitButton("myICWall","getViewSettings",false, backFunc);
		webapp.myICWall.mainSettingsView	= this;

		// Refresh categories and apps only if server is online
		if(this.webapp.data.isServerOnline) {
			this.refreshSelectedAppsList();
		}
	},

	/* ----------------------------------- Main Functions --------------------------------------- */

	/**
	 * Refresh the installed app list
	 */
	refreshSelectedAppsList : function() {
		var data = webapp.myICWall.data;
		//Update the category list
		this.settings.update((this.webapp.data.isServerOnline) ? data.installed : []);
		webapp.myICWall.isSAppsUpdated = false;
		// Automatically select first entry
		this.settings.selectFirstEntry();
	},

	/**
	 * Refresh webapps list
	 * @param {number} hostedApp Settings of hostedApp to display
	 */
	refreshSettingsList : function(hostedApp) {
		webapp.myICWall.data.hostedAppCurrent = hostedApp;
		// On categories received callback function
		var	callback = dojo.hitch(this,this.OnSettingListReceived);
		// On categories error received callback function
		var callbackError = dojo.hitch(this,this.OnSettingListReceivedError);
		// load the category
		this.webapp.sendServiceRequest(this.webapp.data.services["getAllSettings_"+hostedApp], "", callback, callbackError, webapp.myICWall.data.strKeyAuthorization);

		hostedApp	= null;
	},

	/* ----------------------------------- Category callback ------------------------------------ */


	/* ----------------------------------- Selected app callback ------------------------------------ */

	/**
	 * Callback when clicking on a selected App
	 * @msg {string} data The item selected
	 */
	OnSelectedAppsClickCallback : function(data) {
		this.webapp.displaySpinner();
		this.refreshSettingsList(data);

		data	= null;
	},

	/* ----------------------------------- On selected app received callback ------------------------------------ */

	/**
	 * Callback
	 * On categories list received
	 * @param {string} data Data received from the server
	 */
	OnListSelectedAppsReceived : function(data) {
		// Transform data into JSON format
		//this.webapp.data.isServerOnline = true;
		var selectedApp = data.installed;
		var onSelectedAppsClick = dojo.hitch(this,this.OnSelectedAppsClickCallback);

		data	= null;
	},

	/**
	 * Callback
	 * On categories list error received
	 * @param {Object} xhrErr Data received on error
	 * @param {Object} xhrArgs IO args object
	 */
	OnListSelectedAppsReceivedError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.getViewSettingsBase - OnListSelectedAppsReceivedError / error status: " + xhrErr.status);
		this.webapp.displayErrorPopup(xhrErr,xhrArgs);

		xhrErr	= null;
		xhrArgs	= null;
	},

	/* ---------------------------- On settings received callback ---------------------------- */

	/**
	 * Callback
	 * On Webapps list received
	 * @param {string} data Data received from the server
	 */
	OnSettingListReceived : function(data) {
		//this.webapp.data.isServerOnline = true;
		var database	= webapp.myICWall.data;
		if(data.length < 1){
			database.arrTmpArrSettings = null;
			database.loadedDetails();
		}else{
			database.getSettingsValue(data);
			database.updateAppBar(database.MAIN_STATUS);
		}

		data	= null;
	},

	/**
	 * Refresh settings list
	 */
	reloadSettings : function() {
		if(this.layout.getContainer()){
			this.layout.getContainer().reload({
				objContent: {
					name: "webapp.myICWall.getSettings",
					params:{}
				}
			});
		}
	},

	/**
	 * Callback
	 * On Webapps list received
	 * @param {Object} xhrErr Data received on error
	 * @param {Object} xhrArgs IO args object
	 */
	OnSettingListReceivedError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.getViewSettingsBase - OnSettingListReceivedError / error status: " + xhrErr.status);
		this.webapp.displayErrorPopup(xhrErr, xhrArgs);
		
		xhrErr	= null;
		xhrArgs	= null;
	},

	/* ----------------------------------- Buttons callback ------------------------------------ */

	/**
	 * Refresh Callback button
	 */
	OnRefreshCallback : function() {
		// Refresh all
		this.refreshInstalledAppsList();
	},

	destroy : function() {
		this.list = null;
		delete this.list;

		this.settings = null;
		delete this.settings;

		this.layout = null;
		delete this.layout;

		this.inherited(arguments);
	}

});
