dojo.provide("webapp.myICWall.getViewBase");
dojo.declare("webapp.myICWall.getViewBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{

	/**
	 * Reference on the list Widget
	 */
	list:null,

	/**
	 * Reference on the category Widget
	 */
	category:null,

	/**
	 * reference on the layout widget
	 */
	layout:null,

	/**
	 * List of webapp
	 */
	appList: [],

	/**
	 * Create the visual element
	 */
	postCreate:function(){

		// Declaration
		var data = webapp.myICWall.data;

		// On category selected callback function
		var onCategoryClick = dojo.hitch(this,this.OnCategoryClickCallback);
		// On webapps selected/unselected callback function
		var onAppClick = dojo.hitch(this,this.OnAppClickCallback);

		data.updateAppBar(data.MAIN_STATUS);

		// Define the view layout
		this.layout = new UIElements.ApplicationMode.ThirdControl({
			menu: {
				name:"webapp.myICWall.getCategory",
				params:{
					callBackFunc: onCategoryClick
				}
			},
			container : {
				name:"webapp.myICWall.getList",
				params:{
					callBackFunc: onAppClick
				}
			},
			objContainerTitle : {
				strLabel : _("Web applications","webapp.myICWall")
			},
			objMenuTitle : {
				strLabel: _("Categories","webapp.myICWall")
			}
		},this.domView);

		// Keep reference on the widgets
		this.list		= this.layout.getContainer();
		this.category	= this.layout.getMenu().getContent();

		webapp.myICWall.mainView	= this;

		// Refresh categories and apps only if server is online
		if(data.isServerOnline) {
			this.refreshCategoriesList();
		}
	},

	/* ----------------------------------- Main Functions --------------------------------------- */

	/**
	 * Refresh the category list
	 */
	refreshCategoriesList : function() {
		//test if mail is stored in settings
		if(this.webapp.checkLoginSettings()){
			this.getCategoriesList();
		}else{
			this.webapp.displayPopupLogin();
		}

	// load the category
	},

	getCategoriesList : function(){
		// On categories received callback function
		var callback = dojo.hitch(this,this.OnListReceived);
		// On categories error received callback function
		var callbackError = dojo.hitch(this,this.OnListReceivedError);
		var strParams = "company.id=" + this.webapp.data.getCompanyID();
		this.webapp.sendServiceRequest(this.webapp.data.services["categories"], strParams, callback, callbackError,this.webapp.data.strKeyAuthorization);
	},

	/**
	 * Refresh webapps list
	 * @param {number} category The category to display
	 */
	refreshWebappsList : function(category) {
		var data	= webapp.myICWall.data;
		// On categories received callback function
		var	callback = dojo.hitch(this,this.OnWebappsListReceived);
		// On categories error received callback function
		var callbackError = dojo.hitch(this,this.OnWebappsListReceivedError);

		// load the category
		if(category != "") {
			this.webapp.sendServiceRequest(this.webapp.data.services["applications"], "category.id=" + category, callback, callbackError, data.strKeyAuthorization);
		} else {
			this.webapp.sendServiceRequest(this.webapp.data.services["applications"], "", callback, callbackError, data.strKeyAuthorization);
		}
		
		category	= null;
	},

	/* ----------------------------------- Category callback ------------------------------------ */

	/**
	 * Callback when clicking on an app
	 * @msg {string} data The item selected
	 */
	OnAppClickCallback : function(index) {

		this.webapp.displaySpinner();
		var data	= webapp.myICWall.data;
		// Get the selectList
		var selectList = this.layout.getContainer().getContent().selectList;
		// Get the selected items
		var selected = selectList.getSelected();
		// Check if item is selected or not
		var found = false;
		for(var i=0, len=selected.length; i < len ; i++) {
			if(selected[i] == index) {
				found = true;
				break;
			}
		}

		var funcCallback		= dojo.hitch(webapp.myICWall, webapp.myICWall.updateInstalledApps);
		var funcCallbackError	= dojo.hitch(webapp.myICWall, webapp.myICWall.updateInstalledAppsError);

		//Inform server of modifications done on installed/uninstalled apps
		if(found) {
			var content = '{"refs":["/applications/'+selectList.arrItems[index].app.id+'"],"type":"ADD"}';
			this.webapp.sendServiceRequest(this.webapp.data.services["install"], "", funcCallback, funcCallbackError, data.strKeyAuthorization, content );//"user="+data.strSessionID+"&app=" + selectList.arrItems[index].app.id
		} else {
			var content = '{"refs":["/applications/'+selectList.arrItems[index].app.id+'"],"type":"REMOVE"}';
			this.webapp.sendServiceRequest(this.webapp.data.services["uninstall"], "", funcCallback, funcCallbackError, data.strKeyAuthorization, content);
		}

		index	= null;
	},

	/* ----------------------------------- Category callback ------------------------------------ */

	/**
	 * Callback when clicking on a category
	 * @msg {string} data The item selected
	 */
	OnCategoryClickCallback : function(data) {
		this.webapp.displaySpinner();
		this.refreshWebappsList(data);

		data	= null;
	},

	/* ----------------------------------- On Categories received callback ------------------------------------ */

	/**
	 * Callback
	 * On categories list received
	 * @param {string} data Data received from the server
	 */
	OnListReceived : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.getViewBase - OnListReceived");

		//this.webapp.data.isServerOnline = true;
		//Update the category list
		this.category.update(data);

		// Automatically select first entry
		this.category.selectFirstEntry();

		data	= null;
	},

	/**
	 * Callback
	 * On categories list error received
	 * @param {Object} err Data received on error
	 */
	OnListReceivedError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.getViewBase - OnListReceivedError / error status: " + xhrErr.status);
		this.webapp.displayErrorPopup(xhrErr, xhrArgs);

		xhrErr	= null;
		xhrArgs	= null;
	},

	/* ---------------------------- On Webapps received callback ---------------------------- */

	/**
	 * Callback
	 * On Webapps list received
	 * @param {string} data Data received from the server
	 */
	OnWebappsListReceived : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.getViewBase - OnWebappsListReceived");
		try{
			var dataBase	= webapp.myICWall.data;
			//dataBase.isServerOnline = true;
			var onAppClick	= dojo.hitch(this,this.OnAppClickCallback);
			this.appList = [];

			var funcButtonCallback = dojo.hitch(webapp.myICWall, webapp.myICWall.onDisplayPopupCallback);

			// Store new items
			var app	= null;
			var boolInstalled	= false;

			for (var i=0, len = data.length; i < len; i++) {
				app = data[i];
				boolInstalled	= dataBase.isInstalledWebapp(app.id);

				this.appList.push({
					intIndex: i,
					strSecondaryDesignIcon : dataBase.LABS_APP_PREFIX + app.id,
					strLabel: app.name + "&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;" + app.developer.name,
					boolSelected: boolInstalled,
					app:app,
					strActionIcon: "info-button"
				});

				var funcCallback		= dojo.hitch(this, this.addCSSToHeader, app);
				var funcCallbackError	= dojo.hitch(this, this.addDefaultCSSToHeader, app);
				
				var appName		= app.widget.path.split('.');
				var strAppName	= appName[0];

				var args = {
					method: "get",
					url: dataBase.LABS_PROTOCOL + dataBase.LABS_URL + dataBase.LABS_REPOSITORY + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-32.png",
					context: this,
					timeout: 5000,
					callback: funcCallback,
					callbackError:funcCallbackError
				};

				ICTouchAPI.HttpServices.httpRequest(args);
			}

			// Reload view
			this.list.reload({
				objTitle : {
					strLabel : _("Web applications","webapp.myICWall")
				},
				objContent : {
					name:"webapp.myICWall.getList",
					params:{
					callBackFunc: onAppClick,
					items: this.appList,
					buttonCallback:funcButtonCallback
				}
				}
			});
			dataBase.updateAppBar(dataBase.MAIN_STATUS);
		}catch(err){
			this.webapp.removeSpinner();
			ICTouchAPI.debugServices.error("webapp.myICWall.getViewBase - OnWebappsListReceived / error catched: " + err.toString());
		}

		data	= null;
	},

	/**
	 * Create all rules for apps button
	 * @param {Object}	app	The application
	 */
	addCSSToHeader : function(app) {
		// Create a new CSS rule
		var appName		= app.widget.path.split('.');
		var strAppName	= appName[0];
		var data		= webapp.myICWall.data;

		ICTouchAPI.skinServices.addCssRuleToFrame(ICTouchAPI.transitionServices.getCurrentWebAppIFrame(), data.LABS_APP_PREFIX + app.id + "-32", "background-image: url('" + data.LABS_PROTOCOL + data.LABS_URL + data.LABS_REPOSITORY + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-32.png');");
		
		app	= null;
	},

	/**
	 * Create all rules for apps button
	 * @param {Object}	app	The application
	 */
	addDefaultCSSToHeader : function(app) {
		// Create a new CSS rule
		var data		= webapp.myICWall.data;
		
		ICTouchAPI.skinServices.addCssRuleToFrame(ICTouchAPI.transitionServices.getCurrentWebAppIFrame(), data.LABS_APP_PREFIX + app.id + "-32", "background-image:url('"+data.FORWARD_PROXY_IMG+"/webapp/myICWall/themes/Default/images/myicwall_generique.png');");
		
		app	= null;
	},

	/**
	 * Callback
	 * On Webapps list received
	 * @param {Object} xhrErr Data received on error
	 * @param {Object} xhrArgs IO args object
	 */
	OnWebappsListReceivedError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.getViewBase - OnWebappsListReceivedError / error status: " + xhrErr.status);
		this.webapp.removeSpinner();

		// Reload view
		var onAppClick			= dojo.hitch(this,this.OnAppClickCallback);
		this.appList			= [];
		var funcButtonCallback	= dojo.hitch(webapp.myICWall, webapp.myICWall.onDisplayPopupCallback);
		this.layout.setContainer(
			"webapp.myICWall.getList",
			{
				callBackFunc: onAppClick,
				items: this.appList,
				buttonCallback:funcButtonCallback
			}
		);
		this.webapp.displayErrorPopup(xhrErr, xhrArgs);

		xhrErr	= null;
		xhrArgs	= null;
	},

	/* ----------------------------------- Buttons callback ------------------------------------ */

	/**
	 * Refresh Callback button
	 */
	OnRefreshCallback : function() {
		// Refresh all
		this.refreshCategoriesList();
	},

	/**
	 * Destroy all items of this view
	 */
	destroy : function() {
		this.list	= null;
		delete this.list;

		this.category	= null;
		delete this.category;

		this.layout	= null;
		delete this.layout;

		this.inherited(arguments);
	}
});
