dojo.provide("webapp.myICWall.getSettingsBase");
dojo.declare("webapp.myICWall.getSettingsBase",
	[ICTouchAPI.webWidget,dojox.dtl._Templated],{
		
	// Link to settings menuList
	setList: null,


	// Callback function defined by getViewBase view
	callBackFunc: null,

	/**
	 * Dijit Widget Post Create function
	 * Create view UI elements
	 */
	postCreate:function(){
		// Declarations
		var data		= webapp.myICWall.data;
		var onSetClick = dojo.hitch(this,this.OnSettingClickCallback);

		this.setList = new UIElements.PresentationList.PresentationListControl({
							arrItems: data._arrDetails,
							boolShowLabel: true,
							showEmptyState: true,
							emptyText:_("NoSettings","webapp.myICWall")
						}, this.domSettingsList);

	},
    
	/**
	 * Callback when clicking on an app
	 * @msg {string} data The item selected
	 */
	OnSettingClickCallback : function(index) {
		//var settings = this.layout.getContainer().settings;
		ICTouchAPI.debugServices.debug("webapp.myICWall.getSettingsBase - OnSettingClickCallback / index: " + index);
		this.webapp.sendServiceRequest(this.webapp.data.services["setSetting"],
			"user="+webapp.myICWall.data.strSessionID+"&app=" + webapp.myICWall.data.hostedAppCurrent+"&settingName=" +
			this.setList.arrItems[index].app.id+"&settingValue=" + this.setList.arrItems[index].app.id);

		index	= null;
	},
                
	/**
	 * Select the first entry of the list
	 */
	selectFirstEntry : function() {
		this.setList.selectFirst();
	},

	destroy : function() {
		this.setList = null;
		delete this.setList;

		this.inherited(arguments);
	}
});
