dojo.provide("webapp.myICWall.getSelectedAppsBase");
dojo.declare("webapp.myICWall.getSelectedAppsBase",
	[ICTouchAPI.webWidget,dojox.dtl._Templated],{
	
	// Link to category menuList
	sAppsList: null,

	// Link to title ContainerTitle
	title: null,

	// Callback function defined by getViewBase view
	callBackFunc: null,
	
	/**
	 * Dijit Widget Post Create function
	 * Create view UI elements
	 */
	postCreate:function(){
		// Declarations
		var func = dojo.hitch(this, this.onSelectedAppsClick);
		
		// create an empty MenuList
		this.sAppsList = new UIElements.MenuList.MenuListControl({
			arrItems: [],
			callback: this.callBackFunc,
			showEmptyState: true,
			emptyText:_("No hosted applications selected","webapp.myICWall")
			}, this.domSelectedAppsList
		);
		this.sAppsList._emptyState.setVisibility(true);
	},
	
	/**
	 * Update the installed apps MenuList according to server results
	 */
	update: function(selectedApps) {
                // Create service for each awap
		if(selectedApps) {
			var app		= null;
			var data	= webapp.myICWall.data;

			for(var i in selectedApps) {
				app	= selectedApps[i];
								
				if(!data.services['getAllSettings_'+app.id]) {
					data.services['getAllSettings_'+app.id]	= {'url' : '/applications/'+app.id+'/settings', 'method' : 'get'};
				}
			}
		}
		// remove all items if exists
		this.sAppsList.emptyItems();
		if(this.webapp.mainSettingsView){
			webapp.myICWall.data._arrDetails = [];
			webapp.myICWall.mainSettingsView.reloadSettings();
		}
             
		// Store new items
		for (var i=0, len = selectedApps.length; i < len; i++) {
			this.sAppsList.pushItem({
				strPrimaryContent: selectedApps[i].name,
				intIndex: selectedApps[i].id
			}, true);
		}

		selectedApps	= null;
	},
	
	/**
	 * Select the first entry of the list
	 */
	selectFirstEntry : function() {
		this.sAppsList.selectFirst();
	},
                
	destroy : function() {
		this.sAppsList = null;
		delete this.sAppsList;
		this.title = null;
		delete this.title;

		this.inherited(arguments);
	}
});
