dojo.provide("webapp.myICWall.getListBase");
dojo.declare("webapp.myICWall.getListBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{
	
	// Link to the list of the web apps SelectList 
	selectList:null,
	
	// Link to the title ContainerTitle
	title: null,
	
	// Callback function defined by getViewBase view
	callBackFunc: null,
	
	// List Items
	items: [],

	// callback info button
	buttonCallback: null,
	
	/**
	 * Create the visual element
	 */
	postCreate:function(){
		// Create service for each awap
		if(this.items) {
			var app		= null;
			var data	= webapp.myICWall.data;

			for(var i in this.items) {
				app	= this.items[i].app;
				if(!data.services['manifest_'+app.id]) {
					data.services['manifest_'+app.id]		= {'url' : '/applications/'+app.id, 'method' : 'get'};
				}
				
				if(!data.services['getAllSettings_'+app.id]) {
					data.services['getAllSettings_'+app.id]	= {'url' : '/applications/'+app.id+'/settings', 'method' : 'get'};
				}
			}
		}
		
		// Create the SelectList
		this.selectList = new UIElements.SelectList.SelectListControl({
			arrItems :			this.items,
			boolMultiselect :	true,
			showEmptyState :	true,
			emptyText :			_("No web application","webapp.myICWall"),
			itemCallback :		this.callBackFunc,
			buttonCallback :	this.buttonCallback
		}, this.domList);

		this.webapp.removeSpinner();
	},

	/**
	 * Destroy Widget
	 */
	destroy : function(){
		if(this.selectList){
			this.selectList.destroy();
			this.selectList = null;
		}
		/*if(this.title) {
			this.title.destroy();
			this.title = null;
		}*/
		this.inherited(arguments);
	}
});