dojo.provide("webapp.myICWall.getCategoryBase");
dojo.declare("webapp.myICWall.getCategoryBase",
	[ICTouchAPI.webWidget,dojox.dtl._Templated],{
		
		// Link to category menuList
		catList: null,
		
		// Link to title ContainerTitle
		title: null,
		
		// Callback function defined by getViewBase view
		callBackFunc: null,
		
		/**
		 * Dijit Widget Post Create function
		 * Create view UI elements
		 */
		postCreate:function(){
			// Declarations
			var func = dojo.hitch(this, this.onCategoryClick);
			
			// create an empty MenuList
			this.catList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				callback: this.callBackFunc,
				showEmptyState: true,
				emptyText:_("No category","webapp.myICWall")
				}, this.domCategoryList
			);
		},
		
		/**
		 * Update the Category MenuList according to server results
		 */
		update: function(categories) {
			// remove all items if exists
			this.catList.emptyItems();

			if(categories.length > 0) {
				// Store new items
				for (var i=0, len = categories.length; i < len; i++) {
					this.catList.pushItem({
						strPrimaryContent: categories[i].name,
						intIndex: categories[i].id
					}, true);
				}
			}

		categories	= null;
		},
		
		/**
		 * Select the first entry of the list
		 */
		selectFirstEntry : function() {
			this.catList.selectFirst();
	},
	
	/**
	 * Destroy Widget
	 */
	destroy : function() {
		if(this.catList){
			this.catList.destroy();
			this.catList = null;
		}
	}
});
