dojo.provide("webapp.myICWall.dataBase");
dojo.declare("webapp.myICWall.dataBase",null,{

	LABS_PROTOCOL: "http://",

	/**
	 * My IC Labs default url
	 */
	LABS_URL: "",

	/**
	 * My IC Labs apps repository
	 */
	LABS_REPOSITORY: "/VHE8082/applications",

	/**
	 * My IC labs server path
	 */
	LABS_PATH: "",

	/**
	 * My IC labs namespace
	 */
	LABS_NAMESPACE: "awap",

	/**
	 * My IC labs namespace
	 */
	LABS_APP_PREFIX: "awap_",

	/**
	 * ForwardProxyURL
	 */
	FORWARD_PROXY_URL: (location.origin) ? location.origin+"/127.0.0.1/ext/" : "http://127.0.0.1/ext/",
	FORWARD_PROXY_IMG: (location.origin) ? location.origin+"/127.0.0.1/" : "http://127.0.0.1/",

	ERR_STD_POPUP_LABEL : "Error: the setting could not be saved.",
	ERR_ALT_POPUP_LABEL : null,
	
	/**
	 * Services
	 */
	services : {
		"login"			: {
			"url" : "/users",
			"method" : "get"
		},
		"password"		: {
			"url" : "/users",
			"method" : "head"
		},
		"register"		: {
			"url" : "/registrations",
			"method" : "post"
		},
		"categories"	: {
			"url" : "/categories",
			"method" : "get"
		},
		"applications"	: {
			"url" : "/applications",
			"method" : "get"
		}

	},

	/**
	 * Mac address
	 */
	strMacAddress : "",

	/**
	 * Company ID
	 */
	strCompanyID : "",

	/**
	 * User login
	 */
	strLogin : "",

	/**
	 * User passwd
	 */
	strPasswd : "",

	/**
	 * User authentification key
	 */
	strKeyAuthorization : "",

	/**
	 * setting temp
	 */
	strTmpSetting : "",

	/**
	 * settings array temp
	 */
	arrTmpArrSettings : [],


	/**
	 * Session ID
	 */
	strSessionID : "",

	/**
	 * URI returned by log request
	 */
	strURI : "",

	/**
	 * Setting1
	 */
	strSet1 : "",

	/**
	 * Setting2
	 */
	strSet2 : "",

	/**
	 * Setting3
	 */
	strSet3 : "",

	/**
	 * Settings
	 */
	settings : [],

	/**
	 * Settings details
	 */
	_arrDetails		: [],

	/**
	 * Settings callback
	 */
	_arrCallbackSettings		: [],

	/**
	 * Settings callback
	 */
	_arrCachedAwapSettings      :[],

	/**
	 * reference on the current selected hosted App
	 */
	hostedAppCurrent:null,

	/**
	 * List of installed web apps
	 */
	installed:[],

	/**
	 * List of displayed web apps
	 */
	displayed:[],

	/**
	 * Is the server Online ?
	 */
	isServerOnline: false,

	/**
	 * Is selected apps list updated ?
	 */
	isSAppsUpdated: true,

	popupMyICWall: null,
	viewToRemoveSpinner: null,
	viaPopup:false,
	boolDisplayErrorPopups:true,
	boolHomepageJustStarted:true,
	isChangingLabsURL: false,
	
	/**
	 * Status of Appbar
	 */
	MAIN_STATUS		: 0,
	PREF_STATUS		: 1,

	LOGIN			: 'LOGIN_BTN',
	REFRESH			: 'REFRESH_BTN',
	PREF			: 'PREF_BTN',
	BACK			: 'BACK_BTN',
	BACK_TO_PREV    : 'BACK_TO_PREV_BTN',

	// Enum setting rights as they are in the bdd
	SETTING_WRITABLE: 2, // RW
	SETTING_READABLE: 1, // R
	SETTING_NORIGHTS: 0, // 0

	intChoiceListSelected				: 0,
	intCurrentSetting					: 0,
	objCurrentSetting					: null,
	intCountSettingsToDisplayInDetails	: 0,

	/**
	 * Language
	 */
	_arrLanguage	: [],
	strLanguageId	: 0,
	
	/**
	 * Constructor
	 */
	constructor : function(){
		this.defineAppBar();
	},

	/**
	 * Modify url of labs
	 * @param {String} url
	 */
	setLabsUrl : function(url) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - setLabsUrl");

		if (url.search("^http://")!=-1) {
			url = url.substr(7);
		}
		else if (url.search("^https://")!=-1) {
			url = url.substr(8);
		}

		this.LABS_URL = url;
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setLabsUrl / LABS_URL is: " + this.LABS_URL);
		dojo.registerModulePath(this.LABS_NAMESPACE, this.FORWARD_PROXY_URL + this.LABS_URL + this.LABS_REPOSITORY);
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setLabsUrl / registerModulePath - LABS_NAMESPACE: " + this.LABS_NAMESPACE + ", URL: " + this.FORWARD_PROXY_URL + this.LABS_URL + this.LABS_REPOSITORY);
		url	= null;
	},

	/**
	 * Getter for url of labs
	 * @return {String} LABS_URL url
	 */
	getLabsUrl : function() {
		return this.LABS_URL;
	},
	
	/**
	 * Modify login name
	 * @param {String} loginName
	 */
	setLoginName : function(loginName) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - setLoginName");

		if(loginName != this.strLogin){
			this.oldStrLogin	= this.strLogin;
			this.strLogin		= loginName;
			if(!this.viaPopup && this.oldStrLogin) {
				webapp.myICWall.onRegistrationSetting();
			}
			else {
				this.viaPopup = false;
			}
		}
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setLoginName / oldStrLogin is: " + this.oldStrLogin);
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setLoginName / strLogin is: " + this.strLogin);
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setLoginName / viaPopup is: " + this.viaPopup);
		loginName	= null;
	},

	/**
	 * Getter for login name
	 * @return {String} strLogin login name
	 */
	getLoginName : function() {
		return this.strLogin;
	},

	/**
	 * Modify password
	 * @param {String} passwd
	 */
	setPasswd : function(passwd) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - setPasswd");
		this.strPasswd = passwd;
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setPasswd / strPasswd is: " + this.strPasswd);
		passwd	= null;
	},

	/**
	 * Getter for password
	 * @return {String} strPasswd password
	 */
	getPasswd : function() {
		return this.strPasswd;
	},

	/**
	 * Modify company ID
	 * @param {String} companyID
	 */
	setCompanyID : function(companyID) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - setCompanyID");
		this.strCompanyID = companyID;
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setCompanyID / strCompanyID is: " + this.strCompanyID);
		companyID	= null;
	},

	/**
	 * Getter for company ID
	 * @return {String} strCompanyID company ID
	 */
	getCompanyID : function() {
		return this.strCompanyID;
	},

	/**
	 * Modify mac address
	 * @param {String} macAddress
	 */
	setMacAddress : function(macAddress) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - setMacAddress");
		this.strMacAddress = macAddress;
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - setMacAddress / strMacAddress is: " + this.strMacAddress);
		macAddress	= null;
	},

	/**
	 * Getter for mac address
	 * @return {String} strMacAddress mac address
	 */
	getMacAddress : function() {
		return this.strMacAddress;
	},
	
	/**
	 * Modify language
	 * @param {Object} languageID
	 */
	_setLanguage : function(languageID) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - _setLanguage");
		this.strLanguageId	= languageID;
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - _setLanguage / strLanguageId is: " + this.strLanguageId);
		languageID	= null;
	},

	/**
	 * Modify language allowed values
	 * @param {Object} languageAllowedValues
	 */
	_setLanguageAllowedValues : function(languageAllowedValues) {
		ICTouchAPI.debugServices.info("webapp.myICWall.database - _setLanguageAllowedValues");
		this._arrLanguage	= languageAllowedValues;
		languageAllowedValues	= null;
	},

	/**
	 * Getter for language
	 * @return {String} strLanguage the code of language
	 */
	getLanguage : function() {
		var strLanguage = "en";

		for(var i in this._arrLanguage) {
			if(this._arrLanguage[i].id == this.strLanguageId) {
				strLanguage = this._arrLanguage[i].name;
			}
		}

		return strLanguage
	},

	/**
	 * Define all buttons of the appbar
	 */
	defineAppBar : function() {
		// Callback function of each button
		var func		= dojo.hitch(webapp.myICWall,webapp.myICWall.buttonCallback);

		var arrButtons	= [];	// Buttons' array of appbar

		arrButtons.push({
			strButtonName: this.REFRESH,
			strButtonLabel: _('Refresh',"webapp.myICWall"),
			strButtonIcon: 'refresh-button',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.PREF,
			strButtonLabel: _('Pref',"webapp.myICWall"),
			strButtonIcon: 'pref-button',
			callback: func
		});

		// Construction of appbar
		var appBar = ICTouchAPI.AppBarServices.getAppBar("myICWall", "getView");
		for (var k in arrButtons) {
			var objButton = new UIElements.AppButton.AppButtonControl(arrButtons[k]);
			appBar.addActionButton(objButton);
		}

		// Create the static back button
		var backFunc = dojo.hitch( webapp.myICWall, webapp.myICWall.buttonCallback, this.BACK);
		ICTouchAPI.AppBarServices.addExitButton("myICWall","getView",true, backFunc);
	},

	/**
	 * set the action bar corresponding to the status
	 * @param {Integer} status
	 */
	updateAppBar: function(status) {
		// Register action bars according to state
		this.formatAppBar(status);
		ICTouchAPI.AppBarServices.setAppBar("myICWall","getView", "getView");

		status	= null;
	},

	/**
	 * Display or not button according to the current status
	 * @param {Integer} status
	 */
	formatAppBar : function(status) {
		var appBar		= ICTouchAPI.AppBarServices.getAppBar("myICWall", "getView");
		var btnRefresh	= appBar.getButton(this.REFRESH);
		var btnPref		= appBar.getButton(this.PREF);

		btnPref.show();
		btnRefresh.show();
		status	= null;
	},

	setCurrentObj : function(intCategory, intSetting) {
		this.intCurrentSetting = intSetting;
		this.objCurrentSetting = this._arrDetails[intSetting].objSetting;
		intCategory	= null;
		intSetting	= null;
	},

	/**
	 * Callback for the settings from current activ subcategory
	 * It will fill the _arrDetails[index] with data suitable for ClickableList
	 */
	getSettingsValue : function(_arr) {
		var currentWebappName = null;
		for(var k = 0; k < this.installed.length; k++){
			if(this.installed[k].id == this.hostedAppCurrent){
				currentWebappName = this.installed[k].name;
			}
		}

		this.arrTmpArrSettings = _arr;
		this.intCountSettingsToDisplayInDetails = _arr.length;
		for(var i=0;i<_arr.length;i++){
			var	callback = dojo.hitch(this,this.OnGetSettingValueReceived);
			var	callbackError = dojo.hitch(this,this.OnGetSettingValueReceivedError);
			this.arrTmpArrSettings[i].value = "";
			webapp.myICWall.sendServiceRequest(this.services["getSetting"], "settingName="+this.arrTmpArrSettings[i].name+"&applicationName="+currentWebappName, callback, callbackError, this.strKeyAuthorization);
		}
		_arr	= null;
	},

	OnGetSettingValueReceivedError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.database - OnGetSettingValueReceivedError() / error status: " + xhrErr.status);
		if((xhrErr.dojoType && xhrErr.dojoType == "timeout") || xhrErr.status == 504) {
			ICTouchAPI.debugServices.error("webapp.myICWall.dataBase - OnGetSettingValueReceivedError / error timeout");
			webapp.myICWall.displayErrorPopup(xhrErr,xhrArgs);
		} else {
			this.intCountSettingsToDisplayInDetails = this.intCountSettingsToDisplayInDetails - 1;
			if(this.intCountSettingsToDisplayInDetails == 0){
				for(var l = 0; l < this.arrTmpArrSettings.length; l++){
					webapp.myICWall._formatToJSAndCacheSetting(this.arrTmpArrSettings[l]);
				}
				this.loadedDetails();
			}
		}
		xhrErr	= null;
		xhrArgs	= null;
	},

	OnGetSettingValueReceived : function(data) {
		ICTouchAPI.debugServices.debug("webapp.myICWall.database - OnGetSettingValueReceived() / " + data);
		//this.isServerOnline	= true;
		for(var j = 0; j < this.arrTmpArrSettings.length; j++){
			if(this.arrTmpArrSettings[j].name == data.name){
				if(data.value)
					this.arrTmpArrSettings[j].value = data.value;
				else if(data.defaultValue)
					this.arrTmpArrSettings[j].value = data.defaultValue;
				else
					this.arrTmpArrSettings[j].value = "";
			}
		}
		this.intCountSettingsToDisplayInDetails = this.intCountSettingsToDisplayInDetails - 1;
		if(this.intCountSettingsToDisplayInDetails == 0){
			for(var l = 0; l < this.arrTmpArrSettings.length; l++){
				webapp.myICWall._formatToJSAndCacheSetting(this.arrTmpArrSettings[l]);
			}
			this.loadedDetails();
		}
		data	= null;
	},

	/**
	 * Callback for the settings from current activ subcategory
	 * It will fill the _arrDetails[index] with data suitable for ClickableList
	 */
	loadedDetails : function() {
		try {
			var intIndex = 0;
			var _arr = this.arrTmpArrSettings
			var start = new Date().getTime();
			this._arrDetails = [];
			var item;

			//else for each setting returned
			for (var i in _arr) {
				//Setting enabled or not
				var enabled = true;
				//Getting the UIElement
				var objUIType = webapp.myICWall.getSettingUIType(_arr[i]);

				//Embed means to be directly accessable on the page (no lsts or toaster or  .. ) just like input text
				var func;
				if (objUIType === webapp.myICWall._UI_TYPE_EMBED && enabled) {
					item = {
						objContent: webapp.myICWall.getSettingUI(_arr[i]),
						strLabel: _(_arr[i].label, "webapp.settings"),
						boolEnabled: enabled,
						objSetting: _arr[i]
					};

					func = dojo.hitch(this, this.setCurrentObj, intIndex, this._arrDetails.length /*this._arrDetails[intIndex].length*/);
					item.callback = func;
				}
				else {
					var value = "";
					//getting the string value if was an object
					if (objUIType === webapp.myICWall._UI_TYPE_EMBED
						|| objUIType === webapp.myICWall._UI_TYPE_TOASTER)
						{
						value = webapp.myICWall.getSettingTextualValue(_arr[i]);
					}
					else if(_arr[i].typeData.name == ICTouchAPI.settingServices.TYPE_PASSWORD) {
						value = "*****";
					}
					else {
						value = webapp.myICWall.getSettingUI(_arr[i]);
					}

					item = {
						strContent: value,
						strLabel: _(_arr[i].label, "webapp.settings"),
						boolEnabled: enabled,
						objSetting: _arr[i]
					};

					if ( objUIType === webapp.myICWall._UI_TYPE_TOASTER ) {
						func = dojo.hitch(this, this.loadToaster, intIndex, this._arrDetails.length);
						item.callback = func;
					}
					else if (this.arrOverriddenSettings[_arr[i].id]) {
						item.callback = dojo.hitch(this, this.callOverridden, _arr[i]);
					}
				}

				this._arrDetails.push(item);
			}

			webapp.myICWall.mainSettingsView.reloadSettings();
			webapp.myICWall.removeSpinner();

			ICTouchAPI.debugServices.info("webapp.myICWall.database - loadedDetails / done ("+ (new Date().getTime() - start) +")");
		} catch(err) {
			webapp.myICWall.removeSpinner();
			ICTouchAPI.debugServices.error("webapp.myICWall.database - loadedDetails / error catched: " + err.toString());
		}
	},

	/*
	 * Load the toaster for edition
	 */
	loadToaster : function(intCategory, intSetting) {
		this.intCurrentSetting = intSetting;
		this.objCurrentSetting = this._arrDetails[intSetting].objSetting;
		webapp.myICWall.getToaster(this.objCurrentSetting);
		intCategory	= null;
		intSetting	= null;
	},

	buildErrorPopupLabelMinMax : function(min,max){
		if(max === undefined) {
			webapp.myICWall.data.ERR_ALT_POPUP_LABEL = [
			"ErrHigherEqual",
			""+min];
		} else if(min === undefined) {
			webapp.myICWall.data.ERR_ALT_POPUP_LABEL = [
			"ErrLowerEqual",
			""+max];
		}else {
			webapp.myICWall.data.ERR_ALT_POPUP_LABEL = [
			"ErrOutOfBound",
			""+min,
			"and",
			""+max];
		}
		min	= null;
		max	= null;
	},

	isInstalledWebapp : function(idx) {
		var boolFound	= false;

		for(var i in this.installed) {
			if(this.installed[i].id == idx) {
				boolFound = true;
			}
		}

		ICTouchAPI.debugServices.debug("webapp.myICWall.database - isInstalledWebapp / idx: " + idx + ", return " + boolFound);
		idx	= null;
		return boolFound;
	},

	getAwapIdFromName : function(strAwapName) {
		for(var i in this.installed){
			var appName		= this.installed[i].widget.path.split('.');
			var strAppName	= appName[0];
			
			if(strAppName == strAwapName) {
				return this.installed[i].id;
			}
		}
		strAwapName	= null;
	}	
});
