dojo.provide("webapp.myICWall.controlBase");
dojo.declare("webapp.myICWall.controlBase",[ICTouchAPI.webApplication],{

	/* ----------------------------------------- INITIALIZATION ---------------------------------------------------- */

	subscribeID		: null,
	mainView		: null,
	objPopup		: null,
	mainSettingsView: null,
	toasterUI		: null,
	boolRegistration: false,
	loadedWebapp : "",
	hideSubscribeID : null,

	// UI type constants
	_UI_TYPE_EMBED		: "embed",		// used for types such as boolean, texts (directly editable)
	_UI_TYPE_TOASTER	: "toaster",	// used for types that require to open a toaster such as calendar or choice
	_UI_TYPE_OTHER		: "other",		// used for types that require a specific screen, or disabled settings (no specific UI in list)
	_UI_TYPE_WEBAPP		: "webapp",

	/**
	 * @private
	 */
	_uiSpinner : null,

	/**
	 * Constructor
	 */
	constructor:function(){
		ICTouchAPI.tools.registerHomepageKey(["webapp.myICWall.getView","MYICWALL_BTN","myicwall-application","App Wall"]);

		this.subscribeID = dojo.subscribe("iframe.show",this, this.onShow);
	},

	/**
	 * Loaded function
	 */
	loaded : function() {
		// Get Setting myICLabs
		ICTouchAPI.settingServices.subscribeToSetting(this, "MyICAppLabsURL",this._onMyICAppLabsURLChanged);
		ICTouchAPI.settingServices.getSetting("MyICAppLabsURL", this, this._onGetMyICAppLabsURL);
		ICTouchAPI.settingServices.subscribeToSetting(this, "MyICAppLabsEmailAddress",this._onMyICAppLabsEmailAddressChanged);
		ICTouchAPI.settingServices.getSetting("MyICAppLabsEmailAddress", this, this._onMyICAppLabsEmailAddressChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "MyICAppLabsPassword",this._onMyICAppLabsPasswordChanged);
		ICTouchAPI.settingServices.getSetting("MyICAppLabsPassword", this, this._onGetMyICAppLabsPassword);
		ICTouchAPI.settingServices.subscribeToSetting(this, "MyICAppLabsCompanyID",this._onMyICAppLabsCompanyIDChanged);
		ICTouchAPI.settingServices.getSetting("MyICAppLabsCompanyID", this, this._onMyICAppLabsCompanyIDChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "CurrentEnetcfgMacaddr",this._onCurrentEnetcfgMacaddrChanged);
		ICTouchAPI.settingServices.getSetting("CurrentEnetcfgMacaddr", this, this._onCurrentEnetcfgMacaddrChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "Language",this._onLanguageChanged);
		ICTouchAPI.settingServices.getSetting("Language", this, this._onLanguageLoaded);
	},

	/**
	 * Load function
	 */
	load : function() {
		// Load function
	},

	/**
	 * unload function
	 */
	unload : function() {
		// Unload function
	},

	/**
	 * dump function
	 */
	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("myICWall settings :");
		ICTouchAPI.debugServices.dump(" - MyICAppLabsURL (LABS_URL): " + this.data.getLabsUrl());
		ICTouchAPI.debugServices.dump(" - MyICAppLabsEmailAddress (strLogin): " + this.data.getLoginName());
		ICTouchAPI.debugServices.dump(" - MyICAppLabsPassword (strPasswd): " + this.data.getPasswd());
		ICTouchAPI.debugServices.dump(" - MyICAppLabsCompanyID (strCompanyID): " + this.data.getCompanyID());
		ICTouchAPI.debugServices.dump(" - CurrentEnetcfgMacaddr (strMacAddress): " + this.data.getMacAddress());
		ICTouchAPI.debugServices.dump(" - Language (strLanguageId): " + this.data.strLanguageId);
		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("myICWall internal variables :");
			ICTouchAPI.debugServices.dump(" - LABS_PROTOCOL: " + this.data.LABS_PROTOCOL);
			ICTouchAPI.debugServices.dump(" - LABS_URL: " + this.data.LABS_URL);
			ICTouchAPI.debugServices.dump(" - LABS_REPOSITORY: " + this.data.LABS_REPOSITORY);
			ICTouchAPI.debugServices.dump(" - LABS_PATH: " + this.data.LABS_PATH);
			ICTouchAPI.debugServices.dump(" - LABS_NAMESPACE: " + this.data.LABS_NAMESPACE);
			ICTouchAPI.debugServices.dump(" - FORWARD_PROXY_URL: " + this.data.FORWARD_PROXY_URL);
			ICTouchAPI.debugServices.dump(" - strMacAddress: " + this.data.strMacAddress);
			ICTouchAPI.debugServices.dump(" - strLanguageId: " + this.data.strLanguageId);
			ICTouchAPI.debugServices.dump(" - _arrLanguage: ");
			for (var i in this.data._arrLanguage) {
				ICTouchAPI.debugServices.dump(" -> _arrLanguage["+i+"].id: " + this.data._arrLanguage[i].id + ", arrLanguage["+i+"].name: " + this.data._arrLanguage[i].name);
			}
			ICTouchAPI.debugServices.dump(" - Language code (getLanguage()): " + this.data.getLanguage());
			ICTouchAPI.debugServices.dump(" - strCompanyID: " + this.data.strCompanyID);
			ICTouchAPI.debugServices.dump(" - strLogin: " + this.data.strLogin);
			ICTouchAPI.debugServices.dump(" - strPasswd: " + this.data.strPasswd);
			ICTouchAPI.debugServices.dump(" - strKeyAuthorization: " + this.data.strKeyAuthorization);
			ICTouchAPI.debugServices.dump(" - strTmpSetting: " + this.data.strTmpSetting);
			ICTouchAPI.debugServices.dump(" - arrTmpArrSettings: ");
			for (var i in this.data.arrTmpArrSettings) {
				ICTouchAPI.debugServices.dump(" -> arrTmpArrSettings["+i+"]: name = " + this.arrTmpArrSettings[i].name + ", value = " + this.arrTmpArrSettings[i].value);
			}
			ICTouchAPI.debugServices.dump(" - strSessionID: " + this.data.strSessionID);
			ICTouchAPI.debugServices.dump(" - strURI: " + this.data.strURI);
			ICTouchAPI.debugServices.dump(" - strSet1: " + this.data.strSet1);
			ICTouchAPI.debugServices.dump(" - strSet2: " + this.data.strSet2);
			ICTouchAPI.debugServices.dump(" - strSet3: " + this.data.strSet3);
			ICTouchAPI.debugServices.dump(" - list of installed apps (installed):");
			for (var i = 0 ; i < this.data.installed.length ; i++) {
				ICTouchAPI.debugServices.dump(" -> installed["+i+"]: name = " + this.data.installed[i].name + ", id = " + this.data.installed[i].id);
			}
			ICTouchAPI.debugServices.dump(" - list of installed apps (displayed):");
			for (var i = 0 ; i < this.data.installed.length ; i++) {
				ICTouchAPI.debugServices.dump(" -> displayed["+i+"]: name = " + this.data.displayed[i].name + ", id = " + this.data.displayed[i].id);
			}
			ICTouchAPI.debugServices.dump(" - isServerOnline: " + this.data.isServerOnline);
			ICTouchAPI.debugServices.dump(" - isSAppsUpdated: " + this.data.isSAppsUpdated);
			ICTouchAPI.debugServices.dump(" - viaPopup: " + this.data.viaPopup);
			ICTouchAPI.debugServices.dump(" - viewToRemoveSpinner: " + this.data.viewToRemoveSpinner);
			ICTouchAPI.debugServices.dump(" - boolDisplayErrorPopups: " + this.data.boolDisplayErrorPopups);
			ICTouchAPI.debugServices.dump(" - boolHomepageJustStarted: " + this.data.boolHomepageJustStarted);
			ICTouchAPI.debugServices.dump(" - isChangingLabsURL: " + this.data.isChangingLabsURL);
		}
		boolAdvancedLogs	= null;
	},

	/**
	 * unlock function
	 */
	unlock : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - unlock");
		// Update homepage icons
		var data = webapp.myICWall.data;
		if(data.services["getInstalled"] && data.strKeyAuthorization){
			this.displaySpinner();
			this.getInstalledApps();
		}
		data.viaPopup = false;
		this.toasterUI = null;
		delete this.toasterUI;
		// Exit this webapp
		dojo.publish("unlockTransition", [true]);
	},

	/**
	 * Callback
	 * When an iframe become visible
	 */
	onShow : function(id) {
		var data = webapp.myICWall.data;
		if( id == "webapp.homepage.getHomepage" && !data.strKeyAuthorization && data.boolHomepageJustStarted) {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onShow / onShow homepage, boolHomepageJustStarted is true, KeyAuthorization is not defined -> login on the labs server");
			data.boolHomepageJustStarted = false;
			data.boolDisplayErrorPopups = false;
			// Login on labs server
			this.onLogin(true);
		} else if(id == "webapp.myICWall.getView") {
			data.boolDisplayErrorPopups = true;
			if(!data.strKeyAuthorization){
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onShow / on show myICWall, KeyAuthorization is not defined and not viaPopup -> sendServiceRequest to test if the labs server is available'");
				if (this.checkLoginSettings()) { // server is online, login and pwd are field, try to login to the app server
					this.displaySpinner();
					data.viaPopup = true; // display the popup login if the couple login/password is wrong
					this.onLogin();
				}
				else {
					this.displayPopupLogin();
				}
			} else if(data.strKeyAuthorization) {
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onShow / on show myICWall, KeyAuthorization is defined -> getInstalledApps'");
				this.displaySpinner();
				this.getInstalledApps();
			}
		} else if(data.viewToRemoveSpinner && id == data.viewToRemoveSpinner) {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onShow / on show viewToRemoveSpinner -> removeSpinner'");
			this.removeSpinner(id);
		}
		id = null;
	},

	/**
	 * Update labs url from MyICAppLabsURL setting value
	 * @param {Object} objSetting
	 */
	_onGetMyICAppLabsURL : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onGetMyICAppLabsURL");
		if(objSetting) {
			// Get server URL from setting
			this.data.setLabsUrl(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onGetMyICAppLabsURL / MyICAppLabsURL is not defined: " + objSetting);
		}
	},

	/**
	 * Get labs url from MyICAppLabsURL setting value
	 * @param {Object} objSetting
	 */
	_onMyICAppLabsURLChanged : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onMyICAppLabsURLChanged");
		if(objSetting) {
			// Get server URL from setting
			this.data.setLabsUrl(objSetting.jsValue);
			if (this.data.strPasswd) {
				// If the setting password is defined, clear password settings to use new one for the new labs server
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - _onMyICAppLabsURLChanged / Labs URL has changed, reset MyICAppLabsPassword");
				this.data.isChangingLabsURL = true;
				ICTouchAPI.settingServices.setSettingValue("MyICAppLabsPassword","");
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onMyICAppLabsURLChanged / MyICAppLabsURL is not defined: " + objSetting);
		}
		objSetting	= null;
	},

	/**
	 * Update login name from MyICAppLabsEmailAddress setting value
	 * @param {Object} objSetting
	 */
	_onMyICAppLabsEmailAddressChanged : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onMyICAppLabsEmailAddressChanged");
		if(objSetting) {
			// Get login from setting
			this.data.setLoginName(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onMyICAppLabsEmailAddressChanged / MyICAppLabsEmailAddress is not defined: " + objSetting);
		}
		objSetting	= null;
	},

	/**
	 * Update password from MyICAppLabsPasswordChanged setting value
	 * @param {Object} objSetting
	 */
	_onMyICAppLabsPasswordChanged : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onMyICAppLabsPasswordChanged");
		if(objSetting) {
			// Get passwd from setting
			this.data.setPasswd(objSetting.jsValue);
			// If we are changing the labs URL, when we receive _onMyICAppLabsPasswordChanged ask a refresh of the setting view (login/password reset)
			if (this.data.isChangingLabsURL) {
				dojo.publish("settings/reloadCurrentCategory");
				this.data.isChangingLabsURL = false;
			}
			if(!this.data.viaPopup) {
				this.displaySpinner();
				this.onLogin();
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onMyICAppLabsPasswordChanged / MyICAppLabsPassword is not defined: " + objSetting);
		}
		objSetting	= null;
	},
	
	/**
	 * Get password from MyAppLabsPasswordChanged setting value
	 * @param {Object} objSetting
	 */
	_onGetMyICAppLabsPassword : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onGetMyICAppLabsPassword");
		if(objSetting) {
			// Get passwd from setting
			this.data.setPasswd(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onGetMyICAppLabsPassword / MyICAppLabsPassword is not defined: " + objSetting);
		}
		objSetting	= null;
	},

	/**
	 * Update companyID from MyICAppLabsCompanyID setting value
	 * @param {Object} objSetting
	 */
	_onMyICAppLabsCompanyIDChanged : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onMyICAppLabsCompanyIDChanged");
		if(objSetting) {
			// Get companyID from setting
			this.data.setCompanyID(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onMyICAppLabsCompanyIDChanged / MyICAppLabsCompanyID is not defined: " + objSetting);
		}
		objSetting	= null;
	},

	/**
	 * Update mac address from CurrentEnetcfgMacaddr setting value
	 * @param {Object} objSetting
	 */
	_onCurrentEnetcfgMacaddrChanged : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onCurrentEnetcfgMacaddrChanged");
		if(objSetting) {
			// Get mac address from setting
			this.data.setMacAddress(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onCurrentEnetcfgMacaddrChanged / CurrentEnetcfgMacaddr is not defined: " + objSetting);
		}
		objSetting	= null;
	},

	/**
	 * Got language from Language setting value
	 * @param {Object} objSetting
	 */
	_onLanguageLoaded : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onLanguageLoaded");
		if(objSetting) {
			// Get language from setting
			this.data._setLanguage(objSetting.jsValue);
			this.data._setLanguageAllowedValues(objSetting.allowedValues);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onLanguageLoaded / Language is not defined: " + objSetting);
		}
		objSetting	= null;
	},

	/**
	 * Update language from Language setting value
	 * @param {Object} objSetting
	 */
	_onLanguageChanged : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _onLanguageChanged");
		if (this.data.strKeyAuthorization) {
			if(objSetting) {
				// Get language from setting
				this.data._setLanguage(objSetting.jsValue);
				this.data._setLanguageAllowedValues(objSetting.allowedValues);

				// Update Homepage buttons
				var callback = dojo.hitch(this, this.updateHomepageKeysLabel);
				webapp.myICWall.sendServiceRequest(this.data.services['getInstalled'], "", callback, null, this.data.strKeyAuthorization);
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onLanguageChanged / Language is not defined: " + objSetting);
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _onLanguageChanged / strKeyAuthorization is not defined, the phone is not logged in to the labs server");
		}
		objSetting	= null;
	},


	/* ----------------------------------------- MAIN FUNCTIONS ---------------------------------------------------- */

	/**
	 * Send the request to outside service
	 * @param {String} service The name of the service
	 * @param {String} param The parameters
	 * @param {Function} callback The callback function
	 * @param {Function} callbackError The callback function in case of error
	 * @param {String} headerAuthorization
	 * @param {Object} data
	 * @param {String} timeout
	 */
	sendServiceRequest : function(service, param, callback, callbackError, headerAuthorization, data, timeout) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - sendServiceRequest");

		// Manage the parameter
		var p = param.length > 0 ? "?" + param : "";
		var strLanguage	= this.data.getLanguage();

		// Create URL
		var url = this.data.LABS_PROTOCOL +
		this.data.LABS_URL +
		this.data.LABS_PATH +
		service.url +
		p;

		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - sendServiceRequest / url: " + url);
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - sendServiceRequest / method : " + service.method + ", timeout: " + timeout + ", headerAuthorization: " + headerAuthorization);

		var headers = {'Accept-Language' : strLanguage};
		if(headerAuthorization) {
			headers = {'Accept-Language' : strLanguage, 'Authorization' : headerAuthorization};
		}

		// Create my request
		var args = {
				method: service.method,
				url: url,
				responseType: "json",
				context: this,
				postData: data ? data : "",
				putData: data ? data : "",
				headers: headers,
				timeout: timeout ? timeout : 5000,
				callback: callback,
				callbackError:callbackError,
				callbackParams:{params:{service:service}}
		};
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - sendServiceRequest / header: " +args.headers);

		// Send my request
		ICTouchAPI.HttpServices.httpRequest(args);

		service				= null;
		param				= null;
		callback			= null;
		callbackError		= null;
		headerAuthorization	= null;
		data				= null;
		timeout				= null;
	},

	/**
	 * Display a spinner during convertion
	 */
	displaySpinner : function(viewName) {
		if(viewName){
			var data = webapp.myICWall.data;
			data.viewToRemoveSpinner = viewName;
		}
		if(!this._uiSpinner) {
			this._uiSpinner = new UIElements.Spinner.SpinnerControl({
				boolForeground:true
			}, document.body);
		}
		viewName = null;
	},

	/**
	 * Removes the spinner displayed during conversion
	 */
	removeSpinner : function(viewName) {
		if(viewName){
			var data = webapp.myICWall.data;
			data.viewToRemoveSpinner = null;
		}
		if(this._uiSpinner){
			this._uiSpinner.destroy();
			this._uiSpinner = null;
		}
		viewName = null;
	},

	/**
	 * Get the value of setting id from server
	 */
	getSetting:function(id, context, callback, callbackParams, synchro){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getSetting");
		var data = webapp.myICWall.data;
		var namespace = (context && context.declaredClass) ? context.declaredClass.split(".") : null;
		var currentWebappName = namespace[1];
		data._arrCallbackSettings[id] = {
			callback:callback,
			context :context
		};
		this.sendServiceRequest(data.services["getSetting"], "settingName="+id+"&applicationName="+currentWebappName, this._gotSetting, this._gotSettingError, data.strKeyAuthorization);

		id				= null;
		context			= null;
		callback		= null;
		callbackParams	= null;
		synchro			= null;
	},

	_gotSettingError : function (xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - _gotSettingError");
		this.displayErrorPopup(xhrErr,xhrArgs);
		xhrErr = null;
		xhrArgs = null;
	},

	_gotSetting : function (objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _gotSetting");
		//this.data.isServerOnline = true;
		var data = webapp.myICWall.data;
		var callbackParams = {
			context :   data._arrCallbackSettings[objSetting.name].context,
			callback:   data._arrCallbackSettings[objSetting.name].callback
		};
		data._arrCallbackSettings[objSetting.name].context=null;
		data._arrCallbackSettings[objSetting.name].callback=null;
		data._arrCallbackSettings[objSetting.name] = null;
		if (objSetting)
		{
			this._formatToJSAndCacheSetting(objSetting);
			if (callbackParams.callback != undefined) {
				// Call callback function with stored context and input parameters
				try{
					callbackParams.callback.apply(callbackParams.context, [objSetting, callbackParams.callbackParams]);
				}catch(err){
					ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _gotSetting / Your callback function made an error listening setting = " + dojo.toJson(this._arrCachedSettings[objSetting.id]));
					ICTouchAPI.debugServices.warning("webapp.myICWall.controlBase - _gotSetting / error: " + err.toString());
				}
			}
		}
		else if (callbackParams.callback != undefined) {
			// Call callback function with stored context and input parameters
			callbackParams.callback.apply(callbackParams.context, [null, callbackParams.callbackParams]);
		}
		objSetting = null;
	},

	/**
	 * @private
	 * Method used to format a Setting object to JS format (add jsValue and typeData attributes to object)
	 * After formatting, the Setting object is stored into the _arrCachedSettings array
	 * @param {Setting} objSetting setting object
	 */
	_formatToJSAndCacheSetting : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _formatToJSAndCacheSetting");

		// Add "typeData" object to objSetting
		objSetting.typeData = ICTouchAPI.settingServices.getSettingTypeData(objSetting);
		if (objSetting) {
			// Switch in case of jsValue must be different from value
			switch (objSetting.typeData.name) {
				case ICTouchAPI.settingServices.TYPE_ENABLER:
				case ICTouchAPI.settingServices.TYPE_BOOLEAN:
					if (objSetting.value == "true") {
						objSetting.jsValue = true;
					}
					else if (objSetting.value == "false") {
						objSetting.jsValue = false;
					}
					break;
				case ICTouchAPI.settingServices.TYPE_NUMERIC:
					objSetting.jsValue = parseInt(objSetting.value);
					break;
				case ICTouchAPI.settingServices.TYPE_IPPORT:
					objSetting.jsValue = parseInt(objSetting.value);
					break;
				case ICTouchAPI.settingServices.TYPE_LIST:
					if(objSetting.value == "")
						objSetting.jsValue = [];
					else
						objSetting.jsValue = objSetting.value.split(";");
					break;
				case ICTouchAPI.settingServices.TYPE_CHOICE:
					objSetting.jsValue = -1;
					for (var i=0; i<objSetting.allowedValues.length; i++) {
						if (objSetting.allowedValues[i].id == objSetting.value) {
							objSetting.jsValue = i;
							break;
						}
					}
					break;
				case ICTouchAPI.settingServices.TYPE_DATE: // Breakthrough
				case ICTouchAPI.settingServices.TYPE_DATETIME:
					objSetting.jsValue = new Date();
					objSetting.jsValue.setTime(objSetting.value*1000);
					break;
				case ICTouchAPI.settingServices.TYPE_TEXT:
					objSetting.jsValue = this._byteArrayToString(dojox.encoding.base64.decode(objSetting.value));
					objSetting.value = this._byteArrayToString(dojox.encoding.base64.decode(objSetting.value));
					break;
				default:
					objSetting.jsValue = objSetting.value;
					break;
			}
		}
		else
		{
			// "UNDEFINED"
			objSetting.jsValue = objSetting.value;
		}
		// always cache it
		// objSetting is now cached in _arrCachedSettings
		webapp.myICWall.data._arrCachedAwapSettings[objSetting.name] = objSetting;
		objSetting = null;
	},

	/**
	 * Get the value of setting id from server
	 */
	getSettingValue : function (id, context, callback, callbackParams, synchro) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getSettingValue");
		this.getSetting(id, context, callback, callbackParams, synchro);
		id				= null;
		context			= null;
		callback		= null;
		callbackParams	= null;
		synchro			= null;
	},

	/**
	 * Set the value of setting id from server
	 */
	setSettingValue : function (id, jsValue, context, callback, callbackParams) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - setSettingValue");
		var data = webapp.myICWall.data;
		var namespace = (context && context.declaredClass) ? context.declaredClass.split(".") : null;
		var currentWebappName = namespace[1];

		if (data._arrCachedAwapSettings[id] != undefined ) {
			if (ICTouchAPI.settingServices._isNewValueValidForSetting(data._arrCachedAwapSettings[id], jsValue)) {
				// The setting must be cloned, so that the cache is NOT updated until we receive a ChangedSettingEvent.
				// In this way the setting in cache will not be modified if the validation fails on business side.
				var clonedSetting = dojo.clone(data._arrCachedAwapSettings[id]);
				clonedSetting.jsValue = jsValue;
				clonedSetting = ICTouchAPI.settingServices._formatSettingToICTGate(clonedSetting);
				if(!data.services['setSetting_'+clonedSetting.name]) {
					data.services['setSetting_'+clonedSetting.name]	= {
						'url' : '/users/'+data.strSessionID+'/settings/'+currentWebappName+"/"+clonedSetting.name+'/value',
						'method' : 'put'
					};
				}
				this.sendServiceRequest(data.services['setSetting_'+clonedSetting.name], "", callback, null, data.strKeyAuthorization, clonedSetting.value);
			}else{

		}
		}else{

		}
		id				= null;
		context			= null;
		callback		= null;
		callbackParams	= null;
		jsValue			= null;
	},

	/**
	* Get the list of installed apps
	*/
	updateInstalledApps : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - updateInstalledApps");
		var data	= webapp.myICWall.data;
		data.isSAppsUpdated = true;
		// On categories received callback function
		var callback		= dojo.hitch(this,this.OnUpdateInstalledAppsCallback);
		// On categories error received callback function
		var callbackError	= dojo.hitch(this,this.OnUpdateInstalledAppsCallbackError);

		// Get the list of installed apps
		this.sendServiceRequest(this.data.services["getInstalled"], "user="+data.strSessionID, callback, callbackError, data.strKeyAuthorization);
	},

	updateInstalledAppsError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - updateInstalledAppsError / error status: " + xhrErr.status);
		this.displayErrorPopup(xhrErr, xhrArgs);
		xhrErr	= null;
		xhrArgs	= null;
	},

	/**
	 * Callback
 	 * Get the list of installed apps
	 */
	OnUpdateInstalledAppsCallback : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - OnUpdateInstalledAppsCallback");
		try {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - OnUpdateInstalledAppsCallback / received: " + data.length + " app(s)");

			// Server is online
			this.data.isServerOnline = true;

			this.data.installed = data;

			//Update appbar
			this.data.updateAppBar( this.data.MAIN_STATUS);
			this.removeSpinner();
		}
		catch(err) {
			this.removeSpinner();
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnUpdateInstalledAppsCallback / error catched: " + err.toString());
		}
		data = null;
	},

	OnUpdateInstalledAppsCallbackError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnUpdateInstalledAppsCallbackError / error status: " + xhrErr.status);
		this.displayErrorPopup(xhrErr,xhrArgs);
		xhrErr	= null;
		xhrArgs	= null;
	},

	/**
	 * Display description popup
	 */
	displayPopupLogin : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - displayPopupLogin");
		var data				= webapp.myICWall.data;
		this.boolRegistration	= true;
		data.viaPopup = true;
		var context = this;
		var buttons = [];

		// Create Cancel button
		buttons.push({
			strButtonName: "CANCEL_BTN",
			strButtonIcon: "generic-cancel",
			strButtonLabel : _("Cancel", "ICTouchAPI"),
			callback : function() {
				data.strTmpSetting			= null;
				context.boolRegistration	= false;
				data.viaPopup = false;
				var popupMyICWall = document.getElementById("Popup");
				popupMyICWall.style.zIndex = "15000";
				ICTouchAPI.popupServices.removePopup(context.objPopup);
				popupMyICWall = document.getElementById("Popup");
				dojo.removeClass(popupMyICWall, "stylePopupMyICWall");
				dojo.publish("OpenHomepage");
			}
		});

		// Create NEXT button
		buttons.push({
			strButtonName: "NEXT_BTN",
			strButtonIcon: "generic-next",
			strButtonLabel : _("Next", "ICTouchAPI"),
			callback : function() {
				if(!data.strTmpSetting)
					data.strTmpSetting = data.strLogin;
				if(context.checkEmail(data.strTmpSetting)) {

					// When click on Close, the popup must be removed
					ICTouchAPI.settingServices.setSettingValue("MyICAppLabsEmailAddress",data.strTmpSetting, context);
					var popupMyICWall = document.getElementById("Popup");
					popupMyICWall.style.zIndex = "15000";
					ICTouchAPI.popupServices.removePopup(context.objPopup);
					// On sessionid received callback function
					var callback = dojo.hitch(context,context.OnSetLoginCallback);
					// On sessionid error received callback function
					var callbackError = dojo.hitch(context,context.OnRegistrationCallbackError);
					// Get the list of installed apps
					var strParams	= "registration.email="+encodeURIComponent(data.strTmpSetting)+"&registration.companyId="+data.strCompanyID;
					context.sendServiceRequest(data.services["register"], strParams, callback, callbackError);
					data.strLogin = data.strTmpSetting;
					data.strTmpSetting = null;
				} else {
					context.displayErrorLogin();
				}
			}
		});

		// Create the content of the popup
		var popupData = {
			strTitle        : _("Login","webapp.myICWall"),
			strWidgetName	:  "webapp.myICWall.loginPopupView",
			arrPopupButtons : buttons
		};

		// Create and open the popup
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		var popupMyICWall = document.getElementById("Popup");
		popupMyICWall.style.zIndex = "9000";

	},

	checkEmail : function(strEmail) {
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - checkEmail / email: " + strEmail);
		var data = webapp.myICWall.data;
		if(strEmail){
			var isEmailValid = ICTouchAPI.tools.checkEmailAddress(strEmail);
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - checkEmail / 1_emailValidity :" + isEmailValid);
			return isEmailValid;
		}else if(data.strLogin){
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - checkEmail / 2_email already validate :" + data.strLogin);
			return true;
		}
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - checkEmail / 3_other case, a : " + data.strLogin + "b : " + strEmail);
		strEmail = null;
		return false;
	},

	displayErrorLogin : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - displayErrorLogin");
		var buttons = [];
		var context	= this;

		// Create Cancel button
		buttons.push({
			strButtonName: "CLOSE_BTN",
			strButtonIcon: "generic-close",
			strButtonLabel : _("Close", "webapp.myICWall"),
			callback : function() {
				ICTouchAPI.popupServices.removePopup(context.objPopupError);
			}
		});

		// Create the content of the popup
		var popupErrorData = {
			strTitle        : _("Error", "ICTouchAPI"),
			arrPopupButtons : buttons,
			strContent		: _("ErrorLoginTxt", "webapp.myICWall")
		};

		// Create and open the popup
		this.objPopupError = ICTouchAPI.popupServices.addNewPopup(popupErrorData, "MEDIUM");
	},

	/**
	 * Display description popup
	 */
	OnSetLoginCallback : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - OnSetLoginCallback");
		this.data.isServerOnline = true;//Mandatory
		ICTouchAPI.debugServices.info("myICWall::Control} : OnSetLoginCallback() - :" + data);
		this.displayPopupPasswd();
		data = null;
	},

	/**
	 * Display description popup
	 */
	displayPopupPasswd : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - displayPopupPasswd");
		var data	= webapp.myICWall.data;
		var context = this;
		var buttons = [];
		data.viaPopup = true;
		data.strTmpSetting = null;
		// Create Cancel button
		buttons.push({
			strButtonName: "CANCEL_BTN",
			strButtonIcon: "generic-cancel",
			strButtonLabel : _("Cancel", "ICTouchAPI"),
			callback : function() {
				var data2	= webapp.myICWall.data;
				data2.strTmpSetting			= null;
				data2.viaPopup				= false;
				context.boolRegistration	= false;
				var popupMyICWall = document.getElementById("Popup");
				popupMyICWall.style.zIndex = "15000";
				ICTouchAPI.popupServices.removePopup(context.objPopup);
				dojo.publish("OpenHomepage");
			}
		});

		// Create NEXT button
		buttons.push({
			strButtonName: "LOGIN_BTN",
			strButtonIcon: "generic-ok",
			strButtonLabel : _("Login", "webapp.myICWall"),
			callback : function() {
				context.boolRegistration	= false;
				// When click on Close, the popup must be removed
				var popupMyICWall = document.getElementById("Popup");
				popupMyICWall.style.zIndex = "15000";
				ICTouchAPI.popupServices.removePopup(context.objPopup);
				if(context.data.strTmpSetting == null){
					context.data.strTmpSetting = context.data.strPasswd;
				}
				// On sessionid received callback function
				var callback = dojo.hitch(context,context.onValidationPasswordCallback);
				// On sessionid error received callback function
				var callbackError = dojo.hitch(context,context.OnRegistrationPasswordCallbackError);

				// Get the list of installed apps
				var strParams	= "user.email="+context.data.strLogin+"&user.password="+dojox.encoding.base64.encode(context._stringToByteArray(context.data.strTmpSetting));

				webapp.myICWall.sendServiceRequest(context.data.services["password"], strParams, callback, callbackError);
			}
		});

		// Create the content of the popup
		var popupData = {
			strTitle		: _("Login","webapp.myICWall"),
			strWidgetName	:  "webapp.myICWall.passwordPopupView",
			arrPopupButtons : buttons
		};

		// Create and open the popup
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		var popupMyICWall = document.getElementById("Popup");
		popupMyICWall.style.zIndex = "9000";

		data = null;
	},

	onValidationPasswordCallback : function(xhrErr) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - onValidationPasswordCallback");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onValidationPasswordCallback / xhrErr: " + xhrErr);
		var data = webapp.myICWall.data;
		data.isServerOnline = true;//Mandatory
		ICTouchAPI.settingServices.setSettingValue("MyICAppLabsPassword",data.strTmpSetting,this);
		data.strKeyAuthorization = "Basic "+dojox.encoding.base64.encode(this._stringToByteArray(data.strLogin+":"+data.strTmpSetting));

		// On sessionid received callback function
		var callback = dojo.hitch(this,this.OnRegistrationCallBack);
		// On sessionid error received callback function
		var callbackError = dojo.hitch(this,this.OnRegistrationPasswordCallbackError);

		// Get the list of installed apps
		var strParams	= "user.email="+data.strLogin;

		webapp.myICWall.sendServiceRequest(data.services["login"], strParams, callback, callbackError,data.strKeyAuthorization );
		data.strTmpSetting = null;
		xhrErr = null;
	},

	OnRegistrationCallBack : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - OnRegistrationCallBack");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - OnRegistrationCallBack / data: " + data);
		//dojo.unsubscribe(this.subscribeID);
		//this.subscribeID = null;
		var webappData				= webapp.myICWall.data;
		webappData.viaPopup = false;
		webappData.isServerOnline	= true;//Mandatory
		webappData.strSessionID		= data[0].id;
		webappData.strURI			= data[0].uri;

		// API Services
		webappData.services['getInstalled']	= {
			"url" : "/users/"+webappData.strSessionID+"/applications",
			"method" : "get"
		};
		webappData.services['getSetting']	= {
			"url" : "/users/"+webappData.strSessionID+"/settings",
			"method" : "get"
		};
		webappData.services['install']		= {
			"url" : "/users/"+webappData.strSessionID+"/applications",
			"method" : "post"
		};
		webappData.services['uninstall']	= {
			"url" : "/users/"+webappData.strSessionID+"/applications",
			"method" : "post"
		};
		this.mainView.getCategoriesList();
		data	= null;
	},

	OnRegistrationCallbackError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnRegistrationCallbackError");
		try{
			var data = webapp.myICWall.data;
			if(xhrErr.status == 409 || xhrErr.status==0) {
				ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnRegistrationCallbackError / error 409 or 0: " + xhrErr.status);
				this.displayPopupPasswd();
				data.viaPopup = false;
			} else {
				this.boolRegistration	= false;
				this.displayErrorPopup(xhrErr, xhrArgs);
			}
		} catch(err) {
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnRegistrationCallbackError / error catched: " + err.toString());
			var data = webapp.myICWall.data;
			data.viaPopup = false;
			if(err.status == 409) {
				ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnRegistrationCallbackError / error 409" + err.status);
				this.displayPopupPasswd();
			}
		}
		xhrErr	= null;
		xhrArgs	= null;
	},

	OnRegistrationPasswordCallbackError : function(xhrError,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnRegistrationPasswordCallbackError");
		this.boolRegistration	= false;
		var data = webapp.myICWall.data;
		data.viaPopup = false;
		data.strTmpSetting = null;
		if((xhrError.status == 401 || xhrError.status == 0) || (xhrArgs.args.callbackParams && xhrArgs.args.callbackParams.params && xhrArgs.args.callbackParams.params.service && xhrArgs.args.callbackParams.params.service.method=='head' && xhrError.status==404)){
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnRegistrationPasswordCallbackError / error status: " + xhrError.status);
			if (xhrError.status == 401) {
				xhrArgs.xhr.abort();
			}
			var buttons = [];
			var context	= this;

			// Create Cancel button
			buttons.push({
				strButtonName: "CLOSE_BTN",
				strButtonIcon: "generic-close",
				strButtonLabel : _("Close", "webapp.myICWall"),
				callback : function() {
					ICTouchAPI.popupServices.removePopup(context.objPopupError);
					context.displayPopupLogin();
				}
			});

			// Create the content of the popup
			var popupErrorData = {
				strTitle        : _("Error","ICTouchAPI"),
				arrPopupButtons : buttons,
				strContent		: _("ErrorPasswordCredential", "webapp.myICWall")
			};

			// Create and open the popup
			this.objPopupError = ICTouchAPI.popupServices.addNewPopup(popupErrorData, "MEDIUM");
		}
		else {
			this.displayErrorPopup(xhrError, xhrArgs);
		}
		xhrError	= null;
		xhrArgs	= null;
	},

	onRegistrationSetting : function () {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - onRegistrationSetting");
		var data = webapp.myICWall.data;

		data.strKeyAuthorization = null;

		// On sessionid received callback function
		var callback = dojo.hitch(this,this.onRegistrationSettingCallback);
		// On sessionid error received callback function
		var callbackError = dojo.hitch(this,this.onRegistrationSettingCallbackError);

		var strParams	= "registration.email="+data.strLogin+"&registration.companyId="+data.strCompanyID;
		webapp.myICWall.sendServiceRequest(data.services["register"], strParams, callback, callbackError);
	},

	onRegistrationSettingCallback : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - onRegistrationSettingCallback");
		this.data.isServerOnline = true;//Mandatory
		data = null;
	},

	onRegistrationSettingCallbackError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - onRegistrationSettingCallbackError");
		this.displayErrorPopup(xhrErr,xhrArgs);
		xhrErr	= null;
		xhrArgs	= null;
	},

	testServerBeforeLoadAwap : function(viewName){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - testServerBeforeLoadAwap");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - testServerBeforeLoadAwap / viewName: " + viewName);
		this.displaySpinner(viewName);

		var arrAwapName = viewName.split('.');
		var idAwap		= this.data.getAwapIdFromName(arrAwapName[1]);

		var callback = dojo.hitch(this,this.testServerBeforeLoadAwapOk,viewName);
		// On categories error received callback function
		var callbackError = dojo.hitch(this,this.testServerBeforeLoadAwapError,viewName);

		var strParams	= [];

		if(!this.data.services['manifest_'+idAwap]) {
			this.data.services['manifest_'+idAwap] = {'url' : '/applications/'+idAwap, 'method' : 'get'};
		}

		// Get the list of installed apps
		this.sendServiceRequest(this.data.services["manifest_"+idAwap], strParams, callback, callbackError, this.data.strKeyAuthorization, null, 2000);
		viewName = null;
	},

	testServerBeforeLoadAwapOk : function(strWebapp){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - testServerBeforeLoadAwapOk");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - testServerBeforeLoadAwapOk / strWebapp: " + strWebapp);
		var index = strWebapp.indexOf("."),
		    indexEnd = strWebapp.substring(index + 1).indexOf("."),
		    strWebappName = strWebapp.substr(index+1, indexEnd),
		    namespace = strWebapp.substring(0, index);
		ICTouchAPI.webApplicationManager.loadWebappFromNamespace(strWebappName, namespace);
		// Save iframe id (to stop subscription)
		this.loadedWebapp = strWebapp;
		// Subscribe to webapp hide
		this.hideSubscribeID = dojo.subscribe("iframe.hide",this, this.onHide);
		// Display the default app view
		ICTouchAPI.transitionServices.getScreen({
			name: strWebapp,
			params: {},
			position: null
		});
		strWebapp = null;
	},

	onHide : function(id) {
		// Unload web app
		if(id == this.loadedWebapp) {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onHide / {myICWall::Control} : onHide() - " + id + " is hidden");

			var index = id.indexOf("."),
			    indexEnd = id.substring(index + 1).indexOf("."),
			    strWebappName = id.substr(index+1, indexEnd),
			    namespace = id.substring(0, index);

			// Unsubscribe from the homepage displayed event
			dojo.unsubscribe(this.hideSubscribeID);
			this.hideSubscribeID = null;
			this.loadedWebapp = "";

			ICTouchAPI.webApplicationManager.unloadWebappFromNamespace(strWebappName, namespace);
		}
	},

	testServerBeforeLoadAwapError : function(strWebapp,err){
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - testServerBeforeLoadAwapError / strWebapp: " + strWebapp);
		this.removeSpinner();
		this.getTimeoutPopupFromAwap(err);
		strWebapp = null;
		err = null;
	},
	/**
	 * Get the list of installed apps
	 */
	getInstalledApps : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getInstalledApps");
		// On categories received callback function
		var callback = dojo.hitch(this,this.OnGetInstalledAppsCallback);
		// On categories error received callback function
		var callbackError = dojo.hitch(this,this.OnGetInstalledAppsCallbackError);

		var data	= webapp.myICWall.data;
		var strParams   = [];

		// Get the list of installed apps
		this.sendServiceRequest(this.data.services["getInstalled"], strParams, callback, callbackError, data.strKeyAuthorization);
	},

	/**
	 * Update the homepage
	 * Add/Remove button
	 */
	updateHomepageIcons : function(newApps) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - updateHomepageIcons");
		// shortcut
		var installed = this.data.displayed;

		// check if old installed apps still exist
		if(installed.length > 0) {
			if(newApps.length > 0) {
				var finish = false;
				var index = 0;
				while(!finish) {
					var found = false;
					var indexNew = 0;
					for(var j=0 ; j < newApps.length; j++) {
						if(installed[index].id == newApps[j].id) {
							found = true;
							indexNew = j;
							break;
						}
					}
					if(found) {
						installed[index] = newApps[indexNew];
						newApps.splice(indexNew, 1);
						index++;
					} else {
						ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateHomepageIcons / Remove button: " + this.data.LABS_APP_PREFIX + installed[index].id);
						// Remove associated style from homepage
						this.removeButtonStyleInHomepage(installed[index]);
						// Remove app button from homepage
						ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateHomepageIcons / unregisterHomepageAwapKey for app: " + this.data.LABS_APP_PREFIX + installed[index].id);
						ICTouchAPI.tools.unregisterHomepageKey([this.data.LABS_APP_PREFIX + installed[index].id, true]);
						this.removeStyleToGenericIFrame(installed[index]);
						// Remove app from installed array
						installed.splice(index, 1);
					}
					if(index >= installed.length) {
						finish = true;
					}
				}
			} else {
				// Remove all apps
				while(installed.length > 0) {
					// Remove an app
					var app = installed.pop();
					ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateHomepageIcons / Remove button: " + this.data.LABS_APP_PREFIX + app.id);
					// Remove associated style from homepage
					this.removeButtonStyleInHomepage(app);
					// Remove button from homepage
					ICTouchAPI.tools.unregisterHomepageKey([this.data.LABS_APP_PREFIX + app.id, true]);
					this.removeStyleToGenericIFrame(app);
				}
			}
		}

		// Add all new apps icons
		for(var i=0 ; i < newApps.length; i++) {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateHomepageIcons / Add button: " + this.data.LABS_APP_PREFIX + newApps[i].id);
			// Store app in installed array
			installed.push(newApps[i]);
			// Add Button style to homepage
			this.addButtonStyleInHomepage(newApps[i]);
			// Add button into the homepage
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateHomepageIcons / registerHomepageKey for app: " + newApps[i].name);
			var callback = dojo.hitch(this,this.testServerBeforeLoadAwap,this.data.LABS_NAMESPACE + "." + newApps[i].widget.path);
			ICTouchAPI.tools.registerHomepageKey([this.data.LABS_NAMESPACE + "." + newApps[i].widget.path,this.data.LABS_APP_PREFIX + newApps[i].id,this.data.LABS_APP_PREFIX + newApps[i].id,newApps[i].name,null,callback]);

			this.addStyleToGenericIFrame(newApps[i]);
		}
		this.data.displayed = installed;
		this.data.installed = installed;
		newApps = null;
	},

	/**
	 * Add styles to generic iframe
	 * @param {Object} app the web application
	 */
	addStyleToGenericIFrame : function(app) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - addStyleToGenericIFrame");
		var path, appName, strAppName;
		var url = this.data.LABS_PROTOCOL + this.data.LABS_URL + this.data.LABS_REPOSITORY;
		var i;

		appName		= app.widget.path.split('.');
		strAppName	= appName[0];

		// Get the provided.json file
		var skinConfig = ICTouchAPI.skinServices.getWebappSkinConfig("Default", strAppName, this.data.LABS_NAMESPACE);
		if(skinConfig){
			if(skinConfig.webapp[strAppName]){
				// For each css files
				for (i = 0 ; i < skinConfig.webapp[strAppName].length ; i++) {
					path = dojo.moduleUrl(this.data.LABS_NAMESPACE).path + strAppName + "/themes/Default/css/" + skinConfig.webapp[strAppName][i];
					ICTouchAPI.transitionServices.addStyleToGenericIFrame(path);
				}
				// Register application button to each appbar frames
				ICTouchAPI.transitionServices.addCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.png');");
				ICTouchAPI.transitionServices.addCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64:active", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.active.png');");
				ICTouchAPI.transitionServices.addCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64.active", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.active.png');");
				ICTouchAPI.transitionServices.addCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64.disabled", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.disabled.png');");
			}
		}
		app = null;
	},

	/**
	 * Remove styles to generic iframe
	 * @param {Object} app the web application
	 */
	removeStyleToGenericIFrame : function(app) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - removeStyleToGenericIFrame");
		var path, appName, strAppName;
		var i;

		appName		= app.widget.path.split('.');
		strAppName	= appName[0];
		
		// Get the provided.json file
		var skinConfig = ICTouchAPI.skinServices.getWebappSkinConfig("Default", strAppName, this.data.LABS_NAMESPACE);
		if(skinConfig){
			if(skinConfig.webapp[strAppName]){
				// For each css files
				for (i = 0 ; i < skinConfig.webapp[strAppName].length ; i++) {
					path = dojo.moduleUrl(this.data.LABS_NAMESPACE).path + strAppName + "/themes/Default/css/" + skinConfig.webapp[strAppName][i];
					ICTouchAPI.transitionServices.removeStyleToGenericIFrame(path);
				}
				// Unregister application button to each generic frames
				ICTouchAPI.transitionServices.removeCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64");
				ICTouchAPI.transitionServices.removeCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64:active");
				ICTouchAPI.transitionServices.removeCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64.active");
				ICTouchAPI.transitionServices.removeCssRuleToGenericIFrame(this.data.LABS_APP_PREFIX + app.id + "-64.disabled");
			}
		}
		app = null;
	},

	/**
	 * Ask the Homepage to add all new styles for apps button
	 */
	addButtonStyleInHomepage : function(app) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - addButtonStyleInHomepage");
		app.prefix	= this.data.LABS_APP_PREFIX;
		dojo.publish("AddCSSInHeader", [app, this.data.LABS_PROTOCOL + this.data.LABS_URL + this.data.LABS_REPOSITORY]);
		app = null;
	},

	/**
	 * Ask the Homepage to remove all styles for apps button
	 */
	removeButtonStyleInHomepage : function (app) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - removeButtonStyleInHomepage");
		app.prefix	= this.data.LABS_APP_PREFIX;
		dojo.publish("RemoveCSSInHeader", [app]);
		app = null;
	},

	/* ----------------------------------------- CALLBACKS --------------------------------------------------------- */

	/**
	 * Callback
	 * For back button
	 */
	buttonCallback:function(buttonId){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - buttonCallback");
		var data=webapp.myICWall.data;
		switch(buttonId){
			case data.BACK:
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - buttonCallback: data.BACK");
				dojo.publish("OpenHomepage");
				break;
			case data.REFRESH:
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - buttonCallback: data.REFRESH");
				this.mainView.OnRefreshCallback();
				break;
			case data.PREF:
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - buttonCallback: data.PREF");
				this.settingsView();
				break;
			case data.LOGIN:
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - buttonCallback: data.LOGIN");
				this.loginView.onLoginCallback();
				break;
			case data.BACK_TO_PREV:
				ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - buttonCallback: data.BACK_TO_PREV");
				this.catView();
				break;
		}
		buttonId = null;
	},

	/**
	 * Callback
	 * for getting setting labs server
	 */
	getLabsURLCallback:function(setting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getLabsURLCallback");
		if(setting){
			// Get server URL from setting
			//setting.jsValue = "192.168.0.147:4144";

			var url = setting.jsValue;

			if (url.search("^http://")!=-1) {
				url = url.substr(7);
			}
			else if (url.search("^https://")!=-1) {
				url = url.substr(8);
			}

			this.data.LABS_URL = url;

			// Register path to my IC Labs app repository
			dojo.registerModulePath(this.data.LABS_NAMESPACE, this.data.FORWARD_PROXY_URL + this.data.LABS_URL + this.data.LABS_REPOSITORY);

			//dojo.registerModulePath("awap", "http://172.25.41.47/127.0.0.1/ext/icphone-ale.actency.fr/labs/awap");

			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - getLabsURLCallback / URL: " + this.data.LABS_PROTOCOL + this.data.LABS_URL + this.data.LABS_PATH);

			// Get Installed apps
			if(this.data.services["getInstalled"]){
				this.getInstalledApps();
			}
		}
		setting = null;
	},

	/**
	 * Callback
	 * Get the list of installed apps
	 */
	OnGetInstalledAppsCallback : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - OnGetInstalledAppsCallback");
		try {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - OnGetInstalledAppsCallback / received: " + data.length + " app(s)");

			// Server is online
			this.data.isServerOnline = true;

			// Update the homepage
			this.updateHomepageIcons(data);

			if(this.mainView) {
				this.mainView.getCategoriesList();
			}else{
				this.removeSpinner();
			}
		}
		catch(err) {
			this.removeSpinner();
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnGetInstalledAppsCallback / error catched: " + err.toString());
		}
		data = null;
	},

	/**
	 * Callback
	 * Get the list of installed apps error
	 */
	OnGetInstalledAppsCallbackError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnGetInstalledAppsCallbackError");
		this.displayErrorPopup(xhrErr,xhrArgs);
		xhrErr	= null;
		xhrArgs	= null;
	},

	/**
	 * Display settings of selected hosted apps
	 */
	settingsView : function(args) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - settingsView");
		if(webapp.myICWall.mainSettingsView){
			//if(webapp.myICWall.isSAppsUpdated){
			webapp.myICWall.mainSettingsView.refreshSelectedAppsList();
		//}
		}
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.myICWall.getViewSettings",
			params: {}
		});
		args = null;
	},

	catView : function(args) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - catView");
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.myICWall.getView",
			params: {}
		});
		args = null;
	},
	/* ------------------------------------------- LOGIN ----------------------------------------------------------- */
	/**
	 * check if email & passwd are stored in settings
	 *
	 */
	checkLoginSettings : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - checkLoginSettings");

		if(!this.boolRegistration && this.data.strLogin && this.data.strPasswd) {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - checkLoginSettings / return true");
			return true;
		}
		else {
			ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - checkLoginSettings / return false");
			return false;
		}
	},

	/**
	 * Login on labs server
	 */
	onLogin : function(boolFirstBoot) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - onLogin");
		var data	= webapp.myICWall.data;
		if(this.checkLoginSettings()) {
			// On sessionid received callback function
			var callback = dojo.hitch(this,this.onLoginCallback);
			// On sessionid error received callback function
			var callbackError = dojo.hitch(this,this.OnGetSessionCallbackError);
			// Get the list of installed apps
			var strParams	= "user.email="+data.strLogin+"&user.password="+dojox.encoding.base64.encode(this._stringToByteArray(data.strPasswd));
			webapp.myICWall.sendServiceRequest(data.services["password"], strParams, callback, callbackError, null, null, boolFirstBoot?10000:null);
		} else {
			data.strKeyAuthorization = null;
			this.updateHomepageIcons([]);
			this.emptyMainView();
			this.removeSpinner();
		}
	},
	/**
	 * Login on labs server
	 */
	onLoginCallback : function(xhrErr) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - onLoginCallback");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - onLoginCallback / xhrErr: " + xhrErr);
		var data	= webapp.myICWall.data;
		data.boolDisplayErrorPopups = true;
		if(this.checkLoginSettings()) {
			data.strKeyAuthorization = "Basic "+dojox.encoding.base64.encode(this._stringToByteArray(data.strLogin+":"+data.strPasswd));

			// On sessionid received callback function
			var callback = dojo.hitch(this,this.OnGetSessionCallback);
			// On sessionid error received callback function
			var callbackError = dojo.hitch(this,this.OnGetSessionCallbackError);

			// Get the list of installed apps
			var strParams	= "user.email="+data.strLogin;

			webapp.myICWall.sendServiceRequest(data.services["login"], strParams, callback, callbackError,data.strKeyAuthorization );
		} else {
			data.strKeyAuthorization = null;
			this.updateHomepageIcons([]);
		}
		xhrErr = null;
	},

	/**
	 * Callback
	 * Get the session id
	 */
	OnGetSessionCallback : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - OnGetSessionCallback");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - OnGetSessionCallback / data: " + data);
		//dojo.unsubscribe(this.subscribeID);
		//this.subscribeID = null;
		var webappData	= webapp.myICWall.data;
		webappData.isServerOnline = true;
		webappData.strSessionID	= data[0].id;
		webappData.strURI		= data[0].uri;
		webappData.viaPopup		= false;

		// API Services
		webappData.services['getInstalled']	= {
			"url" : "/users/"+webappData.strSessionID+"/applications",
			"method" : "get"
		};
		webappData.services['getSetting']	= {
			"url" : "/users/"+webappData.strSessionID+"/settings",
			"method" : "get"
		};
		webappData.services['install']		= {
			"url" : "/users/"+webappData.strSessionID+"/applications",
			"method" : "post"
		};
		webappData.services['uninstall']	= {
			"url" : "/users/"+webappData.strSessionID+"/applications",
			"method" : "post"
		};
		webapp.myICWall.getInstalledApps();
		data = null;
	},

	/**
	 * Callback
	 * Get the list of installed apps error
	 */
	OnGetSessionCallbackError : function(xhrErr,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnGetSessionCallbackError / error status: " + xhrErr.status);
		var data	= webapp.myICWall.data;
		// in this error callback, 404 error can come from a pair login/pwd which does not exist (workaround to avoid 401 errors blocking the phone)
		if(xhrErr.status == 404 || xhrErr.status == 0) {
			this.removeSpinner();
			if(data.boolDisplayErrorPopups) {
				var buttons = [];
				var context	= this;

				// Create Cancel button
				buttons.push({
					strButtonName: "CLOSE_BTN",
					strButtonIcon: "generic-close",
					strButtonLabel : _("Close", "webapp.myICWall"),
					callback : function() {
						ICTouchAPI.popupServices.removePopup(context.objPopupError);
						if(data.viaPopup)
							context.displayPopupLogin();
					}
				});

				// Create the content of the popup
				var popupErrorData = {
					strTitle        : _("Error","ICTouchAPI"),
					arrPopupButtons : buttons,
					strContent		: _("ErrorPasswordCredential", "webapp.myICWall")
				};

				// Create and open the popup
				this.objPopupError = ICTouchAPI.popupServices.addNewPopup(popupErrorData, "MEDIUM");
			}
			else {
				ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - OnGetSessionCallbackError / do not display popup as boolDisplayErrorPopups is false");
			}
			// empty My IC Wall (access no longer authorized, remove homepage buttons)
			data.strKeyAuthorization = null;
			this.updateHomepageIcons([]);
			// empty My IC Wall views
			this.emptyMainView();
		} else {
			this.displayErrorPopup(xhrErr, xhrArgs);
		}
		data.boolDisplayErrorPopups = true;
		xhrErr	= null;
		xhrArgs	= null;
	},

	/* ------------------------------------------- DESCRIPTION POPUP ------------------------------------------- */

	/**
	 * onDisplayPopupCallback : function to research the manifest of an awap
	 * @param (Integer) idx		Id of Awap
	 */
	onDisplayPopupCallback : function(idx) {
		var callback = dojo.hitch(this,this.displayPopup);
		// On categories error received callback function
		var callbackError = dojo.hitch(this,this.displayPopupError);
		
		var strParams	= [];
		
		var item	= this.mainView.appList[idx];
		var idAwap	= item.app.id;
		
		if(!this.data.services['manifest_'+idAwap]) {
			this.data.services['manifest_'+idAwap] = {'url' : '/applications/'+idAwap, 'method' : 'get'};
		}
		
		// Get the list of installed apps
		this.sendServiceRequest(this.data.services["manifest_"+idAwap], strParams, callback, callbackError, this.data.strKeyAuthorization, null, 2000);
		idx	= null;
	},
	
	/**
	 * Display description popup
	 */
	displayPopup : function(data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - displayPopup");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - displayPopup / idx: " + data.id);
		//var item	= this.mainView.appList[idx];
		//var data	= webapp.myICWall.data;
		var context = this;
		var buttons = [];

		var boolInstalled	= this.data.isInstalledWebapp(data.id);
		context.idxWebapp	= data.id;

		if(boolInstalled) {
			// Create Unselect button to unload a webapp
			buttons.push({
				strButtonName: "UNSELECT_BTN",
				strButtonIcon: "generic-delete",
				strButtonLabel : _("Unselect", "webapp.myICWall"),
				callback : function() {
					context.updateInstalledWebappList(context.idxWebapp, false);
					context.idxWebapp	= null;
				}
			});
		} else {
			// Create Select button to load a webapp
			buttons.push({
				strButtonName: "SELECT_BTN",
				strButtonIcon: "generic-ok",
				strButtonLabel : _("Select", "webapp.myICWall"),
				callback : function() {
					context.updateInstalledWebappList(context.idxWebapp, true);
					context.idxWebapp	= null;
				}
			});
		}

		// Create OK button to display in the popup
		buttons.push({
			strButtonName: "CLOSE_BTN",
			strButtonIcon: "generic-cancel",
			strButtonLabel : _("Close", "webapp.myICWall"),
			callback : function() {
				// When click on Close, the popup must be removed
				ICTouchAPI.popupServices.removePopup(context.objPopup);
			}
		});

		// Create the content of the popup
		var popupData = {
			strTitle        : data.name,
			strContent      : data.description,
			arrPopupButtons : buttons
		};

		// Create and open the popup
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		data = null;
	},

	/**
	 * displayPopupError :
	 */
	displayPopupError : function(xhrErr) {
		this.getTimeoutPopupFromAwap(xhrErr);
		xhrErr = null;
	},

	updateInstalledWebappList : function(idx, boolInstall) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - updateInstalledWebappList");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateInstalledWebappList / idx: " + idx + ", boolInstall: " + boolInstall);
		// Update the webapps selectList
		var selectList	= this.mainView.layout.getContainer().selectList;
		if(boolInstall) {
			selectList.selectAtIndex(idx);
		} else {
			selectList.unselectAtIndex(idx);
		}

		// select a webapp
		this.mainView.OnAppClickCallback(idx);
		this.mainView.appList[idx].boolSelected = boolInstall;

		// Remove popup
		ICTouchAPI.popupServices.removePopup(this.objPopup);
		idx			= null;
		boolInstall	= null;
	},

	getSettingUIType : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getSettingUIType");
		var type = this._UI_TYPE_OTHER;

		switch (objSetting.typeData.name) {
			case ICTouchAPI.settingServices.TYPE_ENABLER:
			case ICTouchAPI.settingServices.TYPE_BOOLEAN:
			case ICTouchAPI.settingServices.TYPE_PASSWORD:
			case ICTouchAPI.settingServices.TYPE_TEXT:
			case ICTouchAPI.settingServices.TYPE_LIST:
			case ICTouchAPI.settingServices.TYPE_PHONE:
			case ICTouchAPI.settingServices.TYPE_FLOAT:
			case ICTouchAPI.settingServices.TYPE_IPPORT:
			case ICTouchAPI.settingServices.TYPE_IPADDRESS:
			case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
				type = this._UI_TYPE_EMBED;
				break;
			case ICTouchAPI.settingServices.TYPE_CHOICE:
			case ICTouchAPI.settingServices.TYPE_DATE :
			case ICTouchAPI.settingServices.TYPE_DATETIME :
			case ICTouchAPI.settingServices.TYPE_TIME :
				type = this._UI_TYPE_TOASTER;
				break;
			case ICTouchAPI.settingServices.TYPE_NUMERIC:
				type = this._UI_TYPE_EMBED;
				break;
			case ICTouchAPI.settingServices.TYPE_WEBAPP :
				type = this._UI_TYPE_WEBAPP;
				break;
			default:
				type = this._UI_TYPE_OTHER;
				break;
		}
		objSetting	= null;
		return type;
	},

	setInput : function(objUI){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - setInput");
		webapp.myICWall.data.objCurrentSetting=objUI.associatedSetting;
		webapp.myICWall.data.objSettingUI=objUI;
		objUI	= null;
	},

	/*
	 * Return the value from an object setting
	 */
	//build a generic UI matching the setting passed to the function
	getSettingUI : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getSettingUI");
		var objUI = "UNDEFINED";

		switch (objSetting.typeData.name) {
			case ICTouchAPI.settingServices.TYPE_ENABLER:
			case ICTouchAPI.settingServices.TYPE_BOOLEAN:
				var items = [_("yes","ICTouchAPI"), _("no","ICTouchAPI")];
				objUI = new UIElements.OptionChooser.OptionChooserControl({
					arrItems: items,
					intIndex : objSetting.jsValue?0:1,
					funcCallback : dojo.hitch(this, this.settingChanged, objSetting),
					intOptionWidth: 110
				});
				break;

			case ICTouchAPI.settingServices.TYPE_PASSWORD:
				objUI = new UIElements.InputField.InputFieldControl({
					keyboardType: ICTouchAPI.KeyboardTypes.PASSWORD,
					boolPassword: true,
					strInputText: this.getSettingTextualValue(objSetting),//CRI : crms00260967
					strInputTitle : _(objSetting.label,"webapp.settings"),
					isMultiLines: false,
					funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
					associatedSetting : objSetting,
					strEventId : "myICWall.InputFieldClicked." + objSetting.id
				});
				dojo.subscribe("myICWall.InputFieldClicked." + objSetting.id,this,this.setInput);
				break;

			case ICTouchAPI.settingServices.TYPE_TEXT:
			case ICTouchAPI.settingServices.TYPE_LIST:
				objUI = new UIElements.InputField.InputFieldControl({
					keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
					strInputText: this.getSettingTextualValue(objSetting),
					strInputTitle : _(objSetting.label,"webapp.settings"),
					isMultiLines: false,
					funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
					associatedSetting : objSetting,
					strEventId : "myICWall.InputFieldClicked." + objSetting.id
				});
				dojo.subscribe("myICWall.InputFieldClicked." + objSetting.id,this,this.setInput);
				break;

			case ICTouchAPI.settingServices.TYPE_PHONE:
				objUI = new UIElements.InputField.InputFieldControl({
					keyboardType: ICTouchAPI.KeyboardTypes.NUM,
					strInputText: this.getSettingTextualValue(objSetting),
					strInputTitle : _(objSetting.label,"webapp.settings"),
					isMultiLines: false,
					funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
					associatedSetting : objSetting,
					strEventId : "settings.InputFieldClicked." + objSetting.id
				});
				dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
				break;

			case ICTouchAPI.settingServices.TYPE_FLOAT:
			case ICTouchAPI.settingServices.TYPE_IPPORT:
			case ICTouchAPI.settingServices.TYPE_IPADDRESS:
				objUI = new UIElements.InputField.InputFieldControl({
					keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
					strInputText: this.getSettingTextualValue(objSetting),
					strInputTitle : _(objSetting.label,"webapp.settings"),
					isMultiLines: false,
					funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
					numLockKeyboard : 1,
					associatedSetting : objSetting,
					strEventId : "myICWall.InputFieldClicked." + objSetting.id
				});
				dojo.subscribe("myICWall.InputFieldClicked." + objSetting.id,this,this.setInput);
				break;

			case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
				objUI = new UIElements.InputField.InputFieldControl({
					keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
					strInputText: this.getSettingTextualValue(objSetting),
					strInputTitle : _(objSetting.label,"webapp.settings"),
					isMultiLines: false,
					funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
					numLockKeyboard : 0,
					associatedSetting : objSetting,
					strEventId : "myICWall.InputFieldClicked." + objSetting.id
				});
				dojo.subscribe("myICWall.InputFieldClicked." + objSetting.id,this,this.setInput);
				break;

			case ICTouchAPI.settingServices.TYPE_CHOICE:
			case ICTouchAPI.settingServices.TYPE_DATE :
			case ICTouchAPI.settingServices.TYPE_DATETIME :
			case ICTouchAPI.settingServices.TYPE_TIME :
				objUI = objSetting.jsValue;
				break;

			case ICTouchAPI.settingServices.TYPE_NUMERIC:
				objUI = new UIElements.InputField.InputFieldControl({
					keyboardType: ICTouchAPI.KeyboardTypes.NUM,
					strInputText: this.getSettingTextualValue(objSetting),
					strInputTitle : _(objSetting.label,"webapp.settings"),
					isMultiLines: false,
					funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
					associatedSetting : objSetting,
					strEventId : "myICWall.InputFieldClicked." + objSetting.id
				});
				dojo.subscribe("myICWall.InputFieldClicked." + objSetting.id,this,this.setInput);
				break;

			case ICTouchAPI.settingServices.TYPE_WEBAPP :
				objUI = objSetting.jsValue;
				break;

			default:
				objUI = objSetting.jsValue;
				break;
		}
		objSetting	= null;
		return objUI;
	},


	/*
	  * This function is a callbakc when a setting is changed
	  */
	settingChanged : function(objSetting, value) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - settingChanged");
		var data = webapp.myICWall.data;
		if(!data.services['setSetting_'+objSetting.name]) {
			var currentWebappName = null;
			for(var k = 0; k < data.installed.length; k++){
				if(data.installed[k].id == data.hostedAppCurrent){
					currentWebappName = data.installed[k].name;
				}
			}
			data.services['setSetting_'+objSetting.name]	= {
				'url' : '/users/'+data.strSessionID+'/settings/'+currentWebappName+"/"+objSetting.name+'/value',
				'method' : 'put'
			};
		}

		var funcCallback = dojo.hitch(this, this.refreshSetting);
		switch (objSetting.type) {
			//Settin with boolean value
			case ICTouchAPI.settingServices.TYPE_ENABLER:
			case ICTouchAPI.settingServices.TYPE_BOOLEAN:
				if (value == 0) {
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, "true");
				}
				else {
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name],  "", funcCallback, null, data.strKeyAuthorization, "false");
				}
				break;

			//setting with text or password value
			case ICTouchAPI.settingServices.TYPE_PASSWORD:
			case ICTouchAPI.settingServices.TYPE_TEXT:
				if (objSetting.value !== undefined) {
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, value);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_LIST:
				if (objSetting.jsValue !== undefined) {
					var arrValue = value.split(";");
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, arrValue);
				}
				break;

			//Setting with phone number value
			case ICTouchAPI.settingServices.TYPE_PHONE:
				if (objSetting.jsValue !== undefined) {
					var val = parseInt(value,10);
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, val);
				}
				break;

			//Setting with ip adress value
			case ICTouchAPI.settingServices.TYPE_IPADDRESS:
				var ip,i;
				if (objSetting.jsValue !== undefined) {
					ip = value.split(".");
					if (ip.length !== 4) {
						this.rollBack();
						this.getErrorPopup();
						return;
					}

					var upTo255 = false;
					for (i in ip) {
						if (parseInt(ip[i],10) > 255 || parseInt(ip[i],10) < 0) {
							upTo255 = true;
						}
						if (ip[i] != parseInt(ip[i],10) && ip[i] != "00"+parseInt(ip[i],10) && ip[i] != "0"+parseInt(ip[i],10)) {
							this.rollBack();
							this.getErrorPopup();
							return;
						}
					}
					if (upTo255) {
						this.rollBack();
						this.getErrorPopup();
						return;
					}

					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, value);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
				if (objSetting.jsValue !== undefined)
				{
					var valid = false;
					ip = value.split(".");

					if(ip.length === 4){
						valid = true;
						var expInt = /^[0-9]+$/;
						for (i in ip)
						{
							if(expInt.exec(i) === null)
							{
								valid = false;
							}
							else if (parseInt(ip[i],10) > 255 || parseInt(ip[i],10) < 0){
								valid = false;
							}
							else if (ip[i] != parseInt(ip[i],10) && ip[i] != "00"+parseInt(ip[i],10) && ip[i] != "0"+parseInt(ip[i],10))
							{
								valid = false;
							}
						}
					}
					var reg,n;
					if(!valid){
						reg = /^([a-z][a-z0-9\-]+(\.|\-*\.))+[a-z]{2,6}$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
						}
					}
					if(!valid){
						reg = /^(([12][0-9]|[0-9]?)[0-9]\.){3}([12][0-9]|[0-9]?)[0-9]$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
						}
					}
					if(!valid){
						reg = /^([a-zA-Z0-9]+\.)*[a-zA-Z0-9]+$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
						}
					}
					if(!valid){
						reg = /^([0-9A-Fa-f]{0,4}:){2,7}[0-9A-Fa-f]{0,4}$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
						}
					}

					if(!valid){
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, value);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_FLOAT:
				if (objSetting.jsValue !== undefined)
				{
					if(value != parseFloat(value).toString())
					{
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, value);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_IPPORT:
				var intValue;
				if (objSetting.jsValue !== undefined) {
					intValue = parseInt(value,10);
					if(intValue > 65535 || intValue < 0  || value != intValue.toString())
					{
						webapp.myICWall.data.buildErrorPopupLabelMinMax(0, 65535);
						this.rollBack();
						this.getErrorPopup();
						return;
					}

					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, intValue);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_NUMERIC: //only if max value > 100 else it's a toaster
				if (objSetting.jsValue !== undefined)
				{
					intValue = parseInt(value,10);
					webapp.myICWall.sendServiceRequest(data.services['setSetting_'+objSetting.name], "", funcCallback, null, data.strKeyAuthorization, intValue);
				}
				break;
			default :
				break;
		}
		objSetting	= null;
		value		= null;
	},

	/*
	 *This function shows up a popup for an error while saving a setting's value
	 */
	getErrorPopup : function (message){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getErrorPopup");
		var context = this;
		if (message){
			var strContent = message;
		}
		else{
			if(webapp.myICWall.data.ERR_ALT_POPUP_LABEL){
				strContent = _(webapp.myICWall.data.ERR_ALT_POPUP_LABEL,"webapp.settings");
			}else{
				strContent = _(webapp.myICWall.data.ERR_STD_POPUP_LABEL,"webapp.settings");
			}
		}

		var popupData = {
			strTitle: _("Settings error","webapp.settings"),
			strType: "error",
			strContent: strContent,
			arrPopupButtons: [
			{
				strButtonLabel: _("Ok","ICTouchAPI"),
				callback : function(){
					ICTouchAPI.popupServices.removePopup(context.objPopup);
				}
			}
			]
		};

		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");

		webapp.myICWall.data.ERR_ALT_POPUP_LABEL = "";
		message	= null;
	},

	rollBack : function(){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - rollBack");
		if(ICTouchAPI.settingServices.isDisplayedSequence(this.data.objCurrentSetting.id)) {
			return;
		}
		for(var i=0;i<this.data._arrDetails.length;i++){
			if(this.data._arrDetails[i].objSetting.id == this.data.objCurrentSetting.id){
				var detail = this.data._arrDetails[i];
				switch ( this.getSettingUIType(detail.objSetting)) {
					case this._UI_TYPE_EMBED:
						var declaredClass =  detail.objContent.declaredClass;
						if (declaredClass === "UIElements.OptionChooser.OptionChooserControl"){
							detail.objContent.setValue(this.data.objCurrentSetting.jsValue?0:1);
						}
						else if (declaredClass === "UIElements.InputField.InputFieldControl") {
							var value = this.getSettingTextualValue(this.data.objCurrentSetting);
							detail.objContent.setInputFieldContent(value, false, false);
						}
						break;
					case this._UI_TYPE_TOASTER :
						break;
					case this._UI_TYPE_WEBAPP:
						break;
					case this._UI_TYPE_OTHER :
						break;
					default:
						break;
				}
			}
		}
	},

	/*
	 * Return the String value from an object setting
	 */
	getSettingTextualValue: function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getSettingTextualValue");
		switch (objSetting.type) {
			case ICTouchAPI.settingServices.TYPE_ENABLER:
			case ICTouchAPI.settingServices.TYPE_BOOLEAN:
				if (objSetting.jsValue !== undefined){
					return (objSetting.jsValue) ? _(objSetting.typeData.params.name2, "webapp.settings") : _(objSetting.typeData.params.name1, "webapp.settings");
				}
				break;
			case ICTouchAPI.settingServices.TYPE_CHOICE:
				if (objSetting.jsValue >= 0){
					if(objSetting.allowedValues[objSetting.jsValue]){
						if(objSetting.allowedValues[objSetting.jsValue].name){
							return _(objSetting.allowedValues[objSetting.jsValue].name, "webapp.settings");
						}else{
							return "";
						}
					}else{
						return "";
					}
				}
				break;
			case ICTouchAPI.settingServices.TYPE_PASSWORD:
				return objSetting.jsValue;//CRI : crms00260967
			//break;
			case ICTouchAPI.settingServices.TYPE_DATE:
				// OK we should use the current locale, but for now the dictionnaries don't
				// have these dateFormat and timeFormat values...
				// and I don't know how this objSetting  will really de used!!
				return objSetting.jsValue.format('M/d/yy', 'en');
			//
			// WAS return dojo.date.locale.format(objSetting.jsValue, {
			//	selector: "date"
			//});
			//break;
			case ICTouchAPI.settingServices.TYPE_DATETIME:
				return objSetting.jsValue.format('M/d/yy h:mm a', 'en');
			// WAS: return dojo.date.locale.format(objSetting.jsValue);
			//break;
			case ICTouchAPI.settingServices.TYPE_LIST:
				return _(objSetting.value, "webapp.settings");
			//break;
			case ICTouchAPI.settingServices.TYPE_TIME:
				var tabHour = objSetting.jsValue.split(":");
				if( !webapp.settings.data._24hformat ) {
					var hour = parseInt(tabHour[0],10);
					var moment = "am";
					if (hour>=12){
						hour -=12;
						moment = "pm";
					}
					if (hour === 0){
						hour = 12;
					}
					if (hour <10) {
						hour = "0"+hour;
					}
					return hour+":"+tabHour[1]+" "+moment;
				}
				return  tabHour[0]+":"+tabHour[1];

			//break;
			case ICTouchAPI.settingServices.TYPE_PHONE:
			case ICTouchAPI.settingServices.TYPE_IPPORT:
			case ICTouchAPI.settingServices.TYPE_FLOAT:
			case ICTouchAPI.settingServices.TYPE_NUMERIC:
				return objSetting.value.toString();
			//break;
			case ICTouchAPI.settingServices.TYPE_TEXT:
				return objSetting.value;
			default:
				return objSetting.value;
		}
		objSetting	= null;
		return "";
	},

	getToaster : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getToaster");
		var objUi = null;
		switch (objSetting.typeData.name) {
			case ICTouchAPI.settingServices.TYPE_CHOICE:
				objUi = this.getUiChoiceToaster(objSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_TIME:
				objUi = this.getUiTimeToaster(objSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATE:
				objUi = this.getUiDateToaster(objSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATETIME:
				objUi = this.getUiDateTimeToaster(objSetting);
				break;
		}

		this.toasterUI = ICTouchAPI.toasterServices.showDialogBox(objUi, {
			strTitle: _(objSetting.label, "webapp.settings"),
			funcOk: dojo.hitch(this, this.getToasterValidated),
			funcCancel: dojo.hitch(this, this.getToasterCanceled),
			onHide: dojo.hitch(this, this.toggleWebappVisibility, true)
		});
		objSetting	= null;
	},

	getToasterValidated : function(){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getToasterValidated");
		this.toggleWebappVisibility(true);
		var objSetting = this.data.objCurrentSetting;
		var arrUiSetting = [this.toasterUI.getContent()];
		switch (objSetting.typeData.name) {
			case ICTouchAPI.settingServices.TYPE_CHOICE:
				this.getChoiceToasterValidated(arrUiSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_TIME:
				this.getTimeToasterValidated(arrUiSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATE:
				this.getDateToasterValidated(arrUiSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATETIME:
				this.getDateTimeToasterValidated(arrUiSetting);
				break;
		}

		ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
		this.toasterUI = null;
	},

	getChoiceToasterValidated : function(arrUiSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getChoiceToasterValidated");
		var objSetting = this.data.objCurrentSetting;
		var func = dojo.hitch(this, this.refreshSetting);
		var value = arrUiSetting[0].getSelected()[0];
		if(objSetting && objSetting.action && objSetting.action.exit_preview){
			ICTouchAPI.settingServices.callMethodForAction(value, {
				action:objSetting.action.exit_preview
			})
		}

		this.data.objCurrentSetting.jsValue = value;

		webapp.myICWall.sendServiceRequest(webapp.myICWall.data.services["setSetting"],
			"user="+webapp.myICWall.data.strSessionID+"&app="+objSetting.module+"&settingName="+objSetting.id+"&settingValue="+value, func);
		arrUiSetting	= null;
	},

	getToasterCanceled : function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getToasterCanceled");
		this.toggleWebappVisibility(true);
		if(this.data.objCurrentSetting && this.data.objCurrentSetting.action && this.data.objCurrentSetting.action.exit_preview && this.data.objCurrentSetting.typeData.name == ICTouchAPI.settingServices.TYPE_CHOICE){
			ICTouchAPI.settingServices.callMethodForAction(null, {
				action:this.data.objCurrentSetting.action.exit_preview
			})
		}
		ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
		this.toasterUI.destroy();
		this.toasterUI = null;
	},

	getUiChoiceToaster : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getUiChoiceToaster");

		var objUi = null;

		var func = dojo.hitch(webapp.myICWall, webapp.myICWall.onChoiceClicked);
		var _arrChoice = new Array();
		if(objSetting.action && objSetting.action.preview){
			var strPreviewIcon = "generic-search";
			var actionFunc = dojo.hitch(ICTouchAPI.settingServices, ICTouchAPI.settingServices.callMethodForAction)
			if (objSetting.allowedValues[0]){
				var link = objSetting.allowedValues[0].id;
				if (link.indexOf(".mp3") !== -1 || link.indexOf(".wav") !== -1 || link.indexOf(".ogg") !== -1){
					strPreviewIcon = "filesmanager-play";
				}
			}
			for (var i = 0; i <  objSetting.allowedValues.length; i++) {
				_arrChoice.push({
					intIndex: i,
					strLabel: _(objSetting.allowedValues[i].name,"webapp.settings"),
					boolSelected: (objSetting.jsValue == i),
					strActionIcon : strPreviewIcon
				});
			}
			objUi = new UIElements.SelectList.SelectListControl({
				arrItems: _arrChoice,
				intContainerSize: 6,
				itemCallback: func,
				buttonCallback : actionFunc,
				buttonCallbackParams : {
					action : objSetting.action.preview
				}
			});
		}
		else{
			for (var i = 0; i <  objSetting.allowedValues.length; i++) {
				_arrChoice.push({
					intIndex: i,
					strLabel: _(objSetting.allowedValues[i].name,"webapp.settings"),
					boolSelected: (objSetting.jsValue == i)
				});
			}
			objUi = new UIElements.SelectList.SelectListControl({
				arrItems: _arrChoice,
				intContainerSize: 6,
				itemCallback: func
			});
		}
		// Starting at 6 elements the toaster takes the whole screen
		if (objSetting.allowedValues.length >= 6) {
			// Don't hide now or the user will see the screen disappear
			var context = this;
			setTimeout(function(){
				context.toggleWebappVisibility(false);
			}, 1000);
		}
		objSetting	= null;
		return objUi;
	},

	refreshSetting: function() {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - refreshSetting");

		this.mainSettingsView.refreshSettingsList(this.data.hostedAppCurrent);
	},

	onChoiceClicked : function(intIndex) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - onChoiceClicked");
		this.data.intChoiceListSelected = intIndex;
		intIndex	= null;
	},

	toggleWebappVisibility: function(visible) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - toggleWebappVisibility");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - toggleWebappVisibility / visible: " + visible);
		dojo.toggleClass(this.mainSettingsView.domNode, "setting_hidden", !visible);
		visible	= null;
	},

	getTimeoutPopupFromAwap : function(xhrErr) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - getTimeoutPopupFromAwap");
		var buttons = [];
		var context	= this;
		var popupErrorData;
		if((xhrErr.dojoType && xhrErr.dojoType == "timeout") || xhrErr.status == 504) {

			// Create Cancel button
			buttons.push({
				strButtonName: "CLOSE_BTN",
				strButtonIcon: "generic-close",
				strButtonLabel : _("Close", "webapp.myICWall"),
				callback : function() {
					ICTouchAPI.popupServices.removePopup(context.objPopupError);
				}
			});

			// Create the content of the popup
			popupErrorData = {
				strTitle        : _("ErrorTimeout","webapp.myICWall"),
				arrPopupButtons : buttons,
				strContent		: _("ServerUnreachable", "webapp.myICWall")
			};

			// Create and open the popup
			this.objPopupError = ICTouchAPI.popupServices.addNewPopup(popupErrorData, "MEDIUM");
		} else if (xhrErr.status == 404) {
			// Create Cancel button
			buttons.push({
				strButtonName: "CLOSE_BTN",
				strButtonIcon: "generic-close",
				strButtonLabel : _("Close", "webapp.myICWall"),
				callback : function() {
					ICTouchAPI.popupServices.removePopup(context.objPopupError);
				}
			});

			// Create the content of the popup
			popupErrorData = {
				strTitle        : _("NosourcesTitle","webapp.myICWall"),
				arrPopupButtons : buttons,
				strContent		: _("Nosources", "webapp.myICWall")
			};

			// Create and open the popup
			this.objPopupError = ICTouchAPI.popupServices.addNewPopup(popupErrorData, "MEDIUM");
		}
		xhrErr	= null;
	},

	displayErrorPopup : function(xhrError,xhrArgs) {
		ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup");

		var data = webapp.myICWall.data;
		var strPopupTitle, strPopupContent;

		if((xhrError.dojoType && xhrError.dojoType == "timeout") || xhrError.status == 504 || xhrError.status == 0) {
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup / timeout, error status: " + xhrError.status);
			strPopupTitle	= _("ErrorTimeout","webapp.myICWall");
			strPopupContent = _("ServerUnreachable", "webapp.myICWall");
			data.isServerOnline = false;
			data.viaPopup = false;
		} else {
			xhrArgs.xhr.abort();
			// empty My IC Wall (access no longer authorized, remove homepage buttons)
			data.strKeyAuthorization = null;
			this.updateHomepageIcons([]);
			if(xhrError.status == 401){
				ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup / error 401");
				strPopupTitle	= _("Error","ICTouchAPI");
				strPopupContent = _("ErrorPasswordCredential", "webapp.myICWall");
			}
			if(xhrError.status == 404){
				ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup / error 404");
				strPopupTitle	= _(["Error",xhrArgs.xhr.status.toString()],"ICTouchAPI");
				strPopupContent = _("ServerUnreachable", "webapp.myICWall");
				data.isServerOnline = false;
				data.viaPopup = false;
			} else {
				ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup / other error: " + xhrError ? xhrError.status : "no error status");
				strPopupTitle	= _(["Error",xhrArgs.xhr.status.toString()],"ICTouchAPI");
				strPopupContent = _(xhrArgs.xhr.statusText, "webapp.myICWall");
			}
		}

		if(data.boolDisplayErrorPopups) {
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup / display popup as boolDisplayErrorPopups is true");
			var buttons = [];
			var context	= this;

			// Create Cancel button
			buttons.push({
				strButtonName: "CLOSE_BTN",
				strButtonIcon: "generic-close",
				strButtonLabel : _("Close", "webapp.myICWall"),
				callback : function() {
					ICTouchAPI.popupServices.removePopup(context.objPopupError);
					if(data.viaPopup) {
						context.displayPopupLogin();
					}
				}
			});

			// Create the content of the popup
			var popupErrorData = {
				strTitle        : strPopupTitle,
				arrPopupButtons : buttons,
				strContent		: strPopupContent
			};

			// Create and open the popup
			this.objPopupError = ICTouchAPI.popupServices.addNewPopup(popupErrorData, "MEDIUM");
		}
		else {
			ICTouchAPI.debugServices.error("webapp.myICWall.controlBase - displayErrorPopup / do not display popup as boolDisplayErrorPopups is false");
		}
		// empty My IC Wall views
		this.emptyMainView();
		xhrError = null;
		xhrArgs = null;
	},

	/**
	 * _stringToByteArray : convert a string to a byte array
	 * @param	{String}	strConvert	string to convert to byte array
	 * @return	{Array}		conversion result
	 */
	_stringToByteArray : function(strConvert) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _stringToByteArray");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - _stringToByteArray / strConvert: " + strConvert);
		var byteArray = [];
		for (var i = 0; i < strConvert.length; i++) {
			if (strConvert.charCodeAt(i) <= 0x7F)
				byteArray.push(strConvert.charCodeAt(i));
			else {
				var h = encodeURIComponent(strConvert.charAt(i)).substr(1).split('%');
				for (var j = 0; j < h.length; j++)
					byteArray.push(parseInt(h[j], 16));
			}
		}
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - _stringToByteArray / return: " + byteArray);
		strConvert	= null;
		return byteArray;
	},

	/**
	 * _byteArrayToString : convert a byte array to a string
	 * @param	{Array}		arrBytes	array to convert to string
	 * @return	{String}	conversion result
	 */
	_byteArrayToString : function (arrBytes) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - _byteArrayToString");
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - _byteArrayToString / arrBytes: " + arrBytes);
		var str = '';
		for (var i = 0; i < arrBytes.length; i++) {
			str +=  arrBytes[i] <= 0x7F?
			arrBytes[i] === 0x25 ? "%25" : // %
			String.fromCharCode(arrBytes[i]) :
			"%" + arrBytes[i].toString(16).toUpperCase();
		}
		ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - _byteArrayToString / return: " + str);
		arrBytes	= null;
		return decodeURIComponent(str);
	},

	/**
	 * Update the label of awap on Homepage
	 */
	updateHomepageKeysLabel : function (data) {
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - updateHomepageKeysLabel");
		var arrHomepageKeys = webapp.homepage.homepageStandardView.arrObjKeys;

		if(data.length > 0) {
			for(var i in data) {
				for(var j in arrHomepageKeys) {
					if(arrHomepageKeys[j].strButtonName == 'awap_'+data[i].id) {
						ICTouchAPI.debugServices.debug("webapp.myICWall.controlBase - updateHomepageKeysLabel / set name: " + data[i].name + " for awap with id: " + 'awap_'+data[i].id);
						arrHomepageKeys[j].setButtonLabel(data[i].name);
					}
				}
			}
		}
		data = null;
	},

	emptyMainView : function(){
		ICTouchAPI.debugServices.info("webapp.myICWall.controlBase - resetMainView");
		if(this.mainView) {
			this.mainView.OnListReceived([]);
			this.mainView.OnWebappsListReceived([]);
		}

		if(this.mainSettingsView) {
			this.mainSettingsView.settings.update([]);
		}
		this.removeSpinner();
	}
});
