dojo.provide("webapp.bluetooth.dataBase");
dojo.declare("webapp.bluetooth.dataBase",null,{

	arrWidgetsData : [],
	_screenListTitle : "",
	_strTitle : "",
	_strContainerPath : "webapp.bluetooth.getMyDevices",
	myDevicesListUI : null,
	addDevicesListUI : null,
	screenListUI : null,
	devicesList : [],
	deviceNr : 0,
	addDeviceNr : 0,
	addError : null,
	deleteError : null,

	// Both are actual button
	objAddButton : null,
	objDeleteButton : null,

	// Constant values for the button's id
	BACK	: "BACK_BTN",
	SCAN	: "SCAN_BTN",
	ADD	: "ADD_BTN",
	DELETE	: "DELETE_BTN",
	SWITCH	: "SWITCH_BTN",

	WIDGET_MYDEVICES : 0,
	WIDGET_ADDDEVICE : 1,
	WIDGET_NONE : 2,
	CURRENT_WIDGET : 0,

	constructor : function(){
		var func = dojo.hitch( webapp.bluetooth, webapp.bluetooth.buttonCallback );
		this.arrWidgetsData[this.WIDGET_MYDEVICES] = {
			container: "webapp.bluetooth.getMyDevices",
			buttons: [
			{
				strButtonName: this.SWITCH,
				strButtonLabel: _('Add', 'ICTouchAPI'),
				callback : func,
				strButtonIcon: 'generic-add'
			},

			{
				strButtonName: this.DELETE,
				strButtonLabel: _('Delete', 'ICTouchAPI'),
				callback : func,
				strButtonIcon: 'generic-delete',
				strButtonStatus : "unavailable"
			},

			]
		};
		this.arrWidgetsData[this.WIDGET_ADDDEVICE] = {
			container: "webapp.bluetooth.getAddDevice",
			buttons: [
			{
				strButtonName: this.SWITCH,
				strButtonLabel: _('My devices', 'webapp.bluetooth'),
				callback : func,
				strButtonIcon: 'bluetooth-my-devices'
			},

			{
				strButtonName: this.SCAN,
				strButtonLabel: _('Scan', 'webapp.bluetooth'),
				callback : func,
				strButtonIcon: 'bluetooth-scan-devices',
				strStatusIcon : "notif-off"
			},

			{
				strButtonName: this.ADD,
				strButtonLabel: _('Add', 'ICTouchAPI'),
				callback : func,
				strButtonIcon: 'generic-add',
				strButtonStatus : "unavailable"
			},
			]
		};
		this.arrWidgetsData[this.WIDGET_NONE] = {
			container: "",
			buttons: [

		]
		};


		this._screenListTitle=_("Bluetooth", "webapp.bluetooth");
	},

	getContainerPath :function() {
		return this._strContainerPath;
	},

	getScreenListTitle : function() {
		return this._screenListTitle;
	},

	getActionBarAppButtons : function(index) {
		return this.arrWidgetsData[index].buttons;
	},

	getContainerTitle : function () {
		return this._strTitle;
	},

	/*
	 * Get the device list, if boolAdd is true it returns the scanned bt devices
	 * else it returns the bounded bt devices
	 */
	getDeviceList : function(boolAdd) {
		var tempDeviceList = [], deviceList;

		if( boolAdd )
			deviceList = this.addDevicesList;
		else
			deviceList = this.devicesList;


		for ( var key in deviceList)
		{
			var label = null;
			if( deviceList[key].strName !== undefined )
				label = deviceList[key].strName + ' ('+deviceList[key].strAddress+')';
			else
				label = deviceList[key].strAddress;

			tempDeviceList.push({
				intIndex: deviceList[key].strAddress,
				strLabel: label,
				boolSelected: false,
			});
		}
		return tempDeviceList;
	},


	closeAddPopup : function() {
		ICTouchAPI.popupServices.removePopup(this.addError);
	},

	closeDeletePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.deleteError);
	},



	//Specific function for settings integrations

	initForView : function(view) {
		if (view == "webapp.bluetooth.getMyDevices")
		{

			//reset the list
			this.devicesList = [];
			this.deviceNr = 0;
			//call BTShowbondedDevice to receive as events the devices already connected to the phone. After this is done, refresh the page.
			ICTouchAPI.APIServices.Bluetooth.BTShowBondedDevice({});

			webapp.settings.refreshWebappView();
		}
		else
		{

			this.addDevicesList = [];
			this.addDeviceNr = 0;
		};
	},

	stopForView : function(view) {
		//if a scanning is running then stop it
		if(view == "webapp.bluetooth.getAddDevice"){
			webapp.bluetooth.stopScanning();
		}
	},

	getActionBarAppButtonsFromView : function(view) {
		switch(view){
			case "webapp.bluetooth.getAddDevice":
				var index = this.WIDGET_ADDDEVICE;
				break;
			case "webapp.bluetooth.getMyDevices":
				var index = this.WIDGET_MYDEVICES;
				break;
			default :
				var index = this.WIDGET_NONE;
				break;
		}
		return this.arrWidgetsData[index].buttons;
	},

	initAppBarButtons : function(view) {
		var actionBar;
		var btn;
		if (view == "webapp.bluetooth.getMyDevices")
		{
			actionBar =  webapp.settings.getActionBar();
			btn = actionBar.getButton(this.DELETE);
			btn.greyTint();
		}
		else
		{
			actionBar =  webapp.settings.getActionBar();
			btn = actionBar.getButton(this.ADD);
			btn.greyTint();
		}
	}

});
