dojo.provide("webapp.bluetooth.controlBase");
dojo.declare("webapp.bluetooth.controlBase", ICTouchAPI.webApplication,
{
    currentStatus	: 0,
    mainWidget		: null,
    containerUI		: null,
    _currentAddress	: null, // Current selected Device in add mode
    _boolScanning	: false,
    _boolDelete		: false, // Flag only active when user user Clicked on the button "Delete" from My Devices list
    _boolAddButtonEnable : false,
    pairingPopup	: null,	//handle of the pairing process popup
    addErrorPopup	: null,


    constructor : function() {
        //ICTouchAPI.skinServices.linkWebappsStyles("webapp.settings", "webapp.bluetooth", true);
        dojo.subscribe("iframe.hide", this, this.onHideIFrame);
    },

    loaded : function() {
        ICTouchAPI.eventServices.subscribeToEvent(this, "bt_inquiry_result_evt", this.onInquiryResult);
        ICTouchAPI.eventServices.subscribeToEvent(this, "bt_update_device_name", this.onDeviceName);
        ICTouchAPI.eventServices.subscribeToEvent(this, "bt_bonded_device", this.onBondedDevice);
        ICTouchAPI.eventServices.subscribeToEvent(this, "bt_bond_result_evt", this.onBondResult);
        ICTouchAPI.eventServices.subscribeToEvent(this, "bt_delete_result", this.onDeleteDevice);
    },

    dump : function(boolAdvancedLogs) {
        this.inherited(arguments);
        ICTouchAPI.debugServices.dump("Current widget: " + ((this.data.CURRENT_WIDGET==this.data.WIDGET_MYDEVICES)?"List of devices":((this.data.CURRENT_WIDGET==this.data.WIDGET_ADDDEVICE)?"Add device":"No wigdet")));
        ICTouchAPI.debugServices.dump("State is scanning: " + this._boolScanning);
        if (boolAdvancedLogs) {

            if (this.data.devicesList && this.data.devicesList.length) {
                ICTouchAPI.debugServices.dump("Device list: ");
                for (var i in this.data.devicesList) {
                    ICTouchAPI.debugServices.dump(this.data.devicesList[i]);
                }
            }
            else {
                ICTouchAPI.debugServices.dump("Device list: no devices in the list");
            }
        }
    },

    buttonCallback : function(buttonId) {
        var data = webapp.bluetooth.data;
        switch(buttonId)
        {
            case data.BACK:
                this.stopScanning();
                dojo.publish("OpenHomepage");
                break;
            case data.DELETE:
                this.handleDelete();
                break;
            case data.SCAN:
                this.handleScan();
                break;
            case data.ADD:
                this.handleAdd();
                break;
            case data.SWITCH:
                this.switchViews();
                break;
            default:
                console.warn("There is no callback associated with this button");
                break;
        }
    },

    handleScan: function() {
        var data = webapp.bluetooth.data;
        var icon = "notif-on";
        var actionBar = webapp.settings.getActionBar();
        if( !this._boolScanning )
        {
            data.addDeviceNr = 0;
            data.addDevicesList = [];
            ICTouchAPI.APIServices.Bluetooth.BTStartInquiry({});
            icon = "notif-on";

            webapp.settings.refreshWebappView();

            if (this._boolAddButtonEnable) {
                // Grey the button when the list is purged
                var button = actionBar.getButton(data.ADD);
                button.greyTint();
                this._boolAddButtonEnable = false;
            }
        }
        else
        {
            ICTouchAPI.APIServices.Bluetooth.BTStopInquiry({});
            icon = "notif-off";
        }
        var button = actionBar.getButton(data.SCAN);
        button.attr('strStatusIcon', icon);

        this._boolScanning = !this._boolScanning;
    },

    // Callback called when a device is clicked in Scan mode
    addDeviceClicked : function(deviceClicked) {
        var data = webapp.bluetooth.data;
        var actionBar =  webapp.settings.getActionBar();
        data.objAddButton = actionBar.getButton(data.ADD);
        var list = data.addDevicesList;

        if (list[deviceClicked].strName) {
            data.objAddButton.show();
            this._boolAddButtonEnable = true;
        }
        else {
            data.objAddButton.greyTint();
            this._boolAddButtonEnable = false;
        }


        this._currentAddress = deviceClicked;
    },

    // Callback called when a device is clicked in My Devices mode
    deleteDeviceClicked : function(deviceClicked) {
        var data = webapp.bluetooth.data;
        var actionBar =  webapp.settings.getActionBar();
        data.objDeleteButton = actionBar.getButton(data.DELETE);

        data.objDeleteButton.show();

        this._currentAddress = deviceClicked;
    },

    handleAdd : function() {
        var context = this;
        if( this._currentAddress !== null )
        {
            // If we are scanning, stop it or else the pairing won't work
            if( this._boolScanning )
                this.handleScan();

            // Mac address of current selected Device
            var address = this._currentAddress;
            ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUM, null, {
                funcCallbackOk : function(value)  {
                    var pin = value;
                    //call bussines function
                    ICTouchAPI.APIServices.Bluetooth.BTInitiatePairing({
                        params: [address, pin]
                    });

                    //show In Progress Popup
                    var strContent = _("Pairing in progress. Please wait", "webapp.bluetooth");
                    var inProgress = {
                        strTitle: _("Pairing in progress", "webapp.bluetooth"),
                        strType: "info",
                        strContent: strContent,
                        arrPopupButtons: []
                    };
                    context.pairingPopup = ICTouchAPI.popupServices.addNewPopup(inProgress, "MEDIUM");
                    setTimeout(function() {
                        if (context.pairingPopup != null) {
                            ICTouchAPI.popupServices.removePopup(context.pairingPopup);
                        }
                    }, 60000); // 60 seconds
                },
                funcCallbackExit : function()  {
                    webapp.bluetooth.handleScan();
                }
            });
        }
    },

    handleDelete : function() {
        var data = webapp.bluetooth.data;
        if( this._currentAddress !== null )
        {
            var address = this._currentAddress;
            var device = data.devicesList[address];
            if( device !== undefined )
            {
                this._boolDelete = true;
                var type = device.intType;
                ICTouchAPI.APIServices.Bluetooth.BTRemovePairing({
                    params: [address, type]
                });
            }
        }
    },

    onInquiryResult: function(address, type) {
        var data = webapp.bluetooth.data;

        address = address.value;
        type = type.value;

        // addDevicesList is a hash map with address as key and an object as value
        if( data.addDevicesList[address] !== undefined )
            return;

        data.addDevicesList[address] = {
            intIndex: this.addDeviceNr,
            strAddress: address,
            intType : type
        };
        data.addDeviceNr++;

        webapp.settings.refreshWebappView();
    },

    onDeviceName: function(address, type, name) {
        var data = webapp.bluetooth.data;

        address = address.value;
        type = type.value;
        name = name.value;

        var list = data.addDevicesList;

        // Add the name
        if( list[address] !== undefined && list[address].strName === undefined && name.length > 0 ) {
            list[address].strName = name;
            // Change name for handset 2
            if(name == "IC Touch Handset"){
                list[address].strName = "Alcatel-Lucent BT Handset";
            }
            else {
                list[address].strName = name;
            }

            webapp.settings.refreshWebappView();
        }
    },

    onBondedDevice: function(address, type, name) {
        var data = webapp.bluetooth.data;

        address = address.value;
        type = type.value;
		// Change name for handset 2
		if(name.value == "IC Touch Handset"){
			name = "Alcatel-Lucent BT Handset";
		}
		else {
			name = name.value;
		}

            // devicesList is a hash map with address as key and an object as value
        if( data.devicesList[address] !== undefined )
            return;

        data.devicesList[address] = {
            intIndex: this.deviceNr,
            strAddress: address,
            strName: name,
            intType : type
        };
        data.deviceNr++;

        webapp.settings.refreshWebappView();
    },

    onBondResult: function(btdevice, btevtval) {
        var data = webapp.bluetooth.data;
        //reset the devices list
        data.addDeviceNr = 0;
        data.addDevicesList = [];

        /*
		 * 0  bluetooth handset
		 * 1  bluetooth headset
		 * 4  other device
		 */
        btdevice = btdevice.value;
        /*
		 * 1 success
		 * 0 fail
		 */
        //remove the In Progress popup
        if (this.pairingPopup != null) {
            ICTouchAPI.popupServices.removePopup(this.pairingPopup);
            // Switch view to show every device
            this.switchViews();
            this.pairingPopup = null;
        }
        btevtval = btevtval.value;
        if (btevtval == true)
        {
            // Device succesfully added

            this.stopScanning();
            //show Succes Popup
            var strContent = _("Succesfull pairing of Device", "webapp.bluetooth");
            var addSuccess = {
                strTitle: _("Success", "webapp.bluetooth"),
                strType: "info",
                strContent: strContent,
                arrPopupButtons: []
            };
            var addSuccessPopup = ICTouchAPI.popupServices.addNewPopup(addSuccess, "MEDIUM");
            setTimeout(function() {
                ICTouchAPI.popupServices.removePopup(addSuccessPopup);
            }, 4000); // 4 seconds
            // Switch view to show every device
            webapp.settings.getViewFromName("bluetooth",  "My Devices", "webapp.bluetooth.getMyDevices");
        }
        else
        {
            webapp.settings.getViewFromName("bluetooth",  "My Devices", "webapp.bluetooth.getMyDevices");
            //Show Failure Popup
            if(! webapp.bluetooth.addErrorPopup) {
                var strContent = _("The device could not be added", "webapp.bluetooth");
                var addError = {
                    strTitle: _("Add error", "webapp.bluetooth"),
                    strType: "error",
                    strContent: strContent,
                    arrPopupButtons: []
                };
                webapp.bluetooth.addErrorPopup = ICTouchAPI.popupServices.addNewPopup(addError, "MEDIUM");
                setTimeout(function() {
                    ICTouchAPI.popupServices.removePopup(webapp.bluetooth.addErrorPopup);
                    webapp.bluetooth.addErrorPopup = null;
                }, 4000); // 4 seconds
            }
        }
    },

    onDeleteDevice: function(btdevice, btevtval) {
        // Ignore this event if the user hasn't clicked on "Delete" button
        if( this._boolDelete !== true) {
            return;
        }
        else {
            this._boolDelete = false;
        }
        /*
		 * 0  bluetooth handset
		 * 1  bluetooth headset
		 * 4  other device
		 */
        btdevice = btdevice.value;

        /*
		 * 1 success
		 * 0 fail
		 */
        btevtval = btevtval.value;
        if (btevtval == false)
        {
            var strContent = _("Selected device could not be deleted", "webapp.bluetooth");
            var deleteError = {
                strTitle: _("Delete error", "webapp.bluetooth"),
                strType: "error",
                strContent: strContent,
                arrPopupButtons: []
            };
            var deleteErrorPopup = ICTouchAPI.popupServices.addNewPopup(deleteError, "MEDIUM");
            setTimeout(function() {
                ICTouchAPI.popupServices.removePopup(deleteErrorPopup);
            }, 4000); // 4 seconds
        }
        else
        {
            //refresh the list
            webapp.settings.getViewFromName("bluetooth",  "My Devices", "webapp.bluetooth.getMyDevices");
        };
    },

    switchViews : function(){
        var data = webapp.bluetooth.data;
        switch(data.CURRENT_WIDGET){
            case data.WIDGET_MYDEVICES:
                //reset the devices list
                data.addDeviceNr = 0;
                data.addDevicesList = [];

                var objView = {
                    label : "Add Device",
                    module: "bluetooth",
                    value: "webapp.bluetooth.getAddDevice"
                };
                break;
            case data.WIDGET_ADDDEVICE:
                var objView = {
                    label : "My Devices",
                    module: "bluetooth",
                    value: "webapp.bluetooth.getMyDevices"
                };
                this.stopScanning();
                break;
        }
        webapp.settings.getView(objView);
    },
    //stop the scanning process and toogle off the scanning led
    stopScanning: function() {
        if(!webapp.lock|| !webapp.lock.isLocked()){
            var data = webapp.bluetooth.data;
            if (this._boolScanning) {
                ICTouchAPI.APIServices.Bluetooth.BTStopInquiry({});
                this._boolScanning = false;
                var actionBar = webapp.settings.getActionBar();
                var button = actionBar.getButton(data.SCAN);
                button.attr('strStatusIcon', "notif-off");
            }
        }
    },

    // If settings is left, call stopScanning to cancel the scan if it was running
    onHideIFrame: function(srtFrameId) {
        if (srtFrameId == "webapp.settings.getSettings") {
            this.stopScanning();
        }
    }

});
