dojo.provide("webapp.voicemail.controlBase");
dojo.declare("webapp.voicemail.controlBase", ICTouchAPI.webApplication,
{

	// Widgets
	mainWidget              : null,
	objLogContent			: null,

	objPopupConfirmDelete	: null,
	idMessagePlayed			: null,
	boolMessagePaused		: null,

	popupWrongLogin			: null,

	constructor : function() {

	},

	load:function () {
		//help
		dojo.publish("needHelpEvent",["voicemail",[]]);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogChanged", this.apiNotifyComlogChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryAdded", this.apiNotifyComlogEntryAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryDeleted", this.apiNotifyComlogEntryDeleted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryChanged", this.apiNotifyComlogEntryChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyVoiceMailCountChanged", this.apiAddVoiceMailNotif);
	},

	loaded:function () {
		//ICTouchAPI.eventServices.subscribeToEvent(this, "notifyVoiceMailCountChanged", this.onNotifyVoiceMailCountChanged);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMAvailable", this, this.capabilityCallback);

		//Subscribe to visual voicemail events
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMPlaying", this.onVVMPlaying);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMPaused", this.onVVMPaused);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMStopped", this.onVVMStopped);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMDeleted", this.onVVMDeleted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMTransferred", this.onVVMTransferred);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMAccessLocked", this.onVVMAccessLocked);

		dojo.subscribe("ModeHotel", this, this.onModeHotel);

		dojo.subscribe("resetCustomExit", this, this.onResetCustomExit);

		dojo.subscribe("requestCustomVVMExit", this, this.onRequestCustomVVMExit);

		//Suscribe to dayChanged to refresh date label of items
		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged",this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);

		// Capabilities subscription
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMPlayMessage", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMPauseMessage", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMForwardToAnotherVM", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMForwardToVM", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMForwardByEmail", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMDeleteMessage", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMCallSender", this, this.capabilityCallback);

		// Format subscription
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyVmNumber", this.onVMNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyVmNumber", this, this.onVMNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.getSetting("TimeFormat", this,  this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
		ICTouchAPI.settingServices.getSetting("DateFormat", this,  this.onDateFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnablePhotoInComlog", this.onEnablePhotoInComlogChanged);
		ICTouchAPI.settingServices.getSetting("EnablePhotoInComlog", this, this.onEnablePhotoInComlogChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "VisualVoiceMailPasswordEnabled", this.onVisualVoiceMailPasswordEnabled);
		ICTouchAPI.settingServices.getSetting("VisualVoiceMailPasswordEnabled", this, this.onVisualVoiceMailPasswordEnabled);
		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreenSaversListChoice", this._onScreenSaversListChoiceChanged);
		ICTouchAPI.settingServices.getSetting("ScreenSaversListChoice", this, this._onScreenSaversListChoiceChanged);
		dojo.subscribe("ModeHotel", this.data, this.data.setHotelMode);

		var func={context: webapp.voicemail, func: this.onVoicemailSelected};

		this.data.objAllLog = new UIElements.MenuList.MenuListControl({
			boolShowNormalLeftIcon: true,
			autoSelectFirst : false,
			showEmptyState: true,
			callback: func
		});
		this.data.objUnreadLog = new UIElements.MenuList.MenuListControl({
			boolShowNormalLeftIcon: true,
			autoSelectFirst : false,
			showEmptyState: true,
			callback: func
		});
		this.data.loadVoicemailLog();
		this.initNotificationsValue();
	},

	buttonCallback : function(buttonId) {
		var data = this.data;
		var recordId=null;
		var objLog = this.data.getSelectedEntry();
		if(objLog){
			recordId = objLog.objLogData.wsRecordId;
		}
		switch(buttonId)
		{
			case data.BACK_BTN:
				dojo.publish("OpenHomepage");
			break;
			case data.CALLVM_BTN:
				ICTouchAPI.APIServices.Telephony.listenVM({params:[], context:this, callback:null, callbackParams:null});
			break;
			case data.PLAYVM_BTN:
				this.clbkPlayAction();
			break;
			case data.PAUSEVM_BTN:
				this.clbkPauseAction();
			break;
			case data.STOPVM_BTN:
				ICTouchAPI.APIServices.Telephony.stopMessage({params:[recordId], context:this, callback:null, callbackParams:null});
			break;
			case data.RESUMEVM_BTN:
				this.clbkPlayAction();
			break;
			case data.TRANSFERVM_BTN:
				this.showSearchPad({buttonType:data.TRANSFERVM_BTN});
			break;
			case data.TRANSFERVM_BY_MAIL_BTN:
				this.showSearchPad({buttonType:data.TRANSFERVM_BY_MAIL_BTN});
			break;
			case data.CALL_SENDER_BTN:
				var senderNum = objLog.objLogData.listContactSummary[0].officePhone;
				ICTouchAPI.APIServices.Telephony.callMessageSender({params:[recordId,senderNum], context:this, callback:null, callbackParams:null});
			break;
			case data.DELETE_LOG:
				this.openDeletePopup();
				break;
			case data.LISTEN_VM:
				this.apiCallVoicemail();
			break;

			default :
				console.warn("No callback is associated with this ID : " + buttonId);
			break;
		}
	},


	clbkPlayAction : function(){
		if(this.data.boolSliderLoaded) {
			var offsetSlider = this.data.sliderUI.currentSliderPosition/1000;
			var objMessage = this.data.arrMessages[this.data.intCurrentMessageId];
			if(! objMessage) {return;}
			if(objMessage.dateMessagePlayed){
				if(this.data.sliderUI.isSliderMoved()){
					ICTouchAPI.APIServices.Telephony.resumeMessage({params:[objMessage.intMessageId,offsetSlider], context:this, callback:null, callbackParams:null});
				}else {
					ICTouchAPI.APIServices.Telephony.resumeMessage({params:[objMessage.intMessageId,objMessage.intOffsetMessagePaused], context:this, callback:null, callbackParams:null});
				}
			} else {
				if(offsetSlider > 0){
					ICTouchAPI.APIServices.Telephony.resumeMessage({params:[objMessage.intMessageId,offsetSlider], context:this, callback:null, callbackParams:null});
				} else {
					ICTouchAPI.APIServices.Telephony.playMessage({params:[objMessage.intMessageId], context:this, callback:null, callbackParams:null});
				}
			}
		}
	},

	clbkPauseAction : function(){
		if(this.data.boolSliderLoaded) {
			ICTouchAPI.APIServices.Telephony.pauseMessage({params:[this.data.intCurrentMessageId], context:this, callback:null, callbackParams:null});
		}
	},

	clbkStopAction : function(){
		if(this.data.boolSliderLoaded) {
			ICTouchAPI.APIServices.Telephony.stopMessage({params:[this.data.intCurrentMessageId], context:this, callback:null, callbackParams:null});
		}
	},

	playSlider : function(offset) {
		if(this.data.sliderUI) {
			this.data.sliderUI.setToTime(offset);
			this.data.sliderUI.mediaPlay();
		}
	},

	pauseSlider : function(offset) {
		if(this.data.sliderUI) {
			this.data.sliderUI.mediaPause();
			this.data.sliderUI.setToTime(offset);
		}
	},

	onNotifyVoiceMailCountChanged : function(nrOfNotif)
	{
		for (var i = 0;i < nrOfNotif; i++) {
			ICTouchAPI.notificationServices.incNotification("Voicemail");
		}
	},

	capabilityCallback : function(capability, value)
	{
		var data = this.data;

		if(!data) {
			return;
		}

		switch (capability) {
			case "VVMPlayMessage":
				data.intPlayMessage = value;
			break;
			case "VVMPauseMessage":
				data.intPauseMessage = value;
			break;
			case "VVMDeleteMessage":
				data.intDeleteMessage = value;
			break;
			case "VVMCallSender":
				data.intCallSender = value;
			break;
			case "VVMForwardToVM":
				data.intForward = value;
			break;
			case "VVMForwardByEmail":
				data.intForwardToMail = value;
			break;
			case "VVMAvailable":
				if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
					data.voiceMailState = data.VISUAL;
				} else {
					data.voiceMailState = data.BASIC;
				}
				break;
		}
		this.upgradeAppbar();
	},

	upgradeAppbar : function(){
		var data = this.data;
        var appBar = ICTouchAPI.AppBarServices.getAppBar("voicemail", "voicemailStatus"+data.STATUS_VM);
		var arr = [];
		var intAvail = ICTouchAPI.CapabilityServices.AVAILABLE;
		var intUnavail = ICTouchAPI.CapabilityServices.UNAVAILABLE;
		var intTempUnavail = ICTouchAPI.CapabilityServices.TEMP_UNAVAILABLE;
        arr[data.CALLVM_BTN]				=	{btn : appBar.getButton(data.CALLVM_BTN)				, state : intUnavail};
        arr[data.PLAYVM_BTN]				=	{btn : appBar.getButton(data.PLAYVM_BTN)				, state : intUnavail};
        arr[data.PAUSEVM_BTN]				=	{btn : appBar.getButton(data.PAUSEVM_BTN)				, state : intUnavail};
        arr[data.STOPVM_BTN]				=	{btn : appBar.getButton(data.STOPVM_BTN)				, state : intUnavail};
        arr[data.RESUMEVM_BTN]				=	{btn : appBar.getButton(data.RESUMEVM_BTN)				, state : intUnavail};
        arr[data.TRANSFERVM_BTN]			=	{btn : appBar.getButton(data.TRANSFERVM_BTN)			, state : data.intForward};
        arr[data.TRANSFERVM_BY_MAIL_BTN]	=	{btn : appBar.getButton(data.TRANSFERVM_BY_MAIL_BTN)	, state : data.intForwardToMail};
        arr[data.CALL_SENDER_BTN]			=	{btn : appBar.getButton(data.CALL_SENDER_BTN)			, state : data.intCallSender};
		//arr[data.CONTACT_LOG]				=	{btn : appBar.getButton(data.CONTACT_LOG)			, state : intUnavail};
		arr[data.DELETE_LOG]				=	{btn : appBar.getButton(data.DELETE_LOG)				, state : data.intDeleteMessage};


		arr[data.CALLVM_BTN].state = intUnavail;
		if(data.voiceMailState === data.VISUAL){
			var objMessage = data.arrMessages[data.intCurrentMessageId];
			var objContact = objMessage ? objMessage.objContact : null;
			//Management of callback button
			if(objMessage
				&& (!objMessage.objVMLog.objLogData.listContactSummary[0].officePhone
					|| objMessage.objVMLog.objLogData.listContactSummary[0].officePhone == ""
					|| objMessage.objVMLog.objLogData.listContactSummary[0].officePhone == "****"
					|| objMessage.objVMLog.objLogData.listContactSummary[0].officePhone == "anonymous"
					)) {
				arr[data.CALL_SENDER_BTN].state = intUnavail;
			}
			//Management of play, pause, resume buttons
			if(data.intPlayMessage == intAvail){
				if(objMessage && objMessage.dateMessagePlayed){
					arr[data.PLAYVM_BTN].state = intUnavail;
					if(objMessage.dateMessagePaused && objMessage.dateMessagePaused > objMessage.dateMessagePlayed){
						arr[data.PAUSEVM_BTN].state = intUnavail;
						arr[data.RESUMEVM_BTN].state = intAvail;
						arr[data.STOPVM_BTN].state = intAvail;
					} else {
						arr[data.PAUSEVM_BTN].state = intAvail;
						arr[data.RESUMEVM_BTN].state = intUnavail;
						arr[data.STOPVM_BTN].state = intAvail;
					}
				} else {
					arr[data.PLAYVM_BTN].state = intAvail;
					arr[data.PAUSEVM_BTN].state = intUnavail;
					arr[data.RESUMEVM_BTN].state = intUnavail;
					arr[data.STOPVM_BTN].state = intTempUnavail;
				}
			} else if(data.intPlayMessage == intTempUnavail){
				arr[data.PLAYVM_BTN].state = intTempUnavail;
				arr[data.PAUSEVM_BTN].state = intTempUnavail;
				arr[data.RESUMEVM_BTN].state = intTempUnavail;
				arr[data.STOPVM_BTN].state = intTempUnavail;
			} else {
				arr[data.PLAYVM_BTN].state = intUnavail;
				arr[data.PAUSEVM_BTN].state = intUnavail;
				arr[data.RESUMEVM_BTN].state = intUnavail;
				arr[data.STOPVM_BTN].state = intUnavail;
			}
			if(data.intPauseMessage != intAvail){
				if(data.intPauseMessage == intTempUnavail) {
					arr[data.PAUSEVM_BTN].state = intTempUnavail;
					arr[data.RESUMEVM_BTN].state = intTempUnavail;
				} else {
					arr[data.PAUSEVM_BTN].state = intUnavail;
					arr[data.RESUMEVM_BTN].state = intUnavail;
				}
			}
			//arr[data.CONTACT_LOG].state = intAvail;
		} else {
			arr[data.PLAYVM_BTN].state = intUnavail;
			arr[data.PAUSEVM_BTN].state = intUnavail;
			arr[data.RESUMEVM_BTN].state = intUnavail;
			arr[data.STOPVM_BTN].state = intUnavail;
			arr[data.TRANSFERVM_BTN].state = intUnavail;
			arr[data.TRANSFERVM_BY_MAIL_BTN].state = intUnavail;
			arr[data.CALL_SENDER_BTN].state = intUnavail;
			arr[data.DELETE_LOG].state = intUnavail;
			//arr[data.CONTACT_LOG].state = intUnavail;
		}

		var intVmNumber = data.voicemailNumber;
		if(intVmNumber && intVmNumber != "") {
			arr[data.CALLVM_BTN].state = intAvail;
		}

		for (var i in arr){
			if(arr[i].btn && typeof arr[i].btn != 'string'){
				if(arr[i].state == intAvail){
					arr[i].btn.show();
				} else if(arr[i].state == intTempUnavail){
					arr[i].btn.greyTint();
				} else {
					arr[i].btn.hide();
				}
			}
		}
	},

	// This function is called to initiate a transfer. It opens a keyboard or a dial-pad.
	// If the webapp search exists, it's used (else a default dial-pad is used)
	showSearchPad : function(args) {
		var data = this.data;
		var buttonType = args.buttonType;
		// The "funcOpenDialpad" function will be called is webapp search when the dial-pad is deployed,
		//	and everytime it's swtiched between dial-pad and keyboard.
		var funcOpenDialpad = function() {

			};
		// Create the "search" object that contains parameters for the webapp search
		var objSearch = {
			contactDataTypes : null,
			useDefaultCallMethod : true,
			dialpadObject : {
				funcCallbackOk : function(){
					var callback = objSearch.lineClickCallback;
					callback.func.apply(callback.context, [this.getValue()]);
				},
				funcCallbackKeyPress : function(){
					ICTouchAPI.APIServices.Telephony.dialKeyEnter({});
				},
				funcCallbackExit : function(){
				},
				strOkLabel: _("Transfer","webapp.voicemail"),
				numPadLengthLimit : 40
			},
			onOpenDialpad : funcOpenDialpad
		};

		// Define the callback to be called to perform the requested action
		switch (buttonType) {
			case data.TRANSFERVM_BTN:
				objSearch.contactDataTypes = ["Phone"];
				objSearch.secondaryInformation = "phoneNumber"; // information of the contact to be displayed at the right of the contact's display name in the search results
				objSearch.lineClickCallback = {
					neededData: "phoneNumber",
					context: webapp.voicemail,
					func: this.transferToVMFromKeyboard
				};
				break;
			case data.TRANSFERVM_BY_MAIL_BTN:
				objSearch.contactDataTypes = ["address"];
				objSearch.secondaryInformation = "email"; // information of the contact to be displayed at the right of the contact's display name in the search results
				objSearch.lineClickCallback = {
					neededData: "email",
					context: webapp.voicemail,
					func: this.transferToMailFromKeyboard
				};
				break;
		}
		// If the search webapp exists, call it with the parameters defined above
		if (typeof webapp.search != "undefined") {
			webapp.search.doSearch(objSearch, 
				function() {
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						params: {}
				});
			});
		}
		// Else open standard dial-pad
		else
		{
			funcOpenDialpad();
			switch (searchType) {
				case data.SEARCH_NUMBER:
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUM, null, objSearch.dialpadObject);
					break;
				case data.SEARCH_MAIL:
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, objSearch.dialpadObject);
					break;
			}
		}
	},

	transferToVMFromKeyboard : function(value){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication", params: {}});
		var objLog = this.data.getSelectedEntry();
		ICTouchAPI.APIServices.Telephony.forwardMessageToVM({params:[objLog.objLogData.wsRecordId, value], context:this, callback:null, callbackParams:null});
	},

	transferToMailFromKeyboard : function(value){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication", params: {}});
		var objLog = this.data.getSelectedEntry();
		ICTouchAPI.APIServices.Telephony.forwardMessageByEmail({params:[objLog.objLogData.wsRecordId, value], context:this, callback:null, callbackParams:null}) ;
	},

	onVVMPlaying : function(messageId, offset){
		if(this.data.arrMessages[messageId.value] && offset){
			this.data.arrMessages[messageId.value].dateMessagePlayed = new Date().getTime();
			if(messageId.value == this.data.intCurrentMessageId){
				this.playSlider(offset.value);
			}
			this.idMessagePlayed = messageId.value;
			this.boolMessagePaused = false;
		}
		webapp.communication.data.setAvoidCommSwitch(true);
		this.upgradeAppbar();
		var logIdPlaying = this.getIdMessagePlayed();
		dojo.publish('VVMPlayingIdChanged', [logIdPlaying]);
	},

	onVVMPaused : function(messageId, offset){
		if(this.data.arrMessages[messageId.value] && offset){
			this.data.arrMessages[messageId.value].dateMessagePaused = new Date().getTime();
			this.data.arrMessages[messageId.value].intOffsetMessagePaused = offset.value;
			if(messageId.value == this.data.intCurrentMessageId){
				this.pauseSlider(offset.value);
			}
			this.boolMessagePaused = true;
		}
		this.upgradeAppbar();
	},

	onVVMStopped : function(messageId){
		if(this.data.arrMessages[messageId.value]){
			this.data.arrMessages[messageId.value].dateMessagePlayed = null;
			this.data.arrMessages[messageId.value].dateMessagePaused = null;
			this.data.arrMessages[messageId.value].intOffsetMessagePaused = null;
			if(this.data.intCurrentMessageId
				&& messageId.value == this.data.intCurrentMessageId){
				this.pauseSlider(0);
			}
			this.idMessagePlayed = null;
			this.boolMessagePaused = null;
		}
		webapp.communication.data.setAvoidCommSwitch(false);
		this.upgradeAppbar();
		dojo.publish('VVMPlayingIdChanged', [null]);
	},

	onVVMDeleted : function(messageId){
		if(this.data.arrMessages[messageId.value]){
			this.data.arrMessages.splice(messageId,1);
		}
		this.upgradeAppbar();
	},

	onVVMTransferred : function(messageId, destination){
		this.onVVMStopped(messageId);
		this.upgradeAppbar();
	},

	onVVMAccessLocked : function(){
		ICTouchAPI.debugServices.info("webapp.voicemail.controlBase - onVVMAccessLocked");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - onVVMAccessLocked / args: " + dojo.toJson(args));
		//args.comment && args.locked
		if(!args.locked){
			this.data.setPasswordVVMNeed(false);
			this.setCustomExit(false,"screensaver");
			this.setCustomExit(false,"lock");
			this.data.processRemoveUnreadList();
			this.switchList(this.data.currentObjListId || this.data.LOG_LIST_ALL);
			this.data.currentObjListId = null
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.voicemail.getVoicemail",
				params: {}
			});
		}else{
			this.setCustomExit(true,"screensaver");
			this.setCustomExit(false,"lock");
			this.data.setPasswordVVMNeed(true);
			if(args.comment=="TIMEOUT"){
				if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.voicemail") != -1){
					dojo.publish("OpenHomepage");
				}
			}else {
				var context = this;
				var strErrorMessage;
				var callback = function(){
					ICTouchAPI.popupServices.removePopup(context.popupWrongLogin);
				}
				var popupType = "error";
				switch(args.comment) {
					case "EXPIRED":
						//strErrorMessage = _(["Call", "Voicemail", ":", this.data.voicemailNumber], "webapp.voicemail").toString();
						strErrorMessage = _("Dial %s to initialize and change your password", "webapp.voicemail",[this.data.voicemailNumber]).toString();
						popupType = "info";
					break;
					case "LOCKED":
						strErrorMessage = "Account blocked. Please contact your administrator.";
					break;
					case "TEMPORARY_LOCKED":
						strErrorMessage = "Account temporarily blocked. Please try again in 5 minutes.";
					break;
					case "WRONG_PASSWORD":
						strErrorMessage = "Wrong password. Please try again.";
						// overwrite the callback function to open again the keyboard when the popup is closed
						callback = function(){
							ICTouchAPI.popupServices.removePopup(context.popupWrongLogin);
							context.askForVVMPassword();
						}
					break;

					default :
						strErrorMessage = "Request failed or webservices not available. Please try again later.";
						ICTouchAPI.debugServices.warning("webapp.voicemail.controlBase - onVVMAccessLocked / Unknown comment, comment is: " + args.comment + ". Use default error message.");
					break;
				}

				var popupData = {
					strType: popupType,
					strContent : _(strErrorMessage, 'UIElements.DialogBox'),
					arrPopupButtons: [{
						strButtonLabel: _('Dismiss', "ICTouchAPI"),
						strButtonIcon: "generic-cancel",
						callback : callback
					}]
				};

				this.popupWrongLogin = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
			}
		}
	},

	setCustomExit : function(boolCustomExit,webapName){
		switch(webapName)
		{
			case "screensaver":
				if(boolCustomExit){
					dojo.publish("customExitForScreensaverVVM",[true]);
					break;
				}else{
					dojo.publish("customExitForScreensaverVVM",[false]);
					break;
				}
			break;
			case "lock":
				if(boolCustomExit){
					dojo.publish("customExitForLockVVM",[true]);
					break;
				}else{
					dojo.publish("customExitForLockVVM",[false]);
					break;
				}
			break;
		}
	},

	onResetCustomExit : function(webapp){
		if(webapp){
			this.data.customExitWebapp[webapp] = false;
			this.data.boolVVMAlreadyLeft = false;
			this.setCustomExit(false,webapp);
		}
	},

	onRequestCustomVVMExit : function(webappName){
		this.data.customExitWebapp[webappName] = true;
		if(!this.data.boolVVMAlreadyLeft){
			if(!this.data.getPasswordVVMNeed()){
				if(webappName=="lock"){
					if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.voicemail") != -1){
						this.setCustomExit(true,webappName);
						this.data.boolVVMAlreadyLeft = true;
					}
				}else if(webappName=="screensaver"){
					if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.voicemail") != -1){
						this.data.boolVVMAlreadyLeft = true;
					}
				}
			}
		}else{
			if(!this.data.getPasswordVVMNeed()){
				if(webappName=="lock"){
					this.setCustomExit(true,webappName);
				}
			}
		}
	},


	onModeHotel : function(){
		this.data.displayTotalMessages = false;
	},

	getIdMessagePlayed : function() {
		var comlogId = null;
		if(this.data.arrMessages[this.idMessagePlayed]){
			comlogId = this.data.arrMessages[this.idMessagePlayed].objVMLog.objLogData.comLogEntryId;
		}
		return comlogId;
	},

	stopReadingMessage : function() {
		if(this.idMessagePlayed) {
			ICTouchAPI.APIServices.Telephony.stopMessage({params:[this.data.intCurrentMessageId], context:this, callback:null, callbackParams:null});
		}
	},

	checkAndStopMessage : function() {
		if(this.idMessagePlayed) {
			if(this.boolMessagePaused) {
				ICTouchAPI.APIServices.Telephony.stopMessage({params:[this.idMessagePlayed], context:webapp.voicemail, callback:null, callbackParams:null});
			}
		}
	},

	onDateFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data.dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			this.data.loadVoicemailLog();
		}
		objSetting=null;
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting != null) {
			this.data.time24hformat = objSetting.jsValue;
			this.data.loadVoicemailLog();
		}
		objSetting=null;
	},

	onVisualVoiceMailPasswordEnabled:function(objSetting){
		if(objSetting) {
			this.data.setVisualVoiceMailPasswordEnabled(objSetting.jsValue);
		}
		objSetting=null;
	},

	unlock: function(strWebapp) {
		dojo.publish("unlockTransition",[true]);
		this.checkAndStopMessage();
		this.data.processRemoveUnreadList();

		var reg = /^webapp\.(screensaver|lock)\.[^.]+/;
		if(!reg.test(strWebapp) && this.data.getScreensaverWebapp() != strWebapp){
			ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - unlock / Call IctUser.lockVVMAccessRequest");
			ICTouchAPI.APIServices.IctUser.lockVVMAccessRequest({});
		}
	},



	//Called when entry on 1/3 MenuList has pressed
	onVoicemailSelected : function(logId) {
		this.data.loadDetails(logId);
	},

	//Called when tab on 1/3 title has pressed
	switchList : function(listId, boolForce) {
		if(this.mainWidget && this.mainWidget.objMenu) {
			this.mainWidget.objMenu.selectTitleById(listId, true);
		}
		if(listId!==this.data.getDisplayedList() || boolForce) {
			if(listId !== this.data.LOG_LIST_UNREAD) {
				this.data.processRemoveUnreadList();
			}
			this.data.setDisplayedList(listId);
			if(this.objLogContent) {
				this.objLogContent.switchMenuList(listId);
			}
		}

			//Select previous selected entry
			var nbItems = this.data.getNbItems(listId);
			if(nbItems > 0) {
			var comlogId = this.data.getVMIdByRecordId(this.idMessagePlayed, listId);
			if(comlogId) {
				this.data.selectItemByIndex(comlogId, true, listId);
				}
				else {
				this.data.selectItemByPosition(0, true, listId);
				}
			}
			else {
				this.data.loadDetails(undefined);
			}
	},

	// Called when the Voicemail number has changed
	onVMNumberChanged: function(objSetting) {
		if (objSetting) {
			ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - onVMNumberChanged / previous voicemailNumber:" + this.data.voicemailNumber);
			this.data.voicemailNumber = objSetting.jsValue;
			ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - onVMNumberChanged / new voicemailNumber:" + this.data.voicemailNumber);
		}
		objSetting=null;
	},

	onVoicemailEnter : function(objListId){
		if(this.data.voiceMailState===this.data.VISUAL) {
			// Check if capabilities are available. If not, ask for a refresh.
			if(this.data.intPlayMessage == ICTouchAPI.CapabilityServices.UNAVAILABLE || this.data.intPauseMessage == ICTouchAPI.CapabilityServices.UNAVAILABLE){
				ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({params:["RefreshVVMCapabilitiesEvent"]});
			}
			if(this.data.getVisualVoiceMailPasswordEnabled()){
				this.data.currentObjListId = objListId;
				this.askForVVMPassword();
			}else{
				this.data.processRemoveUnreadList();
				this.switchList(objListId || this.data.LOG_LIST_ALL);
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.voicemail.getVoicemail",
					params: {}
				});
			}
		}else{
			// Basic voicemail: call VM
			this.apiCallVoicemail();
		}
	},


	askForVVMPassword : function(){
		ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUMPASSWORD,
		null,
		{
			strDefaultText: "",
			funcCallbackOk : function(password) {
				ICTouchAPI.APIServices.IctUser.unLockVVMAccessRequest({
					params:[password]
				});
			},
			funcCallbackExit : function() {
				// GO TO HOMEPAGE ?
			},
			strExitLabel: _('Cancel','ICTouchAPI'),
			strExitIcon: "generic-cancel",
			strInputTitle : _("Please enter your password :","webapp.voicemail"),
			hideStarsIfPasswordEmpty :true
		});
	},

	onEnablePhotoInComlogChanged : function(objSetting) {
		if(objSetting){
			this.data.boolEnablePhotoInComlog = objSetting.jsValue;
			this.data.loadVoicemailLog();
		}
		objSetting=null;
	},



	apiCallVoicemail: function() {
		if( this.data.voicemailNumber ) {
			ICTouchAPI.APIServices.Telephony.listenVM({});
		} else {
			// display an error popup as the TelephonyVMNumber setting is not defined
			ICTouchAPI.popupServices.errorPopup("", _("Voicemail number is not configured. Please contact your administrator.","webapp.voicemail"));
		}
	},

	apiNotifyComlogEntryAdded : function(objEvent) {
		objEvent = objEvent.value;
		if(objEvent && objEvent.entryType === ICTouchAPI.tools.enumComLogEntryType.VM){
			this.data.addInLog(objEvent);
		}
		objEvent=null;
	},

	apiNotifyComlogEntryDeleted : function(comlogId) {
		this.data.removeFromLog(comlogId.value);
		comlogId=null;
	},

	apiNotifyComlogEntryChanged: function(objEvent) {
		objEvent = objEvent.value;
		if(objEvent && objEvent.entryType === ICTouchAPI.tools.enumComLogEntryType.VM){
			this.data.modifyInLog(objEvent);
		}
		objEvent=null;
	},

	apiNotifyComlogChanged: function() {
		this.data.loadVoicemailLog();
	},



	// Open the delete popup with type choice
	openDeletePopup : function() {
		// Save context
		var context = this;

		context.data.intDeleteOption = context.data.DELETE_ONE;
		var selected = this.data.getSelectedEntry();
		var displayName = "";
		if (selected) {
			displayName = this.data.getSelectedEntryContactString();
		}

		// Create the popup data

		var popupDel = {
			strTitle: _("Select Voice mail entries to delete", "webapp.voicemail"),
			strWidgetName : "UIElements.SelectList.SelectListControl",
			arrItems: [ {
					boolSelected: true,
					intIndex: context.data.DELETE_ONE,
					strLabel: _(['Delete Voice mail from', displayName], "webapp.voicemail"),
					strSecondaryContentIcon: ""
				}, {
					boolSelected: false,
					intIndex: context.data.DELETE_ALL,
					strLabel: _('Delete all Voice mails', "webapp.voicemail"),
					strSecondaryContentIcon: ""
				} ],
			itemCallback : function(intIndex) {
				context.data.intDeleteOption = intIndex;
			},
			boolMultiselect: false,
			arrPopupButtons: [ {
					strButtonName: "DELETE_BTN",
					strButtonLabel: _('Delete', "ICTouchAPI"),
					strButtonIcon: "generic-mode-delete",
					callback : {
						func: context.deleteLog,
						context: context
					}
				}, {
					strButtonName: "CANCEL_BTN",
					strButtonLabel: _('Cancel', "ICTouchAPI"),
					strButtonIcon: "generic-cancel",
					callback : function(){
						ICTouchAPI.popupServices.removePopup(context.objPopupConfirmDelete);
					}
				}
			]
		};
		// Show the popup
		this.objPopupConfirmDelete = ICTouchAPI.popupServices.addNewPopup(popupDel, "MEDIUM");
	},

	deleteLog : function() {
		if(this.data.intDeleteOption === this.data.DELETE_ONE) {
			var selected = this.data.getSelectedEntry();
			if (selected && selected.objLogData) {
				if(this.idMessagePlayed === selected.objLogData.wsRecordId) {
					this.stopReadingMessage();
				}
				ICTouchAPI.APIServices.Comlog.deleteEntry({
					params:[selected.objLogData.comLogEntryId],
					context:this
				});
			}
		}
		else if(this.data.intDeleteOption === this.data.DELETE_ALL) {
			this.stopReadingMessage();
			ICTouchAPI.APIServices.Comlog.deleteWithMoreFilters({
				params:[this.data.COMLOG_FILTER_VM_BUSINESS_ID+":"+this.data.FILTER_ALL],
				context:this
			});
		}
		ICTouchAPI.popupServices.removePopup(this.objPopupConfirmDelete);
	},



	initNotificationsValue : function() {
		 ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "Voicemail",
			strNotificationLabel: _("Voicemail", "webapp.voicemail"),
			intNotificationValue: 0,
			callback: {
				context:this,
				func:this.onNotificationVoiceMail
			}
		});

		ICTouchAPI.APIServices.Comlog.count({
			params:[0,this.data.COMLOG_FILTER_VM_BUSINESS_ID],
			context:this,
			callback:function(count) {
				if(count>0){
					ICTouchAPI.ledServices.activate('communication','N_VM');
				}else{
					ICTouchAPI.ledServices.desactivate('communication','N_VM');
				}
				ICTouchAPI.notificationServices.setNotificationValue("Voicemail", count);
			}
		});
	},

	apiAddVoiceMailNotif : function(notif) {
		if(notif.value>0){
			ICTouchAPI.ledServices.activate('communication','N_VM');
		}else{
			ICTouchAPI.ledServices.desactivate('communication','N_VM');
		}
		ICTouchAPI.notificationServices.setNotificationValue("Voicemail",notif.value);
		notif=null;
	},

	onNotificationVoiceMail : function() {
		this.onVoicemailEnter(this.data.LOG_LIST_UNREAD);
	},

	onDayChanged: function() {
		this.data.loadVoicemailLog();
	},

	_onScreenSaversListChoiceChanged : function(screen){
		ICTouchAPI.debugServices.info("webapp.voicemail.controlBase - _onScreenSaversListChoiceChanged");
		this.data.setScreensaverWebapp(screen);
	}
});
dojo.require("webapp.voicemail.controlBase");
dojo.provide("webapp.voicemail");
dojo.declare("webapp.voicemail", webapp.voicemail.controlBase,
{

});
webapp.voicemail=new webapp.voicemail();
dojo.provide("webapp.voicemail.dataBase");
dojo.declare("webapp.voicemail.dataBase",null,{


	voicemailNumber			: null,

	// Current screensaver screen. Used for PPVVM.
	screensaverWebapp		: null,

	// For appBar
	arrAppBarSkeleton		: [],
	arrAllButtons			: [],

	// For basic voicemail view
	BasicVoicemailUI : null,
	nrOfVoicemail : 0,
	strLastDate : "",
	nrOfUnreadVoicemail : 0,
	displayTotalMessages : true,

	intCurrentMessageId	: null,
	_intDisplayedMenu		: null,
	_arrCurrentEntries		: [],

	arrItemsToRemove		: [],
	intDeleteOption			: 0,

	// Format settings
	_dateFormat 			: "",
	_24hformat  			: false, // 12 \ 24

	//Menu List object
	objAllLog				: null,
	objUnreadLog			: null,

	// 2/3 view
	_containerTitle			: null,
	_container				: null,

	//Array of messages
	arrMessages				: {},

	sliderUI				: null,
	boolSliderLoaded		: false,

	voiceMailState			: null,
	boolEnablePhotoInComlog	: false,

	intLoadingAllLog		: 0,
	intLoadingUnreadLog		: 0,

	//Constants for voicemail log list
	LOG_LIST_ALL			: 1,
	LOG_LIST_UNREAD			: 2,

	//Constants for loadDetails function
	DETAILS_EMPTY			: 0,
	DETAILS_BASIC			: 1,
	DETAILS_VISUAL			: 2,

	//Constant for appBar status
	STATUS_EMPTY_VM			: 1,
	STATUS_VM				: 2,

	//appBar buttons
	BACK_BTN				: "BACK_BTN",
	PLAYVM_BTN				: "PLAYVM_BTN",
	PAUSEVM_BTN				: "PAUSEVM_BTN",
	STOPVM_BTN				: "STOPVM_BTN",
	RESUMEVM_BTN			: "RESUMEVM_BTN",
	TRANSFERVM_BTN			: "TRANSFERVM_BTN",
	TRANSFERVM_BY_MAIL_BTN	: "TRANSFERVM_BY_MAIL_BTN",
	CALL_SENDER_BTN			: "CALL_SENDER_BTN",
	//CONTACT_LOG				: "CONTACT_LOG_BTN",
	DELETE_LOG				: "DELETE_LOG_BTN",
	VOICEMAIL_HOMEPAGE		: "VOICEMAIL_HOMEPAGE_BTN",
	CALLVM_BTN				: "CALLVM_BTN",

	//Constant for voiceMailState
	BASIC					: "basic",
	VISUAL					: "visual",

	// Constant Values for the ComlogFilters business id
	COMLOG_FILTER_VM_BUSINESS_ID	: 7,
	FILTER_UNREAD					: 0,
	FILTER_READ						: 1,
	FILTER_ALL						: 2,

	// Constant for delete option
	DELETE_ONE				: 0,
	DELETE_ALL				: 1,

	//States of capabilities
	intPlayMessage			: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intPauseMessage			: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intForward				: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intForwardToMail		: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intDeleteMessage		: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intCallSender			: ICTouchAPI.CapabilityServices.UNAVAILABLE,

	//Booleans of Voicemail state
	boolMessagePlaying		: false,
	boolMessagePaused		: false,

	intMessageId			: null,
	intNumberTmp			: null,
	dateVVMStart			: null,
	dateVVMEnd				: null,
	intOffsetMessagePaused	: null,
	strMailTmp				: null,

	STATUS_BASIC_VOICEMAIL : "Voicemail",

	// Number of entries in both lists
	_intNewVmNumber			: 0,
	_intAllVmNumber			: 0,

	passwordVVMNeed		: true,
	boolVVMAlreadyLeft	: false,
	customExitWebapp	: [],
	visualVoiceMailPasswordEnabled : false,
	currentObjListId : null,

	constructor : function(){
		this.voiceMailState = this.BASIC;
		this._containerTitle=_("Voicemail", "webapp.voicemail");
		this._container="webapp.voicemail.getEmptyVoicemail";

		var funcHomePageButton = function(){
			webapp.voicemail.onVoicemailEnter(webapp.voicemail.data.LOG_LIST_ALL);
		};
		// Add button on homepage
		ICTouchAPI.tools.registerHomepageButton(["webapp.voicemail.getVoicemail", this.VOICEMAIL_HOMEPAGE, "communication-voice-mail", _("Voicemail","webapp.voicemail"), null, funcHomePageButton]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.voicemail.getVoicemail", this.VOICEMAIL_HOMEPAGE, "communication-voice-mail", _("Voicemail","webapp.voicemail"), null, funcHomePageButton]);

		var func={
			context: webapp.voicemail,
			func: webapp.voicemail.buttonCallback
		};

		//Appbar buttons
		this.arrAllButtons[this.PLAYVM_BTN] = ({
			strButtonName: this.PLAYVM_BTN,
			strButtonLabel:_("Play VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-play',
			callback: func
		});
		this.arrAllButtons[this.PAUSEVM_BTN] = ({
			strButtonName: this.PAUSEVM_BTN,
			strButtonLabel:_("Pause VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-pause',
			callback: func
		});
		this.arrAllButtons[this.RESUMEVM_BTN] = ({
			strButtonName: this.RESUMEVM_BTN,
			strButtonLabel:_("Resume VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-play',
			callback: func
		});
		this.arrAllButtons[this.STOPVM_BTN] = ({
			strButtonName: this.STOPVM_BTN,
			strButtonLabel:_("Stop VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-stop',
			callback: func
		});
		/*this.arrAllButtons[this.TRANSFERVM_BTN] = ({strButtonName: this.TRANSFERVM_BTN, strButtonLabel:_("Forward to VM", "webapp.voicemail"), strButtonIcon: 'communication-deflect-to-voice-mail', callback: func});*/
		// WARNING : only descoped in R200, to keep for future versions
		/*this.arrAllButtons[this.TRANSFERVM_BY_MAIL_BTN] = ({strButtonName: this.TRANSFERVM_BY_MAIL_BTN, strButtonLabel:_("Forward by Mail", "webapp.voicemail"), strButtonIcon: 'mail-forward', callback: func	});*/
		this.arrAllButtons[this.CALL_SENDER_BTN] = ({
			strButtonName: this.CALL_SENDER_BTN,
			strButtonLabel:_("Callback", "webapp.voicemail"),
			strButtonIcon: 'communication-call-me-back',
			callback: func
		});
		this.arrAllButtons[this.DELETE_LOG] = {
			strButtonName: this.DELETE_LOG,
			strButtonLabel:_('Delete', 'ICTouchAPI'),
			strButtonIcon: 'generic-mode-delete',
			callback: func
		};
		this.arrAllButtons[this.CALLVM_BTN] = ({
			strButtonName: this.CALLVM_BTN,
			strButtonLabel:_("Call VM", "webapp.voicemail"),
			strButtonIcon: 'communication-voice-mail',
			callback: func
		});

		//Appbar
		this.arrAppBarSkeleton[this.STATUS_EMPTY_VM]= [this.CALLVM_BTN];
		this.arrAppBarSkeleton[this.STATUS_VM] = [this.PLAYVM_BTN,this.PAUSEVM_BTN,this.RESUMEVM_BTN,this.STOPVM_BTN,this.CALL_SENDER_BTN,this.CALLVM_BTN,/*this.CONTACT_LOG*/,this.DELETE_LOG,"MAGNIFY","homepageBtnHelp"];

		for(var i in this.arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("voicemail", "voicemailStatus" + i , this.arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("voicemail", "voicemailStatus" + i, true, func);
			for(var j in this.arrAppBarSkeleton[i]){
				var currentBtn = this.arrAppBarSkeleton[i][j];
				if(this.arrAllButtons[currentBtn]) {
					var objButton = new UIElements.AppButton.AppButtonControl(this.arrAllButtons[currentBtn]);
					appBar.addAppButton(objButton,false);
				}
			}
			appBar.buildDom();
		}
		ICTouchAPI.AppBarServices.setAppBar("voicemail", "voicemailStatus"+this.STATUS_EMPTY_VM, "getVoicemail");

		this._getSettings();
	},

	getVoiceMailTitle : function ()
	{
		return this._voiceMailtitle;
	},

	getListTitle : function() {
		return [
		{
			strIcon:"tabs-new-32",
			strLabel : _("New", "ICTouchAPI"),
			strLabelBottom:'(' + this.getIntNewVmNumber() + ')',
			intIndex:this.LOG_LIST_UNREAD
		},
		{
			strIcon:"voicemail-tabs-all-32",
			strLabel:_("VoicemailsTab", "webapp.voicemail"),
			strLabelBottom:'(' + this.getIntAllVmNumber() + ')',
			intIndex:this.LOG_LIST_ALL
			}
		]
	},

	// gets the settings for the app
	_getSettings : function(){
		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			// save the setting
			if (objSetting != null)
				this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			// get another setting
			ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
				// save the setting
				if(value != null)
					this._24hformat = value;
			});
		});
	},

	getContainerTitle : function () {
		return this._containerTitle;
	},

	getContainer : function () {
		return this._container;
	},

	getDisplayedList : function() {
		return this._intDisplayedMenu;
	},

	setDisplayedList : function(listId) {
		this._intDisplayedMenu = listId;
	},

	loadDetails : function(logId) {
		var appBar;
		this.setCurrentEntryId(logId, this.getDisplayedList());

		this.nrOfVoicemail = 0;
		this.nrOfUnreadVoicemail = 0;
		this.strLastDate = "";

		if(logId!=null) {
			var item = this.getSelectedEntry();

			var date = new Date(item.objLogData.dateTime.datetime.year, item.objLogData.dateTime.datetime.month - 1, item.objLogData.dateTime.datetime.day);
			this.strLastDate = ICTouchAPI.tools.getFormatedDate(date, this.dateFormat);
			this.strLastDate += " - " + ICTouchAPI.tools.getFormatedTime(item.objLogData.dateTime.datetime.hour, item.objLogData.dateTime.datetime.minute, this.time24hformat);
			var oldCount = 0;
			var newCount = 0;
			if(item.countNew) {
				newCount = item.countNew;
			}
			if(item.countOld) {
				oldCount = item.countOld;
			}
			this.saveVMs(oldCount,newCount);
		}

		if (this.voiceMailState === this.BASIC) {
			this.intCurrentMessageId = null;
			appBar = this.STATUS_VM;
			this._containerTitle=_("Voicemail", "webapp.voicemail");
			this._container="webapp.voicemail.getBasicVoicemail";

		} else {
			if(logId!=null) {
				this.updateMessages(item);
				this.intCurrentMessageId = item.objLogData.wsRecordId;
				appBar = this.STATUS_VM;
				this._container="webapp.voicemail.getVisualVoicemail";

				//Add name and first name on title if exist
				var currentContactString = this.getSelectedEntryContactString();
				if(currentContactString!=null && currentContactString!="") {
                                    if (currentContactString.replace(/\s/g,'') === "anonymous" || currentContactString.replace(/\s/g,'') === "***") {
                                       currentContactString = _("anonymous","ICTouchAPI");
                                    }
                                    this._containerTitle = currentContactString;
				}
				else {
					this._containerTitle=_("Voicemail", "webapp.voicemail");
				}
			}
			else {
				this.setCurrentEntryId(null, this.getDisplayedList());
				this.intCurrentMessageId = null;
				appBar = this.STATUS_EMPTY_VM;
				this._containerTitle=_("No voicemail", "webapp.voicemail");
				this._container="webapp.voicemail.getEmptyVoicemail";
			}
		}

		ICTouchAPI.AppBarServices.setAppBar("voicemail", "voicemailStatus"+appBar, "getVoicemail");
		if(webapp.voicemail.mainWidget) {
			webapp.voicemail.mainWidget.reloadContainer();
		}
		webapp.voicemail.upgradeAppbar();
	},

	saveVMs : function(intNumOld, intNumNew)
	{
		this.nrOfUnreadVoicemail = intNumNew;
		this.nrOfVoicemail = intNumOld + intNumNew;
	},

	updateMessages : function (item){
		var objMessage = this.arrMessages[item.objLogData.wsRecordId];
		if(objMessage){
			objMessage.objVMLog = item;
			objMessage.objContact = this.searchContactFromLog(item);
		} else {
			objMessage = {
				intMessageId				: item.objLogData.wsRecordId,
				objVMLog					: item,
				objContact					: this.searchContactFromLog(item),
				intOffsetMessagePaused		: null,
				dateMessagePlayed			: null,
				dateMessagePaused			: null
			};
		}
		this.arrMessages[objMessage.intMessageId] = objMessage;
	},

	updateCurrentMessageContact : function () {
		var intMessageId = this.intCurrentMessageId;
		if(this.arrMessages[intMessageId]){
			this.arrMessages[intMessageId].objContact = this.searchContactFromLog(this.arrMessages[intMessageId].objVMLog);
		}
	},

	getVMIdByRecordId : function(wsRecordId, listId) {
		var objList;
		if(listId == this.LOG_LIST_ALL){
			objList = this.objAllLog;
		}
		else {
			objList = this.objUnreadLog;
		}

		if(objList){
			for(var i in objList.arrItems){
				if(objList.arrItems[i].objLogData.wsRecordId == wsRecordId){
					return objList.arrItems[i].objLogData.comLogEntryId;
				}
			}
		}

		return null;
	},

	loadVoicemailLog : function() {
		this.intLoadingAllLog++;
		this.intLoadingUnreadLog++;
		// Call business function
		ICTouchAPI.APIServices.Comlog.findEntries({
			params:[this.FILTER_ALL, this.COMLOG_FILTER_VM_BUSINESS_ID],
			context:this,
			callback:this.loadedAllLog
		});
		ICTouchAPI.APIServices.Comlog.findEntries({
			params:[this.FILTER_UNREAD, this.COMLOG_FILTER_VM_BUSINESS_ID],
			context:this,
			callback:this.loadedUnreadLog
		});
	},

	loadedAllLog : function(_arr) {
		this.intLoadingAllLog--;
		if (this.intLoadingAllLog !== 0) {
			_arr = null;
			return;
		}
		ICTouchAPI.log("Start loadedAllVoicemailLog", "TELEPHONY");
		var arrVoicemailLog = [];
		if (_arr !== undefined) {
			for (var i in _arr) {
				var logObject = _arr[i];
				var objLog = this.buildLogItem(logObject);
				arrVoicemailLog.push(objLog);
			}
		}
		//Clean logs
		var nbLogs = this.getNbItems(this.LOG_LIST_ALL);
		this.sliceItems(0, nbLogs, this.LOG_LIST_ALL);

		// Insert new logs
		this.insertItems(0, arrVoicemailLog, this.LOG_LIST_ALL);
		this.setIntAllVmNumber(arrVoicemailLog.length);

		ICTouchAPI.log("End loadedAllVoicemailLog", "TELEPHONY");
		// If log are not being loaded, finalize loading
		var entry = this.findItemByPosition(0,this.LOG_LIST_ALL);
		if(this.getDisplayedList() === this.LOG_LIST_ALL) {
			if(entry){
				this.selectItemByIndex(entry.intIndex, false, this.LOG_LIST_ALL);
			}
			else {
				this.loadDetails(null);
			}
		}

		_arr=null;
	},

	loadedUnreadLog : function(_arr) {
		this.intLoadingUnreadLog--;
		if (this.intLoadingUnreadLog !== 0) {
			_arr = null;
			return;
		}
		ICTouchAPI.log("Start loadedUnreadVoicemailLog", "TELEPHONY");
		var arrVoicemailLog = [];
		if (_arr !== undefined) {
			for (var i in _arr) {
				var logObject = _arr[i];
				var objLog = this.buildLogItem(logObject);
				arrVoicemailLog.push(objLog);
			}
		}

		//Clean logs
		var nbLogs = this.getNbItems(this.LOG_LIST_UNREAD);
		this.sliceItems(0, nbLogs, this.LOG_LIST_UNREAD);

		// Insert new logs
		this.insertItems(0, arrVoicemailLog, this.LOG_LIST_UNREAD);
		this.setIntNewVmNumber(arrVoicemailLog.length);

		ICTouchAPI.log("End loadedUnreadoicemailLog", "TELEPHONY");
		// If log are not being loaded, finalize loading
		var entry = this.findItemByPosition(0,this.LOG_LIST_UNREAD);
		if(this.getDisplayedList() === this.LOG_LIST_UNREAD) {
			if(entry){
				this.selectItemByIndex(entry.intIndex, false, this.LOG_LIST_UNREAD);
			}
			else {
				this.loadDetails(null);
			}
		}
		_arr=null;
	},



	//Get current entry of selected log
	getCurrentEntry : function(intLog) {
		var id = this.getCurrentEntryId(intLog);
		if(id!=null) {
			var entry = this.findItemById(id, intLog);
			return entry;
		}
		else
			return null;

	},

	getCurrentEntryId : function(intList) {
		return this._arrCurrentEntries[intList];
	},

	setCurrentEntryId : function(intLogId, intList) {
		this._arrCurrentEntries[intList] = intLogId;
		intLogId=null;
	},

	//Get entry selected in 2/3
	getSelectedEntry : function() {
		var currentList = this.getDisplayedList();
		var entry = this.getCurrentEntry(currentList);
		return entry;
	},



	//Get number of items in selected log
	getNbItems : function(intLog) {
		if(intLog===this.LOG_LIST_ALL){
			return this.objAllLog ? this.objAllLog.arrItems.length : 0;
		}
		else if(intLog===this.LOG_LIST_UNREAD){
			return this.objUnreadLog ? this.objUnreadLog.arrItems.length : 0;
		}
		return 0;
	},

	//Find item by id in selected log
	findItemById : function(intId, intLog) {
		var entry = undefined;
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			entry = this.objAllLog.findItem("intIndex", intId);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			entry = this.objUnreadLog.findItem("intIndex", intId);
		}
		intId=null;
		return entry;
	},

	//Find item by position in selected log
	findItemByPosition : function(intPosition, intLog){
		var entry = undefined;
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			entry = this.objAllLog.arrItems[intPosition];
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog){
			entry = this.objUnreadLog.arrItems[intPosition];
		}
		intPosition=null;
		intLog=null;
		return entry;
	},

	//Select item by id in selected log
	selectItemByIndex : function(id, boolSelect, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			this.objAllLog.selectItemByIndex(id, boolSelect);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.selectItemByIndex(id, boolSelect);
		}
		id=null;
		boolSelect=null;
	},

	//Select item by posiition in selected log
	selectItemByPosition : function(intPosition, boolSelect, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			this.objAllLog.selectItemByPosition(intPosition, boolSelect);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog){
			this.objUnreadLog.selectItemByPosition(intPosition, boolSelect);
		}
		intPosition=null;
		boolSelect=null;
	},

	//Insert items in selected log
	insertItems : function(intPosition, arrItems, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.insertItems(intPosition, arrItems);
			this.increaseIntAllVmNumber(arrItems.length);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.insertItems(intPosition, arrItems);
			this.increaseIntNewVmNumber(arrItems.length);
		}
		intPosition=null;
		arrItems=null;
	},

	unshiftItem : function(objLog, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.unshiftItem(objLog, true);
			this.increaseIntAllVmNumber(1);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.unshiftItem(objLog, true);
			this.increaseIntNewVmNumber(1);
		}
		// auto select the first if no one is selected
		if ((this.getCurrentEntryId(intLog) == null || this.getCurrentEntryId(intLog) == undefined) && this.getDisplayedList() == intLog) { 
			this.selectItemByPosition(0, true, intLog);
		}

		objLog=null;
	},

	unshiftItems : function(arrLogs, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.unshiftItems(arrLogs, true);
			this.increaseIntAllVmNumber(arrLogs.length);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.unshiftItems(arrLogs, true);
			this.increaseIntAllVmNumber(arrLogs.length);
		}
		arrLogs=null;
	},


	sliceItems : function(intStart, intNb, intLog) {
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.sliceItems(intStart, intNb);
			this.decreaseIntAllVmNumber(intNb);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.sliceItems(intStart, intNb);
			this.decreaseIntNewVmNumber(intNb);
		}
		intStart=null;
		intNb=null;
	},

	//Remove item by id in selected log
	removeItemById : function(id, boolDoNotSelectNext, intLog){
		var removedItem = null;
		if(!boolDoNotSelectNext && intLog!==this.getDisplayedList()) {
			boolDoNotSelectNext = true;
		}
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			removedItem = this.objAllLog.removeItemByIntIndex(id, boolDoNotSelectNext);
			if(removedItem){
				this.decreaseIntAllVmNumber(1);
			}
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			removedItem = this.objUnreadLog.removeItemByIntIndex(id, boolDoNotSelectNext);
			if(removedItem){
				this.decreaseIntNewVmNumber(1);
			}
		}
		id=null;
		boolDoNotSelectNext=null;
		return removedItem;
	},

	updateItem : function(objLog){
		if(this.objAllLog) {
			this.objAllLog.updateItem(objLog);
		}
		if(this.objUnreadLog) {
			this.objUnreadLog.updateItem(objLog);
		}
		objLog=null;
	},



	addInLog : function(objLogData) {
		var isRead = objLogData.isRead;
		var objLog = this.buildLogItem(objLogData);
		this.unshiftItem(objLog, this.LOG_LIST_ALL);
		if(!isRead) {
			this.unshiftItem(objLog, this.LOG_LIST_UNREAD);
		}

	},

	removeFromLog : function(intLogId) {
		this.removeItemById(intLogId, false, this.LOG_LIST_ALL);
		this.removeItemById(intLogId, false, this.LOG_LIST_UNREAD);
		var displayedList = this.getDisplayedList();
		if((displayedList===this.LOG_LIST_ALL && this.getNbItems(this.LOG_LIST_ALL)===0) ||
			(displayedList===this.LOG_LIST_UNREAD &&  this.getNbItems(this.LOG_LIST_UNREAD)===0)) {
			this.loadDetails(undefined);
		}
	},

	modifyInLog : function(objLogData) {
		var isRead = objLogData.isRead;
		var objLog = this.buildLogItem(objLogData);
		this.updateItem(objLog, this.LOG_LIST_ALL);
		if(isRead) {
			if(this.getDisplayedList() === this.LOG_LIST_UNREAD) {
				this.addToRemoveUnreadList(objLogData.comLogEntryId);
			}
			else {
				this.removeItemById(objLogData.comLogEntryId, false, this.LOG_LIST_UNREAD);
			}
		}
		else {
			this.updateItem(objLog, this.LOG_LIST_UNREAD);
		}
	},

	//Add id of unread item to arrItemsToRemove
	addToRemoveUnreadList : function(intLogId) {
		this.arrItemsToRemove.push(intLogId);
	},

	//Remove unread item saved on arrItemsToRemove
	processRemoveUnreadList : function() {
		while(this.arrItemsToRemove.length>0) {
			var id = this.arrItemsToRemove.pop();
			this.removeItemById(id, false, this.LOG_LIST_UNREAD);
		}
		var displayedList = this.getDisplayedList();
		if(displayedList===this.LOG_LIST_UNREAD &&  this.getNbItems(this.LOG_LIST_UNREAD)===0) {
			this.loadDetails(undefined);
		}
	},

	buildLogItem : function(logObject) {
		// built the start time to be displayed in comlog
		var objDate = new Date(logObject.dateTime.datetime.year, logObject.dateTime.datetime.month - 1, logObject.dateTime.datetime.day, logObject.dateTime.datetime.hour, logObject.dateTime.datetime.minute, logObject.dateTime.datetime.second || 0);
		var strTime = this.getFormatedDateForLog(objDate);

		var objLog = {
			strPrimaryIcon: "",
			strPrimaryContent: "",
			strSecondaryContent: strTime,
			objLogData: logObject,
			alternateStyle: true,
			intIndex: logObject.comLogEntryId
		};

		var objContact = this.searchContactFromLog(objLog);
		objLog.strPicture = (objContact.photo) ? objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");

		if(logObject.countOld) {
			objLog.countOld = logObject.countOld;
		} else {
			objLog.countOld = 0;
		}
		if(logObject.countNew) {
			objLog.countNew = logObject.countNew;
		} else {
			objLog.countNew = 0;
		}

		var logType = ICTouchAPI.tools.getLogDataFromStatus(logObject,"24");
		objLog.strPrimaryIcon = logType.strIcon;

		if(objContact.name || objContact.firstName){
			objLog.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objContact);
		}
		else if (logObject.listContactSummary && logObject.listContactSummary[0]) { // use uppermost the name / FirstName of the ContactSummary
			objLog.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(logObject.listContactSummary[0]);
		}
		else if (logObject.listDisplayName && logObject.listDisplayName[0]) {
			objLog.strPrimaryContent = logObject.listDisplayName[0];
		}
		else {
			objLog.strPrimaryContent = logObject.listContactSummary[0].officePhone;
		}
                
               if (objLog.strPrimaryContent.replace(/\s/g,'')==="anonymous" || objLog.strPrimaryContent.replace(/\s/g,'')==="***") {   
                         objLog.strPrimaryContent=_("anonymous","ICTouchAPI");
               }

		if (!objLog.strPrimaryContent) {
			objLog.strPrimaryContent = _("Voicemail", "webapp.voicemail");
		}
		if(!objContact.photo) {
			objLog.strPicture = ICTouchAPI.tools.getDefaultPhotoPath("voicemail", "50");
		}

		// Entry not read
		if (logObject.isRead !== true && logObject.isRead !== 1) {
			this.boolOneUnread = true;
			objLog.alternateStyle = false;
		}

		// Contact picture may be disabled by setting, so we delete it.
		if(!this.boolEnablePhotoInComlog){
			objLog.strPicture = null;
		}
		logObject=null;
		return objLog;
	},

	searchContactFromLog: function(item){
		var phoneNumber, label;
		// Get the correct phoneNumber and displayName to use.
		if (item.objLogData.listContactSummary && item.objLogData.listContactSummary[0]) { // use uppermost the name / FirstName of the ContactSummary
			if(item.objLogData.listContactSummary[0].name || item.objLogData.listContactSummary[0].firstName) {
				label = [item.objLogData.listContactSummary[0].name,item.objLogData.listContactSummary[0].firstName];
			}
			phoneNumber = (item.objLogData.listContactSummary[0].officePhone) ? item.objLogData.listContactSummary[0].officePhone : "";
		}
		if (!label) { // If there is no name / FirstName in the ContactSummary, use the display name
			if (item.objLogData.listDisplayName && item.objLogData.listDisplayName[0]) {
				label = item.objLogData.listDisplayName[0];
			}
		}
		// Search in dataStore.
		var objContact = (phoneNumber)?ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],phoneNumber)[0]:undefined;

		if (!objContact) {
			// If  not in datastore, use cache, use the phonecall info
			objContact = this.createContactFromNumber(label, phoneNumber);
		}
		item=null;
		return objContact;
	},

	createContactFromNumber: function(label, phoneNumber) {
		if (!label || label === ""){
			label = phoneNumber;
		}
		var objContact;
		if (typeof label === "object" && label[0] !== undefined && label[1] !== undefined) { // label can be an array with [LastName, FirstName]
			objContact = {
				contactId: -1,
				name: label[0],
				firstName: label[1],
				officePhone: phoneNumber,
				officePhoneCan: phoneNumber,
				contactFromNumber: true
			};
		}
		else {
			objContact = {
				contactId: -1,
				name: label,
				firstName: "",
				officePhone: phoneNumber,
				officePhoneCan: phoneNumber,
				contactFromNumber: true
			};
		}
		label=null;
		phoneNumber=null;
		return objContact;
	},

	getFormatedDateForLog : function(startDate){
		// start time
		var today = new Date();
		var strTime = ICTouchAPI.tools.getFormatedTime(startDate.getHours(), startDate.getMinutes(), this.time24hformat);
		if (startDate.getDate() !== today.getDate() || startDate.getMonth() !== today.getMonth() || startDate.getFullYear() !== today.getFullYear()) {
			// not today we print the date
			strTime = ICTouchAPI.tools.getFormatedDate(startDate, "dd/mm ") + strTime;
		}
		startDate = null;
		return strTime;
	},

	getSelectedEntryContactString : function() {
		var objContact = this.arrMessages[this.intCurrentMessageId].objContact;
		var strContactName = (objContact && objContact.name) ? objContact.name : "";
		var strContactFirstname = (objContact && objContact.firstName) ? objContact.firstName : "";
		if(strContactFirstname!="" || strContactName!="") {
			var objContactTmp = {
				name : strContactName,
				firstName : strContactFirstname
			};
			return ICTouchAPI.tools.getContactDisplayName(objContactTmp);
		}
		return "";
	},

	getHotelMode : function() {
		return this.boolHotelMode;
	},

	setHotelMode : function() {
		this.boolHotelMode = true;
		if(webapp.voicemail.mainWidget) {
			webapp.voicemail.mainWidget.reloadContainer();
		}
	},

	refreshVmListTitle : function() {
		if(webapp.voicemail.mainWidget){
			webapp.voicemail.mainWidget.objMenu.getTitle().updateContent(this.getListTitle());
		}
	},

	setScreensaverWebapp: function(screensaverSetting) {
		if( screensaverSetting ) {	// Note: screensaver can be undefined(?) or null
			this.screensaverWebapp = screensaverSetting.allowedValues[screensaverSetting.jsValue].id;
		}
	},

	getScreensaverWebapp: function() {
		return this.screensaverWebapp;
	},

	getIntNewVmNumber : function() {
		return this._intNewVmNumber;
	},

	setIntNewVmNumber : function(intNewVmNumber) {
		if(this._intNewVmNumber !== intNewVmNumber){
			this._intNewVmNumber = intNewVmNumber;

			// Change corresponding title
			this.refreshVmListTitle();
		}
	},

	increaseIntNewVmNumber : function(intNb) {
		this.setIntNewVmNumber(this.getIntNewVmNumber() +intNb);
	},

	decreaseIntNewVmNumber : function(intNb) {
		var newIntNewVmNumber = this.getIntNewVmNumber() -intNb;
		if(newIntNewVmNumber < 0){
			newIntNewVmNumber = 0;
		}
		this.setIntNewVmNumber(newIntNewVmNumber);
	},

	getIntAllVmNumber : function() {
		return this._intAllVmNumber;
	},

	setIntAllVmNumber : function(intAllVmNumber) {
		if(this._intAllVmNumber !== intAllVmNumber){
			this._intAllVmNumber = intAllVmNumber;

			// Change corresponding title
			this.refreshVmListTitle();
		}
	},

	increaseIntAllVmNumber : function(intNb) {
		this.setIntAllVmNumber(this.getIntAllVmNumber() +intNb);
	},

	decreaseIntAllVmNumber : function(intNb) {
		var newIntAllVmNumber = this.getIntAllVmNumber() - intNb;
		if(newIntAllVmNumber < 0){
			newIntAllVmNumber = 0;
		}
		this.setIntAllVmNumber(newIntAllVmNumber);
	},

	getPasswordVVMNeed : function(){
		return this.passwordVVMNeed;
	},

	setPasswordVVMNeed : function(_bool){
		this.passwordVVMNeed = _bool;
	},

	getVisualVoiceMailPasswordEnabled : function(){
		return this.visualVoiceMailPasswordEnabled;
	},

	setVisualVoiceMailPasswordEnabled : function(_bool){
		this.visualVoiceMailPasswordEnabled = _bool;
	}
});
dojo.require("webapp.voicemail.dataBase");
dojo.provide("webapp.voicemail.data");
dojo.declare("webapp.voicemail.data",webapp.voicemail.dataBase,{

    
});

webapp.voicemail.data=new webapp.voicemail.data();
dojo.provide("webapp.voicemail.getVoicemailBase");
dojo.declare("webapp.voicemail.getVoicemailBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {

	}
);dojo.require("webapp.voicemail.getVoicemailBase");
dojo.provide("webapp.voicemail.getVoicemail");
dojo.declare("webapp.voicemail.getVoicemail",
	webapp.voicemail.getVoicemailBase,
	{
		templatePath: dojo.moduleUrl("webapp.voicemail","templates/getVoicemail8082.html"),

		objBaseView				: null,
		objContainer			: null,
		objMenu					: null,
		handleTitleClick		: null,


		constructor : function() {
		},

		postCreate : function() {
			var data = webapp.voicemail.data;
			this.objBaseView = new UIElements.ApplicationMode.ThirdControl(
				{
					menu : {
						name    : "webapp.voicemail.getVoicemailLog",
						params  : {}
					},
					container : {
						name    : data.getContainer(),
						params	: {}
					},
					objMenuTitle : {
						clickTitleCallback : {context:webapp.voicemail,func:webapp.voicemail.switchList},
						arrItems: data.getListTitle()
					},
					objContainerTitle : {
						arrItems: [{strLabel:data.getContainerTitle()}]
					}
				}, this.domVoicemail);

			this.objContainer = this.objBaseView.getContainer();
			this.objMenu = this.objBaseView.getMenu();
			webapp.voicemail.mainWidget = this;
			webapp.voicemail.objLogContent = this.objBaseView.getMenu().getContent();
			webapp.voicemail.switchList(data.getDisplayedList(), true);
		},
		
		reloadContainer : function() {
			this.objContainer.reload({
				objTitle: {strLabel: webapp.voicemail.data.getContainerTitle()},
				objContent: {name: webapp.voicemail.data.getContainer(), params: {}},
			});
		},

		destroy : function(){
			this.disconnect(this.handleTitleClick);
			dojo.destroy(this.objMenu);
			dojo.destroy(this.objContainer);
			this.objBaseView.destroy();
			this.inherited(arguments);
		}
	

	}
);dojo.provide("webapp.voicemail.getVoicemailLogBase");
dojo.declare("webapp.voicemail.getVoicemailLogBase",
    [ICTouchAPI.webWidget],
    {

	}
);dojo.require("webapp.voicemail.getVoicemailLogBase");
dojo.provide("webapp.voicemail.getVoicemailLog");
dojo.declare("webapp.voicemail.getVoicemailLog",
	webapp.voicemail.getVoicemailBase,
	{
		templatePath: dojo.moduleUrl("webapp.voicemail","templates/getVoicemailLog8082.html"),


		constructor : function() {
		},

		postCreate : function() {
			var data = webapp.voicemail.data;			
			data.objAllLog.placeAt(this.domAll);
			data.objUnreadLog.placeAt(this.domUnread);			
		},

		destroy : function(){
			this.inherited(arguments);
		},		

		switchMenuList : function(strMenu) {			
			var data = webapp.voicemail.data;
			if(strMenu === data.LOG_LIST_ALL) {		
				dojo.toggleClass(this.domUnread,"hiddenMenu",true);
				dojo.toggleClass(this.domAll,"hiddenMenu",false);
			}
			else if(strMenu === data.LOG_LIST_UNREAD) {
				dojo.toggleClass(this.domAll,"hiddenMenu",true);
				dojo.toggleClass(this.domUnread,"hiddenMenu",false);
			}
		}
			
		

	}
);dojo.provide("webapp.voicemail.getBasicVoicemailBase");
dojo.declare("webapp.voicemail.getBasicVoicemailBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
        domMainList   :  null,
        domScroll : null,
        domContainerTitle : null,

        strVoiceIconPath    : "",


        constructor: function() {
			//this.strVoiceIconPath = "library/ICTouchAPI/themes/Default/images/picture_family.png";
			this.strVoiceIconPath = ICTouchAPI.tools.getDefaultPhotoPath("voicemail", "100");
        },

        postCreate: function() {
            var data = webapp.voicemail.data;

            var listVoicemail = [];
            listVoicemail.push({strLabel : _("Message date", "webapp.voicemail"), strContent : data.strLastDate});
            if( webapp.voicemail.data.displayTotalMessages) {
				listVoicemail.push({strLabel : _("Total messages", "webapp.voicemail"), strContent : data.nrOfVoicemail});
			}
            listVoicemail.push({strLabel : _("Unread messages", "webapp.voicemail"), strContent : data.nrOfUnreadVoicemail});


            //new UIElements.ContainerTitle.ContainerTitleControl({strLabel : _("Voicemail", "webapp.voicemail")}, this.domContainerTitle);
            new UIElements.PresentationList.PresentationListControl({arrItems : listVoicemail, boolScroll : false, boolShowLabel: true}, this.domMainList);


             data.BasicVoicemailUI = this;

        },

        load : function()
        {

        }

    }
    );dojo.require("webapp.voicemail.getBasicVoicemailBase");
dojo.provide("webapp.voicemail.getBasicVoicemail");
dojo.declare("webapp.voicemail.getBasicVoicemail",
	webapp.voicemail.getBasicVoicemailBase,
	{
		templatePath: dojo.moduleUrl("webapp.voicemail","templates/getBasicVoicemail8082.html"),
	}
);dojo.provide("webapp.voicemail.getVisualVoicemailBase");
dojo.declare("webapp.voicemail.getVisualVoicemailBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
        // Contact header data
		boolPresenceInfo			: false,
		strPresenceIcon				: "",
		strContactPhotoPath			: "",
		strContactCompany			: "",
		strContactPosition			: "",
		strContactLocation			: "",
		domVMPresenceIcon				: null,
		scroll					: null,

		boolHasBusinessInformation	: false,
        boolHasPersonnalInformation	: false,
        boolHasContactInformation	: false,

		boolUrgent : null,
		strUrgentIcon : null,
		strUrgentLabel : null,
		domUrgentText : null,
		domUrgentIcon : null,

		attributeMap: {
			"strUrgentLabel": {
				node: "domUrgentText",
				type: "innerHTML"
			}
		},

        constructor: function() {
			//TODO get the good contact
			//Communication problem
			var objMessage = webapp.voicemail.data.arrMessages[webapp.voicemail.data.intCurrentMessageId];
			if(! objMessage) {return;}
			webapp.voicemail.data.updateCurrentMessageContact();
            var objContact = objMessage.objContact;

            this.strContactName = (objContact && objContact.name) ? objContact.name : "";
            this.strContactFirstname = (objContact && objContact.firstname) ? objContact.firstname : "";
            this.strContactPhotoPath = (objContact && objContact.photo) ? objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("voicemail", "100");
            this.strContactCompany = (objContact.miscMap && objContact.miscMap.company) ? objContact.miscMap.company : "";
			this.strContactPosition = (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "";
			this.strContactLocation = (objContact.miscMap && objContact.miscMap.city) ? objContact.miscMap.city : "";

			this.boolUrgent = (objMessage.objVMLog.objLogData.entryPriority == 2)?true:false; // 2 = high priority
			if(this.boolUrgent){
				this.strUrgentIcon = 'communication-log-log-voicemail-priority-24';
				// replacing this.strUrgentText by Label
				this.strUrgentLabel = _("Message flagged as urgent", "webapp.voicemail");
			}
            //this.strContactLocation = (objContact && objContact.company) ? objContact.company.locality.city : "";

			this.strPresenceIcon = "";
			if(objContact.contactId && objContact.contactId >= 0){
				ICTouchAPI.APIServices.InstantMessaging.getPresenceForContact({context : this, params: [objContact.contactId], callback: this.handlePresence});
			}
		},

		handlePresence: function(presenceList) {
			if (presenceList.length != 0 && presenceList[0]) {
				//change the Presence Icon
				this.strPresenceIcon = ICTouchAPI.tools.getPresenceIconPath(presenceList[0].imPresenceValue.value.labelStatus);
				if (this.strPresenceIcon != "") {
					dojo.addClass(this.domVMPresenceIcon, this.strPresenceIcon);
					this.boolPresenceInfo = true;
				}
			}
        },

		postMixInProperties : function() {
            // Only show PersonnalInformation if one of these is non null
            this.boolHasPersonnalInformation = (
            this.strContactFirstname.length > 0 ||
            this.strContactName.length > 0);
            // Only show businessInformation if one of these is non null
            this.boolHasBusinessInformation = (
            this.strContactCompany.length > 0 ||
            this.strContactPosition.length > 0 ||
            this.strContactLocation.length > 0);
            // Only show ContactInformation if one of these is true
            this.boolHasContactInformation = (
            this.boolHasPersonnalInformation ||
            this.boolHasContactCallingStatus ||
            this.boolHasBusinessInformation );

			if(webapp.voicemail.data.getHotelMode()){
				this.strContactPhotoClass = "ContactHotelPhoto";
			} else {
				this.strContactPhotoClass = "ContactPhoto";
			}
        },

        postCreate: function() {
			if(this.boolUrgent && this.strUrgentIcon){
				dojo.addClass(this.domUrgentIcon, this.strUrgentIcon);
			}
			
			var objMessage = webapp.voicemail.data.arrMessages[webapp.voicemail.data.intCurrentMessageId];
			if(! objMessage) {return;}
            var objContact = objMessage.objContact;
			var duration = 60;
			if(objMessage.objVMLog.objLogData.dateTime && objMessage.objVMLog.objLogData.endTime){
				var start = objMessage.objVMLog.objLogData.dateTime;
				var end = objMessage.objVMLog.objLogData.endTime;
				var objDateStart = new Date(start.datetime.year, start.datetime.month - 1, start.datetime.day, start.datetime.hour, start.datetime.minute, start.datetime.second);
				var objDateEnd = new Date(end.datetime.year, end.datetime.month - 1, end.datetime.day, end.datetime.hour, end.datetime.minute, end.datetime.second);
				// For the duration, to have the same value as My IC PC (which seems more realist), we have to do -1...
				duration = Math.floor(dojo.date.difference(objDateStart , objDateEnd, "second") - 1);
			}
			webapp.voicemail.data.boolSliderLoaded = false;
			var slider = null;
			if (webapp.voicemail.data.intPauseMessage == ICTouchAPI.CapabilityServices.AVAILABLE){
				slider = new UIElements.Media.Audio({
									intSliderY : 10,
									intMediaDuration: duration*1000,
									intSliderWidth : 400,
									_boolPlaying : false,
									autopauseOnMove : false,
									boolSeekable : false,
									boolShowSliderButton : false
								}, this.domVMSlider);
			}
			else{
				slider = new UIElements.Media.Audio({
									intSliderY : 10,
									intMediaDuration: duration*1000,
									intSliderWidth : 400,
									boolCanPause : false,
									_boolPlaying : false,
									autopauseOnMove : false,
									boolSeekable : false
								}, this.domVMSlider);
			}
			slider._boolPlaying = false;
			slider.autopauseOnMove = false;
			slider.clbkPlay = dojo.hitch(webapp.voicemail, webapp.voicemail.clbkPlayAction);
			slider.clbkStop = dojo.hitch(webapp.voicemail, webapp.voicemail.clbkStopAction);
			if (webapp.voicemail.data.intPauseMessage == ICTouchAPI.CapabilityServices.AVAILABLE){
				slider.clbkPause = dojo.hitch(webapp.voicemail, webapp.voicemail.clbkPauseAction);
				slider.actionOnMoveEnd = "pause";
			}
			webapp.voicemail.data.boolSliderLoaded = true;
			slider.setValue(0);
			webapp.voicemail.upgradeAppbar();
			var toPlay = false;
			if(slider){
				if(objMessage.dateMessagePlayed){
					var diff = 0;
					var currentDate = new Date().getTime();
					if(objMessage.dateMessagePaused && objMessage.dateMessagePlayed < objMessage.dateMessagePaused){
						slider.setToTime(objMessage.intOffsetMessagePaused);
					} else if(objMessage.dateMessagePaused && objMessage.dateMessagePlayed > objMessage.dateMessagePaused){
						diff = Math.floor(currentDate - objMessage.dateMessagePlayed)/1000;
						slider.setToTime(objMessage.intOffsetMessagePaused + diff);
						toPlay = true;
					} else {
						diff = Math.floor(currentDate - objMessage.dateMessagePlayed)/1000;
						slider.setToTime(diff);
						toPlay = true;
					}
				}
			}

			var _arr = [];
			if(objContact.contactId) {
				var _arrLabels = ICTouchAPI.tools.getContactFieldLabels();
				var item;
				for (var i in _arrLabels) {
					if (_arrLabels[i].type != "Header" && objContact[_arrLabels[i].id]) {
						item = {
							strId: _arrLabels[i].id,
							strLabel: _(_arrLabels[i].label,"webapp.communication"),
							strContent: (objContact[_arrLabels[i].id] === "anonymous" || objContact[_arrLabels[i].id] === "***") ? _("anonymous","ICTouchAPI") : objContact[_arrLabels[i].id],
							strType: _arrLabels[i].type
						};
						_arr.push(item);
					}
				}
			}
			if(_arr && _arr.length > 0){
				new UIElements.PresentationList.PresentationListControl({
					arrItems : _arr,
					boolScroll : false,
					boolShowIcon: true,
					boolShowLabel: true,
					strDisplay:'contactcard'
				}, this.domVMContactDetails);
			}
			
			if(toPlay) {
				slider.mediaPlay();
			}
			webapp.voicemail.data.sliderUI = slider;

			this.scroll = FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});
        },

        load : function()
        {

        },

		destroy: function() {
            if( this.scroll ) this.scroll = null;
            this.inherited("destroy", arguments);
        }
    }
    );
dojo.require("webapp.voicemail.getVisualVoicemailBase");
dojo.provide("webapp.voicemail.getVisualVoicemail");
dojo.declare("webapp.voicemail.getVisualVoicemail",
	webapp.voicemail.getVisualVoicemailBase,
	{
		templatePath: dojo.moduleUrl("webapp.voicemail","templates/getVisualVoicemail8082.html"),
	}
);dojo.provide("webapp.voicemail.getEmptyVoicemailBase");
dojo.declare("webapp.voicemail.getEmptyVoicemailBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {

	}
);dojo.require("webapp.voicemail.getEmptyVoicemailBase");
dojo.provide("webapp.voicemail.getEmptyVoicemail");
dojo.declare("webapp.voicemail.getEmptyVoicemail",
	webapp.voicemail.getEmptyVoicemailBase,
	{
		templatePath: dojo.moduleUrl("webapp.voicemail","templates/getEmptyVoicemail8082.html"),
		
		objEmptyState : null,

		postCreate : function() {
			this.objEmptyState = new UIElements.EmptyState.EmptyStateControl({}, this.domEmptyVoicemail);
			this.objEmptyState.setVisibility(true);
		}
	}
);