dojo.provide("webapp.voicemail.getVisualVoicemailBase");
dojo.declare("webapp.voicemail.getVisualVoicemailBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
        // Contact header data
		boolPresenceInfo			: false,
		strPresenceIcon				: "",
		strContactPhotoPath			: "",
		strContactCompany			: "",
		strContactPosition			: "",
		strContactLocation			: "",
		domVMPresenceIcon				: null,
		scroll					: null,

		boolHasBusinessInformation	: false,
        boolHasPersonnalInformation	: false,
        boolHasContactInformation	: false,

		boolUrgent : null,
		strUrgentIcon : null,
		strUrgentLabel : null,
		domUrgentText : null,
		domUrgentIcon : null,

		attributeMap: {
			"strUrgentLabel": {
				node: "domUrgentText",
				type: "innerHTML"
			}
		},

        constructor: function() {
			//TODO get the good contact
			//Communication problem
			var objMessage = webapp.voicemail.data.arrMessages[webapp.voicemail.data.intCurrentMessageId];
			if(! objMessage) {return;}
			webapp.voicemail.data.updateCurrentMessageContact();
            var objContact = objMessage.objContact;

            this.strContactName = (objContact && objContact.name) ? objContact.name : "";
            this.strContactFirstname = (objContact && objContact.firstname) ? objContact.firstname : "";
            this.strContactPhotoPath = (objContact && objContact.photo) ? objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("voicemail", "100");
            this.strContactCompany = (objContact.miscMap && objContact.miscMap.company) ? objContact.miscMap.company : "";
			this.strContactPosition = (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "";
			this.strContactLocation = (objContact.miscMap && objContact.miscMap.city) ? objContact.miscMap.city : "";

			this.boolUrgent = (objMessage.objVMLog.objLogData.entryPriority == 2)?true:false; // 2 = high priority
			if(this.boolUrgent){
				this.strUrgentIcon = 'communication-log-log-voicemail-priority-24';
				// replacing this.strUrgentText by Label
				this.strUrgentLabel = _("Message flagged as urgent", "webapp.voicemail");
			}
            //this.strContactLocation = (objContact && objContact.company) ? objContact.company.locality.city : "";

			this.strPresenceIcon = "";
			if(objContact.contactId && objContact.contactId >= 0){
				ICTouchAPI.APIServices.InstantMessaging.getPresenceForContact({context : this, params: [objContact.contactId], callback: this.handlePresence});
			}
		},

		handlePresence: function(presenceList) {
			if (presenceList.length != 0 && presenceList[0]) {
				//change the Presence Icon
				this.strPresenceIcon = ICTouchAPI.tools.getPresenceIconPath(presenceList[0].imPresenceValue.value.labelStatus);
				if (this.strPresenceIcon != "") {
					dojo.addClass(this.domVMPresenceIcon, this.strPresenceIcon);
					this.boolPresenceInfo = true;
				}
			}
        },

		postMixInProperties : function() {
            // Only show PersonnalInformation if one of these is non null
            this.boolHasPersonnalInformation = (
            this.strContactFirstname.length > 0 ||
            this.strContactName.length > 0);
            // Only show businessInformation if one of these is non null
            this.boolHasBusinessInformation = (
            this.strContactCompany.length > 0 ||
            this.strContactPosition.length > 0 ||
            this.strContactLocation.length > 0);
            // Only show ContactInformation if one of these is true
            this.boolHasContactInformation = (
            this.boolHasPersonnalInformation ||
            this.boolHasContactCallingStatus ||
            this.boolHasBusinessInformation );

			if(webapp.voicemail.data.getHotelMode()){
				this.strContactPhotoClass = "ContactHotelPhoto";
			} else {
				this.strContactPhotoClass = "ContactPhoto";
			}
        },

        postCreate: function() {
			if(this.boolUrgent && this.strUrgentIcon){
				dojo.addClass(this.domUrgentIcon, this.strUrgentIcon);
			}
			
			var objMessage = webapp.voicemail.data.arrMessages[webapp.voicemail.data.intCurrentMessageId];
			if(! objMessage) {return;}
            var objContact = objMessage.objContact;
			var duration = 60;
			if(objMessage.objVMLog.objLogData.dateTime && objMessage.objVMLog.objLogData.endTime){
				var start = objMessage.objVMLog.objLogData.dateTime;
				var end = objMessage.objVMLog.objLogData.endTime;
				var objDateStart = new Date(start.datetime.year, start.datetime.month - 1, start.datetime.day, start.datetime.hour, start.datetime.minute, start.datetime.second);
				var objDateEnd = new Date(end.datetime.year, end.datetime.month - 1, end.datetime.day, end.datetime.hour, end.datetime.minute, end.datetime.second);
				// For the duration, to have the same value as My IC PC (which seems more realist), we have to do -1...
				duration = Math.floor(dojo.date.difference(objDateStart , objDateEnd, "second") - 1);
			}
			webapp.voicemail.data.boolSliderLoaded = false;
			var slider = null;
			if (webapp.voicemail.data.intPauseMessage == ICTouchAPI.CapabilityServices.AVAILABLE){
				slider = new UIElements.Media.Audio({
									intSliderY : 10,
									intMediaDuration: duration*1000,
									intSliderWidth : 400,
									_boolPlaying : false,
									autopauseOnMove : false,
									boolSeekable : false,
									boolShowSliderButton : false
								}, this.domVMSlider);
			}
			else{
				slider = new UIElements.Media.Audio({
									intSliderY : 10,
									intMediaDuration: duration*1000,
									intSliderWidth : 400,
									boolCanPause : false,
									_boolPlaying : false,
									autopauseOnMove : false,
									boolSeekable : false
								}, this.domVMSlider);
			}
			slider._boolPlaying = false;
			slider.autopauseOnMove = false;
			slider.clbkPlay = dojo.hitch(webapp.voicemail, webapp.voicemail.clbkPlayAction);
			slider.clbkStop = dojo.hitch(webapp.voicemail, webapp.voicemail.clbkStopAction);
			if (webapp.voicemail.data.intPauseMessage == ICTouchAPI.CapabilityServices.AVAILABLE){
				slider.clbkPause = dojo.hitch(webapp.voicemail, webapp.voicemail.clbkPauseAction);
				slider.actionOnMoveEnd = "pause";
			}
			webapp.voicemail.data.boolSliderLoaded = true;
			slider.setValue(0);
			webapp.voicemail.upgradeAppbar();
			var toPlay = false;
			if(slider){
				if(objMessage.dateMessagePlayed){
					var diff = 0;
					var currentDate = new Date().getTime();
					if(objMessage.dateMessagePaused && objMessage.dateMessagePlayed < objMessage.dateMessagePaused){
						slider.setToTime(objMessage.intOffsetMessagePaused);
					} else if(objMessage.dateMessagePaused && objMessage.dateMessagePlayed > objMessage.dateMessagePaused){
						diff = Math.floor(currentDate - objMessage.dateMessagePlayed)/1000;
						slider.setToTime(objMessage.intOffsetMessagePaused + diff);
						toPlay = true;
					} else {
						diff = Math.floor(currentDate - objMessage.dateMessagePlayed)/1000;
						slider.setToTime(diff);
						toPlay = true;
					}
				}
			}

			var _arr = [];
			if(objContact.contactId) {
				var _arrLabels = ICTouchAPI.tools.getContactFieldLabels();
				var item;
				for (var i in _arrLabels) {
					if (_arrLabels[i].type != "Header" && objContact[_arrLabels[i].id]) {
						item = {
							strId: _arrLabels[i].id,
							strLabel: _(_arrLabels[i].label,"webapp.communication"),
							strContent: (objContact[_arrLabels[i].id] === "anonymous" || objContact[_arrLabels[i].id] === "***") ? _("anonymous","ICTouchAPI") : objContact[_arrLabels[i].id],
							strType: _arrLabels[i].type
						};
						_arr.push(item);
					}
				}
			}
			if(_arr && _arr.length > 0){
				new UIElements.PresentationList.PresentationListControl({
					arrItems : _arr,
					boolScroll : false,
					boolShowIcon: true,
					boolShowLabel: true,
					strDisplay:'contactcard'
				}, this.domVMContactDetails);
			}
			
			if(toPlay) {
				slider.mediaPlay();
			}
			webapp.voicemail.data.sliderUI = slider;

			this.scroll = FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});
        },

        load : function()
        {

        },

		destroy: function() {
            if( this.scroll ) this.scroll = null;
            this.inherited("destroy", arguments);
        }
    }
    );
