dojo.provide("webapp.voicemail.dataBase");
dojo.declare("webapp.voicemail.dataBase",null,{


	voicemailNumber			: null,

	// Current screensaver screen. Used for PPVVM.
	screensaverWebapp		: null,

	// For appBar
	arrAppBarSkeleton		: [],
	arrAllButtons			: [],

	// For basic voicemail view
	BasicVoicemailUI : null,
	nrOfVoicemail : 0,
	strLastDate : "",
	nrOfUnreadVoicemail : 0,
	displayTotalMessages : true,

	intCurrentMessageId	: null,
	_intDisplayedMenu		: null,
	_arrCurrentEntries		: [],

	arrItemsToRemove		: [],
	intDeleteOption			: 0,

	// Format settings
	_dateFormat 			: "",
	_24hformat  			: false, // 12 \ 24

	//Menu List object
	objAllLog				: null,
	objUnreadLog			: null,

	// 2/3 view
	_containerTitle			: null,
	_container				: null,

	//Array of messages
	arrMessages				: {},

	sliderUI				: null,
	boolSliderLoaded		: false,

	voiceMailState			: null,
	boolEnablePhotoInComlog	: false,

	intLoadingAllLog		: 0,
	intLoadingUnreadLog		: 0,

	//Constants for voicemail log list
	LOG_LIST_ALL			: 1,
	LOG_LIST_UNREAD			: 2,

	//Constants for loadDetails function
	DETAILS_EMPTY			: 0,
	DETAILS_BASIC			: 1,
	DETAILS_VISUAL			: 2,

	//Constant for appBar status
	STATUS_EMPTY_VM			: 1,
	STATUS_VM				: 2,

	//appBar buttons
	BACK_BTN				: "BACK_BTN",
	PLAYVM_BTN				: "PLAYVM_BTN",
	PAUSEVM_BTN				: "PAUSEVM_BTN",
	STOPVM_BTN				: "STOPVM_BTN",
	RESUMEVM_BTN			: "RESUMEVM_BTN",
	TRANSFERVM_BTN			: "TRANSFERVM_BTN",
	TRANSFERVM_BY_MAIL_BTN	: "TRANSFERVM_BY_MAIL_BTN",
	CALL_SENDER_BTN			: "CALL_SENDER_BTN",
	//CONTACT_LOG				: "CONTACT_LOG_BTN",
	DELETE_LOG				: "DELETE_LOG_BTN",
	VOICEMAIL_HOMEPAGE		: "VOICEMAIL_HOMEPAGE_BTN",
	CALLVM_BTN				: "CALLVM_BTN",

	//Constant for voiceMailState
	BASIC					: "basic",
	VISUAL					: "visual",

	// Constant Values for the ComlogFilters business id
	COMLOG_FILTER_VM_BUSINESS_ID	: 7,
	FILTER_UNREAD					: 0,
	FILTER_READ						: 1,
	FILTER_ALL						: 2,

	// Constant for delete option
	DELETE_ONE				: 0,
	DELETE_ALL				: 1,

	//States of capabilities
	intPlayMessage			: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intPauseMessage			: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intForward				: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intForwardToMail		: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intDeleteMessage		: ICTouchAPI.CapabilityServices.UNAVAILABLE,
	intCallSender			: ICTouchAPI.CapabilityServices.UNAVAILABLE,

	//Booleans of Voicemail state
	boolMessagePlaying		: false,
	boolMessagePaused		: false,

	intMessageId			: null,
	intNumberTmp			: null,
	dateVVMStart			: null,
	dateVVMEnd				: null,
	intOffsetMessagePaused	: null,
	strMailTmp				: null,

	STATUS_BASIC_VOICEMAIL : "Voicemail",

	// Number of entries in both lists
	_intNewVmNumber			: 0,
	_intAllVmNumber			: 0,

	passwordVVMNeed		: true,
	boolVVMAlreadyLeft	: false,
	customExitWebapp	: [],
	visualVoiceMailPasswordEnabled : false,
	currentObjListId : null,

	constructor : function(){
		this.voiceMailState = this.BASIC;
		this._containerTitle=_("Voicemail", "webapp.voicemail");
		this._container="webapp.voicemail.getEmptyVoicemail";

		var funcHomePageButton = function(){
			webapp.voicemail.onVoicemailEnter(webapp.voicemail.data.LOG_LIST_ALL);
		};
		// Add button on homepage
		ICTouchAPI.tools.registerHomepageButton(["webapp.voicemail.getVoicemail", this.VOICEMAIL_HOMEPAGE, "communication-voice-mail", _("Voicemail","webapp.voicemail"), null, funcHomePageButton]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.voicemail.getVoicemail", this.VOICEMAIL_HOMEPAGE, "communication-voice-mail", _("Voicemail","webapp.voicemail"), null, funcHomePageButton]);

		var func={
			context: webapp.voicemail,
			func: webapp.voicemail.buttonCallback
		};

		//Appbar buttons
		this.arrAllButtons[this.PLAYVM_BTN] = ({
			strButtonName: this.PLAYVM_BTN,
			strButtonLabel:_("Play VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-play',
			callback: func
		});
		this.arrAllButtons[this.PAUSEVM_BTN] = ({
			strButtonName: this.PAUSEVM_BTN,
			strButtonLabel:_("Pause VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-pause',
			callback: func
		});
		this.arrAllButtons[this.RESUMEVM_BTN] = ({
			strButtonName: this.RESUMEVM_BTN,
			strButtonLabel:_("Resume VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-play',
			callback: func
		});
		this.arrAllButtons[this.STOPVM_BTN] = ({
			strButtonName: this.STOPVM_BTN,
			strButtonLabel:_("Stop VM", "webapp.voicemail"),
			strButtonIcon: 'filesmanager-stop',
			callback: func
		});
		/*this.arrAllButtons[this.TRANSFERVM_BTN] = ({strButtonName: this.TRANSFERVM_BTN, strButtonLabel:_("Forward to VM", "webapp.voicemail"), strButtonIcon: 'communication-deflect-to-voice-mail', callback: func});*/
		// WARNING : only descoped in R200, to keep for future versions
		/*this.arrAllButtons[this.TRANSFERVM_BY_MAIL_BTN] = ({strButtonName: this.TRANSFERVM_BY_MAIL_BTN, strButtonLabel:_("Forward by Mail", "webapp.voicemail"), strButtonIcon: 'mail-forward', callback: func	});*/
		this.arrAllButtons[this.CALL_SENDER_BTN] = ({
			strButtonName: this.CALL_SENDER_BTN,
			strButtonLabel:_("Callback", "webapp.voicemail"),
			strButtonIcon: 'communication-call-me-back',
			callback: func
		});
		this.arrAllButtons[this.DELETE_LOG] = {
			strButtonName: this.DELETE_LOG,
			strButtonLabel:_('Delete', 'ICTouchAPI'),
			strButtonIcon: 'generic-mode-delete',
			callback: func
		};
		this.arrAllButtons[this.CALLVM_BTN] = ({
			strButtonName: this.CALLVM_BTN,
			strButtonLabel:_("Call VM", "webapp.voicemail"),
			strButtonIcon: 'communication-voice-mail',
			callback: func
		});

		//Appbar
		this.arrAppBarSkeleton[this.STATUS_EMPTY_VM]= [this.CALLVM_BTN];
		this.arrAppBarSkeleton[this.STATUS_VM] = [this.PLAYVM_BTN,this.PAUSEVM_BTN,this.RESUMEVM_BTN,this.STOPVM_BTN,this.CALL_SENDER_BTN,this.CALLVM_BTN,/*this.CONTACT_LOG*/,this.DELETE_LOG,"MAGNIFY","homepageBtnHelp"];

		for(var i in this.arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("voicemail", "voicemailStatus" + i , this.arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("voicemail", "voicemailStatus" + i, true, func);
			for(var j in this.arrAppBarSkeleton[i]){
				var currentBtn = this.arrAppBarSkeleton[i][j];
				if(this.arrAllButtons[currentBtn]) {
					var objButton = new UIElements.AppButton.AppButtonControl(this.arrAllButtons[currentBtn]);
					appBar.addAppButton(objButton,false);
				}
			}
			appBar.buildDom();
		}
		ICTouchAPI.AppBarServices.setAppBar("voicemail", "voicemailStatus"+this.STATUS_EMPTY_VM, "getVoicemail");

		this._getSettings();
	},

	getVoiceMailTitle : function ()
	{
		return this._voiceMailtitle;
	},

	getListTitle : function() {
		return [
		{
			strIcon:"tabs-new-32",
			strLabel : _("New", "ICTouchAPI"),
			strLabelBottom:'(' + this.getIntNewVmNumber() + ')',
			intIndex:this.LOG_LIST_UNREAD
		},
		{
			strIcon:"voicemail-tabs-all-32",
			strLabel:_("VoicemailsTab", "webapp.voicemail"),
			strLabelBottom:'(' + this.getIntAllVmNumber() + ')',
			intIndex:this.LOG_LIST_ALL
			}
		]
	},

	// gets the settings for the app
	_getSettings : function(){
		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			// save the setting
			if (objSetting != null)
				this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			// get another setting
			ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
				// save the setting
				if(value != null)
					this._24hformat = value;
			});
		});
	},

	getContainerTitle : function () {
		return this._containerTitle;
	},

	getContainer : function () {
		return this._container;
	},

	getDisplayedList : function() {
		return this._intDisplayedMenu;
	},

	setDisplayedList : function(listId) {
		this._intDisplayedMenu = listId;
	},

	loadDetails : function(logId) {
		var appBar;
		this.setCurrentEntryId(logId, this.getDisplayedList());

		this.nrOfVoicemail = 0;
		this.nrOfUnreadVoicemail = 0;
		this.strLastDate = "";

		if(logId!=null) {
			var item = this.getSelectedEntry();

			var date = new Date(item.objLogData.dateTime.datetime.year, item.objLogData.dateTime.datetime.month - 1, item.objLogData.dateTime.datetime.day);
			this.strLastDate = ICTouchAPI.tools.getFormatedDate(date, this.dateFormat);
			this.strLastDate += " - " + ICTouchAPI.tools.getFormatedTime(item.objLogData.dateTime.datetime.hour, item.objLogData.dateTime.datetime.minute, this.time24hformat);
			var oldCount = 0;
			var newCount = 0;
			if(item.countNew) {
				newCount = item.countNew;
			}
			if(item.countOld) {
				oldCount = item.countOld;
			}
			this.saveVMs(oldCount,newCount);
		}

		if (this.voiceMailState === this.BASIC) {
			this.intCurrentMessageId = null;
			appBar = this.STATUS_VM;
			this._containerTitle=_("Voicemail", "webapp.voicemail");
			this._container="webapp.voicemail.getBasicVoicemail";

		} else {
			if(logId!=null) {
				this.updateMessages(item);
				this.intCurrentMessageId = item.objLogData.wsRecordId;
				appBar = this.STATUS_VM;
				this._container="webapp.voicemail.getVisualVoicemail";

				//Add name and first name on title if exist
				var currentContactString = this.getSelectedEntryContactString();
				if(currentContactString!=null && currentContactString!="") {
                                    if (currentContactString.replace(/\s/g,'') === "anonymous" || currentContactString.replace(/\s/g,'') === "***") {
                                       currentContactString = _("anonymous","ICTouchAPI");
                                    }
                                    this._containerTitle = currentContactString;
				}
				else {
					this._containerTitle=_("Voicemail", "webapp.voicemail");
				}
			}
			else {
				this.setCurrentEntryId(null, this.getDisplayedList());
				this.intCurrentMessageId = null;
				appBar = this.STATUS_EMPTY_VM;
				this._containerTitle=_("No voicemail", "webapp.voicemail");
				this._container="webapp.voicemail.getEmptyVoicemail";
			}
		}

		ICTouchAPI.AppBarServices.setAppBar("voicemail", "voicemailStatus"+appBar, "getVoicemail");
		if(webapp.voicemail.mainWidget) {
			webapp.voicemail.mainWidget.reloadContainer();
		}
		webapp.voicemail.upgradeAppbar();
	},

	saveVMs : function(intNumOld, intNumNew)
	{
		this.nrOfUnreadVoicemail = intNumNew;
		this.nrOfVoicemail = intNumOld + intNumNew;
	},

	updateMessages : function (item){
		var objMessage = this.arrMessages[item.objLogData.wsRecordId];
		if(objMessage){
			objMessage.objVMLog = item;
			objMessage.objContact = this.searchContactFromLog(item);
		} else {
			objMessage = {
				intMessageId				: item.objLogData.wsRecordId,
				objVMLog					: item,
				objContact					: this.searchContactFromLog(item),
				intOffsetMessagePaused		: null,
				dateMessagePlayed			: null,
				dateMessagePaused			: null
			};
		}
		this.arrMessages[objMessage.intMessageId] = objMessage;
	},

	updateCurrentMessageContact : function () {
		var intMessageId = this.intCurrentMessageId;
		if(this.arrMessages[intMessageId]){
			this.arrMessages[intMessageId].objContact = this.searchContactFromLog(this.arrMessages[intMessageId].objVMLog);
		}
	},

	getVMIdByRecordId : function(wsRecordId, listId) {
		var objList;
		if(listId == this.LOG_LIST_ALL){
			objList = this.objAllLog;
		}
		else {
			objList = this.objUnreadLog;
		}

		if(objList){
			for(var i in objList.arrItems){
				if(objList.arrItems[i].objLogData.wsRecordId == wsRecordId){
					return objList.arrItems[i].objLogData.comLogEntryId;
				}
			}
		}

		return null;
	},

	loadVoicemailLog : function() {
		this.intLoadingAllLog++;
		this.intLoadingUnreadLog++;
		// Call business function
		ICTouchAPI.APIServices.Comlog.findEntries({
			params:[this.FILTER_ALL, this.COMLOG_FILTER_VM_BUSINESS_ID],
			context:this,
			callback:this.loadedAllLog
		});
		ICTouchAPI.APIServices.Comlog.findEntries({
			params:[this.FILTER_UNREAD, this.COMLOG_FILTER_VM_BUSINESS_ID],
			context:this,
			callback:this.loadedUnreadLog
		});
	},

	loadedAllLog : function(_arr) {
		this.intLoadingAllLog--;
		if (this.intLoadingAllLog !== 0) {
			_arr = null;
			return;
		}
		ICTouchAPI.log("Start loadedAllVoicemailLog", "TELEPHONY");
		var arrVoicemailLog = [];
		if (_arr !== undefined) {
			for (var i in _arr) {
				var logObject = _arr[i];
				var objLog = this.buildLogItem(logObject);
				arrVoicemailLog.push(objLog);
			}
		}
		//Clean logs
		var nbLogs = this.getNbItems(this.LOG_LIST_ALL);
		this.sliceItems(0, nbLogs, this.LOG_LIST_ALL);

		// Insert new logs
		this.insertItems(0, arrVoicemailLog, this.LOG_LIST_ALL);
		this.setIntAllVmNumber(arrVoicemailLog.length);

		ICTouchAPI.log("End loadedAllVoicemailLog", "TELEPHONY");
		// If log are not being loaded, finalize loading
		var entry = this.findItemByPosition(0,this.LOG_LIST_ALL);
		if(this.getDisplayedList() === this.LOG_LIST_ALL) {
			if(entry){
				this.selectItemByIndex(entry.intIndex, false, this.LOG_LIST_ALL);
			}
			else {
				this.loadDetails(null);
			}
		}

		_arr=null;
	},

	loadedUnreadLog : function(_arr) {
		this.intLoadingUnreadLog--;
		if (this.intLoadingUnreadLog !== 0) {
			_arr = null;
			return;
		}
		ICTouchAPI.log("Start loadedUnreadVoicemailLog", "TELEPHONY");
		var arrVoicemailLog = [];
		if (_arr !== undefined) {
			for (var i in _arr) {
				var logObject = _arr[i];
				var objLog = this.buildLogItem(logObject);
				arrVoicemailLog.push(objLog);
			}
		}

		//Clean logs
		var nbLogs = this.getNbItems(this.LOG_LIST_UNREAD);
		this.sliceItems(0, nbLogs, this.LOG_LIST_UNREAD);

		// Insert new logs
		this.insertItems(0, arrVoicemailLog, this.LOG_LIST_UNREAD);
		this.setIntNewVmNumber(arrVoicemailLog.length);

		ICTouchAPI.log("End loadedUnreadoicemailLog", "TELEPHONY");
		// If log are not being loaded, finalize loading
		var entry = this.findItemByPosition(0,this.LOG_LIST_UNREAD);
		if(this.getDisplayedList() === this.LOG_LIST_UNREAD) {
			if(entry){
				this.selectItemByIndex(entry.intIndex, false, this.LOG_LIST_UNREAD);
			}
			else {
				this.loadDetails(null);
			}
		}
		_arr=null;
	},



	//Get current entry of selected log
	getCurrentEntry : function(intLog) {
		var id = this.getCurrentEntryId(intLog);
		if(id!=null) {
			var entry = this.findItemById(id, intLog);
			return entry;
		}
		else
			return null;

	},

	getCurrentEntryId : function(intList) {
		return this._arrCurrentEntries[intList];
	},

	setCurrentEntryId : function(intLogId, intList) {
		this._arrCurrentEntries[intList] = intLogId;
		intLogId=null;
	},

	//Get entry selected in 2/3
	getSelectedEntry : function() {
		var currentList = this.getDisplayedList();
		var entry = this.getCurrentEntry(currentList);
		return entry;
	},



	//Get number of items in selected log
	getNbItems : function(intLog) {
		if(intLog===this.LOG_LIST_ALL){
			return this.objAllLog ? this.objAllLog.arrItems.length : 0;
		}
		else if(intLog===this.LOG_LIST_UNREAD){
			return this.objUnreadLog ? this.objUnreadLog.arrItems.length : 0;
		}
		return 0;
	},

	//Find item by id in selected log
	findItemById : function(intId, intLog) {
		var entry = undefined;
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			entry = this.objAllLog.findItem("intIndex", intId);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			entry = this.objUnreadLog.findItem("intIndex", intId);
		}
		intId=null;
		return entry;
	},

	//Find item by position in selected log
	findItemByPosition : function(intPosition, intLog){
		var entry = undefined;
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			entry = this.objAllLog.arrItems[intPosition];
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog){
			entry = this.objUnreadLog.arrItems[intPosition];
		}
		intPosition=null;
		intLog=null;
		return entry;
	},

	//Select item by id in selected log
	selectItemByIndex : function(id, boolSelect, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			this.objAllLog.selectItemByIndex(id, boolSelect);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.selectItemByIndex(id, boolSelect);
		}
		id=null;
		boolSelect=null;
	},

	//Select item by posiition in selected log
	selectItemByPosition : function(intPosition, boolSelect, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog){
			this.objAllLog.selectItemByPosition(intPosition, boolSelect);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog){
			this.objUnreadLog.selectItemByPosition(intPosition, boolSelect);
		}
		intPosition=null;
		boolSelect=null;
	},

	//Insert items in selected log
	insertItems : function(intPosition, arrItems, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.insertItems(intPosition, arrItems);
			this.increaseIntAllVmNumber(arrItems.length);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.insertItems(intPosition, arrItems);
			this.increaseIntNewVmNumber(arrItems.length);
		}
		intPosition=null;
		arrItems=null;
	},

	unshiftItem : function(objLog, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.unshiftItem(objLog, true);
			this.increaseIntAllVmNumber(1);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.unshiftItem(objLog, true);
			this.increaseIntNewVmNumber(1);
		}
		// auto select the first if no one is selected
		if ((this.getCurrentEntryId(intLog) == null || this.getCurrentEntryId(intLog) == undefined) && this.getDisplayedList() == intLog) { 
			this.selectItemByPosition(0, true, intLog);
		}

		objLog=null;
	},

	unshiftItems : function(arrLogs, intLog){
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.unshiftItems(arrLogs, true);
			this.increaseIntAllVmNumber(arrLogs.length);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.unshiftItems(arrLogs, true);
			this.increaseIntAllVmNumber(arrLogs.length);
		}
		arrLogs=null;
	},


	sliceItems : function(intStart, intNb, intLog) {
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			this.objAllLog.sliceItems(intStart, intNb);
			this.decreaseIntAllVmNumber(intNb);
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			this.objUnreadLog.sliceItems(intStart, intNb);
			this.decreaseIntNewVmNumber(intNb);
		}
		intStart=null;
		intNb=null;
	},

	//Remove item by id in selected log
	removeItemById : function(id, boolDoNotSelectNext, intLog){
		var removedItem = null;
		if(!boolDoNotSelectNext && intLog!==this.getDisplayedList()) {
			boolDoNotSelectNext = true;
		}
		if(intLog===this.LOG_LIST_ALL && this.objAllLog) {
			removedItem = this.objAllLog.removeItemByIntIndex(id, boolDoNotSelectNext);
			if(removedItem){
				this.decreaseIntAllVmNumber(1);
			}
		}
		else if(intLog===this.LOG_LIST_UNREAD && this.objUnreadLog) {
			removedItem = this.objUnreadLog.removeItemByIntIndex(id, boolDoNotSelectNext);
			if(removedItem){
				this.decreaseIntNewVmNumber(1);
			}
		}
		id=null;
		boolDoNotSelectNext=null;
		return removedItem;
	},

	updateItem : function(objLog){
		if(this.objAllLog) {
			this.objAllLog.updateItem(objLog);
		}
		if(this.objUnreadLog) {
			this.objUnreadLog.updateItem(objLog);
		}
		objLog=null;
	},



	addInLog : function(objLogData) {
		var isRead = objLogData.isRead;
		var objLog = this.buildLogItem(objLogData);
		this.unshiftItem(objLog, this.LOG_LIST_ALL);
		if(!isRead) {
			this.unshiftItem(objLog, this.LOG_LIST_UNREAD);
		}

	},

	removeFromLog : function(intLogId) {
		this.removeItemById(intLogId, false, this.LOG_LIST_ALL);
		this.removeItemById(intLogId, false, this.LOG_LIST_UNREAD);
		var displayedList = this.getDisplayedList();
		if((displayedList===this.LOG_LIST_ALL && this.getNbItems(this.LOG_LIST_ALL)===0) ||
			(displayedList===this.LOG_LIST_UNREAD &&  this.getNbItems(this.LOG_LIST_UNREAD)===0)) {
			this.loadDetails(undefined);
		}
	},

	modifyInLog : function(objLogData) {
		var isRead = objLogData.isRead;
		var objLog = this.buildLogItem(objLogData);
		this.updateItem(objLog, this.LOG_LIST_ALL);
		if(isRead) {
			if(this.getDisplayedList() === this.LOG_LIST_UNREAD) {
				this.addToRemoveUnreadList(objLogData.comLogEntryId);
			}
			else {
				this.removeItemById(objLogData.comLogEntryId, false, this.LOG_LIST_UNREAD);
			}
		}
		else {
			this.updateItem(objLog, this.LOG_LIST_UNREAD);
		}
	},

	//Add id of unread item to arrItemsToRemove
	addToRemoveUnreadList : function(intLogId) {
		this.arrItemsToRemove.push(intLogId);
	},

	//Remove unread item saved on arrItemsToRemove
	processRemoveUnreadList : function() {
		while(this.arrItemsToRemove.length>0) {
			var id = this.arrItemsToRemove.pop();
			this.removeItemById(id, false, this.LOG_LIST_UNREAD);
		}
		var displayedList = this.getDisplayedList();
		if(displayedList===this.LOG_LIST_UNREAD &&  this.getNbItems(this.LOG_LIST_UNREAD)===0) {
			this.loadDetails(undefined);
		}
	},

	buildLogItem : function(logObject) {
		// built the start time to be displayed in comlog
		var objDate = new Date(logObject.dateTime.datetime.year, logObject.dateTime.datetime.month - 1, logObject.dateTime.datetime.day, logObject.dateTime.datetime.hour, logObject.dateTime.datetime.minute, logObject.dateTime.datetime.second || 0);
		var strTime = this.getFormatedDateForLog(objDate);

		var objLog = {
			strPrimaryIcon: "",
			strPrimaryContent: "",
			strSecondaryContent: strTime,
			objLogData: logObject,
			alternateStyle: true,
			intIndex: logObject.comLogEntryId
		};

		var objContact = this.searchContactFromLog(objLog);
		objLog.strPicture = (objContact.photo) ? objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");

		if(logObject.countOld) {
			objLog.countOld = logObject.countOld;
		} else {
			objLog.countOld = 0;
		}
		if(logObject.countNew) {
			objLog.countNew = logObject.countNew;
		} else {
			objLog.countNew = 0;
		}

		var logType = ICTouchAPI.tools.getLogDataFromStatus(logObject,"24");
		objLog.strPrimaryIcon = logType.strIcon;

		if(objContact.name || objContact.firstName){
			objLog.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objContact);
		}
		else if (logObject.listContactSummary && logObject.listContactSummary[0]) { // use uppermost the name / FirstName of the ContactSummary
			objLog.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(logObject.listContactSummary[0]);
		}
		else if (logObject.listDisplayName && logObject.listDisplayName[0]) {
			objLog.strPrimaryContent = logObject.listDisplayName[0];
		}
		else {
			objLog.strPrimaryContent = logObject.listContactSummary[0].officePhone;
		}
                
               if (objLog.strPrimaryContent.replace(/\s/g,'')==="anonymous" || objLog.strPrimaryContent.replace(/\s/g,'')==="***") {   
                         objLog.strPrimaryContent=_("anonymous","ICTouchAPI");
               }

		if (!objLog.strPrimaryContent) {
			objLog.strPrimaryContent = _("Voicemail", "webapp.voicemail");
		}
		if(!objContact.photo) {
			objLog.strPicture = ICTouchAPI.tools.getDefaultPhotoPath("voicemail", "50");
		}

		// Entry not read
		if (logObject.isRead !== true && logObject.isRead !== 1) {
			this.boolOneUnread = true;
			objLog.alternateStyle = false;
		}

		// Contact picture may be disabled by setting, so we delete it.
		if(!this.boolEnablePhotoInComlog){
			objLog.strPicture = null;
		}
		logObject=null;
		return objLog;
	},

	searchContactFromLog: function(item){
		var phoneNumber, label;
		// Get the correct phoneNumber and displayName to use.
		if (item.objLogData.listContactSummary && item.objLogData.listContactSummary[0]) { // use uppermost the name / FirstName of the ContactSummary
			if(item.objLogData.listContactSummary[0].name || item.objLogData.listContactSummary[0].firstName) {
				label = [item.objLogData.listContactSummary[0].name,item.objLogData.listContactSummary[0].firstName];
			}
			phoneNumber = (item.objLogData.listContactSummary[0].officePhone) ? item.objLogData.listContactSummary[0].officePhone : "";
		}
		if (!label) { // If there is no name / FirstName in the ContactSummary, use the display name
			if (item.objLogData.listDisplayName && item.objLogData.listDisplayName[0]) {
				label = item.objLogData.listDisplayName[0];
			}
		}
		// Search in dataStore.
		var objContact = (phoneNumber)?ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],phoneNumber)[0]:undefined;

		if (!objContact) {
			// If  not in datastore, use cache, use the phonecall info
			objContact = this.createContactFromNumber(label, phoneNumber);
		}
		item=null;
		return objContact;
	},

	createContactFromNumber: function(label, phoneNumber) {
		if (!label || label === ""){
			label = phoneNumber;
		}
		var objContact;
		if (typeof label === "object" && label[0] !== undefined && label[1] !== undefined) { // label can be an array with [LastName, FirstName]
			objContact = {
				contactId: -1,
				name: label[0],
				firstName: label[1],
				officePhone: phoneNumber,
				officePhoneCan: phoneNumber,
				contactFromNumber: true
			};
		}
		else {
			objContact = {
				contactId: -1,
				name: label,
				firstName: "",
				officePhone: phoneNumber,
				officePhoneCan: phoneNumber,
				contactFromNumber: true
			};
		}
		label=null;
		phoneNumber=null;
		return objContact;
	},

	getFormatedDateForLog : function(startDate){
		// start time
		var today = new Date();
		var strTime = ICTouchAPI.tools.getFormatedTime(startDate.getHours(), startDate.getMinutes(), this.time24hformat);
		if (startDate.getDate() !== today.getDate() || startDate.getMonth() !== today.getMonth() || startDate.getFullYear() !== today.getFullYear()) {
			// not today we print the date
			strTime = ICTouchAPI.tools.getFormatedDate(startDate, "dd/mm ") + strTime;
		}
		startDate = null;
		return strTime;
	},

	getSelectedEntryContactString : function() {
		var objContact = this.arrMessages[this.intCurrentMessageId].objContact;
		var strContactName = (objContact && objContact.name) ? objContact.name : "";
		var strContactFirstname = (objContact && objContact.firstName) ? objContact.firstName : "";
		if(strContactFirstname!="" || strContactName!="") {
			var objContactTmp = {
				name : strContactName,
				firstName : strContactFirstname
			};
			return ICTouchAPI.tools.getContactDisplayName(objContactTmp);
		}
		return "";
	},

	getHotelMode : function() {
		return this.boolHotelMode;
	},

	setHotelMode : function() {
		this.boolHotelMode = true;
		if(webapp.voicemail.mainWidget) {
			webapp.voicemail.mainWidget.reloadContainer();
		}
	},

	refreshVmListTitle : function() {
		if(webapp.voicemail.mainWidget){
			webapp.voicemail.mainWidget.objMenu.getTitle().updateContent(this.getListTitle());
		}
	},

	setScreensaverWebapp: function(screensaverSetting) {
		if( screensaverSetting ) {	// Note: screensaver can be undefined(?) or null
			this.screensaverWebapp = screensaverSetting.allowedValues[screensaverSetting.jsValue].id;
		}
	},

	getScreensaverWebapp: function() {
		return this.screensaverWebapp;
	},

	getIntNewVmNumber : function() {
		return this._intNewVmNumber;
	},

	setIntNewVmNumber : function(intNewVmNumber) {
		if(this._intNewVmNumber !== intNewVmNumber){
			this._intNewVmNumber = intNewVmNumber;

			// Change corresponding title
			this.refreshVmListTitle();
		}
	},

	increaseIntNewVmNumber : function(intNb) {
		this.setIntNewVmNumber(this.getIntNewVmNumber() +intNb);
	},

	decreaseIntNewVmNumber : function(intNb) {
		var newIntNewVmNumber = this.getIntNewVmNumber() -intNb;
		if(newIntNewVmNumber < 0){
			newIntNewVmNumber = 0;
		}
		this.setIntNewVmNumber(newIntNewVmNumber);
	},

	getIntAllVmNumber : function() {
		return this._intAllVmNumber;
	},

	setIntAllVmNumber : function(intAllVmNumber) {
		if(this._intAllVmNumber !== intAllVmNumber){
			this._intAllVmNumber = intAllVmNumber;

			// Change corresponding title
			this.refreshVmListTitle();
		}
	},

	increaseIntAllVmNumber : function(intNb) {
		this.setIntAllVmNumber(this.getIntAllVmNumber() +intNb);
	},

	decreaseIntAllVmNumber : function(intNb) {
		var newIntAllVmNumber = this.getIntAllVmNumber() - intNb;
		if(newIntAllVmNumber < 0){
			newIntAllVmNumber = 0;
		}
		this.setIntAllVmNumber(newIntAllVmNumber);
	},

	getPasswordVVMNeed : function(){
		return this.passwordVVMNeed;
	},

	setPasswordVVMNeed : function(_bool){
		this.passwordVVMNeed = _bool;
	},

	getVisualVoiceMailPasswordEnabled : function(){
		return this.visualVoiceMailPasswordEnabled;
	},

	setVisualVoiceMailPasswordEnabled : function(_bool){
		this.visualVoiceMailPasswordEnabled = _bool;
	}
});
