dojo.provide("webapp.voicemail.controlBase");
dojo.declare("webapp.voicemail.controlBase", ICTouchAPI.webApplication,
{

	// Widgets
	mainWidget              : null,
	objLogContent			: null,

	objPopupConfirmDelete	: null,
	idMessagePlayed			: null,
	boolMessagePaused		: null,

	popupWrongLogin			: null,

	constructor : function() {

	},

	load:function () {
		//help
		dojo.publish("needHelpEvent",["voicemail",[]]);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogChanged", this.apiNotifyComlogChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryAdded", this.apiNotifyComlogEntryAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryDeleted", this.apiNotifyComlogEntryDeleted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryChanged", this.apiNotifyComlogEntryChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyVoiceMailCountChanged", this.apiAddVoiceMailNotif);
	},

	loaded:function () {
		//ICTouchAPI.eventServices.subscribeToEvent(this, "notifyVoiceMailCountChanged", this.onNotifyVoiceMailCountChanged);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMAvailable", this, this.capabilityCallback);

		//Subscribe to visual voicemail events
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMPlaying", this.onVVMPlaying);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMPaused", this.onVVMPaused);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMStopped", this.onVVMStopped);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMDeleted", this.onVVMDeleted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMTransferred", this.onVVMTransferred);
		ICTouchAPI.eventServices.subscribeToEvent(this, "VVMAccessLocked", this.onVVMAccessLocked);

		dojo.subscribe("ModeHotel", this, this.onModeHotel);

		dojo.subscribe("resetCustomExit", this, this.onResetCustomExit);

		dojo.subscribe("requestCustomVVMExit", this, this.onRequestCustomVVMExit);

		//Suscribe to dayChanged to refresh date label of items
		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged",this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);

		// Capabilities subscription
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMPlayMessage", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMPauseMessage", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMForwardToAnotherVM", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMForwardToVM", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMForwardByEmail", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMDeleteMessage", this, this.capabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "VVMCallSender", this, this.capabilityCallback);

		// Format subscription
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyVmNumber", this.onVMNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyVmNumber", this, this.onVMNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.getSetting("TimeFormat", this,  this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
		ICTouchAPI.settingServices.getSetting("DateFormat", this,  this.onDateFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnablePhotoInComlog", this.onEnablePhotoInComlogChanged);
		ICTouchAPI.settingServices.getSetting("EnablePhotoInComlog", this, this.onEnablePhotoInComlogChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "VisualVoiceMailPasswordEnabled", this.onVisualVoiceMailPasswordEnabled);
		ICTouchAPI.settingServices.getSetting("VisualVoiceMailPasswordEnabled", this, this.onVisualVoiceMailPasswordEnabled);
		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreenSaversListChoice", this._onScreenSaversListChoiceChanged);
		ICTouchAPI.settingServices.getSetting("ScreenSaversListChoice", this, this._onScreenSaversListChoiceChanged);
		dojo.subscribe("ModeHotel", this.data, this.data.setHotelMode);

		var func={context: webapp.voicemail, func: this.onVoicemailSelected};

		this.data.objAllLog = new UIElements.MenuList.MenuListControl({
			boolShowNormalLeftIcon: true,
			autoSelectFirst : false,
			showEmptyState: true,
			callback: func
		});
		this.data.objUnreadLog = new UIElements.MenuList.MenuListControl({
			boolShowNormalLeftIcon: true,
			autoSelectFirst : false,
			showEmptyState: true,
			callback: func
		});
		this.data.loadVoicemailLog();
		this.initNotificationsValue();
	},

	buttonCallback : function(buttonId) {
		var data = this.data;
		var recordId=null;
		var objLog = this.data.getSelectedEntry();
		if(objLog){
			recordId = objLog.objLogData.wsRecordId;
		}
		switch(buttonId)
		{
			case data.BACK_BTN:
				dojo.publish("OpenHomepage");
			break;
			case data.CALLVM_BTN:
				ICTouchAPI.APIServices.Telephony.listenVM({params:[], context:this, callback:null, callbackParams:null});
			break;
			case data.PLAYVM_BTN:
				this.clbkPlayAction();
			break;
			case data.PAUSEVM_BTN:
				this.clbkPauseAction();
			break;
			case data.STOPVM_BTN:
				ICTouchAPI.APIServices.Telephony.stopMessage({params:[recordId], context:this, callback:null, callbackParams:null});
			break;
			case data.RESUMEVM_BTN:
				this.clbkPlayAction();
			break;
			case data.TRANSFERVM_BTN:
				this.showSearchPad({buttonType:data.TRANSFERVM_BTN});
			break;
			case data.TRANSFERVM_BY_MAIL_BTN:
				this.showSearchPad({buttonType:data.TRANSFERVM_BY_MAIL_BTN});
			break;
			case data.CALL_SENDER_BTN:
				var senderNum = objLog.objLogData.listContactSummary[0].officePhone;
				ICTouchAPI.APIServices.Telephony.callMessageSender({params:[recordId,senderNum], context:this, callback:null, callbackParams:null});
			break;
			case data.DELETE_LOG:
				this.openDeletePopup();
				break;
			case data.LISTEN_VM:
				this.apiCallVoicemail();
			break;

			default :
				console.warn("No callback is associated with this ID : " + buttonId);
			break;
		}
	},


	clbkPlayAction : function(){
		if(this.data.boolSliderLoaded) {
			var offsetSlider = this.data.sliderUI.currentSliderPosition/1000;
			var objMessage = this.data.arrMessages[this.data.intCurrentMessageId];
			if(! objMessage) {return;}
			if(objMessage.dateMessagePlayed){
				if(this.data.sliderUI.isSliderMoved()){
					ICTouchAPI.APIServices.Telephony.resumeMessage({params:[objMessage.intMessageId,offsetSlider], context:this, callback:null, callbackParams:null});
				}else {
					ICTouchAPI.APIServices.Telephony.resumeMessage({params:[objMessage.intMessageId,objMessage.intOffsetMessagePaused], context:this, callback:null, callbackParams:null});
				}
			} else {
				if(offsetSlider > 0){
					ICTouchAPI.APIServices.Telephony.resumeMessage({params:[objMessage.intMessageId,offsetSlider], context:this, callback:null, callbackParams:null});
				} else {
					ICTouchAPI.APIServices.Telephony.playMessage({params:[objMessage.intMessageId], context:this, callback:null, callbackParams:null});
				}
			}
		}
	},

	clbkPauseAction : function(){
		if(this.data.boolSliderLoaded) {
			ICTouchAPI.APIServices.Telephony.pauseMessage({params:[this.data.intCurrentMessageId], context:this, callback:null, callbackParams:null});
		}
	},

	clbkStopAction : function(){
		if(this.data.boolSliderLoaded) {
			ICTouchAPI.APIServices.Telephony.stopMessage({params:[this.data.intCurrentMessageId], context:this, callback:null, callbackParams:null});
		}
	},

	playSlider : function(offset) {
		if(this.data.sliderUI) {
			this.data.sliderUI.setToTime(offset);
			this.data.sliderUI.mediaPlay();
		}
	},

	pauseSlider : function(offset) {
		if(this.data.sliderUI) {
			this.data.sliderUI.mediaPause();
			this.data.sliderUI.setToTime(offset);
		}
	},

	onNotifyVoiceMailCountChanged : function(nrOfNotif)
	{
		for (var i = 0;i < nrOfNotif; i++) {
			ICTouchAPI.notificationServices.incNotification("Voicemail");
		}
	},

	capabilityCallback : function(capability, value)
	{
		var data = this.data;

		if(!data) {
			return;
		}

		switch (capability) {
			case "VVMPlayMessage":
				data.intPlayMessage = value;
			break;
			case "VVMPauseMessage":
				data.intPauseMessage = value;
			break;
			case "VVMDeleteMessage":
				data.intDeleteMessage = value;
			break;
			case "VVMCallSender":
				data.intCallSender = value;
			break;
			case "VVMForwardToVM":
				data.intForward = value;
			break;
			case "VVMForwardByEmail":
				data.intForwardToMail = value;
			break;
			case "VVMAvailable":
				if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
					data.voiceMailState = data.VISUAL;
				} else {
					data.voiceMailState = data.BASIC;
				}
				break;
		}
		this.upgradeAppbar();
	},

	upgradeAppbar : function(){
		var data = this.data;
        var appBar = ICTouchAPI.AppBarServices.getAppBar("voicemail", "voicemailStatus"+data.STATUS_VM);
		var arr = [];
		var intAvail = ICTouchAPI.CapabilityServices.AVAILABLE;
		var intUnavail = ICTouchAPI.CapabilityServices.UNAVAILABLE;
		var intTempUnavail = ICTouchAPI.CapabilityServices.TEMP_UNAVAILABLE;
        arr[data.CALLVM_BTN]				=	{btn : appBar.getButton(data.CALLVM_BTN)				, state : intUnavail};
        arr[data.PLAYVM_BTN]				=	{btn : appBar.getButton(data.PLAYVM_BTN)				, state : intUnavail};
        arr[data.PAUSEVM_BTN]				=	{btn : appBar.getButton(data.PAUSEVM_BTN)				, state : intUnavail};
        arr[data.STOPVM_BTN]				=	{btn : appBar.getButton(data.STOPVM_BTN)				, state : intUnavail};
        arr[data.RESUMEVM_BTN]				=	{btn : appBar.getButton(data.RESUMEVM_BTN)				, state : intUnavail};
        arr[data.TRANSFERVM_BTN]			=	{btn : appBar.getButton(data.TRANSFERVM_BTN)			, state : data.intForward};
        arr[data.TRANSFERVM_BY_MAIL_BTN]	=	{btn : appBar.getButton(data.TRANSFERVM_BY_MAIL_BTN)	, state : data.intForwardToMail};
        arr[data.CALL_SENDER_BTN]			=	{btn : appBar.getButton(data.CALL_SENDER_BTN)			, state : data.intCallSender};
		//arr[data.CONTACT_LOG]				=	{btn : appBar.getButton(data.CONTACT_LOG)			, state : intUnavail};
		arr[data.DELETE_LOG]				=	{btn : appBar.getButton(data.DELETE_LOG)				, state : data.intDeleteMessage};


		arr[data.CALLVM_BTN].state = intUnavail;
		if(data.voiceMailState === data.VISUAL){
			var objMessage = data.arrMessages[data.intCurrentMessageId];
			var objContact = objMessage ? objMessage.objContact : null;
			//Management of callback button
			if(objMessage
				&& (!objMessage.objVMLog.objLogData.listContactSummary[0].officePhone
					|| objMessage.objVMLog.objLogData.listContactSummary[0].officePhone == ""
					|| objMessage.objVMLog.objLogData.listContactSummary[0].officePhone == "****"
					|| objMessage.objVMLog.objLogData.listContactSummary[0].officePhone == "anonymous"
					)) {
				arr[data.CALL_SENDER_BTN].state = intUnavail;
			}
			//Management of play, pause, resume buttons
			if(data.intPlayMessage == intAvail){
				if(objMessage && objMessage.dateMessagePlayed){
					arr[data.PLAYVM_BTN].state = intUnavail;
					if(objMessage.dateMessagePaused && objMessage.dateMessagePaused > objMessage.dateMessagePlayed){
						arr[data.PAUSEVM_BTN].state = intUnavail;
						arr[data.RESUMEVM_BTN].state = intAvail;
						arr[data.STOPVM_BTN].state = intAvail;
					} else {
						arr[data.PAUSEVM_BTN].state = intAvail;
						arr[data.RESUMEVM_BTN].state = intUnavail;
						arr[data.STOPVM_BTN].state = intAvail;
					}
				} else {
					arr[data.PLAYVM_BTN].state = intAvail;
					arr[data.PAUSEVM_BTN].state = intUnavail;
					arr[data.RESUMEVM_BTN].state = intUnavail;
					arr[data.STOPVM_BTN].state = intTempUnavail;
				}
			} else if(data.intPlayMessage == intTempUnavail){
				arr[data.PLAYVM_BTN].state = intTempUnavail;
				arr[data.PAUSEVM_BTN].state = intTempUnavail;
				arr[data.RESUMEVM_BTN].state = intTempUnavail;
				arr[data.STOPVM_BTN].state = intTempUnavail;
			} else {
				arr[data.PLAYVM_BTN].state = intUnavail;
				arr[data.PAUSEVM_BTN].state = intUnavail;
				arr[data.RESUMEVM_BTN].state = intUnavail;
				arr[data.STOPVM_BTN].state = intUnavail;
			}
			if(data.intPauseMessage != intAvail){
				if(data.intPauseMessage == intTempUnavail) {
					arr[data.PAUSEVM_BTN].state = intTempUnavail;
					arr[data.RESUMEVM_BTN].state = intTempUnavail;
				} else {
					arr[data.PAUSEVM_BTN].state = intUnavail;
					arr[data.RESUMEVM_BTN].state = intUnavail;
				}
			}
			//arr[data.CONTACT_LOG].state = intAvail;
		} else {
			arr[data.PLAYVM_BTN].state = intUnavail;
			arr[data.PAUSEVM_BTN].state = intUnavail;
			arr[data.RESUMEVM_BTN].state = intUnavail;
			arr[data.STOPVM_BTN].state = intUnavail;
			arr[data.TRANSFERVM_BTN].state = intUnavail;
			arr[data.TRANSFERVM_BY_MAIL_BTN].state = intUnavail;
			arr[data.CALL_SENDER_BTN].state = intUnavail;
			arr[data.DELETE_LOG].state = intUnavail;
			//arr[data.CONTACT_LOG].state = intUnavail;
		}

		var intVmNumber = data.voicemailNumber;
		if(intVmNumber && intVmNumber != "") {
			arr[data.CALLVM_BTN].state = intAvail;
		}

		for (var i in arr){
			if(arr[i].btn && typeof arr[i].btn != 'string'){
				if(arr[i].state == intAvail){
					arr[i].btn.show();
				} else if(arr[i].state == intTempUnavail){
					arr[i].btn.greyTint();
				} else {
					arr[i].btn.hide();
				}
			}
		}
	},

	// This function is called to initiate a transfer. It opens a keyboard or a dial-pad.
	// If the webapp search exists, it's used (else a default dial-pad is used)
	showSearchPad : function(args) {
		var data = this.data;
		var buttonType = args.buttonType;
		// The "funcOpenDialpad" function will be called is webapp search when the dial-pad is deployed,
		//	and everytime it's swtiched between dial-pad and keyboard.
		var funcOpenDialpad = function() {

			};
		// Create the "search" object that contains parameters for the webapp search
		var objSearch = {
			contactDataTypes : null,
			useDefaultCallMethod : true,
			dialpadObject : {
				funcCallbackOk : function(){
					var callback = objSearch.lineClickCallback;
					callback.func.apply(callback.context, [this.getValue()]);
				},
				funcCallbackKeyPress : function(){
					ICTouchAPI.APIServices.Telephony.dialKeyEnter({});
				},
				funcCallbackExit : function(){
				},
				strOkLabel: _("Transfer","webapp.voicemail"),
				numPadLengthLimit : 40
			},
			onOpenDialpad : funcOpenDialpad
		};

		// Define the callback to be called to perform the requested action
		switch (buttonType) {
			case data.TRANSFERVM_BTN:
				objSearch.contactDataTypes = ["Phone"];
				objSearch.secondaryInformation = "phoneNumber"; // information of the contact to be displayed at the right of the contact's display name in the search results
				objSearch.lineClickCallback = {
					neededData: "phoneNumber",
					context: webapp.voicemail,
					func: this.transferToVMFromKeyboard
				};
				break;
			case data.TRANSFERVM_BY_MAIL_BTN:
				objSearch.contactDataTypes = ["address"];
				objSearch.secondaryInformation = "email"; // information of the contact to be displayed at the right of the contact's display name in the search results
				objSearch.lineClickCallback = {
					neededData: "email",
					context: webapp.voicemail,
					func: this.transferToMailFromKeyboard
				};
				break;
		}
		// If the search webapp exists, call it with the parameters defined above
		if (typeof webapp.search != "undefined") {
			webapp.search.doSearch(objSearch, 
				function() {
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						params: {}
				});
			});
		}
		// Else open standard dial-pad
		else
		{
			funcOpenDialpad();
			switch (searchType) {
				case data.SEARCH_NUMBER:
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUM, null, objSearch.dialpadObject);
					break;
				case data.SEARCH_MAIL:
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, objSearch.dialpadObject);
					break;
			}
		}
	},

	transferToVMFromKeyboard : function(value){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication", params: {}});
		var objLog = this.data.getSelectedEntry();
		ICTouchAPI.APIServices.Telephony.forwardMessageToVM({params:[objLog.objLogData.wsRecordId, value], context:this, callback:null, callbackParams:null});
	},

	transferToMailFromKeyboard : function(value){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication", params: {}});
		var objLog = this.data.getSelectedEntry();
		ICTouchAPI.APIServices.Telephony.forwardMessageByEmail({params:[objLog.objLogData.wsRecordId, value], context:this, callback:null, callbackParams:null}) ;
	},

	onVVMPlaying : function(messageId, offset){
		if(this.data.arrMessages[messageId.value] && offset){
			this.data.arrMessages[messageId.value].dateMessagePlayed = new Date().getTime();
			if(messageId.value == this.data.intCurrentMessageId){
				this.playSlider(offset.value);
			}
			this.idMessagePlayed = messageId.value;
			this.boolMessagePaused = false;
		}
		webapp.communication.data.setAvoidCommSwitch(true);
		this.upgradeAppbar();
		var logIdPlaying = this.getIdMessagePlayed();
		dojo.publish('VVMPlayingIdChanged', [logIdPlaying]);
	},

	onVVMPaused : function(messageId, offset){
		if(this.data.arrMessages[messageId.value] && offset){
			this.data.arrMessages[messageId.value].dateMessagePaused = new Date().getTime();
			this.data.arrMessages[messageId.value].intOffsetMessagePaused = offset.value;
			if(messageId.value == this.data.intCurrentMessageId){
				this.pauseSlider(offset.value);
			}
			this.boolMessagePaused = true;
		}
		this.upgradeAppbar();
	},

	onVVMStopped : function(messageId){
		if(this.data.arrMessages[messageId.value]){
			this.data.arrMessages[messageId.value].dateMessagePlayed = null;
			this.data.arrMessages[messageId.value].dateMessagePaused = null;
			this.data.arrMessages[messageId.value].intOffsetMessagePaused = null;
			if(this.data.intCurrentMessageId
				&& messageId.value == this.data.intCurrentMessageId){
				this.pauseSlider(0);
			}
			this.idMessagePlayed = null;
			this.boolMessagePaused = null;
		}
		webapp.communication.data.setAvoidCommSwitch(false);
		this.upgradeAppbar();
		dojo.publish('VVMPlayingIdChanged', [null]);
	},

	onVVMDeleted : function(messageId){
		if(this.data.arrMessages[messageId.value]){
			this.data.arrMessages.splice(messageId,1);
		}
		this.upgradeAppbar();
	},

	onVVMTransferred : function(messageId, destination){
		this.onVVMStopped(messageId);
		this.upgradeAppbar();
	},

	onVVMAccessLocked : function(){
		ICTouchAPI.debugServices.info("webapp.voicemail.controlBase - onVVMAccessLocked");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - onVVMAccessLocked / args: " + dojo.toJson(args));
		//args.comment && args.locked
		if(!args.locked){
			this.data.setPasswordVVMNeed(false);
			this.setCustomExit(false,"screensaver");
			this.setCustomExit(false,"lock");
			this.data.processRemoveUnreadList();
			this.switchList(this.data.currentObjListId || this.data.LOG_LIST_ALL);
			this.data.currentObjListId = null
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.voicemail.getVoicemail",
				params: {}
			});
		}else{
			this.setCustomExit(true,"screensaver");
			this.setCustomExit(false,"lock");
			this.data.setPasswordVVMNeed(true);
			if(args.comment=="TIMEOUT"){
				if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.voicemail") != -1){
					dojo.publish("OpenHomepage");
				}
			}else {
				var context = this;
				var strErrorMessage;
				var callback = function(){
					ICTouchAPI.popupServices.removePopup(context.popupWrongLogin);
				}
				var popupType = "error";
				switch(args.comment) {
					case "EXPIRED":
						//strErrorMessage = _(["Call", "Voicemail", ":", this.data.voicemailNumber], "webapp.voicemail").toString();
						strErrorMessage = _("Dial %s to initialize and change your password", "webapp.voicemail",[this.data.voicemailNumber]).toString();
						popupType = "info";
					break;
					case "LOCKED":
						strErrorMessage = "Account blocked. Please contact your administrator.";
					break;
					case "TEMPORARY_LOCKED":
						strErrorMessage = "Account temporarily blocked. Please try again in 5 minutes.";
					break;
					case "WRONG_PASSWORD":
						strErrorMessage = "Wrong password. Please try again.";
						// overwrite the callback function to open again the keyboard when the popup is closed
						callback = function(){
							ICTouchAPI.popupServices.removePopup(context.popupWrongLogin);
							context.askForVVMPassword();
						}
					break;

					default :
						strErrorMessage = "Request failed or webservices not available. Please try again later.";
						ICTouchAPI.debugServices.warning("webapp.voicemail.controlBase - onVVMAccessLocked / Unknown comment, comment is: " + args.comment + ". Use default error message.");
					break;
				}

				var popupData = {
					strType: popupType,
					strContent : _(strErrorMessage, 'UIElements.DialogBox'),
					arrPopupButtons: [{
						strButtonLabel: _('Dismiss', "ICTouchAPI"),
						strButtonIcon: "generic-cancel",
						callback : callback
					}]
				};

				this.popupWrongLogin = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
			}
		}
	},

	setCustomExit : function(boolCustomExit,webapName){
		switch(webapName)
		{
			case "screensaver":
				if(boolCustomExit){
					dojo.publish("customExitForScreensaverVVM",[true]);
					break;
				}else{
					dojo.publish("customExitForScreensaverVVM",[false]);
					break;
				}
			break;
			case "lock":
				if(boolCustomExit){
					dojo.publish("customExitForLockVVM",[true]);
					break;
				}else{
					dojo.publish("customExitForLockVVM",[false]);
					break;
				}
			break;
		}
	},

	onResetCustomExit : function(webapp){
		if(webapp){
			this.data.customExitWebapp[webapp] = false;
			this.data.boolVVMAlreadyLeft = false;
			this.setCustomExit(false,webapp);
		}
	},

	onRequestCustomVVMExit : function(webappName){
		this.data.customExitWebapp[webappName] = true;
		if(!this.data.boolVVMAlreadyLeft){
			if(!this.data.getPasswordVVMNeed()){
				if(webappName=="lock"){
					if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.voicemail") != -1){
						this.setCustomExit(true,webappName);
						this.data.boolVVMAlreadyLeft = true;
					}
				}else if(webappName=="screensaver"){
					if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.voicemail") != -1){
						this.data.boolVVMAlreadyLeft = true;
					}
				}
			}
		}else{
			if(!this.data.getPasswordVVMNeed()){
				if(webappName=="lock"){
					this.setCustomExit(true,webappName);
				}
			}
		}
	},


	onModeHotel : function(){
		this.data.displayTotalMessages = false;
	},

	getIdMessagePlayed : function() {
		var comlogId = null;
		if(this.data.arrMessages[this.idMessagePlayed]){
			comlogId = this.data.arrMessages[this.idMessagePlayed].objVMLog.objLogData.comLogEntryId;
		}
		return comlogId;
	},

	stopReadingMessage : function() {
		if(this.idMessagePlayed) {
			ICTouchAPI.APIServices.Telephony.stopMessage({params:[this.data.intCurrentMessageId], context:this, callback:null, callbackParams:null});
		}
	},

	checkAndStopMessage : function() {
		if(this.idMessagePlayed) {
			if(this.boolMessagePaused) {
				ICTouchAPI.APIServices.Telephony.stopMessage({params:[this.idMessagePlayed], context:webapp.voicemail, callback:null, callbackParams:null});
			}
		}
	},

	onDateFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data.dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			this.data.loadVoicemailLog();
		}
		objSetting=null;
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting != null) {
			this.data.time24hformat = objSetting.jsValue;
			this.data.loadVoicemailLog();
		}
		objSetting=null;
	},

	onVisualVoiceMailPasswordEnabled:function(objSetting){
		if(objSetting) {
			this.data.setVisualVoiceMailPasswordEnabled(objSetting.jsValue);
		}
		objSetting=null;
	},

	unlock: function(strWebapp) {
		dojo.publish("unlockTransition",[true]);
		this.checkAndStopMessage();
		this.data.processRemoveUnreadList();

		var reg = /^webapp\.(screensaver|lock)\.[^.]+/;
		if(!reg.test(strWebapp) && this.data.getScreensaverWebapp() != strWebapp){
			ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - unlock / Call IctUser.lockVVMAccessRequest");
			ICTouchAPI.APIServices.IctUser.lockVVMAccessRequest({});
		}
	},



	//Called when entry on 1/3 MenuList has pressed
	onVoicemailSelected : function(logId) {
		this.data.loadDetails(logId);
	},

	//Called when tab on 1/3 title has pressed
	switchList : function(listId, boolForce) {
		if(this.mainWidget && this.mainWidget.objMenu) {
			this.mainWidget.objMenu.selectTitleById(listId, true);
		}
		if(listId!==this.data.getDisplayedList() || boolForce) {
			if(listId !== this.data.LOG_LIST_UNREAD) {
				this.data.processRemoveUnreadList();
			}
			this.data.setDisplayedList(listId);
			if(this.objLogContent) {
				this.objLogContent.switchMenuList(listId);
			}
		}

			//Select previous selected entry
			var nbItems = this.data.getNbItems(listId);
			if(nbItems > 0) {
			var comlogId = this.data.getVMIdByRecordId(this.idMessagePlayed, listId);
			if(comlogId) {
				this.data.selectItemByIndex(comlogId, true, listId);
				}
				else {
				this.data.selectItemByPosition(0, true, listId);
				}
			}
			else {
				this.data.loadDetails(undefined);
			}
	},

	// Called when the Voicemail number has changed
	onVMNumberChanged: function(objSetting) {
		if (objSetting) {
			ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - onVMNumberChanged / previous voicemailNumber:" + this.data.voicemailNumber);
			this.data.voicemailNumber = objSetting.jsValue;
			ICTouchAPI.debugServices.debug("webapp.voicemail.controlBase - onVMNumberChanged / new voicemailNumber:" + this.data.voicemailNumber);
		}
		objSetting=null;
	},

	onVoicemailEnter : function(objListId){
		if(this.data.voiceMailState===this.data.VISUAL) {
			// Check if capabilities are available. If not, ask for a refresh.
			if(this.data.intPlayMessage == ICTouchAPI.CapabilityServices.UNAVAILABLE || this.data.intPauseMessage == ICTouchAPI.CapabilityServices.UNAVAILABLE){
				ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({params:["RefreshVVMCapabilitiesEvent"]});
			}
			if(this.data.getVisualVoiceMailPasswordEnabled()){
				this.data.currentObjListId = objListId;
				this.askForVVMPassword();
			}else{
				this.data.processRemoveUnreadList();
				this.switchList(objListId || this.data.LOG_LIST_ALL);
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.voicemail.getVoicemail",
					params: {}
				});
			}
		}else{
			// Basic voicemail: call VM
			this.apiCallVoicemail();
		}
	},


	askForVVMPassword : function(){
		ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUMPASSWORD,
		null,
		{
			strDefaultText: "",
			funcCallbackOk : function(password) {
				ICTouchAPI.APIServices.IctUser.unLockVVMAccessRequest({
					params:[password]
				});
			},
			funcCallbackExit : function() {
				// GO TO HOMEPAGE ?
			},
			strExitLabel: _('Cancel','ICTouchAPI'),
			strExitIcon: "generic-cancel",
			strInputTitle : _("Please enter your password :","webapp.voicemail"),
			hideStarsIfPasswordEmpty :true
		});
	},

	onEnablePhotoInComlogChanged : function(objSetting) {
		if(objSetting){
			this.data.boolEnablePhotoInComlog = objSetting.jsValue;
			this.data.loadVoicemailLog();
		}
		objSetting=null;
	},



	apiCallVoicemail: function() {
		if( this.data.voicemailNumber ) {
			ICTouchAPI.APIServices.Telephony.listenVM({});
		} else {
			// display an error popup as the TelephonyVMNumber setting is not defined
			ICTouchAPI.popupServices.errorPopup("", _("Voicemail number is not configured. Please contact your administrator.","webapp.voicemail"));
		}
	},

	apiNotifyComlogEntryAdded : function(objEvent) {
		objEvent = objEvent.value;
		if(objEvent && objEvent.entryType === ICTouchAPI.tools.enumComLogEntryType.VM){
			this.data.addInLog(objEvent);
		}
		objEvent=null;
	},

	apiNotifyComlogEntryDeleted : function(comlogId) {
		this.data.removeFromLog(comlogId.value);
		comlogId=null;
	},

	apiNotifyComlogEntryChanged: function(objEvent) {
		objEvent = objEvent.value;
		if(objEvent && objEvent.entryType === ICTouchAPI.tools.enumComLogEntryType.VM){
			this.data.modifyInLog(objEvent);
		}
		objEvent=null;
	},

	apiNotifyComlogChanged: function() {
		this.data.loadVoicemailLog();
	},



	// Open the delete popup with type choice
	openDeletePopup : function() {
		// Save context
		var context = this;

		context.data.intDeleteOption = context.data.DELETE_ONE;
		var selected = this.data.getSelectedEntry();
		var displayName = "";
		if (selected) {
			displayName = this.data.getSelectedEntryContactString();
		}

		// Create the popup data

		var popupDel = {
			strTitle: _("Select Voice mail entries to delete", "webapp.voicemail"),
			strWidgetName : "UIElements.SelectList.SelectListControl",
			arrItems: [ {
					boolSelected: true,
					intIndex: context.data.DELETE_ONE,
					strLabel: _(['Delete Voice mail from', displayName], "webapp.voicemail"),
					strSecondaryContentIcon: ""
				}, {
					boolSelected: false,
					intIndex: context.data.DELETE_ALL,
					strLabel: _('Delete all Voice mails', "webapp.voicemail"),
					strSecondaryContentIcon: ""
				} ],
			itemCallback : function(intIndex) {
				context.data.intDeleteOption = intIndex;
			},
			boolMultiselect: false,
			arrPopupButtons: [ {
					strButtonName: "DELETE_BTN",
					strButtonLabel: _('Delete', "ICTouchAPI"),
					strButtonIcon: "generic-mode-delete",
					callback : {
						func: context.deleteLog,
						context: context
					}
				}, {
					strButtonName: "CANCEL_BTN",
					strButtonLabel: _('Cancel', "ICTouchAPI"),
					strButtonIcon: "generic-cancel",
					callback : function(){
						ICTouchAPI.popupServices.removePopup(context.objPopupConfirmDelete);
					}
				}
			]
		};
		// Show the popup
		this.objPopupConfirmDelete = ICTouchAPI.popupServices.addNewPopup(popupDel, "MEDIUM");
	},

	deleteLog : function() {
		if(this.data.intDeleteOption === this.data.DELETE_ONE) {
			var selected = this.data.getSelectedEntry();
			if (selected && selected.objLogData) {
				if(this.idMessagePlayed === selected.objLogData.wsRecordId) {
					this.stopReadingMessage();
				}
				ICTouchAPI.APIServices.Comlog.deleteEntry({
					params:[selected.objLogData.comLogEntryId],
					context:this
				});
			}
		}
		else if(this.data.intDeleteOption === this.data.DELETE_ALL) {
			this.stopReadingMessage();
			ICTouchAPI.APIServices.Comlog.deleteWithMoreFilters({
				params:[this.data.COMLOG_FILTER_VM_BUSINESS_ID+":"+this.data.FILTER_ALL],
				context:this
			});
		}
		ICTouchAPI.popupServices.removePopup(this.objPopupConfirmDelete);
	},



	initNotificationsValue : function() {
		 ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "Voicemail",
			strNotificationLabel: _("Voicemail", "webapp.voicemail"),
			intNotificationValue: 0,
			callback: {
				context:this,
				func:this.onNotificationVoiceMail
			}
		});

		ICTouchAPI.APIServices.Comlog.count({
			params:[0,this.data.COMLOG_FILTER_VM_BUSINESS_ID],
			context:this,
			callback:function(count) {
				if(count>0){
					ICTouchAPI.ledServices.activate('communication','N_VM');
				}else{
					ICTouchAPI.ledServices.desactivate('communication','N_VM');
				}
				ICTouchAPI.notificationServices.setNotificationValue("Voicemail", count);
			}
		});
	},

	apiAddVoiceMailNotif : function(notif) {
		if(notif.value>0){
			ICTouchAPI.ledServices.activate('communication','N_VM');
		}else{
			ICTouchAPI.ledServices.desactivate('communication','N_VM');
		}
		ICTouchAPI.notificationServices.setNotificationValue("Voicemail",notif.value);
		notif=null;
	},

	onNotificationVoiceMail : function() {
		this.onVoicemailEnter(this.data.LOG_LIST_UNREAD);
	},

	onDayChanged: function() {
		this.data.loadVoicemailLog();
	},

	_onScreenSaversListChoiceChanged : function(screen){
		ICTouchAPI.debugServices.info("webapp.voicemail.controlBase - _onScreenSaversListChoiceChanged");
		this.data.setScreensaverWebapp(screen);
	}
});
