dojo.provide("webapp.magnify.controlBase");
dojo.declare("webapp.magnify.controlBase",[ICTouchAPI.webApplication],
{
	constructor: function() {
		var that = this;
		ICTouchAPI.settingServices.getSetting("MagnifyEnabled", this, function (state) {
			that.data.setEnabled(state.jsValue);
			if(state.jsValue) {
				this.addmagButton();
			}
		});
		ICTouchAPI.settingServices.subscribeToSetting(this, "MagnifyEnabled", function (state) {
			that.data.setEnabled(state.jsValue);
			that.manageMagnifyButton();
		});
	},

	manageMagnifyButton: function() {
		if(this.data.getEnabled()) {
			this.addmagButton();
		} else {
			this.removeMagButton();
			this._demagnifyAll();
		}
	},

	addmagButton: function(){
		var that = this;
		ICTouchAPI.AppBarServices.addGlobalButton({
			strButtonName: "MAGNIFY",
			strButtonLabel: _("Magnify", "webapp.magnify"),
			strButtonIcon: 'generic-magnify',
			callback: function(){
				var oldIcon = this.strButtonIcon;
				if(! this.magnify) {
					this.magnify = true;
					this.strButtonIcon = this.strButtonIcon.replace('generic-magnify', 'generic-magnify-zoomout');
				} else {
					this.magnify = false;
					this.strButtonIcon = this.strButtonIcon.replace('generic-magnify-zoomout', 'generic-magnify');
				}
				dojo.removeClass(this.domIcon, oldIcon);
				dojo.addClass(this.domIcon, this.strButtonIcon);
				that.toggleZoom();
			}
		});
	},

	removeMagButton: function(){
		ICTouchAPI.AppBarServices.removeGlobalButton("MAGNIFY");
	},

	toggleZoom : function () {
		this._magnifyView(ICTouchAPI.transitionServices.getCurrentWebAppIFrameDocument(), "switchZoom");
	},

	_demagnifyAll : function () {
	    dojo.publish("demagnifyAll");
	},

	_magnifyView : function (view, state) {
		var am = view.querySelector("div[id*=UIElements_ApplicationMode_]");
		if(am && am.id) {
			var tmp = dijit.byId(am.id);
			if (tmp && tmp[state] && (typeof tmp[state]) == "function") {
				dijit.byId(am.id)[state]();
			}

		}
	},

	load : function(){


		//help
		dojo.publish("needHelpEvent",["magnify",[]]);
	}



});

