dojo.provide("webapp.communication.historyDataBase");
dojo.declare("webapp.communication.historyDataBase",null,
{
	// Member data used for object construction
	_intLoadingLogs				: 0,
	_arrAllButtons				: [],
	_arrAppBarSkeleton			: [],
	_intCurrentEntry			: 0,
	_intCurrentMissedEntry		: 0,
	_intLogIdToSelect			: null,
	_boolNotifsLoaded			: false,
	_intLastSelected			: 0, // Last item in comlog that has been selected

	_24hformat					: false,

	_objHiddenComlogItems		: {},

	_arrComLogEntryTypes		: [],
	FILTER_UNREAD				: 0,
	FILTER_READ					: 1,
	FILTER_ALL					: 2,
	_intCountCallback			: 0,
	_intCountMissed				: 0,

	_objFirstSelected			: null,
	_strTitle					: "",
	_strContainerPath			: "webapp.communication.getHistoryContactCard",

	// Contact information
	_arrContactLog              : [],

	objCurrentContact           : null,

	objOldAudioEventValue		: null,
	objContactCard				: null,
	objConferenceWidget			: null,
	objComlog					: null,
	objComlogPreview			: null,
	objMissedComlog				: null,

	// Constant values for the button's id
	BACK				: "BACK_BTN",
	CALL				: "CALL_BTN",
	NEW_CALL			: "NEW_CALL_BTN",
	DELETE_LOG			: "DELETE_LOG_BTN",
	DELETE_ALL_LOG		: "DELETE_ALL_LOG_BTN",
	FILTER				: "FILTER_BTN",
	CANCEL_CALL			: "CANCEL_CALL_BTN",
	CALL_BACK			: "CALL_BACK_BTN",
	END_CALL			: "END_CALL_BTN",
	HOLD				: "HOLD_BTN",
	TRANSFER			: "TRANSFER_BTN",
		TRANSFER_TO			: "TRANSFER_TO_BTN",
	DEFLECT_NUMBER		: "DEFLECT_NUMBER_BTN",
	DTMF				: "DTMF_BTN",
	//RECORD				: "RECORD_BTN",
	START_RECORDING		: "START_RECORDING_BTN",
	PAUSE_RECORDING		: "PAUSE_RECORDING_BTN",
	RESUME_RECORDING	: "RESUME_RECORDING_BTN",
	STOP_RECORDING		: "STOP_RECORDING_BTN",
	RETRIEVE			: "RETRIEVE_BTN",
	ANSWER				: "ANSWER_BTN",
	IGNORE				: "IGNORE_BTN",
	DEFLECT				: "DEFLECT_BTN",
	DEFLECT_VM			: "DEFLECT_VM_BTN",
	DEFLECT_MOBILE		: "DEFLECT_MOBILE_BTN",
	REJECT				: "REJECT_BTN",
	CONFERENCE			: "CONFERENCE_BTN",
	ADD_PARTICIPANT		: "ADD_PARTICIPANT_BTN",
	REMOVE_PARTICIPANT	: "REMOVE_PARTICIPANT_BTN",
	MERGE				: "MERGE_BTN",
	LEAVE_CONFERENCE_N	: "LEAVE_CONFERENCE_N_BTN",
	STOP_CONFERENCE_N	: "STOP_CONFERENCE_N_BTN",
	STOP_CONFERENCE_3	: "STOP_CONFERENCE_3_BTN",
	MUTE_PARTICIPANT	: "MUTE_PARTICIPANT_BTN",
	CONTACT_DETAILS		: "CONTACT_DETAILS_BTN",
	TO_DIALER			: "TO_DIALER_BTN",
	CANCEL_INIT_CONF3	: "CANCEL_INIT_CONF3_BTN",
	CANCEL_TRANSFER_TO	: "CANCEL_TRANSFER_TO_BTN",
	CANCEL_ADD_PARTICIPANT: "CANCEL_ADD_PARTICIPANT_BTN",
	CANCEL				: "CANCEL_BTN",
	LISTEN_VM			: "LISTEN_BTN",
	CALLPICKUP			: "CALLPICKUP_BTN",
	DEFLECT_DVA_BTN		: "DEFLECT_DVA_BTN",
	UNREAD				: "UNREAD_BTN",
	SEARCH				: "SEARCH_BTN",

	// Constant Values for the ComlogFilters id
	COMLOG_FILTER_ALL				: 0,
	COMLOG_FILTER_UNANS_INC_CALL	: 1,
	COMLOG_FILTER_VM				: 2,
	COMLOG_FILTER_CALLBACK_REQ		: 3,
	COMLOG_FILTER_IM				: 4,

	// Constant Values for the ComlogFilters business id
	COMLOG_FILTER_INC_CALL_BUSINESS_ID			: 0,
	COMLOG_FILTER_OUT_CALL_BUSINESS_ID			: 1,
	COMLOG_FILTER_ANS_INC_CALL_BUSINESS_ID		: 2,
	COMLOG_FILTER_ANS_OUT_CALL_BUSINESS_ID		: 3,
	COMLOG_FILTER_UNANS_INC_CALL_BUSINESS_ID	: 4,
	COMLOG_FILTER_UNANS_OUT_CALL_BUSINESS_ID	: 5,
	COMLOG_FILTER_CALLBACK_REQ_BUSINESS_ID		: 6,
	COMLOG_FILTER_VM_BUSINESS_ID				: 7,
	COMLOG_FILTER_ALL_BUSINESS_ID				: 8,
	COMLOG_FILTER_IM_BUSINESS_ID				: 9,
	COMLOG_FILTER_MAIL_BUSINESS_ID				: 10,
	COMLOG_FILTER_CONFERENCE_BUSINESS_ID		: 11,
	COMLOG_FILTER_MAX							: 11,

	STATUS_CALLS								: 0,
	STATUS_ONGOING								: 16,
	STATUS_OUTGOING								: 17,
	STATUS_INCOMING								: 18,
	STATUS_HOLD									: 19,
	STATUS_BEEN_TRANSFERED						: 20,
	STATUS_CONFERENCE							: 21,
	STATUS_CONFERENCE_PARTICIPANT_SELECTED		: 22,
	STATUS_HELD									: 23,
	STATUS_CONFERENCE_HOLD						: 24,
	STATUS_CONFERENCE_INCOMING					: 25,
	STATUS_EMPTY_VM								: 26,
	STATUS_DOUBLE_CALL							: 27,
	STATUS_EMPTY_BAR							: 28,
	STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED	: 29,

	STATUS_EMPTY								: 1,
	STATUS_LOG									: 2,
	STATUS_LOG_CONFERENCE						: 3,
	STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED	: 4,
	STATUS_TRANSFER_TO							: 5,
	STATUS_TRANSFER								: 6,
	STATUS_ADD_PARTICIPANT						: 7,
	STATUS_MERGE_CALLS							: 8,
	STATUS_INIT_CONF3							: 9,
	STATUS_VM									: 10,
	STATUS_REMOTE_SESSION						: 11,
	STATUS_CONFERENCE_REMOTE_SESSION			: 12,
	STATUS_DEFLECT_TO							: 13,
	STATUS_FILTERED_RING						: 14,
	STATUS_FILTERED_CALL						: 15,

	STATUS_PROGKEYS_CALL						: 200,
	STATUS_PROGKEYS_ROUTING						: 201,
	STATUS_MDR_ROUTING							: 202,
	STATUS_MDR_OVERFLOW							: 203,
	STATUS_MDR_USER								: 204,
	STATUS_BASIC_ADD_ROUTING					: 205,
	STATUS_BASIC_IMMEDIATE_ROUTING				: 206,

	// Constants for comlog management
	COMLOG_LOG								: 0,
	COMLOG_CALL								: 1,
	COMLOG_FILTERED							: 2,

	// Constants for comlog action management
	COMLOG_ACTION_ADD						: 0,
	COMLOG_ACTION_REMOVE							: 1,
	COMLOG_ACTION_MODIFY							: 2,

	// LEDS and LEDS STATUS
	LED_MUTE : 0,
	LED_COMM : 5,

	LED_STATUS_OFF		: 0,
	LED_STATUS_ON		: 1,

	//Constants for list comlog
	COMLOG_LIST_LOG				: 1,
	COMLOG_LIST_MISSED			: 0,

	// call state label list
	lstCallStateLabel	: null,

	lstReason				: {},

	boolEnablePhotoInComlog : null,

	boolContactCardNotEmpty	: true,

	boolHotelMode			: false,

	_userRole				: "",

	strCurrentCommStatusIcon : "",

	strCurrentCommStatusLabelOk : "",

	strCurrentCommStatusLabelCancel : "",

	// Static role constants
	MANAGER_ROLE	: "Manager",
	ASSISTANT_ROLE	: "Assistant",
	UNKNOWN_ROLE	: "Unknown",

	constructor : function(){
		webapp.history._intStatus = this.STATUS_EMPTY;

		var func={
			context: webapp.history,
			func: webapp.history.buttonCallback
		};

		// Store appli's enum's values.
		this.lstReason.PICKUP = "CALL_REASON_PICKED_UP";

		this.lstCallStateLabel = {};
		this.lstCallStateLabel[this.STATUS_OUTGOING] = "Outgoing call";
		this.lstCallStateLabel[this.STATUS_INCOMING] = "Incoming call";
		this.lstCallStateLabel[this.STATUS_ONGOING] = "Call duration";
		this.lstCallStateLabel[this.STATUS_HELD] = "Hold call";
		this.lstCallStateLabel[this.STATUS_HOLD] = "Hold call";
		this.lstCallStateLabel[this.STATUS_REMOTE_SESSION] = "Other device";
		this.lstCallStateLabel[this.STATUS_CONFERENCE_REMOTE_SESSION] = "Other device";
		// Only assistant side for filtered calls.
		this.lstCallStateLabel[this.STATUS_FILTERED_RING] = "Incoming call for";
		this.lstCallStateLabel[this.STATUS_FILTERED_CALL] = "Received call for";

		this._arrAllButtons[this.NEW_CALL] = {strButtonName: this.NEW_CALL, strButtonLabel:_('New call', 'webapp.communication'), strButtonIcon: 'communication-new-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"makeCall"}]};
		this._arrAllButtons[this.CALL] = {strButtonName: this.CALL, strButtonLabel:_('Callback', "webapp.communication"), strButtonIcon: 'communication-call-me-back', callback: func, arrCapabilities: [{module : "Telephony", capability :"makeCall"}]};
		this._arrAllButtons[this.DELETE_LOG] = {strButtonName: this.DELETE_LOG, strButtonLabel:_('Delete', 'ICTouchAPI'), strButtonIcon: 'generic-delete', callback: func};
		this._arrAllButtons[this.DELETE_ALL_LOG] = {strButtonName: this.DELETE_ALL_LOG, strButtonLabel:_('Delete all', 'ICTouchAPI'), strButtonIcon: 'generic-delete-all', callback: func, eventsShow: ["webapp.communication.logNotEmpty"], eventsHide: ["webapp.communication.logEmpty"]};
		this._arrAllButtons[this.CALL_BACK] = {strButtonName: this.CALL_BACK, strButtonLabel:_('Call back', "webapp.communication"), strButtonIcon: 'communication-call-me-back', callback: func, arrCapabilities: [{module : "Telephony", capability :"callbackRequest", instance: -1}]};
		this._arrAllButtons[this.CANCEL] = {strButtonName: this.CANCEL, strButtonLabel:_('Cancel', "webapp.communication"), strButtonIcon: 'generic-cancel', callback: func};
		this._arrAllButtons[this.SEARCH] = {strButtonName: this.SEARCH, strButtonLabel:_('Search', "ICTouchAPI"), strButtonIcon: 'generic-search-by-name', callback: func};

		this._arrComLogEntryTypes = [];
		this._arrComLogEntryTypes.push({businessIds: [this.COMLOG_FILTER_UNANS_INC_CALL_BUSINESS_ID],	enabled: false,	label: _("Missed calls", "webapp.communication"), strSecondaryContentIcon : "communication-log-missed-call-32"});
		this._arrComLogEntryTypes.push({businessIds: [this.COMLOG_FILTER_CALLBACK_REQ_BUSINESS_ID],	enabled: false,	label: _("Filter callback requests", "webapp.communication"), strSecondaryContentIcon : "communication-log-call-me-back-32"});
		this._arrComLogEntryTypes.push({businessIds: [this.COMLOG_FILTER_CONFERENCE_BUSINESS_ID, this.COMLOG_FILTER_ANS_INC_CALL_BUSINESS_ID, this.COMLOG_FILTER_ANS_OUT_CALL_BUSINESS_ID, this.COMLOG_FILTER_UNANS_OUT_CALL_BUSINESS_ID],	enabled: false,	label: _("Filter others", "webapp.communication"), strSecondaryContentIcon : "communication"});

		//Create the skeleton for each appbar
		//Simple Strings are ID from other webapp buttons
		this._arrAppBarSkeleton[this.STATUS_EMPTY] = ["MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_LOG] = [this.CALL,"ADD_CONTACT",this.DELETE_LOG,this.DELETE_ALL_LOG,"WRITE_BTN","CLOSE_BTN","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_LOG_CONFERENCE] = [this.DELETE_LOG,this.DELETE_ALL_LOG,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_TRANSFER_TO] = [this.CANCEL];
		this._arrAppBarSkeleton[this.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED] = [this.CALL,"ADD_CONTACT","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED] = [this.CALL,"ADD_CONTACT","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_EMPTY_BAR]= [];

		var backFunc={
			context: webapp.history,
			func: webapp.history.buttonCallback,
			param: this.BACK
		};

		for(var i in this._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("communication", "historystatus" + i , this._arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("communication", "historystatus" + i, true, backFunc);
			for(var j in this._arrAppBarSkeleton[i]){
				var currentBtn = this._arrAppBarSkeleton[i][j];
				//Button from communication webapp
				if(this._arrAllButtons[currentBtn]){
					var objButton = new UIElements.AppButton.AppButtonControl(this._arrAllButtons[currentBtn]);
					appBar.addAppButton(objButton,false);
				//Button from other webapps
				}else{
					appBar.addAppButton(currentBtn,false);
				}
			}
			appBar.buildDom();
		}
	},

	getNumAppBarFromStatus : function(numStatus) {
		if (numStatus == this.STATUS_TRANSFER_TO || numStatus == this.STATUS_ADD_PARTICIPANT || numStatus == this.STATUS_MERGE_CALLS || numStatus == this.STATUS_INIT_CONF3 || numStatus == this.STATUS_DEFLECT_TO){
			return this.STATUS_TRANSFER_TO;
		} else if (numStatus == this.STATUS_PROGKEYS_CALL || numStatus == this.STATUS_PROGKEYS_ROUTING  || numStatus == this.STATUS_MDR_ROUTING || numStatus == this.STATUS_MDR_OVERFLOW || numStatus == this.STATUS_MDR_USER || numStatus == this.STATUS_BASIC_ADD_ROUTING || numStatus == this.STATUS_BASIC_IMMEDIATE_ROUTING ){
			return this.STATUS_EMPTY;
		} else {
			return numStatus;
		}
	},

	// Note Joel: now comlog and phone calls are loaded asynchronously to speed up things
	loadList : function() {
		ICTouchAPI.log("Start loadList", "TELEPHONY");

		// List has changed so don't select the old entry
		this._intLastSelected = 0;

		var arrCategories = [];

		for(var i=0; i<=this.COMLOG_FILTER_MAX; i++) {
			if(i!=this.COMLOG_FILTER_VM_BUSINESS_ID && i!=this.COMLOG_FILTER_ALL_BUSINESS_ID) {
				arrCategories.push(i + ":" + this.FILTER_ALL);
			}
		}

		this._intLoadingLogs++;
		// Call business function
		ICTouchAPI.APIServices.Comlog.findEntriesByCategories({
			params:[arrCategories],
			context:this,
			callback:this.loadedComlog
		});
	},

	loadedComlog : function(_arr) {
		this._intLoadingLogs--;
		if (this._intLoadingLogs !== 0) {
			ICTouchAPI.debugServices.warning("Rejecting phone calls results, more recent results will arrive.");
			_arr = null;
			return;
		}
		var arrComLog = [];
		var arrMissedCalls = [];
		if (_arr !== undefined) {
			for (var i in _arr) {
				var logObject = _arr[i];
				var objLog = this.buildComlogItem(logObject);
				arrComLog.push(objLog);
				if(!logObject.isRead){
					arrMissedCalls.push(objLog);
				}
			}
		}

		webapp.communication.data.refreshCommunicationListTitle();
		//Clean comlog
		this.emptyItemsInComlogs(this.COMLOG_LIST_LOG);

		this.insertItemsInComlogs(0, arrComLog, this.COMLOG_LIST_LOG);
		//Clean comlog
		this.emptyItemsInComlogs(this.COMLOG_LIST_MISSED);

		this.insertItemsInComlogs(0, arrMissedCalls, this.COMLOG_LIST_MISSED);

		var entry = this.findItemByPosition(0,this.COMLOG_LIST_LOG);
		if(entry){
			this.selectComlogByIndex(entry.intIndex, false, this.COMLOG_LIST_LOG);
			this.loadDetails(entry.intIndex);
		} else {
			this.loadDetails(undefined);
		}

		_arr=null;
	},

	/**
	 * contactId is optional. If not specified, all entry will be refreshed. Otherwise, only those concerning this contact will be refreshed.
	 */
	refreshComlog : function(contactId) {
		var nbItems = this.getNbItems(this.COMLOG_LIST_LOG);
		var objLog = null;
		for(var i=0; i<nbItems;i++){
			if(!contactId || contactId == objLog.contactId){
				objLog = this.buildComlogItem(this.objComlog.getItemByPosition(i).objLogData);
				this.updateItemInComlogs(objLog, this.COMLOG_LIST_LOG);

				if(this.objComlog.getItemByPosition(i).objLogData.isRead){
					this.updateItemInComlogs(objLog, this.COMLOG_LIST_MISSED);
				}
			}
		}
		this.loadDetails(this.getCurrentEntry());
		
	},

	refreshDetails : function() {
		var boolNoEntry = (this.getNbItems(this.getDisplayedComlogList()))? false : true;

		// Sanitize _intLastSelected
		if(boolNoEntry){
			this._intLastSelected = -1;
		}

		if (this._intLastSelected < 0) {
			this.loadDetails(undefined);   			 // show empty contact card
		} else {
			this.loadDetails(this._intLastSelected);			// show current contact card
		}
	},

	/**
	 * refresh the specified entry in 1/3 and 2/3
	 * @param {int} callEntryId : id of the entry to refresh
	 */
	refreshEntryById : function(callEntryId){
		var logObject = this.findItemById(callEntryId,this.COMLOG_LIST_LOG);
		if(logObject){
			this.modifyInLog(logObject.objLogData, false);
		}
		callEntryId=null;
	},

	/**
	 * refresh the specified entry in 1/3
	 * @param {object} logObject : entry to refresh
	 */
	refreshLeftEntry : function(logObject) {
		var item = null;
		item = this.extractItemFromComlogObject(logObject.objLogData, this.COMLOG_ACTION_MODIFY);
		if(item){
			this.updateItemInComlogs(item, this.COMLOG_LIST_LOG);
		}
		logObject = null;
	},

	getAllAppButtons : function() {
		return this._arrAllButtons;
	},

	/*
	 * Function loadDetails loads anything that should be displayed on 2/3 container
	 * according to what is selected on the 1/3 list.
	 */
	loadDetails : function(id, item) {
		var objContact;
		var boolNoReload = false;
		if(!item){
			// If id is undefined (for instance, when there's no communication at all)
			//  Show an empty contact card
			if (id === undefined) {
				webapp.history.setStatus(this.STATUS_EMPTY);
				this.objCurrentContact = null;
				this._strContainerPath = "webapp.communication.getHistoryContactCard";
				this._strTitle = _("No communications","webapp.communication");

				if(webapp.history.mainWidget) {
					webapp.history.mainWidget.reloadCard({strTitle: this._strTitle});
					webapp.history.updateAppBar();
				}
				else {
					this.askForReloadContainer();
				}
				id = null;
				item = null;
				return; // exit
			}
			item = this.findItemById(id, this.getDisplayedComlogList());
			if(item === undefined){
				id = null;
				item = null;
				return; // exit
			}
		} else {
			boolNoReload = true;
			id = item.intIndex;
		}
		// save the item Id
		this.setCurrentEntry(id);
		webapp.history.setStatus(item.intStatus);
		if (item.objLogData && !webapp.communication.data.isSecondaryItem(item)) { // Old communication
			//send out an event to all external webapps to let them handle there buttons
			dojo.publish("handleHistoryExternalButtons", [item.objLogData.entryType]);

			switch (item.objLogData.entryType) {
				case ICTouchAPI.tools.enumComLogEntryType.Conference :
					webapp.history.setStatus(this.STATUS_LOG_CONFERENCE);
					this._intLogIdToSelect = item.objLogData.comLogEntryId;
					this._strContainerPath = "webapp.communication.getHistoryConference";
					this._strTitle = _("Conference", "webapp.communication");
					this.loadedConferenceDetails(item, boolNoReload);
					break;
				case ICTouchAPI.tools.enumComLogEntryType.CallLog :
				case ICTouchAPI.tools.enumComLogEntryType.CallBackRequest :
					this._strContainerPath = "webapp.communication.getHistoryContactCard";
					this._strTitle = "";

					this._intLogIdToSelect = item.objLogData.comLogEntryId;
					objContact = this.searchContactFromLog(item);
					this.loadedDetails(objContact, item, boolNoReload);

					break;
				default :
					objContact = this.searchContactFromLog(item);
					this.setCurrentContact(objContact, item);
					if(webapp.history.mainWidget) {
						webapp.history.updateAppBar();
						dojo.publish("ComlogExternalTypeClicked"+item.objLogData.entryType,[item, webapp.history.mainWidget.container, 0]);
					}
					break;
			}
		}
		else if(webapp.communication.data.isSecondaryItem(item)){
			this._strContainerPath = "webapp.communication.getHistoryContactCard";
			this._strTitle = "";

			this._intLogIdToSelect = item.objLogData.comLogEntryId;
			var pID = id.split("_");
			objContact = this.searchContactFromLog(item,pID[1]);
			this.loadedDetails(objContact, item, boolNoReload);
		}
		id=null;
		item=null;
	},

	searchContactFromLog: function(item, id){
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - searchContactFromLog");
		var phoneNumber, notCanonicalNumber, label;
		// To be sure we have a real Id for the listContactSummary
		if(id === undefined || id === null){
			id = 0;
		}
		// Get the correct phoneNumber and displayName to use.
		if(item.objLogData) {
			// Call log
			if (item.objLogData.listContactSummary && item.objLogData.listContactSummary[id]) { // use uppermost the name / FirstName of the ContactSummary
				if(item.objLogData.listContactSummary[id].name || item.objLogData.listContactSummary[id].firstName) {
					label = [item.objLogData.listContactSummary[id].name,item.objLogData.listContactSummary[id].firstName];
					ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / listContactSummary existing in comlogEntry, try to use name/firstName : label = " + label);
				}
				phoneNumber = (item.objLogData.listContactSummary[id].officePhone) ? item.objLogData.listContactSummary[id].officePhone : "";
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / listContactSummary existing in comlogEntry, use phoneNumber = " + phoneNumber);
			}
			if (!label) { // If there is no name / FirstName in the ContactSummary, use the display name
				if (item.objLogData.listDisplayName && item.objLogData.listDisplayName[id]) {
					label = item.objLogData.listDisplayName[id];
					ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / no name/firstName in listContactSummary but existing listDisplayName in comlogEntry : use label (listDisplayName[0]) = " + label);
				}
			}
		} else if(item.number) {
			// When we start a call with just number
			phoneNumber = item.number;
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / only phoneNumber provided (preload) = " + phoneNumber);
		}
		// Search in dataStore.
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / search in local contacts ussing Can fields");
		var objContact = (phoneNumber)?ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],phoneNumber)[0]:undefined;
		if (objContact) {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / local contact found"/* : " + ICTouchAPI.tools.getContactDisplayName(objContact)*/);
		}

		if(!objContact || (objContact && objContact.contactFromNumber)){
			// If the contact was not found, use the phonecall info
			if (notCanonicalNumber) {
				objContact = this.createContactFromNumber(label, notCanonicalNumber);
				objContact.phoneNumberCan = phoneNumber;
			}
			else {
				objContact = this.createContactFromNumber(label, phoneNumber);
			}
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / there is no local contact, use phoneCall/log info to create fake contact"/*: " + dojo.toJson(objContact)*/);
		}
		item=null;
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - searchContactFromLog $ return objContact: " + dojo.toJson(objContact));
		return objContact;
	},

	loadedDetails: function(objContact, item, boolNoReload) {
		ICTouchAPI.log("Start loadedDetails", "TELEPHONY");
		this.setCurrentContact(objContact, item);
		if(item!=null && item.strPrimaryContent!=null) {
			if(item.strPrimaryContent.isI18Ned){
				this._strTitle = ICTouchAPI.i18nServices.cloneI18n(item.strPrimaryContent);
			} else {
				this._strTitle = item.strPrimaryContent;
			}
		}
		else {
			this._strTitle = ICTouchAPI.tools.getContactDisplayName(objContact);
		}
		this._arrContactLog = [];
		// Then, load contact log
		if(item && item.objLogData){
			this.loadContactLog();
		}
		this.askForReloadContainer(boolNoReload);
		objContact=null;
		item=null;
		boolNoReload=null;
	},

	// Set the contact as the Current contact or create it from item it not defined. intIndex is the position of the contact if there is more than 1 contact (for conferences)
	setCurrentContact : function(objContact, item, intIndex) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - setCurrentContact");
		if(objContact == undefined){
			objContact = this.searchContactFromLog(item, intIndex);
		}
		this.objCurrentContact = objContact;
		objContact=null;
		item=null;
	},

	loadedConferenceDetails: function(item, boolNoReload) {
		// First refresh widgets with the information we have right now
		this.askForReloadContainer(boolNoReload);
		item=null;
		boolNoReload=null;
	},

	/**
	 * Refresh each entry in the comlog that matches the contactId
	 * @param {string} phoneNumber : the phoneNumber
	 * @param {string} contactId : the contactId
	 */
	refreshComlogByPhoneNumber : function(phoneNumber, contactId){
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - refreshComlogByPhoneNumber");
		// In logs
		var arrComlog = this.getComLog();
		for(var i in arrComlog){
			if((arrComlog[i].objLogData && arrComlog[i].objLogData.listContactSummary[0].officePhone == phoneNumber) || contactId === arrComlog[i].objLogData.contactId){
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - refreshComlogByPhoneNumber / compare phoneNumber with listContactSummary[0].officePhone = " + arrComlog[i].objLogData.listContactSummary[0].officePhone);
				this.refreshEntryById(arrComlog[i].intIndex);
			}
		}
		phoneNumber=null;
		contactId=null;
	},

	createContactFromNumber: function(label, phoneNumber) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - createContactFromNumber");
		if (!label || label === ""){
			label = phoneNumber;
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - createContactFromNumber / no label defined, use phoneNumber for label: " + label);
		}
		var objContact;
		var name;
		var firstName;
		if (typeof label === "object" && label[0] !== undefined && label[1] !== undefined) { // label can be an array with [LastName, FirstName]
			name = label[0];
			firstName = label[1];
		}
		else {
			name = label;
			firstName = "";
		}
		objContact = {
			contactId: -1,
			name: name,
			firstName: firstName,
			officePhone: phoneNumber,
			officePhoneCan: phoneNumber,
			contactFromNumber: true
		};
		label=null;
		phoneNumber=null;
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - createContactFromNumber done $ return objContact: " + dojo.toJson(objContact));
		return objContact;
	},

	extractPhoneNumber : function(objContact) {
		var numbers = [];
		if (objContact.officePhone) {
			numbers.push(objContact.officePhone);
		}
		if (objContact.personalHome) {
			numbers.push(objContact.personalHome);
		}
		if (objContact.personalMobile) {
			numbers.push(objContact.personalMobile);
		}

		objContact=null;
		return numbers;
	},

	loadContactLog : function() {
		ICTouchAPI.log("Start loadContactLog", "TELEPHONY");
		var entry = this.getSelectedEntry();
		if(entry){
			ICTouchAPI.APIServices.Comlog.findEntriesByContactNb({
				params: [entry.objLogData.contactId, this.FILTER_ALL, this.COMLOG_FILTER_ALL_BUSINESS_ID, 5, 0],
				context: this,
				callback: this.loadedContactLog,
				callbackParams: entry.objLogData.contactId
			});
		}
		ICTouchAPI.log("End loadContactLog", "TELEPHONY");
	},

	loadedContactLog : function(_arr, contactId) {
		ICTouchAPI.log("Start loadedContactLog", "TELEPHONY");
		var entry = this.getSelectedEntry();

		if (_arr && entry && contactId === entry.objLogData.contactId) {
			// How many contact log entries should be shown in a contact card: 5
			this._arrContactLog = this.buildContactLogList(_arr, 5);
			this.askForReloadContainer();
		}
		ICTouchAPI.log("End loadedContactLog", "TELEPHONY");
		_arr=null;
		contactId=null;
	},

	buildContactLogList : function(arrLogs, maxLogs, strSize) {
		var result = [];
		for (var i in arrLogs) {
			var objDateTime = arrLogs[i].dateTime.datetime;
			var date = new Date(objDateTime.year, objDateTime.month-1, objDateTime.day);

			var strDate = ICTouchAPI.tools.getFormatedDate(date, ICTouchAPI.tools.getDateFormat());
			var strTime = ICTouchAPI.tools.getFormatedTime(objDateTime.hour, objDateTime.minute, ICTouchAPI.tools.getBoolTimeFormat());
			strDate += " - " + strTime;
			// gets and object for icon from the function
			var objTmp = ICTouchAPI.tools.getLogDataFromStatus(arrLogs[i],strSize);
			var strIcon = objTmp.strIcon;

			result.push({
				strId: result.length,
				strLabel: (i == 0) ? _("History", "webapp.communication") : "",
				strContent: strDate,
				additionalStyle: "contactlog",
				strIcon: strIcon
			});
			if (result.length >= maxLogs) {
				break;
			}
		}
		arrLogs=null;
		maxLogs=null;
		return result;
	},

	askForReloadContainer:function(boolNoReload) {
		if(!boolNoReload){
			this.doReloadContainer();
		}
		boolNoReload=null;
	},

	doReloadContainer:function() {
		if (webapp.history.mainWidget){
			webapp.history.mainWidget.reloadContainer();
			if (webapp.history.getSelectStatus() !== -1) { // if we are in a selection mode, toggleOpacity
				webapp.history.toggleOpacityTwoThird(true);
			}
		}
	},

	getContactInfoList:function(contact) {
		var objLabelIcon = this.getStrCurrentCommStatusIcon();
		return ICTouchAPI.tools.getContactPresentationList(
			contact,
			webapp.history,
			webapp.history.onPresentationListClick,
			"webapp.communication",
			objLabelIcon ? objLabelIcon : "",
			true
			);
	},

	getContactInfoListWithContactLog:function(contact) {
		var _arrItems = this.getContactInfoList(contact).concat(this.getContactLog());
		contact = null;
		return _arrItems;
	},

	// @TODO
	refreshCommunicationListTitle : function() {
		var strTitle = this.getCommunicationListTitle();
		if(webapp.history.mainWidget && webapp.history.mainWidget.menu) {
			webapp.history.mainWidget.menu.reload({
				objTitle: {
					strLabel : strTitle
				}
			});
		}
	},

	refreshMenuCounter : function(intComlogList) {
		if(webapp.history.mainWidget){
			webapp.history.mainWidget.menu.getTitle().setStrLabelBottom("(" + this.getNbItems(intComlogList) + ")",intComlogList);
		}
	},

	getCommunicationListTitle : function() {
		return [{
			strIcon: "tabs-new-32",
			strLabel : _("New", "ICTouchAPI"),
			strLabelBottom: '(' + this.getNbItems(this.COMLOG_LIST_MISSED) + ')',
			intIndex : this.COMLOG_LIST_MISSED
		},{
			strIcon: "communication-tabs-history-all-32",
			strLabel : _("HistoryShortTtl", "webapp.communication"),
			strLabelBottom: '(' + this.getNbItems(this.COMLOG_LIST_LOG) + ')',
			intIndex : this.COMLOG_LIST_LOG
		}]
	},

	getContainerTitle : function() {
		if (this._strTitle !== ""){
			return this._strTitle;
		}
		else{
			return _("HistoryShortTtl", "webapp.communication");
		}
	},

	getContainerPath : function(){
		return this._strContainerPath;
	},

	setContainerPath : function(path){
		this._strContainerPath = path;
		path=null;
	},

	getComLog : function() {
		return this.objComlog ? this.objComlog.arrItems : [];
	},

	getSelectedEntryId : function() {
		return this._intCurrentEntry;
	},

	getSelectedEntry : function() {
		var entry;
		entry = this.findItemById(this._intCurrentEntry, this.COMLOG_LIST_LOG);
		return entry;
	},

	getSelectedEntryCallStateLabel : function(){
		var selectedEntry = this.getSelectedEntry();
		var strLabel;
		var strName;
		if (selectedEntry) {
			strLabel = [];
			// Log of filtered calls
			if(selectedEntry.objLogData.peerId){
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["loginName"],selectedEntry.objLogData.peerId)[0];
				if(objContact){
					if(this.getUserRole() == this.MANAGER_ROLE){
						strLabel.push("Received call by");
					} else {
						if(selectedEntry.objLogData.fromBossSecretary){
							strLabel.push("Received call for");
						} else {
							strLabel.push("Monitored call for");
						}
					}
					strName = ICTouchAPI.tools.getContactDisplayName(objContact);
					strLabel.push(strName);
				}
			} else {
				strName = ICTouchAPI.tools.getContactDisplayName(selectedEntry.objLogData.thirdParty);
				
				// Display as supervision only if there is a name to display in thirdParty.
				if(strName){
					if(selectedEntry.objLogData.startReason == this.lstReason.PICKUP){
						strLabel.push("Intercepted call for");
					} else if(selectedEntry.objLogData.endReason == this.lstReason.PICKUP){
						strLabel.push("Intercepted call by");
					}
					strLabel.push(strName);
				}
			}
		} else {
			strLabel = "";
		}
		return strLabel;
	},

	getCurrentContact : function(){
		return this.objCurrentContact;
	},

	getComLogEntryTypesForDisplay : function(){
		var arrItemsFilters = [];
		// create filter array for the selectList
		for (var i=0; i< this._arrComLogEntryTypes.length; i++) {
			arrItemsFilters.push({
				intIndex: i,
				boolSelected: this._arrComLogEntryTypes[i].enabled,

				strSecondaryContentIcon : this._arrComLogEntryTypes[i].strSecondaryContentIcon,
				strLabel: this._arrComLogEntryTypes[i].label
			});
		}
		return arrItemsFilters;
	},

	getComLogEntryTypes : function() {
		return this._arrComLogEntryTypes;
	},

	// Reset the flag "enable" from _arrComLogEntryTypes to select only the one with given businessId
	resetComLogEntryTypes : function(businessId) {
		var j;
		var enabled;
		// For every EntryTypes to delete
		for (var i=0; i< this._arrComLogEntryTypes.length; i++) {
			enabled = false;
			//Check if filter all was selected
			if(businessId == this.COMLOG_FILTER_ALL_BUSINESS_ID){
				enabled = true;
			} else {
				for(j=0; j<this._arrComLogEntryTypes[i].businessIds.length; j++){
					if(this._arrComLogEntryTypes[i].businessIds[j] == businessId){
						enabled = true;
					}
				}
			}
			this._arrComLogEntryTypes[i].enabled = enabled;
		}
	},

	getContactLog : function() {
		return this._arrContactLog;
	},
	
	getCurrentEntry : function() {
		if(this.isListDisplayed(this.COMLOG_LIST_LOG)){
			return this._intCurrentEntry;
		} else if (this.isListDisplayed(this.COMLOG_LIST_MISSED)){
			return this._intCurrentMissedEntry;
		}

		return null;
	},

	setCurrentEntry : function(id) {
		if(this.isListDisplayed(this.COMLOG_LIST_LOG)){
			this._intCurrentEntry = id;
		} else if (this.isListDisplayed(this.COMLOG_LIST_MISSED)){
			this._intCurrentMissedEntry = id;
		}
		this._intCurrentEntry = id;
		id=null;
	},

	//Get number of items in selected comlog
	getNbItems : function(intLog) {
		if(intLog===this.COMLOG_LIST_LOG){
			return this.objComlog ? this.objComlog.getNbItems() : 0;
		} else if (intLog===this.COMLOG_LIST_MISSED){
			return this.objMissedComlog ? this.objMissedComlog.getNbItems() : 0;
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - getNbItems / Missing or wrong intLog parameter");
		}
		return 0;
	},

	getNbPreviewItems : function() {
		return this.objComlogPreview ? this.objComlogPreview.getNbItems() : 0;
	},

	setUnreadState : function(intState) {
		this.intReadFilter = intState;
		intState=null;
	},

	setHotelMode : function() {
		this.boolHotelMode = true;
		this.refreshEntryById(this.getCurrentEntry());
	},

	getHotelMode : function() {
		return this.boolHotelMode;
	},

	isVMEntry : function(comlogData) {
		var logType = ICTouchAPI.tools.getLogDataFromStatus(comlogData,"24");
		comlogData=null;
		return logType.strNotif && logType.strNotif === "Voicemail";
	},

	buildComlogItem : function(logObject) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - buildComlogItem");
		// built the start time to be displayed in comlog
		var objDate = new Date(logObject.dateTime.datetime.year, logObject.dateTime.datetime.month - 1, logObject.dateTime.datetime.day, logObject.dateTime.datetime.hour, logObject.dateTime.datetime.minute, logObject.dateTime.datetime.second || 0);
		var strTime = this.getFormatedDateForComlog(objDate);

		var objLog = {
			strPrimaryIcon: "",
			strPrimaryContent: "",
			strSecondaryContent: strTime,
			objLogData: logObject,
			intStatus: this.STATUS_LOG,
			alternateStyle: true,
			intIndex: logObject.comLogEntryId,
			strSecondaryContentStyle: "normal"
		};

		// Simplify manipulation by removing the .value in objLogData.
		if(logObject.thirdParty && logObject.thirdParty.value){
			logObject.thirdParty = logObject.thirdParty.value;
		}
		if(logObject.startReason && logObject.startReason.value && logObject.startReason.value.value){
			logObject.startReason = logObject.startReason.value.value;
		}
		if(logObject.endReason && logObject.endReason.value && logObject.endReason.value.value){
			logObject.endReason = logObject.endReason.value.value;
		}

		var objContact = this.searchContactFromLog(objLog);
		if(objContact.contactId){
			objLog.contactId = objContact.contactId;
		}

		objLog.strPicture = (objContact.photo) ? objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");

		var logType = ICTouchAPI.tools.getLogDataFromStatus(logObject,"24");
		objLog.strPrimaryIcon = logType.strIcon;

		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - buildComlogItem / extract 1/3 data from objContact got using searchContactFromLog");
		if(objContact.name || objContact.firstName){
			objLog.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objContact);
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - buildComlogItem / name / firstName available in objContact, use it: " + objLog.strPrimaryContent);
		}
		else if (logObject.listContactSummary && logObject.listContactSummary[0]) { // use uppermost the name / FirstName of the ContactSummary
			objLog.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(logObject.listContactSummary[0]);
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - buildComlogItem / no objContact but listContactSummary existing in comlogEntry, try to use name/firstName : label = " + objLog.strPrimaryContent);
		}
		else if (logObject.listDisplayName && logObject.listDisplayName[0]) {
				objLog.strPrimaryContent = logObject.listDisplayName[0];
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - buildComlogItem / no objContact and no name/firstName in listContactSummary but existing listDisplayName in comlogEntry : use label = " + objLog.strPrimaryContent);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - buildComlogItem / objLogData.listContactSummary[0] and no listDisplayName existing in comlogEntry -> nothing to display");
			objLog.strPrimaryContent = logObject.listContactSummary[0].officePhone;
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - buildComlogItem / objLogData.listContactSummary[0] and no listDisplayName existing in comlogEntry -> display office phonel");
		}

		if (objLog.strPrimaryContent && (objLog.strPrimaryContent.replace(/\s/g,'')==="anonymous" || objLog.strPrimaryContent.replace(/\s/g,'')==="***")) {   
			objLog.strPrimaryContent=_("anonymous","ICTouchAPI");
		}

		if (logObject.entryType === ICTouchAPI.tools.enumComLogEntryType.Conference) {
			objLog.strPrimaryContent = _("Conference", "webapp.communication");
			objLog.strPicture = ICTouchAPI.tools.getDefaultPhotoPath("conference", "50");
			objLog.arrSecondaryItems = this.buildSecondaryLogItems(logObject);
			// only contactId of secondaryItems are relevant.
			objLog.contactId = null;
		}


		// PeedId means it is a log of M/A or supervision.
		// Check it it is a M/A login, to determine wether it is a log of MA or Supervision
		if(logObject.peerId){
			var objMAContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["loginName"],logObject.peerId)[0];
			if(objMAContact){
				if(objMAContact.photo){
					// For the Menu list
					//objLog.strPicture = objMAContact.photo;
					// For the contact card
					objLog.assistantPhoto = objMAContact.photo;
				}

				// Replace the time by the manager / assistant name in second line of the menuList
				objLog.strSecondaryContent = this.getFilteredLogSecondaryContent(objMAContact);
				objLog.arrSecondaryIcon = (logObject.isRead)?[{icon : "arrow-callee-history-read-26", width : 26}]:[{icon : "arrow-callee-history-unread-26", width : 26}];;
				objLog.strSecondaryContentStyle = "italic";
			}
		} else {
			var strSecondaryName = ICTouchAPI.tools.getContactDisplayName(logObject.thirdParty);

			// Display as supervision only if there is a name to display in thirdParty.
			if(strSecondaryName){
				objLog.strSecondaryContent = strSecondaryName;
				objLog.arrSecondaryIcon = (logObject.isRead)?[{icon : "arrow-callee-history-read-26", width : 26}]:[{icon : "arrow-callee-history-unread-26", width : 26}];;
				objLog.strSecondaryContentStyle = "italic";
			} else {
				objLog.strSecondaryContentStyle = "normal";
			}
		}

		// Entry not read
		if (logObject.isRead !== true && logObject.isRead !== 1) {
			objLog.alternateStyle = false;
		}

		// Contact picture may be disabled by setting, so we delete it.
		if(!this.boolEnablePhotoInComlog){
			objLog.strPicture = null;
		}
		logObject=null;
		return objLog;
	},
	
	buildSecondaryLogItems : function(logObject) {
		var secondaryItemsArray = [];
		
		var arrParticipants = logObject.listContactSummary;
		for (var i = 0 ; i < arrParticipants.length ; i++){
			var item = {
				intIndex: logObject.comLogEntryId+"_"+i,
				intStatus: this.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED,
				objParticipant: arrParticipants[i],
				objLogData: logObject,
				alternateStyle: (logObject.isRead)? true : false
			};
			var objContact = this.searchContactFromLog(item,i);
			var contactName = ICTouchAPI.tools.getContactDisplayName(objContact);
			if(objContact.contactId){
				item.contactId = objContact.contactId;
			}
			item.strPrimaryContent = (contactName && contactName !="") ? contactName : ICTouchAPI.tools.getContactDisplayName(item);
                        if (item.strPrimaryContent.replace(/\s/g,'')==="anonymous" || item.strPrimaryContent.replace(/\s/g,'')==="***") {   
				item.strPrimaryContent=_("anonymous","ICTouchAPI");
                        }
			secondaryItemsArray.push(item);
		}
		
		return secondaryItemsArray;
	},
	
	/**
	 * return a string with the arrow icon + the name corresponding to the manager / assistant
	 * @params objContact {object} the manager/assistant contact object
	 */
	getFilteredLogSecondaryContent : function(objContact) {
		var strName = ICTouchAPI.tools.getContactDisplayName(objContact);
		objContact = null;
		return strName;
	},

	setUserRole : function(strRole) {
		this._userRole = strRole;
		strRole = null;
	},

	getUserRole : function() {
		return this._userRole;
	},

	setStrCurrentCommStatusIcon : function(strCurrentCommStatusIcon) {
		this.strCurrentCommStatusIcon = strCurrentCommStatusIcon;
		strCurrentCommStatusIcon = null;
	},

	getStrCurrentCommStatusIcon : function() {
		return this.strCurrentCommStatusIcon;
	},

	setStrCurrentCommStatusLabelOk : function(strCurrentCommStatusLabelOk) {
		this.strCurrentCommStatusLabelOk = strCurrentCommStatusLabelOk;
		strCurrentCommStatusLabelOk = null;
	},

	getStrCurrentCommStatusLabelOk : function() {
		return this.strCurrentCommStatusLabelOk;
	},

	setStrCurrentCommStatusLabelCancel : function(strCurrentCommStatusLabelCancel) {
		this.strCurrentCommStatusLabelCancel = strCurrentCommStatusLabelCancel;
		strCurrentCommStatusLabelCancel = null;
	},

	getStrCurrentCommStatusLabelCancel : function() {
		return this.strCurrentCommStatusLabelCancel;
	},
	
	//Find item by id in selected comlog
	findItemById : function(id, intLog) {
		var entry = undefined;
		var objList = this.getComlogListById(intLog);
		if(objList){
			entry = objList.getItemByIntIndex(id);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - findItemById / Missing or wrong intLog parameter");
		}
		id=null;
		return entry;
	},

	//Find item by position in selected comlog
	findItemByPosition : function(intPosition, intLog){
		var entry = undefined;
		var objList = this.getComlogListById(intLog);
		if(objList){
			entry = objList.getItemByPosition(intPosition);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - findItemByPosition / Missing or wrong intLog parameter");
		}
		intPosition=null;
		intLog=null;
		return entry;
	},

	getFormatedDateForComlog : function(startDate){
		// start time
		var today = new Date();
		var strTime = ICTouchAPI.tools.getFormatedTime(startDate.getHours(), startDate.getMinutes(), this._24hformat);
		if (startDate.getDate() !== today.getDate() || startDate.getMonth() !== today.getMonth() || startDate.getFullYear() !== today.getFullYear()) {
			// not today we print the date
			strTime = ICTouchAPI.tools.getFormatedDate(startDate, "dd/mm ") + strTime;
		}
		startDate = null;
		return strTime;
	},

	selectTitleById : function(titleId) {
		if(webapp.history.mainWidget){
			webapp.history.mainWidget.menu.getTitle().selectTitleById(titleId);
		}
	},

	//Select item by id in selected comlog
	selectComlogByIndex : function(id, boolSelect, intLog){
		var objList = this.getComlogListById(intLog);
		if(objList){
			objList.selectItemByIndex(id, boolSelect);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - selectComlogByIndex / Missing or wrong intLog parameter");
		}
		id=null;
		boolSelect=null;
	},

	//Insert items in selected comlog
	insertItemsInComlogs : function(intPosition, arrItems, intLog){
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog){
				this.objComlog.insertItems(intPosition, dojo.clone(arrItems));
			}
			if(this.objComlogPreview){
				this.objComlogPreview.insertItems(intPosition, dojo.clone(arrItems));
			}
		}
		else if (intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.insertItems(intPosition, dojo.clone(arrItems));
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - insertItemsInComlogs / Missing or wrong intLog parameter");
		}

		this.refreshMenuCounter(intLog);
		intPosition=null;
		arrItems=null;
	},

	unshiftItemInComlogs : function(objLog, intLog){
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog){
				this.objComlog.unshiftItem(dojo.clone(objLog), true);
			}
			if(this.objComlogPreview){
				this.objComlogPreview.unshiftItem(dojo.clone(objLog), true);
			}
		}
		else if (intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.unshiftItem(dojo.clone(objLog), true);
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - unshiftItemInComlogs / Missing or wrong intLog parameter");
		}

		this.refreshMenuCounter(intLog);
		objLog=null;
	},

	sliceItemsInComlogs : function(intStart, intNb, intLog) {
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog){
				this.objComlog.sliceItems(intStart, intNb);
			}
			if(this.objComlogPreview){
				this.objComlogPreview.sliceItems(intStart, intNb);
			}
		}
		else if (intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.sliceItems(intStart, intNb);
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - sliceItemsInComlogs / Missing or wrong intLog parameter");
		}

		this.refreshMenuCounter(intLog);
		intStart=null;
		intNb=null;
	},

	emptyItemsInComlogs : function(intLog) {
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog) {
				this.objComlog.emptyItems();
			}
			if(this.objComlogPreview){
				this.objComlogPreview.emptyItems();
			}
		}
		else if (intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.emptyItems();
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - emptyItemsInComlogs / Missing or wrong intLog parameter");
		}

		this.refreshMenuCounter(intLog);
		intLog = null;
	},

	unshiftItemsInComlogs : function(arrLogs, intLog){
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog){
				this.objComlog.unshiftItems(dojo.clone(arrLogs), true);
			}
			if(this.objComlogPreview){
				this.objComlogPreview.unshiftItems(dojo.clone(arrLogs), true);
			}
		}
		else if (intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.unshiftItems(dojo.clone(arrLogs), true);
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - unshiftItemsInComlogs / Missing or wrong intLog parameter");
		}

		this.refreshMenuCounter(intLog);
		arrLogs=null;
	},

	//Update items Comlog in all comlog
	updateItemInComlogs : function(objLog, intLog){
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog) {
				this.objComlog.updateItem(dojo.clone(objLog));
				if(this.objComlogPreview){
					this.objComlogPreview.updateItem(dojo.clone(objLog));
				}
			}
		} else if(intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.updateItem(dojo.clone(objLog));
			}
		}
		objLog=null;
	},

	//Remove item by id in selected comlog
	removeItemById : function(id, boolDoNotSelectNext, intLog){
		var removedItem = null;
		if(intLog===this.COMLOG_LIST_LOG) {
			if(this.objComlog){
				removedItem = this.objComlog.removeItemByIntIndex(id, boolDoNotSelectNext);
			}
			if(this.objComlogPreview){
				removedItem = this.objComlogPreview.removeItemByIntIndex(id, false);
			}
		}
		else if (intLog===this.COMLOG_LIST_MISSED){
			if(this.objMissedComlog){
				this.objMissedComlog.removeItemByIntIndex(id, boolDoNotSelectNext);
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - removeItemById / Missing or wrong intLog parameter");
		}

		this.refreshMenuCounter(intLog);
		id=null;
		boolDoNotSelectNext=null;
		return removedItem;
	},

	showItemById : function(itemId, strHideType, boolOnComlogOnly, intLog) {
		if(this._objHiddenComlogItems[itemId] == strHideType) {
			delete(this._objHiddenComlogItems[itemId]);
			if(intLog===this.COMLOG_LIST_LOG) {
				if(this.objComlog){
					this.objComlog.showItemByIntIndex(itemId);
				}
				if(!boolOnComlogOnly && this.objComlogPreview){
					this.objComlogPreview.showItemByIntIndex(itemId);
				}
			}
			else if (intLog===this.COMLOG_LIST_MISSED){
				if(this.objMissedComlog){
					this.objMissedComlog.showItemByIntIndex(itemId);
				}
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.communication.dataBase - showItemById / Missing or wrong intLog parameter");
			}
		}
		itemId=null;
	},

	hideItemById : function(itemId, strHideType, boolOnComlogOnly, intLog) {
		if(!this._objHiddenComlogItems[itemId]) {
			this._objHiddenComlogItems[itemId] = strHideType;
			if(intLog===this.COMLOG_LIST_LOG) {
				if(this.objComlog){
					this.objComlog.hideItemByIntIndex(itemId);
				}
					if(!boolOnComlogOnly && this.objComlogPreview){
					this.objComlogPreview.hideItemByIntIndex(itemId);
				}
			}
			else if (intLog===this.COMLOG_LIST_MISSED){
				if(this.objMissedComlog){
					this.objMissedComlog.hideItemByIntIndex(itemId);
				}
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.communication.dataBase - hideItemById / Missing or wrong intLog parameter");
			}
		}
		itemId=null;
	},

	findFirstSelectableItem : function(intLogList) {
		var position;
		var list = this.getMenuListByListType(intLogList);
		if (list) {
			for (var i=0; i<list.getNbItems(); i++) {
				if (!list.getItemByPosition(i).boolToHide) {
					position = i;
					break;
				}
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - findFirstSelectableItem / list is not defined");
		}
		intLogList = null;
		return position;
	},

	loadFirstSelectableItem : function(intLogList) {
		var itemId = this.findFirstSelectableItem(intLogList);
		var item = this.findItemByPosition(itemId, intLogList)
		if(item){
			this.selectComlogByIndex(item.intIndex, false, intLogList);
			this.loadDetails(item.intIndex);
		} else {
			this.loadDetails();
		}
	},

	getMenuListByListType : function(intLogList) {
		var list;
		if(intLogList===this.COMLOG_LIST_LOG) {
			list = this.objComlog;
		}
		else if (intLogList===this.COMLOG_LIST_MISSED){
			list = this.objMissedComlog;
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - getMenuListItemByListType / Missing or wrong intLogList parameter");
		}
		intLogList = null;
		return list;
	},

	addInLog : function(phoneCall) {
		if(!this.isVMEntry(phoneCall)){
			var objCall = null;
			// build the item according to the type (call, log, notification) and insert in lists
			objCall = this.extractItemFromComlogObject(phoneCall, this.COMLOG_ACTION_ADD);

			this.loadAll(objCall, this.COMLOG_ACTION_ADD);
		}
		phoneCall=null;
	},

	removeFromLog : function(callId, boolDoNotSelectNext) {
		var log = this.findItemById(callId,this.COMLOG_LIST_LOG);
		var boolIsRemoved = false;
		// Remove it from lists
		if (log && this.removeItemById(callId, !this.isListDisplayed(this.COMLOG_LIST_LOG) || boolDoNotSelectNext, this.COMLOG_LIST_LOG)) {
			if(this.findItemById(callId,this.COMLOG_LIST_MISSED)){
				this.removeItemById(callId, !this.isListDisplayed(this.COMLOG_LIST_MISSED) || boolDoNotSelectNext, this.COMLOG_LIST_MISSED);
			}
			// If there is no more item, refresh with blank page
			if(this.getNbItems(this.getDisplayedComlogList()) === 0) {
					this.loadDetails(undefined);
			}
			boolIsRemoved = true;
		}
		callId=null;
		boolDoNotSelectNext=null;
		return boolIsRemoved;
	},

	/**
	 * Modify an entry in the Comlog
	 * @param objLog : the phoneCall / log / NotificationContext object to modify
	 */
	modifyInLog : function(objLog) {
		var objCall = null;
		var boolFound = false;

		if(!this.isVMEntry(objLog)){
			// build the item according to the type (call, log, notification)
			objCall = this.extractItemFromComlogObject(objLog, this.COMLOG_ACTION_MODIFY);
			if(objCall){
				this.loadAll(objCall, this.COMLOG_ACTION_MODIFY);
				boolFound = true;
			}

			objLog=null;
		}
		return boolFound;
	},

	/**
	 * Extract a valid item from an object from Comlog or Telephony application.
	 * @param {object} objLog : the phoneCall / log / NotificationContext object to modify
	 * @param {number} intAction : static variable meaning "add", "modify" or "remove"
	 * @return the valid item or null
	 */
	extractItemFromComlogObject : function(objLog, intAction) {
		var item = null;
		if(intAction != this.COMLOG_ACTION_MODIFY || this.findItemById(objLog.comLogEntryId, this.COMLOG_LIST_LOG)){
			item = this.buildComlogItem(objLog);
		}
		objLog = null;
		intAction = null;
		return item;
	},

	refreshPreview : function()
	{
		if(this.previewContainer && this.previewContainer !== null && typeof(this.previewContainer.refresh) === 'function'){
			var nbItems = this.data.getNbPreviewItems();
			var objLog = null;
			for(var i=0; i<nbItems;i++){
				if(this.objComlogPreview.getItemByPosition(i).objLogData){
					objLog = this.buildComlogItem(this.objComlogPreview.getItemByPosition(i).objLogData);
				}
				this.updateItemInComlogs(objLog, this.COMLOG_LIST_LOG);
			}
		}
	},

	loadAll : function(objLog, action) {
		if(action == this.COMLOG_ACTION_ADD){
			// Insert the entry.
			if(!objLog.objLogData.isRead){
				this.unshiftItemInComlogs(objLog, this.COMLOG_LIST_MISSED);
			}
			this.unshiftItemInComlogs(objLog, this.COMLOG_LIST_LOG);
		} else if (action == this.COMLOG_ACTION_MODIFY) {
			// Update the entry
			if(!objLog.objLogData.isRead){
				this.updateItemInComlogs(objLog, this.COMLOG_LIST_MISSED);
			} else {
				if(this.findItemById(objLog.intIndex, this.COMLOG_LIST_MISSED)){
					if(this.isListDisplayed(this.COMLOG_LIST_MISSED)){
						this.updateItemInComlogs(objLog, this.COMLOG_LIST_MISSED);
					} else {
						this.removeItemById(objLog.intIndex, true, this.COMLOG_LIST_MISSED)
					}
				}
			}
			this.updateItemInComlogs(objLog, this.COMLOG_LIST_LOG);
		}

		var boolLoadDetails = true;
		// Modify a log
		if(action == this.COMLOG_ACTION_MODIFY && (this.getCurrentEntry() !== objLog.intIndex)){
			boolLoadDetails = false;
		}

		// Select if it is a call we add, or if we modify a log currently selected.
		if (boolLoadDetails) {
			this.loadDetails(null,objLog);
			this.selectComlogByIndex(objLog.intIndex, false, this.getDisplayedComlogList());
			if(webapp.history.mainWidget){
				webapp.history.mainWidget.reloadContainer();
			}
		}
	},

	//return all details needed to build a contact card (2/3) from the current contact.
	getContactCardParams : function() {
		var objContact = this.getCurrentContact();
		var selectedEntry = this.getSelectedEntry();

		var objContactCard = {};

		//Title
		objContactCard.strTitle = this._strTitle;

		// Call state label
		objContactCard.strCallingStatusLabel = this.getSelectedEntryCallStateLabel();

		if (objContact) {

			objContactCard.objContact = objContact;

			//photo
			objContactCard.strContactPhotoPath = objContact.photo || "";

			// Business details
			objContactCard.strContactCompany = (objContact.miscMap && objContact.miscMap.company) ? objContact.miscMap.company : "";
			objContactCard.strContactPosition = (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "";
			objContactCard.strContactLocation = (objContact.miscMap && objContact.miscMap.city) ? objContact.miscMap.city : "";

			//Contact details
			objContactCard.arrDetails = this.getContactInfoListWithContactLog(objContact);

			if((webapp.communication.getSelectStatus() == -1) && selectedEntry.objLogData && selectedEntry.objLogData.listContactSummary[0] && selectedEntry.objLogData.listContactSummary[0].officePhone) {
			    var pID = 0;
				if(webapp.communication.data.isSecondaryItem(selectedEntry)){
					pID = selectedEntry.intIndex.split("_")[1];
				}
				
				var number = selectedEntry.objLogData.listContactSummary[pID].officePhone;
			    for(var i in objContactCard.arrDetails) {
					if(!objContactCard.arrDetails[i].strContent.isI18Ned && objContactCard.arrDetails[i].strContent.replace(/\s/g,'') == number) {
						objContactCard.arrDetails[i].strIcon = "communication-call-me-back";
					}
			    }
			}
		}

		//Add assistant photo
		if (selectedEntry) {
			objContactCard.strAssistantPhotoPath = selectedEntry.assistantPhoto;
		}

		return objContactCard;
	},

	//return all details needed to build a conference card (2/3) from the current contact.
	getConferenceCardParams : function() {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - getConferenceCardParams");
		//var objContact = this.getCurrentContact();
		var selectedEntry = this.getSelectedEntry();

		// Init variables
		var objCard = {};
		objCard.arrContacts = [];
		var participant;
		var arrContactSummary;
		var i;

		//Title
		objCard.strTitle = this._strTitle;

		// Case of a log object
		if(selectedEntry.objLogData){
			arrContactSummary = selectedEntry.objLogData.listContactSummary;
			for(i = 0 ; i < arrContactSummary.length ; i++){
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - getConferenceCardParams / use searchContactFromLog to search contact for conference participant " + i + ", use listContactSummary["+i+"].officePhone = " + arrContactSummary[i].officePhone);
				participant = this.getConferenceCardParticipant(this.searchContactFromLog({number:arrContactSummary[i].officePhone}));
				if(participant.strLastName == arrContactSummary[i].officePhone) { // no display name found by searchContactFromLog (contact not in datastore), use info from log
					ICTouchAPI.debugServices.debug("webapp.communication.dataBase - getConferenceCardParams / no display name found by searchContactFromLog, try to use conference participant ["+i+"]");
					if(arrContactSummary[i].name || arrContactSummary[i].firstName) {
						participant.strFirstName = arrContactSummary[i].firstName;
						participant.strLastName = arrContactSummary[i].name;
						ICTouchAPI.debugServices.debug("webapp.communication.dataBase - getConferenceCardParams / no display name found by searchContactFromLog, but arrContactSummary["+i+"] has firstName / name, use it: " + participant.strFirstName + " " + participant.strLastName);
					}
					else if (selectedEntry.objLogData.listDisplayName[i]){
						ICTouchAPI.debugServices.debug("webapp.communication.dataBase - getConferenceCardParams / no display name found by searchContactFromLog and no arrContactSummary name, but listDisplayName["+i+"] exists, use it: " + selectedEntry.objLogData.listDisplayName[i]);
						participant.strLastName = selectedEntry.objLogData.listDisplayName[i];
					}
					else {
						ICTouchAPI.debugServices.debug("webapp.communication.dataBase - getConferenceCardParams / no display name found for conference participant " + i + " and no listDisplayName["+i+"] exists, use listContactSummary["+i+"].officePhone: " + arrContactSummary[i].officePhone);
						participant.strLastName = arrContactSummary[i].officePhone;
					}
				}
                                if (participant.strLastName.replace(/\s/g,'')==="anonymous" || participant.strLastName.replace(/\s/g,'')==="***") {   
                                        participant.strLastName=_("anonymous","ICTouchAPI");
                                }
				objCard.arrContacts.push(participant);
			}
		}
	
		return objCard;
	},

	// return all details needed to build a conference card from several numbers.
	buildCurrentConferenceCard : function(arrNumbers) {
		var objCard = {};
		objCard.arrContacts = [];
		var participant;
		for(var i = 0 ; i < arrNumbers.length ; i++){
			participant = this.getConferenceCardParticipant(this.searchContactFromLog({number:arrNumbers[i]}));
			if(!participant.strFirstName && !participant.strLastName){
				participant.strFirstName = arrNumbers[i];
			}
			objCard.arrContacts.push(participant);
		}
		objCard.strTitle = _("Conference", "webapp.communication");
		objCard.strPath = "webapp.communication.getHistoryConference";
		objCard.strCallDuration = "00:00";
		return objCard;
	},

	getConferenceCardParticipant : function(objContact) {
		var participant = {
			strFirstName : objContact.firstName || "",
			strLastName : objContact.name || "",
			strJob : (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "",
			strPhotoPath : objContact.photo || ""
		};

		objContact = null;
		return participant;
	},

	isInConference : function(objLog){
		var status = webapp.history.getStatus();
		if(objLog) {
			status = objLog.intStatus;
		}
		return (status == this.STATUS_LOG_CONFERENCE || status == this.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED || status == this.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED);
	},

	/*
	 * setShownLogs: this function is called when it was asked to open a transfer /to/ transfer to.
	 */
	setShownLogs : function () {
		// Set selectable items for 3rd peer: phone call items whose phone number are not the same as 2nd peer.
		var func = function(item){
			this._setShownLog(item)
		};
		this.objComlog.arrItems.forEach(func, this);
	},

	_setShownLog : function(item){
		if (!this._objFirstSelected  || (this._objFirstSelected && item.objLogData.listContactSummary && item.objLogData.listContactSummary[0] && item.objLogData.listContactSummary[0].officePhone != this._objFirstSelected.objCallData.phoneNumber)) {
			item.boolSelectable = true;
			item.boolToHide = false;
		} else {
			item.boolSelectable = false;
			item.boolToHide = true;
		}
		if(item.boolToHide) {
			this.hideItemById(item.intIndex,"ShownLog",true,this.COMLOG_LIST_LOG);
		}
		item=null;
	},

	cancelShownStatus : function () {
		this.objComlog.arrItems.forEach(this._cancelShownStatus, this);
	},

	_cancelShownStatus : function(item){
		if (item.boolToHide && this._objHiddenComlogItems[item.intIndex] && this._objHiddenComlogItems[item.intIndex] == "ShownLog"){
			delete(item.boolToHide);
			delete(item.boolSelectable);
			this.showItemById(item.intIndex,"ShownLog",true,this.COMLOG_LIST_LOG);
		}
		item=null;
	},

	getComlogListById : function(listId) {
		if(listId == this.COMLOG_LIST_LOG){
			return this.objComlog;
		} else if (listId == this.COMLOG_LIST_MISSED){
			return this.objMissedComlog;
		}

		return null;
	},

	getDisplayedComlogList : function() {
		var intLog;
		if(webapp.history.comlog!=null) {
			intLog = webapp.history.comlog.getDisplayedMenu();
		}
		else {
			intLog = this.COMLOG_LIST_LOG;
		}
		return intLog;
	},

	// Test if the list in argument is currently displayed.
	isListDisplayed : function(intListId) {
		var isDisplayed = (this.getDisplayedComlogList() === intListId);
		intListId = null;
		return isDisplayed
	},

	switchMenu : function(intMenuId) {
		if(webapp.history.comlog){
			if(webapp.history.comlog.getDisplayedMenu() !== intMenuId){

				if(this.isListDisplayed(this.COMLOG_LIST_MISSED)){
					ICTouchAPI.APIServices.Comlog.readAllMissedCall({context:this});
					this.emptyItemsInComlogs(this.COMLOG_LIST_MISSED);
				}
				
				webapp.history.comlog.switchMenuList(intMenuId);

				if(this.isListDisplayed(this.COMLOG_LIST_MISSED)){
					this.loadFirstSelectableItem(this.COMLOG_LIST_MISSED);
				} else {
					if(this.findItemById(this.getCurrentEntry(), this.COMLOG_LIST_LOG)){
						this.selectComlogByIndex(this.getCurrentEntry(), true, this.COMLOG_LIST_LOG);
					} else {
						this.loadFirstSelectableItem(this.COMLOG_LIST_LOG);
					}
				}
			}
		}
	}
});
