dojo.provide("webapp.communication.historyControlBase");
dojo.declare("webapp.communication.historyControlBase",[ICTouchAPI.webApplication],
{
	objPopupConfirmDelete		: null,
	mainWidget					: null,
	comlog						: null,
	previewContainer			: null,
	uiConferenceList			: null,
	objComlogPreview			: null,
	objBaseView					: null,
	_intSelectStatus			: -1,
	_intStatus					: 0,


	constructor : function() {
		// Link style to specific zones
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getComlogPreview","webapp.communication",false,true);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.communication",true,true,true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.notifications","webapp.communication",false,true);

		// Register History button on homepage
		ICTouchAPI.tools.registerHomepageKey(["webapp.communication.getHistory", "HISTORY_BTN", "communication-application", _('HistoryBtn',"webapp.communication"), null, function(){webapp.history.onHistoryEnter()}]);

		// register to physicals Keys
		//ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_COMM", this.eventPhysicalKeyCom);

		// Load setting for preview history
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableCommunicationPreview", this._registerHomePageContainer);
		ICTouchAPI.settingServices.getSetting("EnableCommunicationPreview", this, this._registerHomePageContainer);

	},

	getApplicationName : function(){
		return "webapp.history";
	},

	_registerHomePageContainer : function(objSetting){
		if (objSetting){
			if(objSetting.jsValue === true){
				ICTouchAPI.tools.registerHomepageContainer(["webapp.communication.getComlogPreview", this]);
			}else{
				ICTouchAPI.tools.unregisterHomepageContainer(["webapp.communication.getComlogPreview"]);
			}
		}
		objSetting=null;

	},

	loaded : function() {
		// Event sent when several capabilities changed at the same time
		ICTouchAPI.CapabilityServices.subscribeToCapabilityList("Telephony", "");

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnablePhotoInComlog", this.onEnablePhotoInComlogChanged);
		ICTouchAPI.settingServices.getSetting("EnablePhotoInComlog", this, this.onEnablePhotoInComlogChanged);

		// Setting containing the role, i.e manager or assistant.
		ICTouchAPI.settingServices.subscribeToSetting(this, "UserRole", this.onUserRoleChanged);
		ICTouchAPI.settingServices.getSetting("UserRole", this, this.onUserRoleChanged);

		// Preload communications main screen, UserRole only be called when we are sure that the view has been loaded
		ICTouchAPI.transitionServices.preloadScreen({
			name: "webapp.communication.getHistory",
			params: {}
		});

		// Moved subscription to notifyComLogChanged event from load to loaded to avoid missed event sent by comlog in initialization of the phone
		// when OXO voicemails are get from server
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogChanged", this.apiNotifyComlogChanged);

		dojo.subscribe("ModeHotel", this.data, this.data.setHotelMode);

		var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
		myDS.addEventListener(myDS.E_ITEM_ADDED,   this, this.onContactCreated);
		myDS.addEventListener(myDS.E_ITEM_UPDATED, this, this.onContactModified);
		myDS.addEventListener(myDS.E_ITEM_REMOVED, this, this.onContactDeleted);
		myDS.addEventListener(myDS.E_DATA_LOADED, this, this.onContactSynchro);

		this.initNotificationsValue();
	},

	load : function() {
		// Subscribe to comlog events
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryAdded", this.apiNotifyComlogEntryAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryDeleted", this.apiNotifyComlogEntryDeleted);

		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyComLogEntryChanged", this.apiNotifyComlogEntryChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyCallbackRequestCountChanged", this.apiAddCallbackRequestNotif);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyMissedCallsCountChanged", this.apiAddMissedCallNotif);

		// Subscribe to time format change event
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);

		// Subscribe to date format change event
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);

		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			this.onDateFormatChanged(objSetting, true)
			ICTouchAPI.settingServices.getSetting("TimeFormat", this, this.onTimeFormatChanged);
		});
	
		// Dojo event fired when leaving the communication main screen to reset filters to setting value
		dojo.subscribe("iframe.hide", function(args){
			if(args==='webapp.communication.getHistory'){
				var data = webapp.history.data;
				if(data.isListDisplayed(data.COMLOG_LIST_MISSED)){
					data.selectTitleById(data.COMLOG_LIST_LOG)
				}
			}
		});


		//help
		var widgetsTab = [];
		for(var i in this.data._arrAppBarSkeleton) {
			widgetsTab.push("historystatus"+i);
		}
		dojo.publish("needHelpEvent",["communication",widgetsTab]);
		
		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged",this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);

		dojo.subscribe("CommunicationSelectStatusChange", this, this.onCommSelectStatusChange)
	},

	dump : function(boolAdvancedOption) {
		this.inherited(arguments);
		var i ;
		var data = this.data;
		var entry;
		var idCapabilities;

		if(data.objComlog){
			ICTouchAPI.debugServices.dump("Number of comlog entries : " + data.objComlog.getNbItems() + " (data.objComlog.getNbItems()");
			if(boolAdvancedOption){
				for(i = 0 ; i < data.objComlog.getNbItems() ; i++){
					ICTouchAPI.debugServices.dump("Log number "+i);
					entry = dojo.clone(data.objComlog.getItemByPosition(i));
					ICTouchAPI.debugServices.dump(entry.objLogData);
					delete entry.objLogData;
					ICTouchAPI.debugServices.dump(entry);
				}
			}
		}

		ICTouchAPI.debugServices.dump("Current contact : " + dojo.toJson(data.objCurrentContact));
		ICTouchAPI.debugServices.dump("Enable photo in comlog : " + data.boolEnablePhotoInComlog + " (data.boolEnablePhotoInComlog)");
		ICTouchAPI.debugServices.dump("Hotel mode : " + data.boolHotelMode + " (data.boolHotelMode)");
		ICTouchAPI.debugServices.dump("Manager/assistant role : " + data._userRole + " (data._userRole)");

		ICTouchAPI.debugServices.dump("Status : " + this._intStatus + " (this._intStatus)");
		ICTouchAPI.debugServices.dump("Select status : " + this._intSelectStatus + " (this._intSelectStatus)");
		ICTouchAPI.debugServices.dump("AppBar status : " + data.getNumAppBarFromStatus((this._intSelectStatus >= 0) ? this._intSelectStatus : this._intStatus))
	},

	setHomepageContainer : function (strWebapp, div) {
		webapp.history.previewContainer = new webapp.communication.getComlogPreview({ }, div);
		this.data.loadList(true, true);
		strWebapp=null;
		div=null;
	},

	//allows other webapps to add buttons to the Communication webapp
	addButtonForStatus : function(status, button)
	{
		var numAppBar = this.data.getNumAppBarFromStatus(status);
		//var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus" + status);
		var objButton = new UIElements.AppButton.AppButtonControl(button);
		ICTouchAPI.AppBarServices.addOtherWebAppButton("communication", "historystatus" + numAppBar, objButton);
		//appBar.addAppButton(objButton,true);
		//appBar.updateAppBar();
		return objButton;
		status=null;
		button=null;
	},

	onEnablePhotoInComlogChanged : function(objSetting) {
		if(objSetting){
			this.data.boolEnablePhotoInComlog = objSetting.jsValue;
			this.data.refreshPreview();
			this.data.refreshComlog();
		}
		objSetting=null;
	},

	onPresentationListClick : function(objEntry) {
		var doDialableNumber = false;
		var objContact = this.data.getCurrentContact();
		// use the numbering library only if the contact used to make the call is a local contact
		if (objContact && (objContact.type == 0 || objContact.type == 3)) {
			doDialableNumber = true;
		}
		dojo.publish("ContactDataClicked" + objEntry.strType, [objEntry, objContact, doDialableNumber]);
	    objEntry=null;
	},

	updateAppBar: function()
	{
		ICTouchAPI.log("start updateAppBar", "TELEPHONY");
		var status = (this.getSelectStatus() >= 0) ? this.getSelectStatus() : this.getStatus();
		// Register action bars according to state
		var numAppBar = this.data.getNumAppBarFromStatus(status);
		var isProgkey = this.isSelectStatusProgkey();
		var isMDR = this.isSelectStatusMDR();
		var backFunc;
		if(isProgkey || isMDR) {
			if(isProgkey){
				backFunc = {
					context: webapp.communication,
					func: function(){
						if(webapp.progkeys) {
							webapp.progkeys.externalBack();
						} else {
							ICTouchAPI.transitionServices.back();
						}
					},
				param: this.data.BACK
				};
			}else if(isMDR){
				backFunc = {
					context: webapp.communication,
					func: function(){
						ICTouchAPI.transitionServices.back();
					},
					param: this.BACK
				};
			}
		} else {
			backFunc = {
				context: webapp.history,
				func: webapp.history.buttonCallback,
				param: this.data.BACK
		};
		}
		ICTouchAPI.AppBarServices.addExitButton("communication", "historystatus" + numAppBar, !isProgkey, backFunc);
		ICTouchAPI.AppBarServices.setAppBar("communication", "historystatus"+numAppBar, "getHistory");
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "historystatus" + numAppBar);
		if(appBar) {
			appBar._checkArrows();

			// Manage show/hide on buttons.
			this.updateAppButtons(appBar);
		}
		dojo.publish("ManageExternalButtonsHistory", [this.data.getCurrentContact(), this.getStatus()]);
	},

	updateAppButtons : function(objActionBar) {

		// hide call button if caller was anonymous, show otherwise.
		var objButton = objActionBar.getButton(this.data.CALL);
		if(objButton && typeof objButton != "string"){
			var selectedEntry = this.data.getSelectedEntry();
			if(selectedEntry){
				var officePhone = selectedEntry.objLogData.listContactSummary[0].officePhone;
				if (officePhone == "anonymous" || officePhone == "***" || officePhone === "") {
					objButton.hide()
				} else {
					objButton.show();
				}
			}
		}
	},

	apiNotifyComlogChanged: function() {
		ICTouchAPI.debugServices.info("webapp.history.historyControlBase - apiNotifyComlogChanged");
		this.data.loadList();
	},

	apiNotifyComlogEntryChanged: function(objEvent) {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyComlogEntryChanged");
		this.data.modifyInLog(objEvent.value);
		objEvent=null;
	},

	apiNotifyComlogEntryAdded : function(objLog) {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyComlogEntryAdded");
		this.data.addInLog(objLog.value);
		objLog=null;
	},

	apiNotifyComlogEntryDeleted : function(comlogId) {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyComlogEntryDeleted");
		this.data.removeFromLog(comlogId.value);
		comlogId=null;
	},

	isSelectStatusProgkey : function() {
	    var result = this.data && (this.getSelectStatus() == this.data.STATUS_PROGKEYS_CALL
		||  this.getSelectStatus() == this.data.STATUS_PROGKEYS_ROUTING);
	    return result;
	},

	isSelectStatusMDR : function() {
		var result = this.data && (this.getSelectStatus() == this.data.STATUS_MDR_ROUTING
			||	this.getSelectStatus() == this.data.STATUS_MDR_OVERFLOW
			||	this.getSelectStatus() == this.data.STATUS_MDR_USER
			||	this.getSelectStatus() == this.data.STATUS_BASIC_ADD_ROUTING
			||	this.getSelectStatus() == this.data.STATUS_BASIC_IMMEDIATE_ROUTING);
		return result;
	},

	apiAddCallbackRequestNotif : function(notif) {
		if(notif.value>0){
			ICTouchAPI.ledServices.activate('communication','N_CALLBACK');
		}else{
			ICTouchAPI.ledServices.desactivate('communication','N_CALLBACK');
		}
		ICTouchAPI.notificationServices.setNotificationValue("Callback",notif.value);
		notif=null;
	},

	apiAddMissedCallNotif : function(notif){
		if(notif.value>0){
			ICTouchAPI.ledServices.activate('communication','N_UNANS_CALL');
		}else{
			ICTouchAPI.ledServices.desactivate('communication','N_UNANS_CALL');
		}
		ICTouchAPI.notificationServices.setNotificationValue("Missed",notif.value);
		notif=null;
	},

	onNotificationCallbackRequest : function() {
		this.data.selectTitleById(this.data.COMLOG_LIST_MISSED);
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.communication.getHistory",
			params: {}
		});
	},

	onNotificationMissedCall : function() {
		this.data.selectTitleById(this.data.COMLOG_LIST_MISSED);
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.communication.getHistory",
			params: {}
		});
	},

	onComlogClick : function(comlogId)
	{
		var data = this.data;
		var comlogItem = data.findItemById(comlogId, data.getDisplayedComlogList());
		var selectStatus = this.getSelectStatus();
		// if we are in add participant into a conference mode
		if (selectStatus >= 0)
		{
			if(webapp.communication){
				var objContact = this.data.searchContactFromLog(comlogItem);
				var bDoDialableNumber = (objContact.type == 0 || objContact.type == 3);
				if(this.getSelectStatus() == data.STATUS_PROGKEYS_CALL || this.getSelectStatus() == data.STATUS_PROGKEYS_ROUTING){
					comlogItem.source = "history";
				}
				webapp.communication.doContextStatusCall(comlogItem.objLogData.listContactSummary[0].officePhone, bDoDialableNumber, objContact, comlogItem);
			}
		}
		// other modes of application, load
		else
		{
			data._intLastSelected = comlogId;

			var comlogData = comlogItem.objLogData; // Comlog data object
			if(comlogData.isRead === false || comlogData.isRead === 0 ) {
				comlogData.isRead = true;
				ICTouchAPI.APIServices.Comlog.markEntryAsRead({
					params: [comlogData.comLogEntryId]
				});
				data.objComlog.toggleEmphasis(comlogId, false);
			}

			data.loadDetails(comlogId);
		}
		comlogId=null;
	},

	onConferenceListClick : function(intIndex){
		if (this.uiConferenceList.hasSelectedItems()){
			if (this._intStatus === this.data.STATUS_LOG_CONFERENCE) {
				this._intStatus = this.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED;
			}
		}
		else{
			if (this._intStatus === this.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED) {
				this._intStatus = this.data.STATUS_LOG_CONFERENCE;
			}
		}

        this.data.setCurrentContact(null, this.data.getSelectedEntry(), intIndex);
		this.updateAppBar();
		intIndex=null;
	},
	
	// Created
	onContactCreated : function(objContact){
		this.refreshComlogs();
	},
	
	// Modified
	onContactModified : function(objContact, objContactChanges){
		var onlyPresenceChanged = false;
		if(objContactChanges){
			onlyPresenceChanged = true;
			for(var i in objContactChanges){
				if(i != "telephonyPresence" && i != "IMPresence"){
					onlyPresenceChanged = false;
					break;
				}
			}
		}
		if(!onlyPresenceChanged){
			// Not possible to pass the contactId because we would miss cases when the number changes
			this.refreshComlogs();
		}		
	},
	
	// Deleted
	onContactDeleted : function(contactId){
		this.refreshComlogs(contactId);
	},
	
	// Contact list changed completely
	onContactSynchro : function(arrContacts){
		this.refreshComlogs();
	},

	// Show filters for modifications
	showFilters : function() {
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.communication.getFilters",
			params: {}
		});
	},

	deleteLog : function() {
		var selected = this.data.getSelectedEntry();
		ICTouchAPI.APIServices.Comlog.deleteEntry({
			params:[selected.objLogData.comLogEntryId],
			context:this
		});
	},

	// Delete logs by entry type choice
	deleteAllLogs : function() {
		var filterValue = (this.data.isListDisplayed(this.data.COMLOG_LIST_MISSED)) ? this.data.COMLOG_FILTER_UNANS_INC_CALL_BUSINESS_ID : this.data.COMLOG_FILTER_ALL_BUSINESS_ID;

		// Reset enable value of entryTypes with the current filter type.
		this.data.resetComLogEntryTypes(filterValue);

		// Open the delete choice popup
		this.openDeletePopup();
	},

	// Open the delete popup with type choice
	openDeletePopup : function() {
		// Save context
		var context = this;

		// Create the popup data
		var popupDel = {
			strTitle: _("Select comlog entry types to delete", "webapp.communication"),
			strWidgetName : "UIElements.SelectList.SelectListControl",
			arrItems: context.data.getComLogEntryTypesForDisplay(),
			itemCallback : function(intIndex) {
				context.data._arrComLogEntryTypes[intIndex].enabled = !context.data._arrComLogEntryTypes[intIndex].enabled;
			},
			boolMultiselect: true,
			arrPopupButtons: [ {
					strButtonName: "DELETE_BTN",
					strButtonLabel: _('Delete', "ICTouchAPI"),
					strButtonIcon: "generic-mode-delete",
					callback : {
						func: context.deleteWithFilter,
						context: context
					}
				}, {
					strButtonName: "CANCEL_BTN",
					strButtonLabel: _('Cancel', "ICTouchAPI"),
					strButtonIcon: "generic-cancel",
					callback : function(){
						ICTouchAPI.popupServices.removePopup(context.objPopupConfirmDelete);
					}
				}
			]
		};

		// Show the popup
		this.objPopupConfirmDelete = ICTouchAPI.popupServices.addNewPopup(popupDel, "MEDIUM");
	},

	// Send core function deleteWithMoreFilters with the current selected types in the popup.
	deleteWithFilter : function(){
		// Array of the types to delete
		var logTypesToDelete = [];

		var arrComlogEntryTypes = this.data.getComLogEntryTypes();
		for(var i=0; i<arrComlogEntryTypes.length; i++){
			if(arrComlogEntryTypes[i].enabled){
				for(var j=0; j<arrComlogEntryTypes[i].businessIds.length; j++){
					// If the entry is selected, add to the array to remove every business ids it was representing, read or unread.
					logTypesToDelete.push(arrComlogEntryTypes[i].businessIds[j]+":"+this.data.FILTER_ALL);

				}
			}
		}
		if(logTypesToDelete.length>0){
			// If we are removing VM entries, stop any possible current reading
			ICTouchAPI.APIServices.Comlog.deleteWithMoreFilters({params:[logTypesToDelete], context:this});
		}
		ICTouchAPI.popupServices.removePopup(this.objPopupConfirmDelete);
	},

	resetStatus : function(){
		// Cancel conference or transfert
		this.data.cancelShownStatus();
		// select automatically the first call if it exists
		var firstItem = this.data.findItemByPosition(this.data.findFirstSelectableItem(this.data.COMLOG_LIST_LOG), this.data.COMLOG_LIST_LOG);
		if (firstItem) {
			this.data.selectComlogByIndex(firstItem.intIndex, false, this.data.COMLOG_LIST_LOG);
			this.data.loadDetails(firstItem.intIndex);
		}
		// update action bar to the last item selected
		this.toggleOpacityTwoThird(false);
		this.updateAppBar();
	},

	toggleOpacityTwoThird : function(boolOpacity) {
		if(webapp.history.data.objContactCard) {
			webapp.history.data.objContactCard.toggleOpacity(boolOpacity);
		}
		if(webapp.history.data.objConferenceWidget) {
			webapp.history.data.objConferenceWidget.toggleOpacity(boolOpacity);
		}
		boolOpacity=null;
	},

	initNotificationsValue : function(){
		// Register notifications
		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "Callback",
			strNotificationLabel: _("Callback", "webapp.communication"),
			intNotificationValue: 0,
			callback: {
				context:this,
				func:this.onNotificationCallbackRequest
			}
		});
		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "Missed",
			strNotificationLabel: _("Missed", "webapp.communication"),
			intNotificationValue: 0,
			callback: {
				context:this,
				func:this.onNotificationMissedCall
			}
		});
		this.updateNotificationValue();
	},

	updateNotificationValue : function() {
		ICTouchAPI.APIServices.Comlog.count({
			params:[0,this.data.COMLOG_FILTER_CALLBACK_REQ_BUSINESS_ID],
			context:this,
			callback:function(count) {

				if(count>0){
					ICTouchAPI.ledServices.activate('communication','N_CALLBACK');
				}else{
					ICTouchAPI.ledServices.desactivate('communication','N_CALLBACK');
				}
				ICTouchAPI.notificationServices.setNotificationValue("Callback", count);
			}
		});
		ICTouchAPI.APIServices.Comlog.count({
			params:[0,this.data.COMLOG_FILTER_UNANS_INC_CALL_BUSINESS_ID],
			context:this,
			callback:function(count) {
				if(count>0){
					ICTouchAPI.ledServices.activate('communication','N_UNANS_CALL');
				}else{
					ICTouchAPI.ledServices.desactivate('communication','N_UNANS_CALL');
				}
				ICTouchAPI.notificationServices.setNotificationValue("Missed", count);
			}
		});
	},

	setStatus : function(value) {
		this._intStatus = value;
		value=null;
	},

	getStatus : function() {
		return this._intStatus;
	},

	setSelectStatus : function(value) {
		if(this._intSelectStatus!==value) {
			this._intSelectStatus = value;
		}
		value=null;
	},

	onCommSelectStatusChange : function(params, objFirstSelected) {
		this.setSelectStatus(params.selectStatus);

		// If the status is -1, there is no more select status so we reset
		if(params.selectStatus == -1){
			this.resetStatus();
		}

		// Store the communication objFirstSelected in order to hide/show entries in menuList
		this.data._objFirstSelected = objFirstSelected;

		// Update the appBar.
		this.updateAppBar();

		// Store every label/Icons linked to this select status
		this.data.setStrCurrentCommStatusIcon(params.icon);
		this.data.setStrCurrentCommStatusLabelOk(params.labelOk);
		this.data.setStrCurrentCommStatusLabelCancel(params.labelCancel);
		params = null;
	},

	getSelectStatus : function() {
		return this._intSelectStatus;
	},

	onDateFormatChanged: function(objSetting, boolNoReload) {
		if (objSetting !== null) {
			if(this.data._dateFormat !== objSetting.allowedValues[objSetting.jsValue].name){
				this.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
				if(!boolNoReload){
					this.refreshComlogs();
				}
			}
		}
		objSetting=null;
	},

	onTimeFormatChanged: function(objSetting, boolNoReload) {
		if (objSetting != null) {
			if(this.data._24hformat !== objSetting.jsValue){
				this.data._24hformat = objSetting.jsValue;
				if(!boolNoReload){
					this.refreshComlogs();
				}
			}
		}
		objSetting=null;
	},

	onDayChanged: function() {
		// We have changed the day so every item in list that is from last day must be refreshed to update the date label
		this.data.loadList(false, true);
	},
	
	refreshComlogs : function(){
		this.data.refreshComlog();
		// Bufferize and delay calls to refreshComlog.
		if(this.hRefresh){
			clearTimeout(this.hRefresh);
			this.hRefresh = null;
		}
		this.hRefresh = setTimeout(dojo.hitch(this.data, this.data.refreshComlog), 3000);
	},

	onHistoryEnter : function(entryId, bSelect) {
		if(this.data.getNbItems(this.data.COMLOG_LIST_LOG) > 0) {
			// If an id was in parameter, select it
			if(entryId != null){ // may be 0
				this.data.selectComlogByIndex(entryId, bSelect, this.data.COMLOG_LIST_LOG);
			} else { // Otherwise, select first
				if (this.getSelectStatus() !== -1) { // if we are in a selection mode, setShownLogs
					var firstSelectableItem = this.data.findItemByPosition(this.data.findFirstSelectableItem(this.data.COMLOG_LIST_LOG), this.data.COMLOG_LIST_LOG) ;
					if (firstSelectableItem) {
						this.data.selectComlogByIndex(firstSelectableItem.intIndex, false, this.data.COMLOG_LIST_LOG);
						this.data.loadDetails(firstSelectableItem.intIndex);
					}
				}
			}
		}
		else { // If there is no logs, loadDetails with undefined to get an empty 2/3
			this.data.loadDetails();
		}
		ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getHistory"});
		entryId = null;
		bSelect = null;
	},

	onUserRoleChanged : function(objSetting){
		if(objSetting){
			this.data.setUserRole(objSetting.jsValue);
		}
	},

	enterHistoryBySenskey : function(){
		if(this.data.getNbItems(this.data.COMLOG_LIST_MISSED) != 0){
			this.data.selectTitleById(this.data.COMLOG_LIST_MISSED);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getHistory",
				params: {}
			});
		}else{
			this.onHistoryEnter();
		}
	}

});
