dojo.require("webapp.communication.historyControlBase");
dojo.provide("webapp.communication.historyControl");
dojo.declare("webapp.communication.historyControl",webapp.communication.historyControlBase,
{

	buttonCallback : function(buttonId) {
		var data = webapp.history.data;
		var currentCall;
		var number;
		var objContact;
		switch(buttonId)
		{
			case data.BACK:
				dojo.publish("OpenHomepage");
				break;
			case data.SEARCH:
				if (typeof webapp.search !== "undefined") {
					webapp.communication.showKeyPad({searchType: this.getKeyPadActionFromSelectStatus(), boolInitiatedFromGUI: true, boolForceByname: true, boolInitiateByName: true});
				}
				break;
			case data.CALL:
				var doDialableNumber = false;
				var objLog = data.getSelectedEntry();
				if(this._intStatus === data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED){
					if(this.uiConferenceList){
						var intSelectedId = this.uiConferenceList.getSelectedItemsIndex();
						number = objLog.objLogData.listContactSummary[intSelectedId].officePhone;
					}
				} else if(this._intStatus === data.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
					number = objLog.objLogData.listContactSummary[objLog.intIndex.split("_")[1]].officePhone;
				} else {
					number = objLog.objLogData.listContactSummary[0].officePhone;
				}
				var btn = ICTouchAPI.AppBarServices.getAppBar("communication", "historystatus" + this._intStatus).getButton(data.CALL);
				btn.hide();
				if( number && webapp.communication) {
					webapp.communication.apiCall(number, doDialableNumber, true);
				}
				break;
			case data.NEW_CALL:
				this.showKeyPad({
					searchType: this.DIALACTION_CALL,
					boolInitiatedFromGUI: true
				});
				break;
			case data.CANCEL_INIT_CONF3:
			case data.CANCEL_TRANSFER_TO:
			case data.CANCEL_ADD_PARTICIPANT:
			case data.CANCEL:
				if( this._intSelectStatus === data.STATUS_ADD_PARTICIPANT ||
					this._intSelectStatus === data.STATUS_MERGE_CALLS ||
					this._intSelectStatus === data.STATUS_INIT_CONF3 ||
					this._intSelectStatus === data.STATUS_TRANSFER ||
					this._intSelectStatus === data.STATUS_TRANSFER_TO ||
					this._intSelectStatus === data.STATUS_DEFLECT_TO)
				{
					var oldstatus = this._intSelectStatus;
					this.resetStatus();
                    if( oldstatus === data.STATUS_ADD_PARTICIPANT ||
                        oldstatus === data.STATUS_TRANSFER_TO) {
                        if(data._intLastSelected > 0) {
                            data.refreshDetails();
                        } else {
                            data.loadDetails(data.objActiveComlog.arrItems[0].intIndex);
						}
                    }
				}
				break;
			case data.DELETE_LOG:
				this.deleteLog();
				break;
			case data.DELETE_ALL_LOG:
				this.deleteAllLogs();
				break;
			case data.CALL_BACK:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this.apiRequestCallBack(currentCall.objCallData.callId);
				break;
			default:
				console.warn("buttonCallbak : no callback is defined for this button id:"+buttonId);
				break;
		}
		buttonId=null;
	}
});

webapp.history = new webapp.communication.historyControl();
