/*Contact Webapplication*/
dojo.provide("webapp.communication.getVideoCardBase");
dojo.declare("webapp.communication.getVideoCardBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{		
		videoUI			: null,
		callId			: -1,
		pip				: 1,

		constructor: function() {
			var data = webapp.communication.data;
			data.objVideoCard = this;
		},

		postMixInProperties : function() {
		},

		postCreate : function() {
			ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - postCreate');
			this.inherited(arguments);
			var params = {};
			params.objCard = webapp.communication.data.getVideoCardParams();
			if(params.objCard.callId && typeof params.objCard.pip != "undefined"){
				ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - postCreate callId='+params.objCard.callId+' pip='+params.objCard.pip);
				this.updateContent(params);
			}
			params.objCard = null;
			params = null;
			ICTouchAPI.debugServices.debug("webapp.communication.getVideoCardBase - postCreate done");
		},

		updateVideoUI : function(callId, sipCallId, pip, closeVideo) {
			if(this.sipCallId !== undefined && this.sipCallId !== sipCallId){
				ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - updateVideoUI / sipCallId has changed, a reload of the widget is required');
				return true;
			}
			var data = webapp.communication.data;
			if(closeVideo === undefined){
				closeVideo = false;
			}
			if(data.isInVideoCall(callId) && !this.videoUI) {
				ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - updateVideoUI / startVideo');
				this.callId = callId;
				this.pip = pip;
				this.sipCallId = sipCallId;
				this.videoUI = new UIElements.Video.VideoControl({callId : callId, sipCallId: sipCallId, pip : pip},this.domVideoDisplay);
				this.videoUI.startup();
			} else if((closeVideo || !data.isInVideoCall(callId)) && this.videoUI){
				ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - updateVideoUI / stopVideo');
				this.videoUI.destroy(true);
				this.videoUI = null;
			}
			return false;
		},

		// Check for every parameter if it is modified or not. If at least one is modified, return true. Return false otherwise.
		updateContent : function(params) {
			ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - updateContent');
			var boolModified = false;
			//Get contact card details from params
			if (params && params.objCard && params.objCard.callId){
				boolModified = this.updateVideoUI(params.objCard.callId, params.objCard.sipCallId, params.objCard.pip);
			}
			ICTouchAPI.debugServices.debug('webapp.communication.getVideoCardBase - updateContent done');
			return boolModified;
		},

		destroy: function() {
			ICTouchAPI.debugServices.debug("webapp.communication.getVideoCardBase - destroy");
			var data = webapp.communication.data;
			data.objVideoCard = null;
			data.boolShowVideo = true;
//			if (typeof this.uiPresentation === "object" && this.uiPresentation !== null)
//			{
//				this.uiPresentation.destroy();
//				delete this.uiPresentation;
//			}
			this.inherited(arguments);
		}
	});
